<?php
/* Autor...:  */
/* Esquema.: GSS_MonedaMast.xml */
/* Generado: 2020-08-18 04:21:26 */

/* Metodos de acceso a los campos de la tabla GSS_MonedaMast */
abstract class BaseGSS_MonedaMastBN
{
    /* Campos de la tabla */
    private $s_IdMoneda;    // IdMoneda: ( no definido )
    private $s_Descripcion;    // Descripcion: ( no definido )
    private $s_Sigla;    // Sigla: ( no definido )
    private $s_CodigoFiscal;    // CodigoFiscal: ( no definido )
    private $s_Estado;    // Estado: ( no definido )
    private $d_FechaCreacion;    // FechaCreacion: ( no definido )
    private $s_UsuarioCreacion;    // UsuarioCreacion: ( no definido )
    private $d_FechaModificacion;    // FechaModificacion: ( no definido )
    private $s_UsuarioModificacion;    // UsuarioModificacion: ( no definido )

    /* Establece el valor del campo IdMoneda */
    public function setIdMoneda( $s_IdMoneda )
    {
        $this->s_IdMoneda = $s_IdMoneda;
    }

    /* Obtiene el valor del campo IdMoneda */
    public function getIdMoneda()
    {
        return $this->s_IdMoneda;
    }

    /* Establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion )
    {
        $this->s_Descripcion = $s_Descripcion;
    }

    /* Obtiene el valor del campo Descripcion */
    public function getDescripcion()
    {
        return $this->s_Descripcion;
    }

    /* Establece el valor del campo Sigla */
    public function setSigla( $s_Sigla )
    {
        $this->s_Sigla = $s_Sigla;
    }

    /* Obtiene el valor del campo Sigla */
    public function getSigla()
    {
        return $this->s_Sigla;
    }

    /* Establece el valor del campo CodigoFiscal */
    public function setCodigoFiscal( $s_CodigoFiscal )
    {
        $this->s_CodigoFiscal = $s_CodigoFiscal;
    }

    /* Obtiene el valor del campo CodigoFiscal */
    public function getCodigoFiscal()
    {
        return $this->s_CodigoFiscal;
    }

    /* Establece el valor del campo Estado */
    public function setEstado( $s_Estado )
    {
        $this->s_Estado = $s_Estado;
    }

    /* Obtiene el valor del campo Estado */
    public function getEstado()
    {
        return $this->s_Estado;
    }

    /* Establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion )
    {
        $this->d_FechaCreacion = $d_FechaCreacion;
    }

    /* Obtiene el valor del campo FechaCreacion */
    public function getFechaCreacion()
    {
        return $this->d_FechaCreacion;
    }

    /* Establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion )
    {
        $this->s_UsuarioCreacion = $s_UsuarioCreacion;
    }

    /* Obtiene el valor del campo UsuarioCreacion */
    public function getUsuarioCreacion()
    {
        return $this->s_UsuarioCreacion;
    }

    /* Establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion )
    {
        $this->d_FechaModificacion = $d_FechaModificacion;
    }

    /* Obtiene el valor del campo FechaModificacion */
    public function getFechaModificacion()
    {
        return $this->d_FechaModificacion;
    }

    /* Establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion )
    {
        $this->s_UsuarioModificacion = $s_UsuarioModificacion;
    }

    /* Obtiene el valor del campo UsuarioModificacion */
    public function getUsuarioModificacion()
    {
        return $this->s_UsuarioModificacion;
    }

    public function getJsonSerialize()
    {
        return 
        [
            'IdMoneda' => $this->getIdMoneda(),
            'Descripcion' => $this->getDescripcion(),
            'Sigla' => $this->getSigla(),
            'CodigoFiscal' => $this->getCodigoFiscal(),
            'Estado' => $this->getEstado(),
            'FechaCreacion' => $this->getFechaCreacion(),
            'UsuarioCreacion' => $this->getUsuarioCreacion(),
            'FechaModificacion' => $this->getFechaModificacion(),
            'UsuarioModificacion' => $this->getUsuarioModificacion(),
        ];
    }

    public function toArray()
    {
        return $this->processArray( get_object_vars( $this ) ); 
    }

    private function processArray( $array )
    {
        foreach( $array as $key => $value ) 
        {
            if ( is_object( $value ) )
            {
                $array[$key] = $value->toArray();
            }
            if ( is_array( $value ) ) 
            {
                $array[$key] = $this->processArray( $value );
            }
        }
        return $array;
    }

    public function __toString()
    {
        return json_encode( $this->toArray() ); 
    }

    /* Recupera un objeto GSS_MonedaMastBN desde un RecordSet */
    public static function retrieveByRs( $o_GSS_MonedaMastRs )
    {
        $o_GSS_MonedaMastBN = new GSS_MonedaMastBN();
        $o_GSS_MonedaMastBN->setIdMoneda( $o_GSS_MonedaMastRs[ "IdMoneda" ] );
        $o_GSS_MonedaMastBN->setDescripcion( $o_GSS_MonedaMastRs[ "Descripcion" ] );
        $o_GSS_MonedaMastBN->setSigla( $o_GSS_MonedaMastRs[ "Sigla" ] );
        $o_GSS_MonedaMastBN->setCodigoFiscal( $o_GSS_MonedaMastRs[ "CodigoFiscal" ] );
        $o_GSS_MonedaMastBN->setEstado( $o_GSS_MonedaMastRs[ "Estado" ] );
        $o_GSS_MonedaMastBN->setFechaCreacion( utilTimestamp::getTimestamp( $o_GSS_MonedaMastRs[ "FechaCreacion" ], "Y-m-d H:i:s" ) );
        $o_GSS_MonedaMastBN->setUsuarioCreacion( $o_GSS_MonedaMastRs[ "UsuarioCreacion" ] );
        $o_GSS_MonedaMastBN->setFechaModificacion( utilTimestamp::getTimestamp( $o_GSS_MonedaMastRs[ "FechaModificacion" ], "Y-m-d H:i:s" ) );
        $o_GSS_MonedaMastBN->setUsuarioModificacion( $o_GSS_MonedaMastRs[ "UsuarioModificacion" ] );
        return $o_GSS_MonedaMastBN;
    }
}
?>