<?php
/* Autor...:  */
/* Esquema.: GSS_FeriadosMast.xml */
/* Generado: 2020-08-18 04:21:26 */

/* Metodos de acceso a los campos de la tabla GSS_FeriadosMast */
abstract class BaseGSS_FeriadosMastBN
{
    /* Campos de la tabla */
    private $i_IdFeriado;    // IdFeriado: ( no definido )
    private $i_IdCompania;    // IdCompania: ( no definido )
    private $i_IdSucursal;    // IdSucursal: ( no definido )
    private $s_Anio;    // Anio: ( no definido )
    private $s_Mes;    // Mes: ( no definido )
    private $s_Dia;    // Dia: ( no definido )
    private $i_DiaNumero;    // DiaNumero: ( no definido )
    private $s_UsuarioCreacion;    // UsuarioCreacion: ( no definido )
    private $d_FechaCreacion;    // FechaCreacion: ( no definido )
    private $s_UsuarioModificacion;    // UsuarioModificacion: ( no definido )
    private $d_FechaModificacion;    // FechaModificacion: ( no definido )

    /* Establece el valor del campo IdFeriado */
    public function setIdFeriado( $i_IdFeriado )
    {
        $this->i_IdFeriado = $i_IdFeriado;
    }

    /* Obtiene el valor del campo IdFeriado */
    public function getIdFeriado()
    {
        return $this->i_IdFeriado;
    }

    /* Establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania )
    {
        $this->i_IdCompania = $i_IdCompania;
    }

    /* Obtiene el valor del campo IdCompania */
    public function getIdCompania()
    {
        return $this->i_IdCompania;
    }

    /* Establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal )
    {
        $this->i_IdSucursal = $i_IdSucursal;
    }

    /* Obtiene el valor del campo IdSucursal */
    public function getIdSucursal()
    {
        return $this->i_IdSucursal;
    }

    /* Establece el valor del campo Anio */
    public function setAnio( $s_Anio )
    {
        $this->s_Anio = $s_Anio;
    }

    /* Obtiene el valor del campo Anio */
    public function getAnio()
    {
        return $this->s_Anio;
    }

    /* Establece el valor del campo Mes */
    public function setMes( $s_Mes )
    {
        $this->s_Mes = $s_Mes;
    }

    /* Obtiene el valor del campo Mes */
    public function getMes()
    {
        return $this->s_Mes;
    }

    /* Establece el valor del campo Dia */
    public function setDia( $s_Dia )
    {
        $this->s_Dia = $s_Dia;
    }

    /* Obtiene el valor del campo Dia */
    public function getDia()
    {
        return $this->s_Dia;
    }

    /* Establece el valor del campo DiaNumero */
    public function setDiaNumero( $i_DiaNumero )
    {
        $this->i_DiaNumero = $i_DiaNumero;
    }

    /* Obtiene el valor del campo DiaNumero */
    public function getDiaNumero()
    {
        return $this->i_DiaNumero;
    }

    /* Establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion )
    {
        $this->s_UsuarioCreacion = $s_UsuarioCreacion;
    }

    /* Obtiene el valor del campo UsuarioCreacion */
    public function getUsuarioCreacion()
    {
        return $this->s_UsuarioCreacion;
    }

    /* Establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion )
    {
        $this->d_FechaCreacion = $d_FechaCreacion;
    }

    /* Obtiene el valor del campo FechaCreacion */
    public function getFechaCreacion()
    {
        return $this->d_FechaCreacion;
    }

    /* Establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion )
    {
        $this->s_UsuarioModificacion = $s_UsuarioModificacion;
    }

    /* Obtiene el valor del campo UsuarioModificacion */
    public function getUsuarioModificacion()
    {
        return $this->s_UsuarioModificacion;
    }

    /* Establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion )
    {
        $this->d_FechaModificacion = $d_FechaModificacion;
    }

    /* Obtiene el valor del campo FechaModificacion */
    public function getFechaModificacion()
    {
        return $this->d_FechaModificacion;
    }

    public function getJsonSerialize()
    {
        return 
        [
            'IdFeriado' => $this->getIdFeriado(),
            'IdCompania' => $this->getIdCompania(),
            'IdSucursal' => $this->getIdSucursal(),
            'Anio' => $this->getAnio(),
            'Mes' => $this->getMes(),
            'Dia' => $this->getDia(),
            'DiaNumero' => $this->getDiaNumero(),
            'UsuarioCreacion' => $this->getUsuarioCreacion(),
            'FechaCreacion' => $this->getFechaCreacion(),
            'UsuarioModificacion' => $this->getUsuarioModificacion(),
            'FechaModificacion' => $this->getFechaModificacion(),
        ];
    }

    public function toArray()
    {
        return $this->processArray( get_object_vars( $this ) ); 
    }

    private function processArray( $array )
    {
        foreach( $array as $key => $value ) 
        {
            if ( is_object( $value ) )
            {
                $array[$key] = $value->toArray();
            }
            if ( is_array( $value ) ) 
            {
                $array[$key] = $this->processArray( $value );
            }
        }
        return $array;
    }

    public function __toString()
    {
        return json_encode( $this->toArray() ); 
    }

    /* Recupera un objeto GSS_FeriadosMastBN desde un RecordSet */
    public static function retrieveByRs( $o_GSS_FeriadosMastRs )
    {
        $o_GSS_FeriadosMastBN = new GSS_FeriadosMastBN();
        $o_GSS_FeriadosMastBN->setIdFeriado( ( integer ) $o_GSS_FeriadosMastRs[ "IdFeriado" ] );
        $o_GSS_FeriadosMastBN->setIdCompania( ( integer ) $o_GSS_FeriadosMastRs[ "IdCompania" ] );
        $o_GSS_FeriadosMastBN->setIdSucursal( ( integer ) $o_GSS_FeriadosMastRs[ "IdSucursal" ] );
        $o_GSS_FeriadosMastBN->setAnio( $o_GSS_FeriadosMastRs[ "Anio" ] );
        $o_GSS_FeriadosMastBN->setMes( $o_GSS_FeriadosMastRs[ "Mes" ] );
        $o_GSS_FeriadosMastBN->setDia( $o_GSS_FeriadosMastRs[ "Dia" ] );
        $o_GSS_FeriadosMastBN->setDiaNumero( ( integer ) $o_GSS_FeriadosMastRs[ "DiaNumero" ] );
        $o_GSS_FeriadosMastBN->setUsuarioCreacion( $o_GSS_FeriadosMastRs[ "UsuarioCreacion" ] );
        $o_GSS_FeriadosMastBN->setFechaCreacion( utilTimestamp::getTimestamp( $o_GSS_FeriadosMastRs[ "FechaCreacion" ], "Y-m-d H:i:s" ) );
        $o_GSS_FeriadosMastBN->setUsuarioModificacion( $o_GSS_FeriadosMastRs[ "UsuarioModificacion" ] );
        $o_GSS_FeriadosMastBN->setFechaModificacion( utilTimestamp::getTimestamp( $o_GSS_FeriadosMastRs[ "FechaModificacion" ], "Y-m-d H:i:s" ) );
        return $o_GSS_FeriadosMastBN;
    }
}
?>