<?php

class Ventas_model
{
    /**
     * @param $venta_id
     * @return array
     * @throws SQLException
     */
    public function query_cabecera( $venta_id )
    {
        $o_VTA_FacturacionElectronicaFN = new VTA_FacturacionElectronicaFN();
        $o_VTA_FacturacionElectronicaBN = $o_VTA_FacturacionElectronicaFN->selectByPK( $venta_id );

        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
        $o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $o_VTA_FacturacionElectronicaBN->getTipo(), $o_VTA_FacturacionElectronicaBN->getIdCompania(), $o_VTA_FacturacionElectronicaBN->getFactElecId() );

        $o_VTA_FormaPagoBN     = $o_VTA_DocumentoBN->getObjectFormaPago();
        $o_GSS_MonedaMastBN    = $o_VTA_DocumentoBN->getObjectMoneda();
        $o_MST_PersonaMastBN   = $o_VTA_DocumentoBN->getObjectCliente();
        $o_VTA_TipoDocumentoBN = $o_VTA_DocumentoBN->getObjectTipoDocumento();

        $s_VentaRelacionadoId = "";
        $s_MotivoNotaCredito  = "";
        if( $o_VTA_DocumentoBN->getIdTipoDocumento() == VTA_DocumentoBN::TIPO_DOCUMENTO_NOTA_CREDITO )
        {
            $s_VentaRelacionadoId = $o_VTA_DocumentoBN->getDocumentoParentId();
            $s_MotivoNotaCredito  = "1"; //Anulación de la operacion
        }

        $a_Data = array(
            "direccion_cliente_de_venta"      => $o_VTA_FacturacionElectronicaBN->getClienteDireccion(),
            "numero_pedido"                   => "",
            "nota_venta"                      => "",
            "numero_guia"                     => "",
            "condicion_venta"                 => "",
            "operacion"                       => $o_VTA_TipoDocumentoBN->getClasificacion(),
            "total_descuentos"                => !$o_VTA_FacturacionElectronicaBN->getMontoDescuento() ? "" : $o_VTA_FacturacionElectronicaBN->getMontoDescuento(),
            "operacion_id"                    => "",
            "respuesta_sunat_codigo"          => "",
            "respuesta_sunat_descripcion"     => "",
            "respuesta_anulacion_codigo"      => "",
            "respuesta_anulacion_descripcion" => "",
            "estado_anulacion"                => "",
            "venta_id"                        => $venta_id,
            "venta_anio"                      => UtilDate::getFormatDate( $o_VTA_FacturacionElectronicaBN->getFechaEmision(), "Y" ),
            "forma_pago_id"                   => $o_VTA_FormaPagoBN->getCodigo()=='CON' ? 1 : 2,
            "venta_relacionado_id"            => $s_VentaRelacionadoId, //id del comprobante asociado a la nota de credito o nota de debito
            "tipo_ncredito_id"                => $s_MotivoNotaCredito, //motivo
            "tipo_ndebito_id"                 => "", //motivo
            "serie"                           => $o_VTA_FacturacionElectronicaBN->getSerie(),
            "numero"                          => intval( $o_VTA_FacturacionElectronicaBN->getNumero() ),
            "porcentaje_igv"                  => ( $o_VTA_FacturacionElectronicaBN->getPorcentajeIGV() / 100 ),
            "fecha_emision_sf"                => substr( $o_VTA_FacturacionElectronicaBN->getFechaEmision(), 0, 10 ),
            "fecha_emision"                   => UtilDate::getFormatDate( $o_VTA_FacturacionElectronicaBN->getFechaEmision(), "d-m-Y" ),
            "hora_emision"                    => UtilDate::getFormatDate( $o_VTA_FacturacionElectronicaBN->getFechaCreacion(), "H:i:s" ),
            "fecha_vencimiento"               => $o_VTA_DocumentoBN->getFormaPagoCod() == "CRE" ? UtilDate::getFormatDate( $o_VTA_FacturacionElectronicaBN->getFechaVencimiento(), "d-m-Y" ) : null,
            "fecha_vencimiento_sf"            => $o_VTA_DocumentoBN->getFormaPagoCod() == "CRE" ? substr( $o_VTA_FacturacionElectronicaBN->getFechaVencimiento(), 0, 10 ) : null,
            "tipo_de_cambio"                  => $o_VTA_FacturacionElectronicaBN->getTipoCambio(),
            "total_gravada"                   => $o_VTA_FacturacionElectronicaBN->getMontoAfecto(),
            "total_igv"                       => $o_VTA_FacturacionElectronicaBN->getImpuesto(),
            "total_gratuita"                  => "",
            "total_exportacion"               => "",
            "total_exonerada"                 => $o_VTA_FacturacionElectronicaBN->getMontoExonerado(),
            "total_inafecta"                  => $o_VTA_FacturacionElectronicaBN->getMontoInafecto(),
            "total_bolsa"                     => "",
            "PrepaidAmount"                   => $o_VTA_FacturacionElectronicaBN->getMontoAnticipo(),   //ANTICIPOS
            "total_a_pagar"                   => $o_VTA_FacturacionElectronicaBN->getMontoTotal(),
            "estado_operacion"                => $o_VTA_FacturacionElectronicaBN->getAceptadaxSunat() == "SI" ? 1 : 0,
            "firma_sunat"                     => "",
            "orden_compra"                    => $o_VTA_DocumentoBN->getOrdenCompraRef() ? $o_VTA_DocumentoBN->getOrdenCompraRef() :  "",
            "notas notas"                     => "",
            "tipo_operacion"                  => $o_VTA_DocumentoBN->getTipoOperacionSunat(),
            "UBLVersionID"                    => "2.1",
            "CustomizationID"                 => "2.0",
            "moneda_id"                       => $o_GSS_MonedaMastBN->getIdMoneda(),
            "moneda"                          => $o_GSS_MonedaMastBN->getDescripcion(),
            "simbolo_moneda"                  => $o_GSS_MonedaMastBN->getSigla(),
            "abrstandar"                      => $o_GSS_MonedaMastBN->getCodigoFiscal(),
            "entidad_id"                      => $o_VTA_FacturacionElectronicaBN->getCodCliente(),
            "entidad"                         => $o_VTA_FacturacionElectronicaBN->getClienteNom(),
            "nombre_comercial"                => "",
            "numero_documento"                => $o_VTA_FacturacionElectronicaBN->getClienteDocNum(),
            "direccion_entidad"               => $o_VTA_FacturacionElectronicaBN->getClienteDireccion(),
            "email_1_entidad"                 => $o_VTA_FacturacionElectronicaBN->getClienteEmail(),
            "email_2_entidad"                 => $o_VTA_FacturacionElectronicaBN->getClienteEmail1(),
            "telefono_fijo_1"                 => utilString::eliminar_espacios( $o_MST_PersonaMastBN->getTelefono() ),
            "telefono_fijo_2"                 => "",
            "telefono_movil_1"                => utilString::eliminar_espacios( $o_MST_PersonaMastBN->getCelular() ),
            "telefono_movil_2"                => "",
            "nombres"                         => $o_MST_PersonaMastBN->getNombres(),
            "apellido_paterno"                => $o_MST_PersonaMastBN->getApellidoPaterno(),
            "apellido_materno"                => $o_MST_PersonaMastBN->getApellidoMaterno(),
            "dni"                             => $o_VTA_FacturacionElectronicaBN->getClienteDocNum(),
            "tipo_entidad_id"                 => $o_MST_PersonaMastBN->getTipoDocumentoSunat(),
            "descripcion"                     => $o_VTA_FacturacionElectronicaBN->getClienteTipoDoc(),
            "abreviatura_tipo_entidad"        => $o_VTA_FacturacionElectronicaBN->getClienteTipoDoc(),
            "tipo_entidad"                    => $o_VTA_FacturacionElectronicaBN->getClienteTipoDoc(),
            "codigo_tipo_entidad"             => $o_MST_PersonaMastBN->getTipoDocumentoSunat(),
            "tipo_documento_id"               => intval( $o_VTA_TipoDocumentoBN->getCodigoFiscal() ),
            "abreviado"                       => $o_VTA_TipoDocumentoBN->getIdTipoDocumento(),
            "tipo_documento_codigo"           => $o_VTA_TipoDocumentoBN->getCodigoFiscal(),
            "tipo_documento"                  => $o_VTA_TipoDocumentoBN->getDescripcionLocal(),

            "detraccion_porcentaje"           => "",

            "retencion_porcentaje"            => $o_VTA_DocumentoBN->getRetencionPorcentaje(),
            "retencion_baseimponible"         => $o_VTA_DocumentoBN->getRetencionBaseImponible(),
            "retencion_monto"                 => $o_VTA_DocumentoBN->getRetencionTotal(),

        );

        return $a_Data;
    }

    public function venta_documento( $venta_id )
    {
        $o_VTA_FacturacionElectronicaFN = new VTA_FacturacionElectronicaFN();
        $o_VTA_FacturacionElectronicaBN = $o_VTA_FacturacionElectronicaFN->selectByPK( $venta_id );

        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
        $o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $o_VTA_FacturacionElectronicaBN->getTipo(), $o_VTA_FacturacionElectronicaBN->getIdCompania(), $o_VTA_FacturacionElectronicaBN->getFactElecId() );

        $o_VTA_TipoDocumentoBN = $o_VTA_DocumentoBN->getObjectTipoDocumento();

        $a_Data = array(
            "venta_id"              => $venta_id,
            "serie"                 => $o_VTA_FacturacionElectronicaBN->getSerie(),
            "numero"                => intval( $o_VTA_FacturacionElectronicaBN->getNumero() ),
            "tipo_documento_id"     => intval( $o_VTA_TipoDocumentoBN->getCodigoFiscal() ),
            "tipo_documento_codigo" => $o_VTA_TipoDocumentoBN->getCodigoFiscal(),
            "codigo"                => $o_VTA_TipoDocumentoBN->getCodigoFiscal(),
            "tipo_documento"        => $o_VTA_TipoDocumentoBN->getDescripcionLocal(),
        );

        return $a_Data;
    }
}