<?php

class Venta_detalles_model
{
    public function query_detalle( $venta_id )
    {
        $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
        $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $venta_id );
        $o_VTA_DocumentoDetalleFN->addCondition( VTA_DocumentoDetalleFN::TipoDetalle, "IN", "('P','S')", false );
        $a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();

        $a_Row = array();
        foreach( $a_VTA_DocumentoDetalle as $o_VTA_DocumentoDetalleBN )
        {
            $o_ALM_ItemMastBN          = $o_VTA_DocumentoDetalleBN->getObjectItem();
            $o_MST_UnidadMastBN        = $o_ALM_ItemMastBN->getObjectUnidad();
            $o_MST_TipoAfectacionIGVBN = $o_VTA_DocumentoDetalleBN->getObjectTipoAfectacionIGV();

            $a_Data = array(
                "cantidad"             => $o_VTA_DocumentoDetalleBN->getCantidadPedida(),
                "precio_base"          => $o_VTA_DocumentoDetalleBN->getPrecioUnitario(),
                "tipo_igv_id"          => $o_MST_TipoAfectacionIGVBN->getTipoIgvId(),
                "impuesto_bolsa"       => 0,
                "descuento"            => $o_VTA_DocumentoDetalleBN->getMontoDescuento(),
                "producto_id"          => $o_ALM_ItemMastBN->getCodigoInterno(),
                "codigo_sunat"         => $o_ALM_ItemMastBN->getCodigoSunat(),
                "codigo_producto"      => $o_VTA_DocumentoDetalleBN->getItemCodigo(),
                "producto"             => $o_VTA_DocumentoDetalleBN->getDescripcion(),
                "precio_base_venta"    => $o_VTA_DocumentoDetalleBN->getPrecioUnitario(),
                "comision_venta"       => 0,
                "imagen"               => "",
                "codigo_unidad"        => $o_MST_UnidadMastBN->getCodigoSunat(),
                "unidad"               => $o_MST_UnidadMastBN->getDescripcionCorta(),
                "codigo_de_tributo"    => $o_MST_TipoAfectacionIGVBN->getCodigoTributo(),
                "tipo_igv_codigo"      => $o_MST_TipoAfectacionIGVBN->getCodigoSunat(),
                "nombre_tributo"       => "IGV",
                "codigo_internacional" => "VAT"
            );

            $a_Row[] = $a_Data;
        }

        return $a_Row;
    }
}
