<?php
class iOrdenVenta
{
    protected $OrdenId;
    protected $TipoProc = "nvo";
    protected $EsInafecto;
    protected $ClientId;
    protected $CondicionVentaId;
    protected $OrdenNum;
    protected $OrdenFecha;
    protected $OrdenCompraref;

    public function getOrdenCompraref()
    {
        return $this->OrdenCompraref;
    }

    public function setOrdenCompraref( $OrdenCompraref ): void
    {
        $this->OrdenCompraref = $OrdenCompraref;
    }

    public function getOrdenFecha()
    {
        return $this->OrdenFecha;
    }

    public function setOrdenFecha( $FechaOrden ): void
    {
        $this->OrdenFecha = $FechaOrden;
    }

    public function getOrdenNum()
    {
        return $this->OrdenNum;
    }

    public function setOrdenNum( $OrdenNum ): void
    {
        $this->OrdenNum = $OrdenNum;
    }

    public function getCondicionVentaId()
    {
        return $this->CondicionVentaId;
    }

    public function setCondicionVentaId( $CondicionVentaId ): void
    {
        $this->CondicionVentaId = $CondicionVentaId;
    }

    public function getClientId()
    {
        return $this->ClientId;
    }

    public function setClientId( $ClientId ): void
    {
        $this->ClientId = $ClientId;
    }

    public function getOrdenId()
    {
        return $this->OrdenId;
    }

    public function setOrdenId( $Id ): void
    {
        $this->OrdenId = $Id;
    }

    public function getTipoProc(): string
    {
        return $this->TipoProc;
    }

    public function setTipoProc( $TipoProc ): void
    {
        $this->TipoProc = $TipoProc;
    }

    public function getEsInafecto()
    {
        return $this->EsInafecto;
    }

    public function setEsInafecto( $EsInafecto ): void
    {
        $this->EsInafecto = $EsInafecto;
    }

    public function agregarAperturaPeriodo(  )
    {
        $o_PRO_CierreMensualFN = new PRO_CierreMensualFN();
        $o_PRO_CierreMensualBN = $o_PRO_CierreMensualFN->selectByPK( myUser::getUser()->getIdCompania(), date( "Ym" ) );
        if( !$o_PRO_CierreMensualBN )
        {
            $o_PRO_CierreMensualDP = new PRO_CierreMensualDP();
            $o_PRO_CierreMensualDP->setIdCompania( myUser::getUser()->getIdCompania() );
            $o_PRO_CierreMensualDP->setIdPeriodo( date( "Ym" ) );
            $o_PRO_CierreMensualDP->setAnio( date( "Y" ) );
            $o_PRO_CierreMensualDP->setMes( date( "m" ) );
            $o_PRO_CierreMensualDP->setEstado( "1" );
            $o_PRO_CierreMensualDP->setComentario( "" );
            $o_PRO_CierreMensualDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
            $o_PRO_CierreMensualDP->setUsuarioCreacion( ( string ) myUser::getUser()->getIdCompania() );
            $o_PRO_CierreMensualDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_PRO_CierreMensualDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_PRO_CierreMensualDP->save();
        }

        $o_FCO_CierreFN = new FCO_CierreFN();
        $o_FCO_CierreFN->setIdCompania( myUser::getUser()->getIdCompania() );
        $o_FCO_CierreFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        $o_FCO_CierreFN->setEstado( FCO_CierreBN::ESTADO_ABIERTO );
        $o_FCO_CierreFN->setCodVendedor( myUser::getUser()->getUserId() );
        $a_FCO_Cierre = $o_FCO_CierreFN->select();
        if( !$a_FCO_Cierre )
        {
            $o_FCO_CierreDP = new FCO_CierreDP();
            $i_IdCierre = FCO_CierreDP::recuperarId(); //se genera el cierre

            $o_FCO_CierreDP->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_FCO_CierreDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
            $o_FCO_CierreDP->setIdTurno( 1 ); //mañana
            $o_FCO_CierreDP->setIdCaja( 1 ); //caja 1
            $o_FCO_CierreDP->setIdCierre( $i_IdCierre );
            $o_FCO_CierreDP->setCodVendedor( myUser::getUser()->getUserId() );
            $o_FCO_CierreDP->setPeriodo( date( "Y-m" ) );
            $o_FCO_CierreDP->setEstado( "A" ); //abierto
            $o_FCO_CierreDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
            $o_FCO_CierreDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
            $o_FCO_CierreDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_FCO_CierreDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_FCO_CierreDP->save();
        }
    }

    public function agregarTipoCambioSoles(  )
    {
        $o_GSS_TipoCambioFN = new GSS_TipoCambioFN();
        $o_GSS_TipoCambioBN = $o_GSS_TipoCambioFN->selectByPK( "EX", "LO", date( "Y-m-d" ), myUser::getUser()->getIdCompania() );
        if( !$o_GSS_TipoCambioBN )
        {
            $o_GSS_TipoCambioDP = new GSS_TipoCambioDP();
            $o_GSS_TipoCambioDP->setIdMoneda( "EX" );
            $o_GSS_TipoCambioDP->setIdMonedaCambio( "LO" );
            $o_GSS_TipoCambioDP->setIdFechaCambio( date( "Y-m-d" ) );
            $o_GSS_TipoCambioDP->setIdCompania( myUser::getUser()->getIdCompania() );
            $o_GSS_TipoCambioDP->setSunatCompra( 1 );
            $o_GSS_TipoCambioDP->setSunatVenta( 1 );
            $o_GSS_TipoCambioDP->setTipoCambioCobranza( 1 );
            $o_GSS_TipoCambioDP->setEstado( "A" );
            $o_GSS_TipoCambioDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
            $o_GSS_TipoCambioDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
            $o_GSS_TipoCambioDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_GSS_TipoCambioDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_GSS_TipoCambioDP->save();
        }

        /*
        //Registro del tipo de cambio por ws
        $s_FechaSel = date( "Y-m-d" );
        $o_iVentas = new iVentas();
        $o_iVentas->registrarTipoCambio( $s_FechaSel );
        */
    }

    public function crearOrdenCabecera(): bool
    {
        $i_Id       = $this->getOrdenId();
        $s_TipoProc = $this->getTipoProc();
        $IdUbigeo   = "140101"; //por defecto lima

        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            $IdCompania         = myUser::getUser()->getIdBusiness();
            $o_GSS_CompaniaBN   = GSS_CompaniaFN::buscarCompania( $IdCompania );

            $OrdenTipoId                = 2; //MASTER
            $ClienteNumero              = $o_GSS_CompaniaBN->getIdClientePorDef();
            if( $this->getClientId() )
            {
                $ClienteNumero              = $this->getClientId();
            }

            $Comentario                 = "";
            $FactRegla                  = "MER";
            $ValidezOrden               = "1";
            $PlazaEntregaOrden          = "1";
            $CondicionVenta             = null;
            $s_OrdenCompraRef           = $this->getOrdenCompraref();
            $s_OrdenTipoComercialId     = 1;
            $s_OrdenTipoClasificacionId = 1;
            $s_DiasAlquiler             = null;
            $s_CondicionVentaId         = $this->getCondicionVentaId();

            //SE BUSCA LA DESCRIPCION DE LA CONDICION DE VENTA
            $o_VTA_FormaPagoFN = new VTA_FormaPagoFN();
            $o_VTA_FormaPagoBN = $o_VTA_FormaPagoFN->selectByPK( $s_CondicionVentaId );
            if( !$o_VTA_FormaPagoBN )
            {
                throw new Exception( "La Condicion de Venta no ha sido seleccionada." );
            }

            $s_FormaPagoDesc = $o_VTA_FormaPagoBN->getDescripcionLocal();

            //$a_DataValidez = VTA_OrdenBN::getArrayValidezOrden( $ValidezOrden );
            $o_MST_ValidezOfFN = new MST_ValidezOfFN();
            $o_MST_ValidezOfBN = $o_MST_ValidezOfFN->selectByPK( $ValidezOrden );
            $OrdenVenc = UtilDate::obtenerOrdenFechaVenc( $o_MST_ValidezOfBN->getCantHoras() );
            //$OrdenVenc = UtilDate::obtenerOrdenFechaVenc( ( $s_DiasAlquiler * 24 ) );

            $MonedaCod          = "LO";
            $MonedaCambioValor  = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
            $IdProyecto         = null;

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //se prepara el almacen por defecto:
            $o_GSS_SucursalFN = new GSS_SucursalFN();
            $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( myUser::getUser()->getIdSucursal() );

            $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
            $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $o_GSS_SucursalBN->getIdAlmacen() );

            //$a_ALM_AlmacenMast = ALM_AlmacenMastFN::recuperarAlmacenParaVentas( myUser::getUser()->getIdSucursal() );
            if( $o_ALM_AlmacenMastBN )
            {
                $IdAlmacen       = $o_ALM_AlmacenMastBN->getIdAlmacen();
                $AlmacenDespacho = $IdAlmacen;
            }
            else
            {
                throw new Exception( "Se tiene que seleccionar un Almacen." );
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //se busca el cliente
            $o_MST_PersonaMastFN = new MST_PersonaMastFN();
            $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $ClienteNumero );
            if( !$o_MST_PersonaMastBN )
            {
                throw new Exception( "El Nro Documento ingresado no se encuentra registrado." );
            }

            $TipoDocCliente          = $o_MST_PersonaMastBN->getTipoDocumento();
            $NumDocuCliente          = $o_MST_PersonaMastBN->getDocumento();
            $ClienteDireccion        = $o_MST_PersonaMastBN->getDireccion();
            $ClienteDistritoDesc     = $o_MST_PersonaMastBN->getDistritoDesc();
            $ClienteDepartamentoDesc = $o_MST_PersonaMastBN->getDepartamentoDesc();
            $ProvinciaDesc           = $o_MST_PersonaMastBN->getProvinciaDesc();
            $ClienteNombre           = $o_MST_PersonaMastBN->getNombreCompletoLLeno();
            $VendedorAsigna          = $o_MST_PersonaMastBN->getVendedorAsignado();
            //$CanalCliente            = $o_MST_PersonaMastBN->getCanalCliente();
            $NivelPrecioCliente      = $o_MST_PersonaMastBN->getNivelPrecioCliente();
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            $o_VTA_OrdenBN = new VTA_OrdenBN();
            $o_VTA_OrdenBN->setOrdenObs( $Comentario );
            $o_VTA_OrdenBN->setAdminComentario( "" );
            $o_VTA_OrdenBN->setOrdenImpuestoFlag( "Y" );
            $o_VTA_OrdenBN->setOrdenExoneradoFlag( "N" );

            //NUEVO PROCEDIMIENTO, POR EXONERACION DEL IGV - 2021-12-29
            if( $o_GSS_SucursalBN->getEstaExoneradoIGV() )
            {
                $o_VTA_OrdenBN->setOrdenImpuestoFlag( "N" );
                $o_VTA_OrdenBN->setOrdenExoneradoFlag( "Y" );
            }

            if( $this->getEsInafecto() )
            {
                $o_VTA_OrdenBN->setOrdenImpuestoFlag( "N" );
                //$o_VTA_OrdenBN->setOrdenExoneradoFlag( "Y" );
            }

            $o_VTA_OrdenBN->setClienteId( ( int ) $ClienteNumero );
            $o_VTA_OrdenBN->setClienteDocCod( $TipoDocCliente );
            $o_VTA_OrdenBN->setClienteDocNum( $NumDocuCliente );
            $o_VTA_OrdenBN->setClienteNombre( $ClienteNombre );
            //$o_VTA_OrdenBN->setClienteSucursal( $ClienteDireccion );
            $o_VTA_OrdenBN->setFactDirec1( $ClienteDireccion );
            $o_VTA_OrdenBN->setFactDirec2( $ClienteDistritoDesc );
            $o_VTA_OrdenBN->setFactDirec3( $IdUbigeo );
            $o_VTA_OrdenBN->setPrecioNivel( $NivelPrecioCliente );
            $o_VTA_OrdenBN->setFactPais( "PERU" );
            $o_VTA_OrdenBN->setFactEstado( $ProvinciaDesc );
            $o_VTA_OrdenBN->setFactCiudad( $ClienteDepartamentoDesc );

            $o_VTA_OrdenBN->setValidezOrden( $ValidezOrden );
            $o_VTA_OrdenBN->setPlazaEntregaOrden( $PlazaEntregaOrden );
            $o_VTA_OrdenBN->setCondicionVenta( $CondicionVenta );
            $o_VTA_OrdenBN->setOrdenVenc( $OrdenVenc );
            $o_VTA_OrdenBN->setOrdenCompraRef( $s_OrdenCompraRef );

            $o_VTA_OrdenBN->setDiasAlquiler( intval( $s_DiasAlquiler ) );
            $o_VTA_OrdenBN->setIdProyecto( $IdProyecto );

            //ahora se deja actualizar la moneda y el tipo de cambio. - 2020-07-15
            $o_VTA_OrdenBN->setMonedaCod( $MonedaCod );
            $o_VTA_OrdenBN->setMonedaCambioValor( floatval( $MonedaCambioValor ) );

            $o_VTA_OrdenBN->setOrdenTipoId( $OrdenTipoId );
            $o_VTA_OrdenBN->setCondicionVentaId( $s_CondicionVentaId );
            $o_VTA_OrdenBN->setFormaPagoDesc( $s_FormaPagoDesc );

            if( $s_TipoProc == "nvo" )
            {
                //NUEVO
                $o_VTA_OrdenBN->setOrdenTipoComercialId( $s_OrdenTipoComercialId );
                $o_VTA_OrdenBN->setOrdenTipoClasificacionId( $s_OrdenTipoClasificacionId );
                $o_VTA_OrdenBN->setCiaCod( ( int ) $IdCompania );
                $o_VTA_OrdenBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
                $o_VTA_OrdenBN->setPtoVtaCod( "LIM" );

                $s_OrdenFecha = date( "Y-m-d H:i:s" );
                $o_VTA_OrdenBN->setOrdenFecha( $s_OrdenFecha );
                if( $this->getOrdenFecha() )
                {
                    $o_VTA_OrdenBN->setOrdenFecha( $this->getOrdenFecha() );
                }
                $o_VTA_OrdenBN->setAlmacenCod( $IdAlmacen );
                $o_VTA_OrdenBN->setAlmacenDespacho( $AlmacenDespacho );
                $o_VTA_OrdenBN->setVendedorCliente( $VendedorAsigna );
                $o_VTA_OrdenBN->setVendedorOrden( myUser::getUser()->getUserId() );
                $o_VTA_OrdenBN->setFactRegla( $FactRegla );
                $o_VTA_OrdenBN->setMonedaCod( $MonedaCod );
                $o_VTA_OrdenBN->setMonedaCambioValor( floatval( $MonedaCambioValor ) );
                $o_VTA_OrdenBN->setOrdenEstado( VTA_OrdenBN::ESTADO_ABIERTO );
                $o_VTA_OrdenBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_VTA_OrdenBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_VTA_OrdenBN->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                $o_VTA_OrdenBN->setUsuarioActualizacion( myUser::getUser()->getUserId() );
            }
            else
            {
                //UPDATE
                $o_VTA_OrdenBN->setOrdenId( ( int ) $i_Id );
            }

            $o_CotizacionesBL = new CotizacionesBL();
            $o_CotizacionesBL->iniciarOrdenVenta( $o_VTA_OrdenBN );

            $this->setOrdenId( $o_VTA_OrdenBN->getOrdenId() );
            $this->setOrdenNum( $o_VTA_OrdenBN->getOrdenNum() );

            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            pr( $o_Exception );
            $con->rollback();
            throw new Exception( $o_Exception );
        }

        return true;
    }

    protected $DsctoCod;
    protected $OrdenDscto;

    public function getOrdenDscto()
    {
        return $this->OrdenDscto;
    }

    public function setOrdenDscto( $OrdenDscto ): void
    {
        $this->OrdenDscto = $OrdenDscto;
    }

    public function getDsctoCod()
    {
        return $this->DsctoCod;
    }

    public function setDsctoCod( $DsctoCod ): void
    {
        $this->DsctoCod = ( string ) $DsctoCod;
    }

    public function aplicarDescuentoGlobal(  )
    {
        $o_VTA_OrdenDP = new VTA_OrdenDP();
        $o_VTA_OrdenDP->setOrdenId( $this->getOrdenId() );
        $o_VTA_OrdenDP->setDsctoCod( $this->getDsctoCod() ); //10%
        $o_VTA_OrdenDP->setDsctoTipoCod( "POR" );
        $o_VTA_OrdenDP->setOrdenDscto( $this->getOrdenDscto() ); //361 Soles
        $o_VTA_OrdenDP->setOrdenDsctoMN( $this->getOrdenDscto() );   //361 Soles
        $o_VTA_OrdenDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
        $o_VTA_OrdenDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
        $o_VTA_OrdenDP->update();

        VTA_OrdenDP::actualizarCabaceraMontos( $this->getOrdenId() );
    }

    protected $EstadoOrden;

    public function getEstadoOrden()
    {
        return $this->EstadoOrden;
    }

    public function setEstadoOrden( $EstadoOrden ): void
    {
        $this->EstadoOrden = $EstadoOrden;
    }

    public function cambiarEstadoOrden()
    {
        try
        {
            $o_VTA_OrdenBN = new VTA_OrdenBN();
            $o_VTA_OrdenBN->setOrdenId( $this->getOrdenId() );
            $o_VTA_OrdenBN->setOrdenEstado( $this->getEstadoOrden() );
            if( $this->getEstadoOrden() == VTA_OrdenBN::ESTADO_ANULADO )
            {
                //$s_MotivoAnulacion = $this->getRequestParameter( 'motivo_anulacion' );
                //$o_VTA_OrdenBN->setAnulacionComentario( $s_MotivoAnulacion );
            }
            $o_CotizacionesBL = new CotizacionesBL();
            $o_CotizacionesBL->cambiarEstadoOrdenVenta( $o_VTA_OrdenBN );
        }
        catch ( Exception $o_Exception )
        {
            throw new Exception( $o_Exception );
        }

        return true;
    }

    protected $ItemCod;
    protected $Cantidad;
    protected $OrdenDetalleNum;
    protected $PrecioPersonalizado;

    public function getPrecioPersonalizado()
    {
        return $this->PrecioPersonalizado;
    }

    public function setPrecioPersonalizado( $PrecioNuevo ): void
    {
        $this->PrecioPersonalizado = $PrecioNuevo;
    }

    public function getOrdenDetalleNum()
    {
        return $this->OrdenDetalleNum;
    }

    public function setOrdenDetalleNum( $OrdenDetalleNum ): void
    {
        $this->OrdenDetalleNum = $OrdenDetalleNum;
    }

    public function getCantidad()
    {
        return $this->Cantidad;
    }

    public function setCantidad( $Cantidad ): void
    {
        $this->Cantidad = $Cantidad;
    }

    public function getItemCod()
    {
        return $this->ItemCod;
    }

    public function setItemCod( $ItemCod ): void
    {
        $this->ItemCod = $ItemCod;
    }

    public function agregarDetalles()
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            $s_AlmacenCod = myUser::getUser()->getObjectSucursal()->getIdAlmacen();
            $o_VTA_OrdenDetalleBN = new VTA_OrdenDetalleBN();
            $o_VTA_OrdenDetalleBN->setOrdenId( $this->getOrdenId() );
            if( $this->getOrdenDetalleNum() )
            {
                $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
                $o_VTA_OrdenDetalleBN = $o_VTA_OrdenDetalleFN->selectByPK( $this->getOrdenId(), $this->getOrdenDetalleNum() );
                if( $o_VTA_OrdenDetalleBN )
                {
                    $o_VTA_OrdenDetalleBN->setOrdenDetalleNum( $this->getOrdenDetalleNum() );
                }
            }
            $o_VTA_OrdenDetalleBN->setItemCod( $this->getItemCod() );
            $o_VTA_OrdenDetalleBN->setAlmacenCod( $s_AlmacenCod );
            //$o_VTA_OrdenDetalleBN->setLoteNum( $IdLote );
            $o_VTA_OrdenDetalleBN->setIdUnidad( 58 );
            $o_VTA_OrdenDetalleBN->setOrdenDetalleCantidad( $this->getCantidad() );

            $o_CotizacionesDetalleBL = new CotizacionesDetalleBL();
            $o_CotizacionesDetalleBL->iniciarProceso( $o_VTA_OrdenDetalleBN );

            $i_IdDet = $o_VTA_OrdenDetalleBN->getOrdenDetalleNum();
            //pr($o_VTA_OrdenDetalleBN);

            if( $this->getPrecioPersonalizado() )
            {
                $o_VTA_OrdenDetalleBN = new VTA_OrdenDetalleBN();
                $o_VTA_OrdenDetalleBN->setOrdenId( $this->getOrdenId() );
                $o_VTA_OrdenDetalleBN->setOrdenDetalleNum( $i_IdDet ); //$this->getOrdenDetalleNum()
                $o_VTA_OrdenDetalleBN->setItemCod( $this->getItemCod() );
                $o_VTA_OrdenDetalleBN->setOrdenDetallePrecioNivel( "P" );
                $o_VTA_OrdenDetalleBN->setPrecioUnidadIncImpuesto( $this->getPrecioPersonalizado() );
                //$o_VTA_OrdenDetalleBN->setContrasenia(  );
                //$o_VTA_OrdenDetalleBN->setOrdenDetallePrecioUnidadMN( $f_PrecioPersa );

                $o_CotizacionesDetalleBL = new CotizacionesDetalleBL();
                $o_CotizacionesDetalleBL->iniciarCambioPrecio( $o_VTA_OrdenDetalleBN );
            }

            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            pr($o_Exception);
            $con->rollback();
            throw new Exception( $o_Exception );
        }
        return true;
    }

    public function eliminarDetalle()
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            $o_VTA_OrdenDetalleBN = new VTA_OrdenDetalleBN();
            $o_VTA_OrdenDetalleBN->setOrdenId( $this->getOrdenId() );
            $o_VTA_OrdenDetalleBN->setOrdenDetalleNum( $this->getOrdenDetalleNum() );

            $o_CotizacionesDetalleBL = new CotizacionesDetalleBL();
            $o_CotizacionesDetalleBL->eliminarLinea( $o_VTA_OrdenDetalleBN );

            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();

        }

        return true;
    }

    protected $FechaVencimiento;
    protected $FechaEmision;
    protected $DocComentario;

    public function getDocComentario()
    {
        return $this->DocComentario;
    }

    public function setDocComentario( $DocComentario ): void
    {
        $this->DocComentario = $DocComentario;
    }

    public function getFechaEmision()
    {
        return $this->FechaEmision;
    }

    public function setFechaEmision( $FechaEmision ): void
    {
        $this->FechaEmision = $FechaEmision;
    }

    public function getFechaVencimiento()
    {
        return $this->FechaVencimiento;
    }

    public function setFechaVencimiento( $FechaVencimiento ): void
    {
        $this->FechaVencimiento = $FechaVencimiento;
    }

    protected $IdTipoDocumento;
    protected $TipoDocumentoCod;
    protected $DocumentoSerie;
    protected $OrdenCompraRefVta;
    protected $NumrefAdicional;

    public function getIdTipoDocumento()
    {
        return $this->IdTipoDocumento;
    }

    public function setIdTipoDocumento( $IdTipoDocumento ): void
    {
        $this->IdTipoDocumento = $IdTipoDocumento;
    }

    public function getTipoDocumentoCod()
    {
        return $this->TipoDocumentoCod;
    }

    public function setTipoDocumentoCod( $TipoDocumentoCod ): void
    {
        $this->TipoDocumentoCod = $TipoDocumentoCod;
    }

    public function getDocumentoSerie()
    {
        return $this->DocumentoSerie;
    }

    public function setDocumentoSerie( $DocumentoSerie ): void
    {
        $this->DocumentoSerie = $DocumentoSerie;
    }

    public function getOrdenCompraRefVta()
    {
        return $this->OrdenCompraRefVta;
    }

    public function setOrdenCompraRefVta( $OrdenCompraRefVta ): void
    {
        $this->OrdenCompraRefVta = $OrdenCompraRefVta;
    }

    public function getNumrefAdicional()
    {
        return $this->NumrefAdicional;
    }

    public function setNumrefAdicional( $NumrefAdicional ): void
    {
        $this->NumrefAdicional = $NumrefAdicional;
    }

    public function generarComprobante(  )
    {
        try
        {
            $orden_id           = $this->getOrdenId();
            $txt_orden          = $this->getOrdenNum();

            $FechaDocumento     = date( "Y-m-d" ); //
            if( $this->getFechaEmision() )
            {
                $FechaDocumento     = $this->getFechaEmision(); //
            }

            $Comentario         = $this->getDocComentario();

            $IdTipoDocumento    = $this->getIdTipoDocumento();  //"BV"; //POR DEFECTO BOLETA
            $TipoDocumentoCod   = $this->getTipoDocumentoCod(); //"BOL";
            $DocumentoSerie     = $this->getDocumentoSerie();   //"B001";
            $DocumentoNumero    = "";
            $NaceAnulado        = "";
            $FechaVencimiento   = $this->getFechaVencimiento();

            $TipoVenta          = "MER";
            $IdVendedor         = myUser::getUser()->getUserId();

            $s_MonedaDocumento  = "LO";
            $f_TipodeCambio     = "";
            $f_Descuento        = 0;
            $f_MontoSubTotal    = 0;
            $f_TotalImpuesto    = 0;
            $f_MontoTotal       = 0;

            //PARAMETROS PARA LA DETRACCION
            $DetracconTipoId     = "";
            $DetracconPorcentaje = "";
            $DetracconMedPagoId  = "";
            $DetracconTotal      = "";

            $o_VTA_DocumentoBN = new VTA_DocumentoBN();
            $o_VTA_DocumentoBN->setDocumentoParentId( ( int ) $orden_id );
            $o_VTA_DocumentoBN->setDocumentoParentCod( $txt_orden );

            if( $this->getNumrefAdicional() )
            {
                $o_VTA_DocumentoBN->setNumeroRefAdicional1( $this->getNumrefAdicional() );
            }
            if( $this->getOrdenCompraRefVta() )
            {
                $o_VTA_DocumentoBN->setOrdenCompraRef( $this->getOrdenCompraRefVta() );
            }

            //SETEO PARA DETRACCIONES
            $o_VTA_DocumentoBN->setDetraccionTipoId( intval( $DetracconTipoId ) );
            $o_VTA_DocumentoBN->setDetraccionMedPagoId( intval( $DetracconMedPagoId ) );
            $o_VTA_DocumentoBN->setDetraccionPorcentaje( floatval( $DetracconPorcentaje ) );
            $o_VTA_DocumentoBN->setDetraccionTotal( floatval( $DetracconTotal ) );

            //PARAMETROS PARA RETENCION
            $RetencionTipoId        = "";
            $RetencionBaseImponible = "";
            $RetencionTotal         = "";

            //SETEO PARA RETENCION
            $o_VTA_DocumentoBN->setRetencionTipoId( intval( $RetencionTipoId ) );
            $o_VTA_DocumentoBN->setRetencionBaseImponible( floatval( $RetencionBaseImponible ) );
            $o_VTA_DocumentoBN->setRetencionTotal( floatval( $RetencionTotal ) );
            $o_VTA_DocumentoBN->setIdTipoDocumento( $IdTipoDocumento );
            $o_VTA_DocumentoBN->setEstado( VTA_DocumentoBN::ESTADO_PREPARACION ); //por defecto
            $o_VTA_DocumentoBN->setMonedaDocumento( $s_MonedaDocumento );
            $o_VTA_DocumentoBN->setTipodeCambio( $f_TipodeCambio );
            $o_VTA_DocumentoBN->setMontoSubTotal( $f_MontoSubTotal );
            $o_VTA_DocumentoBN->setMontoImpuestos( $f_TotalImpuesto );
            $o_VTA_DocumentoBN->setMontoTotal( $f_MontoTotal );

            //$FechaDocumento   = date( "Y-m-d H:i:s" );
            //$FechaVencimiento = $FechaDocumento;

            $o_VTA_DocumentoBN->setFechaDocumento( $FechaDocumento );
            $o_VTA_DocumentoBN->setTipoFacturacion( "N" );
            $o_VTA_DocumentoBN->setDocumentoCod( $TipoDocumentoCod );
            $o_VTA_DocumentoBN->setDocumentoSerie( $DocumentoSerie );
            $o_VTA_DocumentoBN->setDocumentoNumero( $DocumentoNumero );
            $o_VTA_DocumentoBN->setNumeroComprobante( $DocumentoSerie."-".$DocumentoNumero );
            $o_VTA_DocumentoBN->setFechaVencimiento( $FechaVencimiento );
            $o_VTA_DocumentoBN->setTipoVenta( $TipoVenta );
            $o_VTA_DocumentoBN->setComentario( $Comentario );
            if( $NaceAnulado )
            {
                $o_VTA_DocumentoBN->setEstado( VTA_DocumentoBN::ESTADO_ANULADO );
                $o_VTA_DocumentoBN->setAnulacionComentario( $Comentario );
            }

            $o_VTA_DocumentoBN->setVendedor( myUser::getUser()->getUserId() );
            if( $IdVendedor )
            {
                $o_VTA_DocumentoBN->setVendedor( $IdVendedor );
            }

            $o_OrdenVentaBL = new OrdenVentaBL();
            $o_OrdenVentaBL->guardarDocumentoPorOrden( $o_VTA_DocumentoBN );

            return $o_VTA_DocumentoBN;
        }
        catch ( Exception $o_Exception )
        {
            //pr( $o_Exception );
            throw new Exception( $o_Exception->getMessage() );
        }

    }

    protected $EstadoRecibo;
    protected $FechaRecibo;
    protected $IdDocRecibo;
    protected $IdAplicacion;
    protected $ReciboNumero;
    protected $IdTipoPago;
    protected $IdBanco;
    protected $MontoAplicar;

    public function getMontoAplicar()
    {
        return $this->MontoAplicar;
    }

    public function setMontoAplicar( $MontoAplicar ): void
    {
        $this->MontoAplicar = $MontoAplicar;
    }

    public function getIdBanco()
    {
        return $this->IdBanco;
    }

    public function setIdBanco( $IdBanco ): void
    {
        $this->IdBanco = $IdBanco;
    }

    public function getIdTipoPago()
    {
        return $this->IdTipoPago;
    }

    public function setIdTipoPago( $IdTipoPago ): void
    {
        $this->IdTipoPago = $IdTipoPago;
    }

    public function getReciboNumero()
    {
        return $this->ReciboNumero;
    }

    public function setReciboNumero( $ReciboNumero ): void
    {
        $this->ReciboNumero = $ReciboNumero;
    }

    public function getIdAplicacion()
    {
        return $this->IdAplicacion;
    }

    public function setIdAplicacion( $IdAplicacion ): void
    {
        $this->IdAplicacion = $IdAplicacion;
    }

    public function getIdDocRecibo()
    {
        return $this->IdDocRecibo;
    }

    public function setIdDocRecibo( $IdDocRecibo ): void
    {
        $this->IdDocRecibo = $IdDocRecibo;
    }

    public function getFechaRecibo()
    {
        return $this->FechaRecibo;
    }

    public function setFechaRecibo( $FechaRecibo ): void
    {
        $this->FechaRecibo = $FechaRecibo;
    }

    public function getEstadoRecibo()
    {
        return $this->EstadoRecibo;
    }

    public function setEstadoRecibo( $EstadoRecibo ): void
    {
        $this->EstadoRecibo = $EstadoRecibo;
    }

    public function registrarRecibo(  ): bool
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            //$s_OrdNum           = "M000000051";
            //$i_IdOrden          = 51;

            $o_VTA_OrdenFN = new VTA_OrdenFN();
            $o_VTA_OrdenBN     = $o_VTA_OrdenFN->selectByPK( $this->getOrdenId() );

            //$o_VTA_OrdenBN     = VTA_OrdenFN::findOrdenByNum( $s_OrdNum );
            $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $o_VTA_OrdenBN->getDocReferenciaId() ); //SE RECUPERA EL COMPROBANTE DEL CLIENTE

            $i_IdPersona        = $o_VTA_OrdenBN->getClienteId();
            $s_IdMoneda         = $o_VTA_OrdenBN->getMonedaCod(); //moneda del recibo
            $i_IdTipoPago       = $this->getIdTipoPago();
            $i_IdBanco          = $this->getIdBanco();
            $i_IdCuenta         = null;
            $i_TerminoPago      = 0;
            $s_ReciboNumero     = $this->getReciboNumero();
            $s_ReciboFecha      = $this->getFechaRecibo();
            //$s_FechaVenc        = null;
            $f_TipodeCambio     = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
            if( !$f_TipodeCambio )
            {
                throw new Exception( "No se encuentra registrado el Tipo de Cambio." );
            }
            $s_Descripcion      = "COBRO POR FACTURA";
            $f_Monto            = $this->getMontoAplicar();
            $f_MontoSoles       = $f_Monto;
            $f_MontoDolar       = round( $f_Monto / $f_TipodeCambio, 2 );
            $f_NvoDocuPagado    = $o_VTA_DocumentoBN->getMontoTotal();
            $f_NvoDocuPagadoMN  = $o_VTA_DocumentoBN->getMontoTotal();

            $f_SaldoMonto       = $f_Monto;
            $f_SaldoMontoSoles  = $f_MontoSoles;
            $f_SaldoMontoDolar  = $f_MontoDolar;
            $f_NvoDocuSaldo     = $o_VTA_DocumentoBN->getMontoSaldo();
            //$f_NvoDocuSaldoMN   = $f_NvoDocuPagadoMN;

            if( $this->getEstadoRecibo() == FCO_DocReciboBN::FLUESTADO_APROBADO )
            {
                $f_SaldoMonto       = 0;
                $f_SaldoMontoSoles  = 0;
                $f_SaldoMontoDolar  = 0;
                //$f_NvoDocuSaldo     = 0;
                //$f_NvoDocuSaldoMN   = 0;
            }

            $o_MST_CuentaBancariaFN = new MST_CuentaBancariaFN();
            $o_MST_CuentaBancariaFN->setEstado( "A" );
            $o_MST_CuentaBancariaFN->setIdBanco( $i_IdBanco );
            $a_MST_CuentaBancaria = $o_MST_CuentaBancariaFN->select();
            if( $a_MST_CuentaBancaria )
            {
                $i_IdCuenta = $a_MST_CuentaBancaria[0]->getIdCuenta();
            }

            //se recupera info de la moneda del recibo
            $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
            $o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $s_IdMoneda );

            //los datos de tipo de pago
            $o_FCO_TipoPagoFN = new FCO_TipoPagoFN();
            $o_FCO_TipoPagoBN = $o_FCO_TipoPagoFN->selectByPK( $i_IdTipoPago );

            $i_IdTipoPago  = $o_FCO_TipoPagoBN->getIdTipoPago();
            $s_TipoPagoNom = $o_FCO_TipoPagoBN->getNombre();
            $s_ClaseNombre = $o_FCO_TipoPagoBN->getClaseNombre();

            //se busca el cliente
            $o_MST_PersonaMastFN = new MST_PersonaMastFN();
            $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $i_IdPersona );

            $s_NumTipoDocCliente = $o_MST_PersonaMastBN->getDocumento();
            $s_TipoDocCliente    = $o_MST_PersonaMastBN->getTipoDocumento();
            $s_NombreCliente     = $o_MST_PersonaMastBN->getNombreCompletoLLeno();

            //ahora se busca el numero de cuenta
            $s_NumeroCuenta = null;
            if( $i_IdCuenta )
            {
                $o_MST_CuentaBancariaFN = new MST_CuentaBancariaFN();
                $o_MST_CuentaBancariaBN = $o_MST_CuentaBancariaFN->selectByPK( $i_IdCuenta );
                $s_NumeroCuenta = $o_MST_CuentaBancariaBN->getNumeroCuenta();
            }

            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            ///
            $o_FCO_DocReciboDP = new FCO_DocReciboDP();

            //se hace un insert
            //en el caso de una cobranza nueva
            $i_IdDocRecibo = FCO_DocReciboDP::recuperarId();

            $o_FCO_DocReciboDP->setIdDocRecibo( $i_IdDocRecibo );

            if( $i_IdTipoPago == 1 )
            {
                $s_ReciboNumero = ( string ) $i_IdDocRecibo;
            }
            $o_FCO_DocReciboDP->setReciboNumero( $s_ReciboNumero );
            $o_FCO_DocReciboDP->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_FCO_DocReciboDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
            $o_FCO_DocReciboDP->setIdTipoPago( $i_IdTipoPago );
            $o_FCO_DocReciboDP->setIdMoneda( $s_IdMoneda );
            $o_FCO_DocReciboDP->setMonedaDes( $o_GSS_MonedaMastBN->getDescripcion() );
            $o_FCO_DocReciboDP->setIdBanco( $i_IdBanco );
            $o_FCO_DocReciboDP->setIdCuenta( $i_IdCuenta );
            $o_FCO_DocReciboDP->setNumeroCuenta( $s_NumeroCuenta );
            $o_FCO_DocReciboDP->setClaseNombre( $s_ClaseNombre );
            $o_FCO_DocReciboDP->setTipoCambio( $f_TipodeCambio );
            $o_FCO_DocReciboDP->setIdPersona( $i_IdPersona );
            $o_FCO_DocReciboDP->setTipoDocCliente( $s_TipoDocCliente );
            $o_FCO_DocReciboDP->setNumTipoDocCliente( $s_NumTipoDocCliente );
            $o_FCO_DocReciboDP->setNombreCliente( $s_NombreCliente );
            $o_FCO_DocReciboDP->setDescripcion( $s_Descripcion );
            $o_FCO_DocReciboDP->setReciboFecha( $s_ReciboFecha );
            $o_FCO_DocReciboDP->setTerminoPago( $i_TerminoPago );
            //$o_FCO_DocReciboDP->setFechaVencimiento( $s_FechaVenc );
            //$o_FCO_DocReciboDP->setFlujoEstado( "PE" ); //PE NDIENTE - AP ROBADO - REC HAZADO
            $o_FCO_DocReciboDP->setFlujoEstado( $this->getEstadoRecibo() ); //PE NDIENTE - AP ROBADO - REC HAZADO
            if( $this->getEstadoRecibo() == FCO_DocReciboBN::FLUESTADO_APROBADO )
            {
                $o_FCO_DocReciboDP->setFechaAprobacion( date( "Y-m-d H:i:s" ) ); //nace aprobado
                $o_FCO_DocReciboDP->setApruebaUsuario( myUser::getUser()->getUserId() );
            }
            $o_FCO_DocReciboDP->setEstado( FCO_DocReciboBN::ESTADO_ACTIVO ); //AC TIVO - AN ULADO
            $o_FCO_DocReciboDP->setCobranzaEstado( FCO_DocReciboBN::ESTADO_COB_PENDIENTE );
            //$o_FCO_DocReciboDP->setFechaCobranza( date( "Y-m-d H:i:s" ) );
            $o_FCO_DocReciboDP->setMonto( $f_Monto );
            $o_FCO_DocReciboDP->setSaldo( $f_SaldoMonto );
            $o_FCO_DocReciboDP->setMontoMN( $f_MontoSoles );
            $o_FCO_DocReciboDP->setSaldoMN( $f_SaldoMontoSoles );
            $o_FCO_DocReciboDP->setMontoME( $f_MontoDolar );
            $o_FCO_DocReciboDP->setSaldoME( $f_SaldoMontoDolar );

            $o_FCO_DocReciboDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
            $o_FCO_DocReciboDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
            $o_FCO_DocReciboDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_FCO_DocReciboDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            //pr( $o_FCO_DocReciboDP );
            $o_FCO_DocReciboDP->save();
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //AHORA SE REGISTRA LA APLICACION

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //recupero el id de caja y el turno
            $o_FCO_CierreFN = new FCO_CierreFN();
            $o_FCO_CierreFN->setEstado( FCO_CierreBN::ESTADO_ABIERTO );
            $o_FCO_CierreFN->setCodVendedor( myUser::getUser()->getUserId() );
            $a_FCO_Cierre = $o_FCO_CierreFN->select();
            if( !$a_FCO_Cierre )
            {
                throw new Exception( "No se aperturo ninguna Caja." );
            }
            if( count( $a_FCO_Cierre ) > 1 )
            {
                throw new Exception( "Incongruencia de datos, por favor de revisar el Cierre de Caja." );
            }
            $i_IdCaja = null;
            $i_IdTurno = null;
            if( count( $a_FCO_Cierre ) == 1 )
            {
                $o_FCO_CierreBN = $a_FCO_Cierre[0];
                $i_IdCaja       = $o_FCO_CierreBN->getIdCaja();
                $i_IdTurno      = $o_FCO_CierreBN->getIdTurno();
                //$s_CodVendedor  = $o_FCO_CierreBN->getCodVendedor();
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            $f_MontoAplicar = $this->getMontoAplicar();
            $f_MontoAplicarMN = $f_MontoAplicar;
            $f_MontoAplicarME = round( $f_MontoAplicar / $f_TipodeCambio, 2 );

            //ahora se guarda la aplicacion
            $i_IdAplicacion = FCO_AplicacionDP::recuperarId();

            $o_FCO_AplicacionDP = new FCO_AplicacionDP();
            $o_FCO_AplicacionDP->setIdAplicacion( $i_IdAplicacion );
            $o_FCO_AplicacionDP->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_FCO_AplicacionDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
            $o_FCO_AplicacionDP->setIdCaja( $i_IdCaja );
            $o_FCO_AplicacionDP->setIdTurno( $i_IdTurno );
            $o_FCO_AplicacionDP->setIdBanco( $i_IdBanco );
            $o_FCO_AplicacionDP->setIdCuenta( $i_IdCuenta );
            $o_FCO_AplicacionDP->setIdMoneda( $s_IdMoneda );
            $o_FCO_AplicacionDP->setMonedaDes( $o_GSS_MonedaMastBN->getDescripcion() );

            $o_FCO_AplicacionDP->setIdTipoPago( $i_IdTipoPago );
            $o_FCO_AplicacionDP->setTipoPagoNombre( $s_TipoPagoNom );
            $o_FCO_AplicacionDP->setClaseNombre( $s_ClaseNombre ); //BANCOS - EFECTIVO - TARJETA - AJUSTES - NC
            $o_FCO_AplicacionDP->setNombreTipo( FCO_AplicacionBN::T_APLICACION_PAGO ); //PAGO - NOTA_CREDITO
            $o_FCO_AplicacionDP->setDescripcion( $s_Descripcion );

            $o_FCO_AplicacionDP->setIdPersona( $i_IdPersona );
            $o_FCO_AplicacionDP->setTipoDocCliente( $s_TipoDocCliente );
            $o_FCO_AplicacionDP->setNumTipoDocCliente( $s_NumTipoDocCliente );
            $o_FCO_AplicacionDP->setNombreCliente( $s_NombreCliente );
            $o_FCO_AplicacionDP->setReciboNumero( $s_ReciboNumero ); //es el numero de operacion de un recibo o una nota de credito, info de donde del padre
            $o_FCO_AplicacionDP->setIdDocRecibo( $i_IdDocRecibo ); //no esta nullo cuando es un pago normal para un recibo, es nulo cuando se aplica por una nota de cred
            //$o_FCO_AplicacionDP->setIdNumeroDocumento(  ); //cuando nace por una nota de credito se setea el id del comprobante
            $o_FCO_AplicacionDP->setIdDocNumRef( $o_VTA_DocumentoBN->getNumeroDocumento() );
            $o_FCO_AplicacionDP->setCodDocRef( $o_VTA_DocumentoBN->getDocumentoCod() );
            $o_FCO_AplicacionDP->setSerieNumeroDocRef( $o_VTA_DocumentoBN->getDocumentoSerieNumero() );
            $o_FCO_AplicacionDP->setMontoTotalDocRef( $o_VTA_DocumentoBN->getMontoTotal() );
            $o_FCO_AplicacionDP->setSaldoDocRef( $f_NvoDocuSaldo );
            $o_FCO_AplicacionDP->setFechaDocRef( $o_VTA_DocumentoBN->getFechaDocumento() );
            $o_FCO_AplicacionDP->setFechaDocVenRef( $o_VTA_DocumentoBN->getFechaVencimiento() );
            $o_FCO_AplicacionDP->setIdMonedaRef( $o_VTA_DocumentoBN->getMonedaDocumento() );
            $o_FCO_AplicacionDP->setTipoCambioRef( $o_VTA_DocumentoBN->getTipodeCambio() );
            $o_FCO_AplicacionDP->setCodVendedorRef( $o_VTA_DocumentoBN->getVendedor() );
            $o_FCO_AplicacionDP->setIdAlmacenRef( $o_VTA_DocumentoBN->getIdAlmacen() );
            $o_FCO_AplicacionDP->setTipoCambio( $f_TipodeCambio ); //POR DEFECTO 1 POR SER EN SOLES
            $o_FCO_AplicacionDP->setPeriodo( date( "Ym" ) );
            $o_FCO_AplicacionDP->setFechaAplicacion( date( "Y-m-d H:i:s" ) );
            $o_FCO_AplicacionDP->setMontoAplicado( $f_MontoAplicar );
            $o_FCO_AplicacionDP->setMontoAplicacionMN( $f_MontoAplicarMN );
            $o_FCO_AplicacionDP->setMontoAplicacionME( $f_MontoAplicarME );
            $o_FCO_AplicacionDP->setMostrar( "Y" ); //al parecer cuando se hace la reversion en reportes especiales no se muestra
            $o_FCO_AplicacionDP->setEstado( $this->getEstadoRecibo() ); //PE NDIENTE - AP LICADO - AN ULADO
            $o_FCO_AplicacionDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
            $o_FCO_AplicacionDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
            $o_FCO_AplicacionDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_FCO_AplicacionDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            //pr( $o_FCO_AplicacionDP );
            $o_FCO_AplicacionDP->save();
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //ahora se actualiza los saldos del comprobante
            if( $this->getEstadoRecibo() == FCO_DocReciboBN::FLUESTADO_APROBADO )
            {
                $o_VTA_DocumentoDP = new VTA_DocumentoDP();
                $o_VTA_DocumentoDP->setIdTipoDocumento( $o_VTA_DocumentoBN->getIdTipoDocumento() );
                $o_VTA_DocumentoDP->setIdCompania( $o_VTA_DocumentoBN->getIdCompania() );
                $o_VTA_DocumentoDP->setNumeroDocumento( $o_VTA_DocumentoBN->getNumeroDocumento() );
                $o_VTA_DocumentoDP->setMontoPagado( $f_NvoDocuPagado );
                $o_VTA_DocumentoDP->setMontoPagadoMN( $f_NvoDocuPagadoMN );
                $o_VTA_DocumentoDP->setMontoSaldo( 0 );
                $o_VTA_DocumentoDP->setMontoSaldoMN( 0 );
                if( $o_VTA_DocumentoBN->getMontoTotal() == $f_NvoDocuPagado || $o_VTA_DocumentoBN->getMontoPagadoMN() == $f_NvoDocuPagadoMN )
                {
                    $o_VTA_DocumentoDP->setFechaAprobacion( date( "Y-m-d H:i:s" ) );
                    $o_VTA_DocumentoDP->setFechaCobranza( date( "Y-m-d H:i:s" ) );
                    $o_VTA_DocumentoDP->setCobranzaEstado( VTA_DocumentoBN::ESTADO_COB_COBRADO );
                }
                $o_VTA_DocumentoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_VTA_DocumentoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                //pr( $o_VTA_DocumentoDP );
                $o_VTA_DocumentoDP->update();
            }
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            $this->setIdDocRecibo( $i_IdDocRecibo );
            $this->setIdAplicacion( $i_IdAplicacion );

            $con->commit();
        }
        catch( Exception $exc )
        {
            pr( $exc );
            $con->rollback();
            throw new Exception( $exc->getMessage() );
        }

        return true;
    }

    public function moverPendienteRecibo(  ): bool
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            $i_IdDocRecibo     = $this->getIdDocRecibo();
            $i_IdPersona       = $this->getClientId();
            $s_NumeroDocumento = $this->getOrdenNum();

            $i_IdTipoPago       = $this->getIdTipoPago();
            $i_IdBanco          = $this->getIdBanco();
            $i_IdCuenta         = null;
            $s_ReciboNumero     = $this->getReciboNumero();
            $s_ReciboFecha      = $this->getFechaRecibo();

            $f_TipodeCambio     = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
            if( !$f_TipodeCambio )
            {
                throw new Exception( "No se encuentra registrado el Tipo de Cambio." );
            }

            $f_Monto            = $this->getMontoAplicar();
            $f_MontoSoles       = $f_Monto;
            $f_MontoDolar       = round( $f_Monto / $f_TipodeCambio, 2 );
            //$f_NvoDocuPagado    = $o_VTA_DocumentoBN->getMontoTotal();
            //$f_NvoDocuPagadoMN  = $o_VTA_DocumentoBN->getMontoTotal();

            $f_SaldoMonto       = $f_Monto;
            $f_SaldoMontoSoles  = $f_MontoSoles;
            $f_SaldoMontoDolar  = $f_MontoDolar;
            //$f_NvoDocuSaldo     = $o_VTA_DocumentoBN->getMontoSaldo();

            $o_FCO_DocReciboFN = new FCO_DocReciboFN();
            $o_FCO_DocReciboFN->setIdDocRecibo( $i_IdDocRecibo );
            $o_FCO_DocReciboFN->setIdPersona( $i_IdPersona );
            $a_FCO_DocRecibo = $o_FCO_DocReciboFN->select();
            if( $a_FCO_DocRecibo )
            {
                $o_FCO_DocReciboBN = $a_FCO_DocRecibo[0];

                if( !$this->getIdTipoPago() )
                {
                    $i_IdTipoPago = $o_FCO_DocReciboBN->getIdTipoPago();
                }
                if( !$this->getReciboNumero() )
                {
                    $s_ReciboNumero = $o_FCO_DocReciboBN->getReciboNumero();
                }
                if( !$this->getIdBanco() )
                {
                    $i_IdBanco = $o_FCO_DocReciboBN->getIdBanco();
                }
                if( !$this->getFechaRecibo() )
                {
                    $s_ReciboFecha = $o_FCO_DocReciboBN->getReciboFecha();
                }
                if( !$this->getMontoAplicar() )
                {
                    $f_Monto            = $o_FCO_DocReciboBN->getMonto();
                    $f_MontoSoles       = $f_Monto;
                    $f_MontoDolar       = round( $f_Monto / $f_TipodeCambio, 2 );

                    $f_SaldoMonto       = $f_Monto;
                    $f_SaldoMontoSoles  = $f_MontoSoles;
                    $f_SaldoMontoDolar  = $f_MontoDolar;
                }

                //los datos de tipo de pago
                $o_FCO_TipoPagoFN = new FCO_TipoPagoFN();
                $o_FCO_TipoPagoBN = $o_FCO_TipoPagoFN->selectByPK( $i_IdTipoPago );

                $i_IdTipoPago  = $o_FCO_TipoPagoBN->getIdTipoPago();
                $s_TipoPagoNom = $o_FCO_TipoPagoBN->getNombre();
                //$s_ClaseNombre = $o_FCO_TipoPagoBN->getClaseNombre();

                $o_MST_CuentaBancariaFN = new MST_CuentaBancariaFN();
                $o_MST_CuentaBancariaFN->setEstado( "A" );
                $o_MST_CuentaBancariaFN->setIdBanco( $i_IdBanco );
                $a_MST_CuentaBancaria = $o_MST_CuentaBancariaFN->select();
                if( $a_MST_CuentaBancaria )
                {
                    $i_IdCuenta = $a_MST_CuentaBancaria[0]->getIdCuenta();
                }

                //ahora se busca el numero de cuenta
                $s_NumeroCuenta = null;
                if( $i_IdCuenta )
                {
                    $o_MST_CuentaBancariaFN = new MST_CuentaBancariaFN();
                    $o_MST_CuentaBancariaBN = $o_MST_CuentaBancariaFN->selectByPK( $i_IdCuenta );
                    $s_NumeroCuenta = $o_MST_CuentaBancariaBN->getNumeroCuenta();
                }

                $o_FCO_DocReciboDP = new FCO_DocReciboDP();
                $o_FCO_DocReciboDP->setIdDocRecibo( $o_FCO_DocReciboBN->getIdDocRecibo() );
                $o_FCO_DocReciboDP->setCobranzaEstado( FCO_DocReciboBN::ESTADO_COB_PENDIENTE );
                $o_FCO_DocReciboDP->setFlujoEstado( FCO_DocReciboBN::FLUESTADO_PENDIENTE );
                $o_FCO_DocReciboDP->setMotivoRechazo( "" );

                if( $i_IdTipoPago == 1 )
                {
                    $s_ReciboNumero = ( string ) $i_IdDocRecibo;
                }
                $o_FCO_DocReciboDP->setReciboNumero( $s_ReciboNumero );
                $o_FCO_DocReciboDP->setIdTipoPago( $i_IdTipoPago );
                $o_FCO_DocReciboDP->setIdBanco( $i_IdBanco );
                $o_FCO_DocReciboDP->setIdCuenta( $i_IdCuenta );
                $o_FCO_DocReciboDP->setNumeroCuenta( $s_NumeroCuenta );
                $o_FCO_DocReciboDP->setReciboFecha( $s_ReciboFecha );

                $o_FCO_DocReciboDP->setMonto( $f_Monto );
                $o_FCO_DocReciboDP->setSaldo( $f_SaldoMonto );
                $o_FCO_DocReciboDP->setMontoMN( $f_MontoSoles );
                $o_FCO_DocReciboDP->setSaldoMN( $f_SaldoMontoSoles );
                $o_FCO_DocReciboDP->setMontoME( $f_MontoDolar );
                $o_FCO_DocReciboDP->setSaldoME( $f_SaldoMontoDolar );

                $o_FCO_DocReciboDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_FCO_DocReciboDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                //pr( $o_FCO_DocReciboDP );
                $o_FCO_DocReciboDP->update();

                $o_FCO_AplicacionFN = new FCO_AplicacionFN();
                //$o_FCO_AplicacionFN->setDebug( true );
                $o_FCO_AplicacionFN->setIdDocRecibo( $i_IdDocRecibo );
                //$o_FCO_AplicacionFN->setEstado( FCO_AplicacionBN::ESTADO_PENDINTE );
                $o_FCO_AplicacionFN->addCondition( FCO_AplicacionFN::IdParent, "IS", 'NULL', false );
                $a_FCO_Aplicacion = $o_FCO_AplicacionFN->select();

                foreach ( $a_FCO_Aplicacion as $o_FCO_AplicacionBN )
                {
                    if( $s_NumeroDocumento != $o_FCO_AplicacionBN->getIdDocNumRef() )
                    {
                        throw new Exception( "El Numero de Documento de Referencia no es el correcto." );
                    }

                    $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $o_FCO_AplicacionBN->getIdDocNumRef() ); //SE RECUPERA EL COMPROBANTE DEL CLIENTE

                    //primero vamos a anular la aplicacion
                    $o_FCO_AplicacionDP = new FCO_AplicacionDP();
                    $o_FCO_AplicacionDP->setIdAplicacion( $o_FCO_AplicacionBN->getIdAplicacion() );
                    $o_FCO_AplicacionDP->setEstado( FCO_AplicacionBN::ESTADO_PENDINTE ); //PE NDIENTE - AP LICADO - AN ULADO
                    $o_FCO_AplicacionDP->setIdBanco( $i_IdBanco );
                    $o_FCO_AplicacionDP->setIdCuenta( $i_IdCuenta );
                    $o_FCO_AplicacionDP->setIdTipoPago( $i_IdTipoPago );
                    $o_FCO_AplicacionDP->setTipoPagoNombre( $s_TipoPagoNom );
                    $o_FCO_AplicacionDP->setReciboNumero( $s_ReciboNumero ); //es el numero de operacion de un recibo o una nota de credito, info de donde del padre
                    $o_FCO_AplicacionDP->setSaldoDocRef( $o_VTA_DocumentoBN->getMontoSaldo() );
                    $o_FCO_AplicacionDP->setMontoAplicado( $f_Monto );
                    $o_FCO_AplicacionDP->setMontoAplicacionMN( $f_MontoSoles );
                    $o_FCO_AplicacionDP->setMontoAplicacionME( $f_MontoDolar );
                    $o_FCO_AplicacionDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_FCO_AplicacionDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    //pr( $o_FCO_AplicacionDP );
                    $o_FCO_AplicacionDP->update();
                }

            }
            else
            {
                throw new Exception( "No se encontro el Recibo." );
            }

            $con->commit();
        }
        catch( Exception $exc )
        {
            //pr( $exc );
            $con->rollback();
            throw new Exception( $exc->getMessage() );
        }

        return true;
    }

    public function aprobarRecibo(  ): bool
    {
        $s_IdDocRecibo = $this->getIdDocRecibo();
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            //PRIMERO DE CAMBIA EL ESTADO DE APROBACION DEL RECIBO Y SE CAMBIO LOS SALDOS
            $o_FCO_DocReciboDP = new FCO_DocReciboDP();
            $o_FCO_DocReciboDP->setIdDocRecibo( ( int ) $s_IdDocRecibo );
            $o_FCO_DocReciboDP->setSaldo( 0 );
            $o_FCO_DocReciboDP->setSaldoME( 0 );
            $o_FCO_DocReciboDP->setSaldoMN( 0 );
            $o_FCO_DocReciboDP->setFechaCobranza( date( "Y-m-d H:i:s" ) );
            $o_FCO_DocReciboDP->setCobranzaEstado( FCO_DocReciboBN::ESTADO_COB_COBRADO );
            $o_FCO_DocReciboDP->setFlujoEstado( FCO_DocReciboBN::FLUESTADO_APROBADO );
            $o_FCO_DocReciboDP->setFechaAprobacion( date( "Y-m-d H:i:s" ) ); //nace aprobado
            $o_FCO_DocReciboDP->setApruebaUsuario( myUser::getUser()->getUserId() );
            $o_FCO_DocReciboDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_FCO_DocReciboDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            //pr( $o_FCO_DocReciboDP );
            $o_FCO_DocReciboDP->update();
            ////////////////////////////////////////
            ///
            /// AHORA SE APRUEBA LA APLICAION Y SE CAMBIO LOS SALDOS
            $o_FCO_AplicacionFN = new FCO_AplicacionFN();
            //$o_FCO_AplicacionFN->setDebug( true );
            $o_FCO_AplicacionFN->setIdDocRecibo( $s_IdDocRecibo );
            $o_FCO_AplicacionFN->setEstado( FCO_AplicacionBN::ESTADO_PENDINTE );
            $o_FCO_AplicacionFN->addCondition( FCO_AplicacionFN::IdParent, "IS", 'NULL', false );
            $a_FCO_Aplicacion = $o_FCO_AplicacionFN->select();

            foreach ( $a_FCO_Aplicacion as $o_FCO_AplicacionBN )
            {
                //busco comprobante para actualizar saldos
                $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $o_FCO_AplicacionBN->getIdDocNumRef() );

                //VALIDACION POR ESTADO DE COBRANZA
                if( $o_VTA_DocumentoBN->getCobranzaEstado() == VTA_DocumentoBN::ESTADO_COB_COBRADO )
                {
                    throw new Exception( "Actualmente el Documento tiene un estado de COBRADO." );
                }
                //VALIDACION POR EL SALDO PARA NO GENERAR EN NEGATIVO
                if( $o_VTA_DocumentoBN->getMontoSaldo() <= 0 )
                {
                    throw new Exception( "El saldo del documento no puede ser menor a 0." );
                }

                //primero vamos a anular la aplicacion
                $o_FCO_AplicacionDP = new FCO_AplicacionDP();
                $o_FCO_AplicacionDP->setIdAplicacion( $o_FCO_AplicacionBN->getIdAplicacion() );
                $o_FCO_AplicacionDP->setEstado( FCO_AplicacionBN::ESTADO_APLICADO ); //PE NDIENTE - AP LICADO - AN ULADO
                $o_FCO_AplicacionDP->setFechaAplicacion( date( "Y-m-d H:i:s" ) );
                $o_FCO_AplicacionDP->setSaldoDocRef( round( $o_FCO_AplicacionBN->getSaldoDocRef() - $o_FCO_AplicacionBN->getMontoAplicado(), 2 ) );
                $o_FCO_AplicacionDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_FCO_AplicacionDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_FCO_AplicacionDP->update();

                $o_VTA_DocumentoDP = new VTA_DocumentoDP();
                $o_VTA_DocumentoDP->setIdTipoDocumento( $o_VTA_DocumentoBN->getIdTipoDocumento() );
                $o_VTA_DocumentoDP->setIdCompania( $o_VTA_DocumentoBN->getIdCompania() );
                $o_VTA_DocumentoDP->setNumeroDocumento( $o_VTA_DocumentoBN->getNumeroDocumento() );

                $o_VTA_DocumentoDP->setMontoPagado( $o_VTA_DocumentoBN->getMontoPagado() + $o_FCO_AplicacionBN->getMontoAplicacionMN() );
                $o_VTA_DocumentoDP->setMontoPagadoMN( $o_VTA_DocumentoBN->getMontoPagado() + $o_FCO_AplicacionBN->getMontoAplicacionMN() );
                $o_VTA_DocumentoDP->setMontoSaldo( round( $o_VTA_DocumentoBN->getMontoSaldo() - $o_FCO_AplicacionBN->getMontoAplicacionMN(), 2 ) );
                $o_VTA_DocumentoDP->setMontoSaldoMN( round( $o_VTA_DocumentoBN->getMontoSaldo() - $o_FCO_AplicacionBN->getMontoAplicacionMN(), 2 ) );
                $o_VTA_DocumentoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_VTA_DocumentoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_VTA_DocumentoDP->update();

                //busco comprobante para ver el ultimo saldo
                $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $o_FCO_AplicacionBN->getIdDocNumRef() );
                if( $o_VTA_DocumentoBN->getMontoSaldo() <= 0 || $o_VTA_DocumentoBN->getMontoPagado() >= $o_VTA_DocumentoBN->getMontoTotal() )
                {
                    $o_VTA_DocumentoDP->setFechaAprobacion( date( "Y-m-d H:i:s" ) );
                    $o_VTA_DocumentoDP->setFechaCobranza( date( "Y-m-d H:i:s" ) );
                    $o_VTA_DocumentoDP->setCobranzaEstado( VTA_DocumentoBN::ESTADO_COB_COBRADO );
                    $o_VTA_DocumentoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_VTA_DocumentoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    //pr( $o_VTA_DocumentoDP );
                    $o_VTA_DocumentoDP->update();
                }
            }
            ////////////////////////////////////////////////////////

            $con->commit();
        }
        catch ( Exception $e )
        {
            $con->rollback();
            throw new Exception( $e->getMessage() );
        }
        return true;
    }

    public function anularRecibo(  )
    {
        $s_IdDocRecibo = $this->getIdDocRecibo();
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            //PRIMERO DE CAMBIA EL ESTADO DE APROBACION DEL RECIBO Y SE CAMBIO LOS SALDOS
            $o_FCO_DocReciboDP = new FCO_DocReciboDP();
            $o_FCO_DocReciboDP->setIdDocRecibo( ( int ) $s_IdDocRecibo );
            $o_FCO_DocReciboDP->setSaldo( 0 );
            $o_FCO_DocReciboDP->setSaldoME( 0 );
            $o_FCO_DocReciboDP->setSaldoMN( 0 );
            //$o_FCO_DocReciboDP->setFechaCobranza( date( "Y-m-d H:i:s" ) );
            $o_FCO_DocReciboDP->setEstado( FCO_DocReciboBN::ESTADO_ANULADO );
            $o_FCO_DocReciboDP->setCobranzaEstado( FCO_DocReciboBN::ESTADO_COB_PENDIENTE );
            $o_FCO_DocReciboDP->setFlujoEstado( FCO_DocReciboBN::FLUESTADO_PENDIENTE );
            //$o_FCO_DocReciboDP->setFechaAprobacion( date( "Y-m-d H:i:s" ) ); //nace aprobado
            //$o_FCO_DocReciboDP->setApruebaUsuario( myUser::getUser()->getUserId() );
            $o_FCO_DocReciboDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_FCO_DocReciboDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            //pr( $o_FCO_DocReciboDP );
            $o_FCO_DocReciboDP->update();
            ////////////////////////////////////////
            ///
            /// AHORA SE APRUEBA LA APLICAION Y SE CAMBIO LOS SALDOS
            $o_FCO_AplicacionFN = new FCO_AplicacionFN();
            //$o_FCO_AplicacionFN->setDebug( true );
            $o_FCO_AplicacionFN->setIdDocRecibo( $s_IdDocRecibo );
            $o_FCO_AplicacionFN->setEstado( FCO_AplicacionBN::ESTADO_PENDINTE );
            $o_FCO_AplicacionFN->addCondition( FCO_AplicacionFN::IdParent, "IS", 'NULL', false );
            $a_FCO_Aplicacion = $o_FCO_AplicacionFN->select();

            foreach ( $a_FCO_Aplicacion as $o_FCO_AplicacionBN )
            {
                //busco comprobante para actualizar saldos
                $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $o_FCO_AplicacionBN->getIdDocNumRef() );

                //VALIDACION POR ESTADO DE COBRANZA
                if( $o_VTA_DocumentoBN->getCobranzaEstado() == VTA_DocumentoBN::ESTADO_COB_COBRADO )
                {
                    throw new Exception( "Actualmente el Documento tiene un estado de COBRADO." );
                }
                //VALIDACION POR EL SALDO PARA NO GENERAR EN NEGATIVO
                if( $o_VTA_DocumentoBN->getMontoSaldo() <= 0 )
                {
                    throw new Exception( "El saldo del documento no puede ser menor a 0." );
                }

                //primero vamos a anular la aplicacion
                $o_FCO_AplicacionDP = new FCO_AplicacionDP();
                $o_FCO_AplicacionDP->setIdAplicacion( $o_FCO_AplicacionBN->getIdAplicacion() );
                $o_FCO_AplicacionDP->setEstado( FCO_AplicacionBN::ESTADO_ANULADO ); //PE NDIENTE - AP LICADO - AN ULADO
                //$o_FCO_AplicacionDP->setFechaAplicacion( date( "Y-m-d H:i:s" ) );
                //$o_FCO_AplicacionDP->setSaldoDocRef( round( $o_FCO_AplicacionBN->getSaldoDocRef() - $o_FCO_AplicacionBN->getMontoAplicado(), 2 ) );
                $o_FCO_AplicacionDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_FCO_AplicacionDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_FCO_AplicacionDP->update();
            }
            ////////////////////////////////////////////////////////

            $con->commit();
        }
        catch ( Exception $e )
        {
            $con->rollback();
            throw new Exception( $e->getMessage() );
        }
        return true;
    }
}