<?php
/**
 * Clase Imprimir
 *
 * @package sym_project
 * @author 
 * @version 0.1.0
 * @copyright documentacion
 * 
 * @filesource
 * $ld$
 */
define("cpi10", 0);

define("cpi12", 1);

define("anchoProporcional", 2);

define("anchoCondensado", 4);

define("negrita_1", 8);

define("negrita_2", 16);

define("anchoDuplicado", 32);

define("cursiva", 64);

define("subrayado", 128);

class UtilImprimir
{

    public $texto;

    private $cpi10;

    private $cpi12;

    private $anchoProporcional;

    private $anchoCondensado;

    private $negrita_1;

    private $negrita_2;

    private $anchoDuplicado;

    private $cursiva;

    private $subrayado;

    /**
     * Funcion para imprimir
     * 
     * @param
     *            ninguno
     */
    function __construct()
    {
        $this->texto = "";
        $this->cpi10 = 0;
        $this->anchoProporcional = 0;
        $this->anchoCondensado = 0;
        $this->negrita_1 = 0;
        $this->negrita_2 = 0;
        $this->anchoDuplicado = 0;
        $this->cursiva = 0;
        $this->subrayado = 0;
    }

    /**
     * Printer Operation
     * 
     * @param
     *            ninguno
     */
    function inicializar()
    {
        // Limpia el buffer de datos de la impresora y la reinicia
        $this->texto = $this->texto . chr(27) . chr(64);
    }

    /**
     * Seleccionar Impresora
     * 
     * @param
     *            ninguno
     */
    function seleccionarImpresora()
    {
        // Selecciona la impresora
        $this->texto = $this->texto . chr(17);
    }

    /**
     * Seleccionar Impresora
     * 
     * @param
     *            ninguno
     */
    function deseleccionarImpresora()
    {
        // Deselecciona la impresora
        $this->texto = $this->texto . chr(19);
    }

    /**
     * Data Control, retorno de carro pero no aumenta una nueva linea
     * 
     * @param
     *            ninguno
     */
    function retornoCarro()
    {
        $this->texto = $this->texto . chr(13);
    }

    /**
     * Elimina el ultimo caracter ingresado,no afecta a los de control
     * 
     * @param
     *            ninguno
     */
    function del()
    {
        $this->texto = $this->texto . chr(127);
    }

    /**
     * Vertical Motion/Horizontal Motion
     * 
     * @param
     *            ninguno
     */
    function saltoPagina()
    {
        // Realiza un salto de pagina de acuerdo al alto definido en la funcion setAltoPagina
        $this->texto = $this->texto . chr(12);
    }

    /**
     * Define el alto de Página
     * 
     * @param $alto, $unidad            
     */
    function setAltoPagina($alto, $unidad)
    {
        // La unidad del alto de pagina a utilizar puede ser pulgadas (unidad = 0) o lineas (unidad = 1)
        /*
         * if($unidad == 0) { //Pulgadas
         * if($alto >= 1 && $alto <= 22)
         * $this->texto = $this->texto.chr(27).chr(67).chr(0).chr($alto);
         * }else{ //Lineas
         *
         * if($alto >= 1 && $alto <= 127){
         * $this->texto = $this->texto.chr(27).chr(67).chr($alto);
         * }
         * }
         */
    }

    /**
     * Imprime una nueva linea
     * 
     * @param
     *            ninguno
     */
    function nuevaLinea()
    {
        // esta nueva linea no significa retorno de carro
        $this->texto = $this->texto . chr(10);
    }

    /**
     * Define el espacio entre cada Linea
     * 
     * @param $espaceo, $factor            
     */
    function setEspaceoEntreLinea($espaceo, $factor = -1)
    {
        // Define el espaceo entre cada linea, si se establece un factor este se dividira entre el numero definido por 'espaceo'
        if ($factor == - 1) {
            switch ($espaceo) {
                case 1:
                    $this->texto = $this->texto . chr(27) . chr(48);
                    break; // 1/8 pulgada
                case 2:
                    $this->texto = $this->texto . chr(27) . chr(49);
                    break; // 7/72 pulgada
                case 3:
                    $this->texto = $this->texto . chr(27) . chr(50);
                    break; // 1/6 pulgada
            }
        } else {
            switch ($espaceo) {
                case 1: // n/216 pulgada
                    if ($factor >= 0 && $factor <= 255) {
                        $this->texto = $this->texto . chr(27) . chr(51) . chr($factor);
                        break;
                    }
                case 2: // n/72 pulgada
                    if ($factor >= 0 && $factor <= 85) {
                        $this->texto = $this->texto . chr(27) . chr(65) . chr($factor);
                        break;
                    }
            }
        }
    }

    /**
     * Produce el desplazamiento Vertical
     * 
     * @param
     *            $factor
     */
    function desplazar($factor)
    {
        // Produce un desplazamiento vertical n/216 pulgadas
        if ($factor >= 0 && $factor <= 255) {
            $this->texto = $this->texto . chr(27) . chr(74) . chr($factor);
        }
    }

    /**
     * Define el margen izquierdo
     * 
     * @param
     *            $factor
     */
    function setMargenIzquierdo($factor)
    {
        // Define el margen izquierdo tomando como unidad el ancho de caracter
        $this->texto = $this->texto . chr(27) . chr(108) . chr($factor);
    }

    /**
     * Define el margen derecho
     * 
     * @param
     *            $factor
     */
    function setMargenDerecho($factor)
    {
        // Define el margen derecho tomando como unidad el ancho de caracter
        $this->texto = $this->texto . chr(27) . chr(81) . chr($factor);
    }

    /**
     * Retrocede una posicion a la izquierda
     * 
     * @param
     *            ninguno
     */
    function backspace()
    {
        $this->texto = $this->texto . chr(8);
    }

    /**
     * Mueve a la posicion absoluta (x,y)
     * 
     * @param $x, $y            
     */
    function setPosicion($x, $y)
    {
        // Mueve a la posicion absoluta (x,y), la unidad utilizada es 1/60 pulgadas
        $this->texto = $this->texto . chr(27) . chr(36) . chr($x) . chr($y);
    }

    /**
     * Mueve a la posicion relativa (x,y)
     * 
     * @param $x, $y            
     */
    function setPosicionRelativa($x, $y)
    {
        // Mueve a la posicion relativa (x,y), la unidad utilizada es 1/120 pulgadas
        $this->texto = $this->texto . chr(27) . chr(92) . chr($x) . chr($y);
    }

    /**
     * tabulacion hacia la derecha
     * 
     * @param
     *            ninguno
     */
    function tab()
    {
        // hace una tabulacion hacia la derecha (8 caracteres a la derecha)
        $this->texto = $this->texto . chr(9);
    }

    /**
     * tabulacion hacia la derecha
     * 
     * @param
     *            $numero
     */
    function tabs($numero)
    {
        // hace una tabulacion hacia la derecha (8 caracteres a la derecha)
        for ($i = 1; $i <= $numero; $i ++) {
            $this->tab();
        }
    }

    /**
     * Overall Printing Style/Print Size
     * 
     * @param
     *            $modo
     */
    function setModoDraftNLQ($modo = 1)
    {
        // En el modo Draft no se puede utilizar ningun tipo de letra especial.
        // En el modo (NLQ 'Near Letter Quality') se pueden definir los tipos de letra: 'Roman', 'Sans Serif' o algun tipo de letra definida por el usuario.
        if ($modo == 0) {
            $this->texto = $this->texto . chr(27) . chr(120) . chr(0);
        } else {
            $this->texto = $this->texto . chr(27) . chr(120) . chr(1);
        }
    }

    /**
     * Define el tipo de letra
     * 
     * @param
     *            $tipo
     */
    function setTipoLetra($tipo)
    {
        // Define el tipo de letra (solo para NLQ): 'Roman' = 0, 'Sans Serif' = 1
        if ($tipo == 0) {
            $this->texto = $this->texto . chr(27) . chr(107) . chr(0);
        } else {
            $this->texto = $this->texto . chr(27) . chr(107) . chr(1);
        }
    }

    /**
     * tabulacion hacia la derecha
     * 
     * @param
     *            ninguno
     */
    function getFormatoTexto()
    {
        // Define un numero que utilizado por la funcion setFormatoTexto define la forma en que se imprimen los caracteres
        $formato = 0;
        if ($this->cpi10 == 1) {
            $formato = 0;
        }
        if ($this->cpi12 == 1) {
            $formato += 1;
        }
        if ($this->anchoProporcional == 1) {
            $formato += 2;
        }
        if ($this->anchoCondensado == 1) {
            $formato += 4;
        }
        // Dobla caracter por caracter
        if ($this->negrita_1 == 1) {
            $formato += 8;
        }
        // Dobla linea por linea
        if ($this->negrita_2 == 1) {
            $formato += 16;
        }
        if ($this->anchoDuplicado == 1) {
            $formato += 32;
        }
        if ($this->cursiva == 1) {
            $formato += 64;
        }
        if ($this->subrayado == 1) {
            $formato += 128;
        }
        return $formato;
    }

    /**
     * Permite establecer multiples caracteristicas
     * 
     * @param
     *            $formato
     */
    function setFormatoTexto($formato)
    {
        // Permite establecer multiples caracteristicas para el formato de texto, 'formato' es un numero que se obtiene con la funcion getFormatoTexto
        $this->texto = $this->texto . chr(27) . chr(33) . chr($formato);
    }

    /**
     * Resetea todos los valores establecidos en setFormatoTexto
     * 
     * @param
     *            ninguno
     */
    function resetFormatoTexto()
    {
        $this->cpi10 = 0;
        $this->cpi12 = 0;
        $this->anchoProporcional = 0;
        $this->anchoCondensado = 0;
        $this->negrita_1 = 0;
        $this->negrita_2 = 0;
        $this->anchoDuplicado = 0;
        $this->cursiva = 0;
        $this->subrayado = 0;
    }

    /**
     * define que se imprima 10 caracteres por pulgada
     * 
     * @param
     *            ninguno
     */
    function set10cpi()
    {
        $this->cpi10 = 1;
        $this->cpi12 = 0;
        $this->texto = $this->texto . chr(27) . chr(80);
    }

    /**
     * define que se imprima 12 caracteres por pulgada
     * 
     * @param
     *            ninguno
     */
    function set12cpi()
    {
        $this->cpi12 = 1;
        $this->cpi10 = 0;
        $this->texto = $this->texto . chr(27) . chr(77);
    }

    /**
     * establece un ancho proporcional al tamaño de cada letra
     * 
     * @param
     *            $habilitar
     */
    function setAnchoProporcional($habilitar)
    {
        // Esta funcion establece un ancho proporcional al tamaño de cada letra ('W' sera mas ancho que 'I').
        if ($habilitar) {
            $this->anchoProporcional = 1;
            $this->texto = $this->texto . chr(27) . chr(112) . chr(1);
        } else {
            $this->anchoProporcional = 0;
            $this->texto = $this->texto . chr(27) . chr(112) . chr(0);
        }
    }

    /**
     * disminuye el ancho de todas las letras en un 60%
     * 
     * @param
     *            $habilitar
     */
    function setAnchoCondensado($habilitar)
    {
        // (el tamaño resultante depende de si se ha establecido 10 cpi o 12 cpi)
        if ($habilitar) {
            $this->anchoCondensado = 1;
            $this->texto = $this->texto . chr(27) . chr(15);
        } else {
            $this->anchoCondensado = 0;
            $this->texto = $this->texto . chr(18);
        }
    }

    /**
     * Duplica el ancho de todas las letras
     * 
     * @param
     *            $habilitar
     */
    function setAnchoDuplicado($habilitar)
    {
        // (el tamaño resultante depende de si se ha establecido 10 cpi o 12 cpi)
        if ($habilitar) {
            $this->anchoDuplicado = 1;
            $this->texto = $this->texto . chr(27) . chr(14);
        } else {
            $this->anchoDuplicado = 0;
            $this->texto = $this->texto . chr(20);
        }
    }

    /**
     * duplica el ancho de todas las letras
     * 
     * @param
     *            $habilitar
     */
    function setAltoDuplicado($habilitar)
    {
        // (el tamaño resultante depende de si se ha establecido 10 cpi o 12 cpi)
        if ($habilitar) 
        {
            $this->texto = $this->texto . chr(27) . chr(119) . chr(1);
        }
        else 
        {
            $this->texto = $this->texto . chr(27) . chr(119) . chr(0);
        }
    }

    /**
     * Print Enhancement/Word Processing
     * 
     * @param $habilitar, $modo            
     */
    function setNegrita($habilitar, $modo = 1)
    {
        // Esta funcion imprime dos veces cada punto de cada caracter
        // (en el modo 1 duplica al terminar la linea, en el modo 0 lo hace caracter por caracter)
        if ($habilitar) 
        {
            if ($mode == 1) { // Por linea (negrita_2)
                $this->negrita_2 = 1;
                $this->negrita_1 = 0;
                $this->texto = $this->texto . chr(27) . chr(71);
            } else { // Por caracter (negrita_1)
                $this->negrita_1 = 1;
                $this->negrita_2 = 0;
                $this->texto = $this->texto . chr(27) . chr(69);
            }
        } else {
            if ($mode == 1) {
                $this->negrita_2 = 0;
                $this->texto = $this->texto . chr(27) . chr(72);
            } else {
                $this->negrita_1 = 0;
                $this->texto = $this->texto . chr(27) . chr(70);
            }
        }
    }

    /**
     * imprime los caracteres en sub indice
     * 
     * @param
     *            $habilitar
     */
    function setSubIndice($habilitar)
    {
        if ($habilitar) {
            $this->texto = $this->texto . chr(27) . chr(83) . chr(1);
        } else {
            $this->texto = $this->texto . chr(27) . chr(84);
        }
    }

    /**
     * imprime los caracteres en super indice
     * 
     * @param
     *            $habilitar
     */
    function setSuperIndice($habilitar)
    {
        if ($habilitar) {
            $this->texto = $this->texto . chr(27) . chr(83) . chr(0);
        } else {
            $this->texto = $this->texto . chr(27) . chr(84);
        }
    }

    /**
     * imprime los caracteres en super indice
     * 
     * @param
     *            $habilitar
     */
    function setSubrayado($habilitar)
    {
        // Esta funcion imprime los caracteres en super indice
        if ($habilitar) {
            $this->subrayado = 1;
            $this->texto = $this->texto . chr(27) . chr(45) . chr(1);
        } else {
            $this->subrayado = 0;
            $this->texto = $this->texto . chr(27) . chr(45) . chr(0);
        }
    }

    /**
     * establece la aliniacion del texto
     * 
     * @param
     *            $aliniacion
     */
    function setAliniacion($aliniacion = 0)
    {
        switch ($aliniacion) {
            case 0:
                $this->texto = $this->texto . chr(27) . chr(97) . chr(0);
                break; // Izquierda
            case 1:
                $this->texto = $this->texto . chr(27) . chr(97) . chr(1);
                break; // Centrado
            case 2:
                $this->texto = $this->texto . chr(27) . chr(97) . chr(2);
                break; // Derecho
            case 3:
                $this->texto = $this->texto . chr(27) . chr(97) . chr(3);
                break; // Justificado
        }
    }

    /**
     * define el espaceo entre caracteres
     * 
     * @param
     *            $factor
     */
    function setEspaceoEntreCaracter($factor)
    {
        // Esta funcion define el espaceo entre caracteres el cual es (factor/120) pulgadas
        if ($factor >= 0 && $factor <= 127) {
            $this->texto = $this->texto . chr(27) . chr(32) . chr($factor);
        }
    }

    /**
     * Character Sets
     * 
     * @param
     *            $tabla
     */
    function setJuegoCaracteresEspeciales($tabla = 1)
    {
        // Esta funcion define que tabla de caracteres especiales se utilizara para los caracteres ASCII del 128 - 255
        // 0 : caracteres en cursiva
        // 1 : Caracteres Extendidos de EPSON
        if ($tabla == 0) {
            $this->texto = $this->texto . chr(27) . chr(116) . chr(0);
        } else {
            $this->texto = $this->texto . chr(27) . chr(116) . chr(1);
        }
    }

    /**
     * imprime los caracteres en cursiva
     * 
     * @param
     *            $habilitar
     */
    function setCursiva($habilitar)
    {
        // Esta funcion imprime los caracteres en cursiva
        if ($habilitar) {
            $this->cursiva = 1;
            $this->texto = $this->texto . chr(27) . chr(52);
        } else {
            $this->cursiva = 0;
            $this->texto = $this->texto . chr(27) . chr(53);
        }
    }

    /**
     * define el juego de caracteres internacionales
     * 
     * @param
     *            $pais
     */
    function setJuegoCaracteresPais($pais)
    {
        // Esta funcion define el juego de caracteres internacionales a utilizar
        $this->texto = $this->texto . chr(27) . chr(82) . chr($pais);
    }

    /**
     * agregar Texto //
     * 
     * @param $texto, $formato            
     */
    function addTexts($texto, $formato = 0)
    {
        $texto = str_replace("\n", chr(10), $texto);
        $texto = str_replace("\t", chr(9), $texto);
        $texto = str_replace("\\\\", "\\", $texto);
        $this->texto = $this->texto . $texto;
    }

    /**
     * agregar Texto //antes llamado anadirLinea
     * 
     * @param $texto, $formato            
     */
    function addText($texto, $formato = 0)
    {
        $this->setFormatoTexto($formato);
        $texto = str_replace("\n", chr(10), $texto);
        $texto = str_replace("\t", chr(9), $texto);
        $texto = str_replace("\\\\", "\\", $texto);
        $this->texto = $this->texto . $texto;
    }

    function crearArchivoWeb( $s_NombreArchivo )
    {
        $nameFileOne = $s_NombreArchivo.".txt";
        $nameFile = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR."tmp".DIRECTORY_SEPARATOR.$nameFileOne;
        if( file_exists( $nameFile ) )
        {
            unlink( $nameFile );
        }
        $archivo = fopen(  $nameFile, "w" );
        fwrite( $archivo, $this->texto );
        fclose( $archivo );
        return $nameFileOne;
    }
    
    /**
     * Creación de Archivo
     * 
     * @param
     *            $text
     */
    function crearArchivo($text)
    {
        // $this->saltoPagina();
        // $this->inicializar();
        // $aleatorio = rand(0, 100);
        // while(file_exists($DOCUMENT_ROOT."/modulos/promociones/sorteo/cupon_".$nro_cupon.".txt")) {
        // $aleatorio = rand(0, 100);
        // }
        $nameFile = rand(0, 10000);
        $archivo = fopen('/tmp/' . $nameFile . '.txt', "w");
        fwrite($archivo, $text);
        fclose($archivo);
        return '/tmp/' . $nameFile . '.txt';
    }

    /**
     * Imprimir Archivo
     * 
     * @param $archivo, $impresora            
     */
    function imprimirArchivo($archivo, $impresora)
    {
        $comando = "cat " . $archivo . "|lpr -P " . $impresora;
        exec($comando, $respuesta, $error);
        return $respuesta;
    }

    /**
     * Imprimir Archivo temporal
     * 
     * @param $archivo, $impresora            
     */
    function imprimirArchivoTmp($impresora)
    {
        $retorno = true;
        $nombre_temp = tempnam("/tmp", "INV");
        $gestor = fopen($nombre_temp, "w");
        fwrite($gestor, $this->texto);
        fclose($gestor);
        $comando = "cat /tmp/" . basename($nombre_temp) . "|lpr -P " . $impresora;
        exec($comando, $respuesta, $error);
        unlink($nombre_temp);
        if ($error) {
            $retorno = false;
        }
        return $retorno;
    }
}