<?php
class RegistroAsistenciaAction extends wtActions
{
    public function execute()
    {
        $content = trim( file_get_contents( "php://input" ) );
        $decoded = json_decode( $content, true );

        $_POST   = $decoded;
        $j_datos = $_POST;
        $a_datos = $j_datos['datos'];

        $a_Result = array();

        try 
        {
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //validaciones
            if( !is_array( $a_datos ) )
            {
                throw new Exception( "El requerimiento no es funcional." );
            }

            if( !isset( $a_datos['metodo'] ) )
            {
                throw new Exception( "El requerimiento no tiene los parametros establecidos." );
            }

            if( !isset( $a_datos['asistencias'] ) || !is_array( $a_datos['asistencias'] ) )
            {
                throw new Exception( "No se encontro Registro de Asistencia." );
            }
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            //ahora se  procesde a registrar las asistencias
            foreach ( $a_datos['asistencias'] as $a_Values ) 
            {
                pr( "------------------------------------------------------------------------------------------------------------------------------" );

                pr( $a_Values );

                $s_FechaHoraMarca = $a_Values['fecha']." ".$a_Values['hora'];

                $o_MST_PersonaEmpleadoFN = new MST_PersonaEmpleadoFN();
                $o_MST_PersonaEmpleadoFN->setNumeroDocumento( $a_Values['dni'] );
                $a_MST_PersonaEmpleado = $o_MST_PersonaEmpleadoFN->select();
                if( $a_MST_PersonaEmpleado )
                {
                    $o_MST_PersonaEmpleadoBN = $a_MST_PersonaEmpleado[0];

                    $f_SueldoEmpleado = $o_MST_PersonaEmpleadoBN->getSueldo();
                    //pr( $o_MST_PersonaEmpleadoBN );

                    //recuperamos el id de persona
                    $i_IdPersona = $o_MST_PersonaEmpleadoBN->getIdPersona();
                    ////////////////////////////////////////////////////////////////////

                    //ahora se recupera el id del dia de semana
                    $o_MST_DiaSemanaFN = new MST_DiaSemanaFN();
                    $o_MST_DiaSemanaBN = $o_MST_DiaSemanaFN->selectByPK( date( "N", strtotime( $a_Values['fecha'] ) ) );
                    //pr( $o_MST_DiaSemanaBN );
                    $i_IdDiaSem = $o_MST_DiaSemanaBN->getIdDiaSem();
                    pr( $i_IdDiaSem );
                    ////////////////////////////////////////////////////////////////////

                    //se recupera el id del registro
                    $o_PLA_MarcacionRegistroBN = PLA_MarcacionRegistroFN::getObjectPorIdReferencia( $a_Values['tipo_registro'] );
                    //pr( $o_PLA_MarcacionRegistroBN );
                    $s_IdRegistro = $o_PLA_MarcacionRegistroBN->getIdRegistro();
                    ////////////////////////////////////////////////////////////////////

                    //ahora buscamos el tipo de marcacion por el horario
                    pr( "$i_IdPersona - $i_IdDiaSem - $s_IdRegistro -> $f_SueldoEmpleado" );
                    $o_PLA_MarcacionEmpleadoFN = new PLA_MarcacionEmpleadoFN();
                    $o_PLA_MarcacionEmpleadoFN->setIdPersona( $i_IdPersona );
                    $o_PLA_MarcacionEmpleadoFN->setIdDiaSem( $i_IdDiaSem );
                    $o_PLA_MarcacionEmpleadoFN->setIdRegistro( $s_IdRegistro );
                    $a_PLA_MarcacionEmpleado = $o_PLA_MarcacionEmpleadoFN->select();
                    //pr( $a_PLA_MarcacionEmpleado );
                    $b_Control = false;
                    $f_MontoDescuento = 0;
                    foreach ( $a_PLA_MarcacionEmpleado as $o_PLA_MarcacionEmpleadoBN ) 
                    {

                        pr
                            ( 
                                "[".strtotime( $a_Values['fecha']." ".$o_PLA_MarcacionEmpleadoBN->getHoraMinutoDesde() )." - ".$a_Values['fecha']." ".$o_PLA_MarcacionEmpleadoBN->getHoraMinutoDesde()."] || ". 
                                "[".strtotime( $a_Values['fecha']." ".$o_PLA_MarcacionEmpleadoBN->getHoraMinutoHasta() )." - ".$a_Values['fecha']." ".$o_PLA_MarcacionEmpleadoBN->getHoraMinutoHasta()."]" 
                            );

                        if
                        ( 
                            strtotime( $s_FechaHoraMarca ) >= strtotime( $a_Values['fecha']." ".$o_PLA_MarcacionEmpleadoBN->getHoraMinutoDesde() ) &&
                            strtotime( $s_FechaHoraMarca ) <= strtotime( $a_Values['fecha']." ".$o_PLA_MarcacionEmpleadoBN->getHoraMinutoHasta() )
                        )
                        {
                            $b_Control = true;
                            $s_IdTipo = $o_PLA_MarcacionEmpleadoBN->getIdTipo();

                            //ahora se recupera la hora pactada
                            $o_PLA_MarcacionEmpleadoFN = new PLA_MarcacionEmpleadoFN();
                            $o_PLA_MarcacionEmpleadoBN = $o_PLA_MarcacionEmpleadoFN->selectByPK( $i_IdDiaSem, "NO", $s_IdRegistro, $i_IdPersona );
                            $s_HoraMinutoPactado = $a_Values['fecha']." ".$o_PLA_MarcacionEmpleadoBN->getHoraMinutoDesde();

                            pr( $s_IdTipo." -> ".strtotime( $s_FechaHoraMarca )." - ".$s_FechaHoraMarca." - ".$s_HoraMinutoPactado );

                            //SI ES TIPO INGRESO, ES TARNDANZA
                            if( $s_IdRegistro == "IN" && $s_IdTipo == "TA" )
                            {
                                $f_SueldoPorMinuto = ( ( ( $f_SueldoEmpleado / 30 ) / 12 ) / 60 );
                                pr( $f_SueldoPorMinuto );
                                $o_Obj = UtilDate::datetimeDiff( $s_HoraMinutoPactado, $s_FechaHoraMarca );
                                pr( $o_Obj );
                                $f_MontoDescuento = round( ( $o_Obj->total_min * $f_SueldoPorMinuto ), 2 );
                                pr( $f_MontoDescuento );
                            }
                            
                            break;
                        }
                    }
                    ////////////////////////////////////////////////////////////////////

                    //ahora se guarda la asistencia
                    if( $b_Control )
                    {
                        $o_PLA_AsistenciaFN = new PLA_AsistenciaFN();
                        $o_PLA_AsistenciaFN->setIdAsistenciaRef( $a_Values['idasistencia'] );
                        $a_PLA_Asistencia = $o_PLA_AsistenciaFN->select();
                        if( $a_PLA_Asistencia )
                        {
                            continue;
                        }

                        $i_IdAsistencia = PLA_AsistenciaDP::recuperarId();
                        $o_PLA_AsistenciaDP = new PLA_AsistenciaDP();
                        $o_PLA_AsistenciaDP->setIdAsistencia( $i_IdAsistencia );
                        $o_PLA_AsistenciaDP->setIdDiaSem( $i_IdDiaSem );
                        $o_PLA_AsistenciaDP->setIdRegistro( $s_IdRegistro );
                        $o_PLA_AsistenciaDP->setIdTipo( $s_IdTipo );
                        $o_PLA_AsistenciaDP->setIdPersona( $i_IdPersona );
                        $o_PLA_AsistenciaDP->setFecha( $a_Values['fecha'] );
                        $o_PLA_AsistenciaDP->setTipoDocumento( 'DNI' );
                        $o_PLA_AsistenciaDP->setNumeroDocumento( $a_Values['dni'] );
                        $o_PLA_AsistenciaDP->setHoraMinuto( $s_FechaHoraMarca );
                        $o_PLA_AsistenciaDP->setHoraMinutoPactado( $s_HoraMinutoPactado );
                        if( $f_MontoDescuento )
                        {
                            $o_PLA_AsistenciaDP->setMontoDescuento( $f_MontoDescuento );
                        }
                        $o_PLA_AsistenciaDP->setIdAsistenciaRef( ( int ) $a_Values['idasistencia'] );
                        $o_PLA_AsistenciaDP->setUsuarioCreacion( "webservice" );
                        $o_PLA_AsistenciaDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                        $o_PLA_AsistenciaDP->setUsuarioModificacion( "webservice" );
                        $o_PLA_AsistenciaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_PLA_AsistenciaDP->setEliminado( 0 );
                        $o_PLA_AsistenciaDP->save();
                    }
                    else
                    {
                        throw new Exception( "No se encontro el Tipo de Marcacion" );
                    }
                    ////////////////////////////////////////////////////////////////////

                    pr( "------------------------------------------------------------------------------------------------------------------------------" );
                    

                }
                else
                {
                    //no se encontro el numero de dni
                }
            }

            $a_Result = array( 'resultado' => array( "error_code" => 1, "mensaje" => "Exito" ) );
        } 
        catch ( Exception $e ) 
        {
            pr( $e );
            //$a_Result['estado']  = 0;
            //$a_Result['mensaje'] = $e->getMessage();
            $a_Result = array( 'resultado' => array( "error_code" => 0 ) );
            $a_Result = null;
        }

        echo html_entity_decode( json_encode( $a_Result, JSON_FORCE_OBJECT ) );

        return ViewResponse::NONE;
    }
}