<?php 
class GridServicesAction extends wtActions
{
    public function execute()
    {
        $IdAlmacen = $this->getRequestParameter( 'IdAlmacen' );
        $moneda_cod  = $this->getRequestParameter( 'moneda_cod' );

        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new ALM_ItemMastFN() );
        
        $o_GridAction->addMethodDefault( ALM_ItemMastFN::Estado, "A" );
        $o_GridAction->addMethodDefault( "ALM_ItemMast.IdItemTipo", array( 'Condition'=>'IN', 'Value'=>"('02')" ) );
        
        //$o_GridAction->addAssignFilter( "ConStock" );
        $o_GridAction->addConditionFilter( "DescripcionCompleta", ALM_ItemMastFN::DescripcionCompleta, "LIKE", "%%s%" );
        
        $o_GridAction->addOrderDefault( ALM_ItemMastFN::DescripcionCompleta, true );
        
        $o_GridAction->setNumberRecordsShow( 100 );
        $o_GridAction->setControlArray( false );
        $o_GridAction->setMethodSelectCustomRs( "selectdos" ); //FUNCION PERSONALIZADO PARA BUSQUEDA
        $o_GridAction->initialize();
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        //$a_ResultJson['rows']    = $o_GridAction->getResultArray();
        $a_ResultSelect    = $o_GridAction->getResultSelect();
        $a_Rs = array();
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_MST_ListaPrecioCabeceraFN = new MST_ListaPrecioCabeceraFN();
        $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->selectByPK( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal() );
        if( !$o_MST_ListaPrecioCabeceraBN )
        {
            $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->buscaListaPrecioAlternativo();
        }
        
        $f_ValorIGV       = GSS_ParametroMastFN::getValorPorTipo( "AL", "IGV" ); //0.18
        $f_ValorIGVMasUno = $f_ValorIGV + 1;  //1.18
        
        $f_TipoCob      = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        foreach ( $a_ResultSelect as $iKey => $o_ObjClassBN )
        {
            $o_ObjClassBN->setIdCompania( myUser::getUser()->getIdBusiness() );
            //$o_ObjClassBN->setIdAlmacen( $IdAlmacen );
            //$o_ObjClassBN->setIdSucursal( $s_IdSucursal );
            
            $PrecioFinal = 0;
            if( myUser::getUser()->getIdSucursal() )
            {
                $f_PrecioUnidadIGV = $o_ObjClassBN->getPrecioConIGV();
                
                if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "LO" ) //MONEDA DE LA LISTA DE PRECIOS ES SOLES
                {
                    if( $moneda_cod == "LO" )
                    {
                        $PrecioFinal = $f_PrecioUnidadIGV;
                    }
                    if( $moneda_cod == "EX" )
                    {
                        $PrecioUnitarioME = utilMath::fnround( $f_PrecioUnidadIGV / $f_TipoCob, 2 );
                        $PrecioFinal = $PrecioUnitarioME;
                    }
                }
                
                if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "EX" ) //MONEDA DE LA LISTA DE PRECIOS ES DOLARES
                {
                    if( $moneda_cod == "LO" )
                    {
                        $PrecioUnitarioSoles = utilMath::fnround( $f_PrecioUnidadIGV * $f_TipoCob, 2 );
                        $PrecioFinal = $PrecioUnitarioSoles;
                    }
                    if( $moneda_cod == "EX" )
                    {
                        $PrecioFinal = $f_PrecioUnidadIGV;
                    }
                }
                /*}*/
            }
            $a_Rs[] = array
            (
                    "IdItem"              => utf8_encode( $o_ObjClassBN->getIdItem() ),
                    //"IdLote"              => $o_ObjClassBN->getIdLote(),
                    //"ConcatLoteFecV"      => $o_ObjClassBN->getConcatLoteFecV(),
                    "DescripcionCompleta" => ( $o_ObjClassBN->getDescripcionCompleta() ),
                    "PrecioConIGV"        => $PrecioFinal,
                    //"Marca"               => $o_ObjClassBN->getIdMarca(),
                    
                    /*"Stock"               => number_format( $o_ObjClassBN->getStockDisponible(), 0 ),
                    "PrecioxCaja"         => $PrecioFinal,
                    "PrecioxUni"          => $o_ObjClassBN->getUsoFraccionFlag() ? round( $PrecioFinal / $o_ObjClassBN->getDivisor(), 2 ) : "",*/
                    
                    /*"UniMedVentaDesc"     => $o_ObjClassBN->getUniMedVentaDesc(),
                    "IdUniMedVenta"       => $o_ObjClassBN->getIdUniMedVenta(),*/
                    //"CantUniMedVenta"     => round( $o_ObjClassBN->getCantUniMedVenta(), 2 ),
                    
                    /*"CantidadxCaja"       => $o_ObjClassBN->getCantidadxCaja(),
                    "CantidadxUnidad"     => $o_ObjClassBN->getUsoFraccionFlag() ? number_format( $o_ObjClassBN->getCantidadxUnidad(), 2 ) : "",*/
                    
                    //"Divisor"             => $o_ObjClassBN->getDivisor(),
                    //"UnidadEquivalenteFlag" => $o_ObjClassBN->getUnidadEquivalenteFlag(),
                    //"UsoFraccionFlag"       => $o_ObjClassBN->getUsoFraccionFlag(),
                    //"EsUnidadMinimaFlag"    => $o_ObjClassBN->getEsUnidadMinimaFlag(),
            );
        }
        
        $a_ResultJson['rows'] = $a_Rs;
        
        echo json_encode( $a_ResultJson );
        
        return ViewResponse::NONE;
    }
}