<?php
class GenerarNDAction extends wtActions
{
    public function execute()
    {
        $s_Id       = $this->getRequestParameter( 'i_Id' );

        $a_Ids = explode( "_", $s_Id );
        $IdTipoDocumento = $a_Ids[0];
        $IdCompania      = ( int) $a_Ids[1];
        $NumeroDocumento = $a_Ids[2];

        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
        $o_TMPVTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $IdTipoDocumento, $IdCompania, $NumeroDocumento );

        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            //SE SETEA DATOS PARA CABECERA
            $s_SerieNC  = $this->getRequestParameter( 'SerieNC' );
            $s_NumeroNC = $this->getRequestParameter( 'NumeroNC' );
            $s_FechaDoc = $this->getRequestParameter( 'FechaDocumento' );

            //VALIDACION DE FECHA
            $b_Result = UtilDate::validar_fecha( $s_FechaDoc );
            if( !$b_Result )
            {
                throw new Exception( "Ingrese una fecha valida para la emision de NC." );
            }
            //////////////////////

            $f_TipoCambio = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
            if( !$f_TipoCambio )
            {
                throw new Exception( "Debe de registrar el Tipo de Cambio de hoy." );
            }

            $s_FechaDoc = $s_FechaDoc." ".date( "H:i:s" ); //SE AGREGA LA HORA

            $o_VTA_DocumentoBN = new VTA_DocumentoBN();
            $o_VTA_DocumentoBN->setIdCompania( $IdCompania );
            $o_VTA_DocumentoBN->setIdTipoDocumento( $IdTipoDocumento );
            $o_VTA_DocumentoBN->setNumeroDocumento( $NumeroDocumento );
            $o_VTA_DocumentoBN->setIdMotivo( intval( $this->getRequestParameter( "IdMotivo" ) ) );
            $o_VTA_DocumentoBN->setFechaDocumento( $s_FechaDoc );
            $o_VTA_DocumentoBN->setDocumentoSerie( $s_SerieNC ); //SERIE ASIGNADO A LA NC
            $o_VTA_DocumentoBN->setDocumentoNumero( $s_NumeroNC ); //NUMERO ASIGNADO A LA NC
            $o_VTA_DocumentoBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
            $o_VTA_DocumentoBN->setClienteNumero( $o_TMPVTA_DocumentoBN->getClienteNumero() );
            $o_VTA_DocumentoBN->setIdFormaPago( $this->getRequestParameter( "cboFormaPago" ) );

            //DATOS PARA LOS DETALLES
            $s_IdItem            = $this->getRequestParameter( 'IdServicio' );
            $f_PrecioUnitario    = floatval( $this->getRequestParameter( 'valor_unit' ) );
            $f_MontoIGV          = floatval( $this->getRequestParameter( 'monto_igv' ) );
            $f_PrecioUnitarioInc = floatval( $this->getRequestParameter( 'txt_precio' ) );
            $a_VTA_DocumentoDetalle = array();
            if( !$s_IdItem )
            {
                throw new Exception( "No se puede generar NC si no se tiene detalles." );
            }

            $o_VTA_DocumentoDetalleBN = new VTA_DocumentoDetalleBN();
            $o_VTA_DocumentoDetalleBN->setItemCodigo( $s_IdItem );
            $o_VTA_DocumentoDetalleBN->setCantidadPedida( 1 );
            $o_VTA_DocumentoDetalleBN->setPrecioUnitario( $f_PrecioUnitario );
            $o_VTA_DocumentoDetalleBN->setPrecioUnitarioMN( $f_PrecioUnitario );
            $o_VTA_DocumentoDetalleBN->setMontoImpuestoUnidad( $f_MontoIGV );
            $o_VTA_DocumentoDetalleBN->setMontoImpuestoUnidadMN( $f_MontoIGV );
            $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidad( $f_PrecioUnitarioInc );
            $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidadMN( $f_PrecioUnitarioInc );

            if( $o_TMPVTA_DocumentoBN->getMonedaDocumento() == "EX" )
            {
                $f_MontoIncImpuestoUnidadMN = round( $f_PrecioUnitarioInc * $f_TipoCambio, 2 ) ;
                $f_PrecioUnitarioMN         = round( $f_PrecioUnitario * $f_TipoCambio, 2 );
                $f_MontoImpuestoUnidadMN    = round( $f_MontoIncImpuestoUnidadMN - $f_PrecioUnitarioMN, 2 );

                $o_VTA_DocumentoDetalleBN->setPrecioUnitarioMN( $f_PrecioUnitarioMN );
                $o_VTA_DocumentoDetalleBN->setMontoImpuestoUnidadMN( $f_MontoImpuestoUnidadMN );
                $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidadMN( $f_MontoIncImpuestoUnidadMN );
            }

            $a_VTA_DocumentoDetalle[] = $o_VTA_DocumentoDetalleBN;

            $o_VTA_DocumentoBN->setArrayDocumentoDetalle( $a_VTA_DocumentoDetalle );
            //$o_VTA_DocumentoBN->setForzarMovimientoInventario( false );

            $o_OrdenVentaBL = new OrdenVentaBL();
            $o_OrdenVentaBL->generarNotaDebito( $o_VTA_DocumentoBN );

            $con->commit();

            $a_Rs['error']    = false;
            $a_Rs['id']       = $s_Id;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
}

