<?php
class BuscarOrdenVentaAction extends wtActions
{
    public function execute()
    {
        $s_OrdenNum = $this->getRequestParameter( 'orden' );
        $i_Anticipo = intval( $this->getRequestParameter( 'anticipo' ) );
        
        $a_Rs = array( "error" => true, "mensaje_error" => "No se encontro Orden." );
        
        try
        {
            myUser::getUser()->validar_session();
            
            if( !GSS_TipoCambioFN::getStaticTipoCambioCobranza() )
            {
                throw new Exception( "Debe de registrar el Tipo de Cambio de hoy." );
            }

            $a_VTA_OrdenBN = VTA_OrdenFN::findOrdenByNumToArray( $s_OrdenNum );
            if( $a_VTA_OrdenBN )
            {
                if( $a_VTA_OrdenBN['OrdenEstado'] == "F" )
                {
                    throw new Exception( "La Orden de Venta actualmente ya se encuentra Facturada." );
                }
                if( !$i_Anticipo )
                {
                    if( $a_VTA_OrdenBN['OrdenEstado']  != "C" )
                    {
                        throw new Exception( "La Orden de Venta tiene que estar Cerrado para continuar con la Facturacion." );
                    }
                }

                //SE BUSCA LA SIGLA DE LA MONEDA
                $o_VTA_OrdenBN = VTA_OrdenFN::findOrdenByNum( $s_OrdenNum );
                $a_VTA_OrdenBN['SiglaMoneda'] = GSS_MonedaMastFN::getSiglaxId( $a_VTA_OrdenBN['MonedaCod'] );

                //AHORA SE BUSCA LA FORMA DE PAGO, SI ES CREDITO O AL CONTADO
                $o_VTA_FormaPagoFN = new VTA_FormaPagoFN();
                $o_VTA_FormaPagoBN = $o_VTA_FormaPagoFN->selectByPK( $a_VTA_OrdenBN['CondicionVentaId'] );
                if( !$o_VTA_FormaPagoBN )
                {
                    $o_VTA_FormaPagoBN = new VTA_FormaPagoBN();
                }

                $a_VTA_OrdenBN['FormaPagoCod']     = $o_VTA_FormaPagoBN->getCodigo();
                $a_VTA_OrdenBN['FormaPagoDias']    = $o_VTA_FormaPagoBN->getDias();
                $a_VTA_OrdenBN['FechaVencimiento'] = $o_VTA_FormaPagoBN->getDias();

                $a_Rs = $a_VTA_OrdenBN;

                $a_Rs['ProyectoDesc'] = $o_VTA_OrdenBN->getProyectoNombre();
                //ahora buscamos los detalles, para identificar si maneja series
                $a_Rs['escanear_serie'] = 0;
                $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
                $o_VTA_OrdenDetalleFN->setOrdenId( $a_VTA_OrdenBN['OrdenId'] );
                $a_VTA_OrdenDetalle = $o_VTA_OrdenDetalleFN->select();
                if( $a_VTA_OrdenDetalle )
                {
                    foreach ( $a_VTA_OrdenDetalle as $o_VTA_OrdenDetalleBN )
                    {
                        if( $o_VTA_OrdenDetalleBN->getObjectItem()->SiManejaSerie() )
                        {
                            $a_Rs['escanear_serie'] = 1;
                        }
                    }
                }

                //AQUI SE IMPLEMENTA SI EL CLIENTE ES UN AGENTE RETENEDOR -> 2021-10-10
                $a_Rs['EsAgenteRetenedor'] = false;
                $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $a_Rs['ClienteId'] );
                if( $o_MST_PersonaMastBN )
                {
                    if( $o_MST_PersonaMastBN->getEsAgenteRetenedor() )
                    {
                        $a_Rs['EsAgenteRetenedor'] = true;
                        //$a_DataRetencion = MST_PersonaMastBN::getArrayRetenciones( $o_MST_PersonaMastBN->getIdRetencion() );
                        $a_Rs['IdRetencion'] = $o_MST_PersonaMastBN->getIdRetencion();
                    }
                }

            }
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        
        echo json_encode( $a_Rs );
        
        return ViewResponse::NONE;
    }
}