<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>

<script>
asignarIdPrecio = function( id_precio )
{
    $( "#IdTipoPrecio" ).val( id_precio );
    ejecutarGuardar();
}

ejecutarGuardar = function()
{
    var PrecioTotal = parseFloat( $( "#txt_precio" ).val() );

    if( PrecioTotal > 0 )
    {
        blockContent( "content_frm" );

        var strFormSerialize = $( 'form' ).serialize();
        executeAjaxJson
        (
            "<?php echo buildUrl( 'cot/changePrice' ) ?>",
            strFormSerialize,
            function( o_json )
            {
                unBlockContent( "content_frm" );
                console.log( o_json );

                if( o_json.error )
                {
                    showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                    return false;
                }
                parent.executeFindDetail();
                parent.ocultarModal( 'exampleModalScrollable' );
                //parent.$( '#dialog2' ).dialog( 'close' );
                if ( typeof parent.calcularMontoFinal === 'function' )
                {
                    parent.calcularMontoFinal(); // Llama a la función si existe
                }
            }
        );
    }
    else
    {
        showAlertBootStrap( 'content_alert', 'alert-danger', "Debe de ingresar un monto Valido." );
    }
}
</script>

<script>
calcularMontos = function( conIGV )
{
    id_precio_venta_igv = "txt_precio";
    id_precio_venta     = "valor_unit";
    id_monto_igv        = "monto_igv";

    var ValorIGV        = <?=GSS_ParametroMastFN::getValorPorTipo( "AL", "IGV" )?>; //0.18
    var ValorIGVMasUno  = ValorIGV + 1; //1.18

    if( conIGV )
    {
    	if( $( "#" + id_precio_venta_igv ).val() == "" )
    	{
            return false;
    	}
        
        var precio_venta_igv = parseFloat( $( "#" + id_precio_venta_igv ).val() );
    	if( "<?=$AfectoIGV?>" == "Y" )
        {
            var precio_venta = redondear( ( precio_venta_igv / ValorIGVMasUno ), 2 );
            var monto_igv    = redondear( precio_venta_igv - precio_venta, 2 );
        }
    	else
        {
            var precio_venta = precio_venta_igv;
            var monto_igv    = 0;
        }

        $( "#" + id_precio_venta ).val( precio_venta );
        $( "#" + id_monto_igv ).val( monto_igv );
    }
    else
    {
    	if( $( "#" + id_precio_venta ).val() == "" )
    	{
            return false;
    	}
        
        var precio_venta = parseFloat( $( "#" + id_precio_venta ).val() );
        if( "<?=$AfectoIGV?>" == "Y" )
        {
            var precio_venta_igv = redondear( precio_venta * ValorIGVMasUno, 2 );
            var monto_igv        = redondear( precio_venta_igv - precio_venta, 2 );
        }
        else
        {
            var precio_venta_igv = precio_venta;
            var monto_igv        = 0;
        }

        $( "#" + id_precio_venta_igv ).val( precio_venta_igv );
        $( "#" + id_monto_igv ).val( monto_igv );
    }

    calcularTotalOrden();
}

calcularTotalOrden = function()
{
    var ValorIGV        = <?=GSS_ParametroMastFN::getValorPorTipo( "AL", "IGV" )?>; //0.18
    var ValorIGVMasUno  = ValorIGV + 1; //1.18

    var PrecioUnit      = floatval( $( "#valor_unit" ).val() );
    var PrecioIncIGV    = floatval( $( "#txt_precio" ).val() );
    var Cantidad        = floatval( $( "#cantidad" ).val() );
    var Descuento       = floatval( $( "#descuento" ).val() );
    //var DescuentoTot    = floatval( $( "#descuento_tot" ).val() );

    if( "<?=$AfectoIGV?>" == "Y" )
    {
        var MontoTotalNeto = redondear( PrecioIncIGV * Cantidad, 2 );
        var MontoSubTotal = redondear( MontoTotalNeto / ValorIGVMasUno, 2 );
        var Impuesto = redondear( MontoTotalNeto - MontoSubTotal, 2 );
    }
    else
    {
        var MontoTotalNeto = redondear( PrecioIncIGV * Cantidad, 2 );
        var MontoSubTotal = MontoTotalNeto;
        var Impuesto = 0;
    }

    if( Descuento > 0 )
    {
        var DsctoTotVal = redondear( Cantidad * Descuento, 2 );
        $( "#descuento_tot" ).val( DsctoTotVal );

        $( "#precio_dscto" ).val( redondear( PrecioUnit - Descuento, 2 ) );

        if( "<?=$AfectoIGV?>" == "Y" )
        {
            MontoSubTotal   = redondear( MontoSubTotal - DsctoTotVal, 2 );
            MontoTotalNeto  = redondear( MontoSubTotal * ValorIGVMasUno, 2 );
            Impuesto        = redondear( MontoTotalNeto - MontoSubTotal, 2 );
        }
        else
        {
            MontoSubTotal   = MontoSubTotal - DsctoTotVal;
            MontoTotalNeto  = MontoSubTotal;
            Impuesto        = 0;
        }

        var CalculoPorDscto = redondear( ( Descuento * 100 ) / PrecioUnit, 2 );
        $( "#por_dscto" ).val( CalculoPorDscto );
    }
    else
    {
        $( "#descuento_tot" ).val( 0 );
        $( "#precio_dscto" ).val( 0 );
    }

    $( "#subtotal_valor" ).val( MontoSubTotal );
    $( "#subtotal_igv" ).val( Impuesto );
    $( "#total_valor" ).val( MontoTotalNeto );
}

calcularDsctoxLinea = function()
{
    var por_dscto  = parseFloat( $( "#por_dscto" ).val() );
    var valor_unit = parseFloat( $( "#valor_unit" ).val() );
    var tot_dscto  = redondear( valor_unit * ( por_dscto / 100 ) , 2 );
    $( "#descuento" ).val( tot_dscto );
    calcularTotalOrden();
}
</script>

<div id="content_frm">
    <form id="form1" name="form1" method="POST" onsubmit="return false;"  enctype="multipart/form-data">
        <input type="hidden" name="id" id="id" value="<?=$i_Id?>"/>
        <input type="hidden" name="id_item" id="id_item" value="<?=$s_IdItem?>"/>
        <input type="hidden" name="secuencia" id="secuencia" value="<?=$s_Secuencia?>"/>
        <input type="hidden" name="tipo_precio" id="IdTipoPrecio" value=""/>
    
        <div id="resultContent" style=""></div>
        <div id="content_alert" style=""></div>

        <div class="container">
            <div class="row">
                <div class="col p-2 mb-1 bg-info text-white text-right">
                    C&oacute;digo
                </div>
                <div class="col p-2 mb-1 bg-white text-dark border border-info">
                    <?=$o_ALM_ItemMastBN->getIdItem()?>
                </div>
            </div>
            <div class="row">
                <div class="col p-2 mb-1 bg-info text-white text-right">
                    Descripci&oacute;n
                </div>
                <div class="col p-2 mb-1 bg-white text-dark border border-info">
                    <?=$o_ALM_ItemMastBN->getDescripcionCompleta()?>
                </div>
            </div>
            <div class="row">
                <div class="col p-2 mb-1 bg-info text-white text-right">
                    <label class="text-white" for="contrasenia">Contrase&ntilde;a</label>
                </div>
                <div class="col p-2 mb-1 bg-white text-dark border border-info">
                    <input type="password" class="form-control text-center" name="contrasenia" id="contrasenia" onblur="" onfocus="this.select();">
                </div>
            </div>
        </div>
        <div class="dropdown-divider"></div>

        <div class="form-row mx-0">
            <div class="col-md-10 mb-1">
                <div class="card">
                    <div class="form-row mx-0">
                        <div class="col-md-3 mt-1 mb-1">
                            <label class="col-form-label" for="cantidad">Cantidad</label>
                            <input type="text" class="form-control text-center" name="cantidad" id="cantidad" onblur="" onfocus="" autocomplete="off" value="<?=$o_VTA_DocumentoDetalleBN->getOrdenDetalleCantidad()?>" readonly>
                        </div>
                        <div class="col-md-3 mt-1 mb-1">
                            <label class="col-form-label" for="valor_unit">Valor Unit. Sin IGV</label>
                            <input type="text" class="form-control text-center" name="valor_unit" id="valor_unit" onblur="calcularMontos( false )" onfocus="this.select();" autocomplete="off" value="<?=$o_VTA_DocumentoDetalleBN->getOrdenDetallePrecioUnidad()?>">
                        </div>
                        <div class="col-md-3 mt-1 mb-1">
                            <label class="col-form-label" for="monto_igv">IGV</label>
                            <input type="text" class="form-control text-center" name="monto_igv" id="monto_igv" placeholder="" readonly="readonly" value="<?=$o_VTA_DocumentoDetalleBN->getOrdenDetalleImpuestoUnidad()?>">
                        </div>
                        <div class="col-md-3 mt-1 mb-1">
                            <label class="col-form-label" for="txt_precio">Total Unit. Inc IGV</label>
                            <input type="text" class="form-control text-center" name="txt_precio" id="txt_precio" onblur="calcularMontos( true )" onfocus="this.select();" autocomplete="off" value="<?=$o_VTA_DocumentoDetalleBN->getPrecioUnidadIncImpuesto()?>">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-2 mb-1">
                <button type="button" class="btn btn-primary btn-sm btn-block" onclick="asignarIdPrecio('P');">GUARDAR</button>
            </div>
        </div>

        <div class="form-row mx-0">
            <div class="col-md-12 mb-1">
                <div class="card">
                    <div class="form-row mx-0">
                        <div class="col-md-1 mb-1">
                            <label class="col-form-label" for="descuento">% Dscto</label>
                            <input type="text" class="form-control text-center" name="por_dscto" id="por_dscto" onblur="calcularDsctoxLinea();" onfocus="this.select();" autocomplete="off" value="<?=$o_VTA_DocumentoDetalleBN->getOrdenDetallePorcDscto()?>">
                        </div>
                        <div class="col-md-11">
                            <div class="form-row mx-0">
                                <div class="col-md-2 mb-1">
                                    <label class="col-form-label" for="descuento">Descuento</label>
                                    <input type="text" class="form-control text-center" name="descuento" id="descuento" onblur="calcularTotalOrden();" onfocus="this.select();" autocomplete="off" value="<?=( $o_VTA_DocumentoDetalleBN->getOrdenDetalleDsctoUnidad() / $o_VTA_DocumentoDetalleBN->getOrdenDetalleCantidad() )?>" >
                                </div>
                                <div class="col-md-2 mb-1">
                                    <label class="col-form-label" for="precio_dscto">Precio Dscto</label>
                                    <input type="text" class="form-control text-center" name="precio_dscto" id="precio_dscto" onblur="" onfocus="" autocomplete="off" value="" readonly>
                                </div>
                                <div class="col-md-2 mb-1">
                                    <label class="col-form-label" for="subtotal_valor">Subtotal</label>
                                    <input type="text" class="form-control text-center" name="subtotal_valor" id="subtotal_valor" onblur="" onfocus="" autocomplete="off" value="" readonly>
                                </div>
                                <div class="col-md-2 mb-1">
                                    <label class="col-form-label" for="descuento_tot">Dscto Total</label>
                                    <input type="text" class="form-control text-center" name="descuento_tot" id="descuento_tot" onblur="" onfocus="" autocomplete="off" value="" readonly>
                                </div>
                                <div class="col-md-2 mb-1">
                                    <label class="col-form-label" for="subtotal_igv">Nvo IGV</label>
                                    <input type="text" class="form-control text-center" name="subtotal_igv" id="subtotal_igv" onblur="" onfocus="" autocomplete="off" value="" readonly>
                                </div>
                                <div class="col-md-2 mb-1">
                                    <label class="col-form-label" for="total_valor">Total Inc IGV</label>
                                    <input type="text" class="form-control text-center" name="total_valor" id="total_valor" onblur="" onfocus="" autocomplete="off" value="" readonly>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="dropdown-divider"></div>

        <table class="table table-sm table-bordered table-hover">
            <thead class="thead-light">
                <tr>
                    <th scope="col" style="text-align: center;">Nivel</th>
                    <!-- <th scope="col" style="text-align: center;">Margen %</th> -->
                    <th scope="col" style="text-align: center;">Precio Sin IGV</th>
                    <th scope="col" style="text-align: center;">Precio Con IGV</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach ( $a_MST_ListaPrecioDetalle as $i_Key => $o_MST_ListaPrecioDetalleBN ){ ?>
                <?php
                $s_IdTipoPrecio = $o_MST_ListaPrecioDetalleBN->getIdTipoPrecio();
                $f_Porcentaje   = $o_MST_ListaPrecioDetalleBN->getPorcentajeUtilidad();
                if( !$f_Porcentaje )
                {
                    if( $o_MST_ListaPrecioDetalleBN->getPrecioVenta() > 0 )
                    {
                        $f_Porcentaje = round( ( 100 * ( $o_MST_ListaPrecioDetalleBN->getPrecioVenta() - $o_MST_ListaPrecioDetalleBN->getPrecioCosto() ) / $o_MST_ListaPrecioDetalleBN->getPrecioVenta() ), 2 );
                    }
                    else
                    {
                        $f_Porcentaje = 0;
                    }
                }
                if( $o_MST_ListaPrecioDetalleBN->getIdRangoDetalle() )
                {
                    $o_MST_RangoDetalleFN = new MST_RangoDetalleFN();
                    $o_MST_RangoDetalleBN = $o_MST_RangoDetalleFN->selectByPK( $o_MST_ListaPrecioDetalleBN->getIdRangoDetalle() );
                    if( $o_MST_RangoDetalleBN )
                    {
                        $s_IdTipoPrecio = $o_MST_RangoDetalleBN->getMinimo()." - ".$o_MST_RangoDetalleBN->getMaximo();
                    }
                }
                ?>
                <tr ondblclick="asignarIdPrecio('<?=$o_MST_ListaPrecioDetalleBN->getIdTipoPrecio()?>');">
                    <td align="center" ><label class="labelData"><?=$s_IdTipoPrecio?></label></td>
                    <!-- <td align="center" ><label class="labelData"><?=$f_Porcentaje?>%</label></td> -->
                    <td align="center" >
                        <?php
                        echo GSS_MonedaMastFN::getSiglaxId( $o_VTA_OrdenBN->getMonedaCod() )."&nbsp;";
                        if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "LO" ) //MONEDA DE LA LISTA DE PRECIOS ES SOLES
                        {
                            if( $o_VTA_OrdenBN->getMonedaCod() == 'LO' )
                            {
                                echo number_format( $o_MST_ListaPrecioDetalleBN->getPrecioVenta(), 2 );
                            }
                            if( $o_VTA_OrdenBN->getMonedaCod() == 'EX' )
                            {
                                echo number_format( $o_MST_ListaPrecioDetalleBN->getPrecioVenta() / $o_VTA_OrdenBN->getMonedaCambioValor(), 2 );
                            }
                        }
                        if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "EX" ) //MONEDA DE LA LISTA DE PRECIOS ES DOLARES
                        {
                            if( $o_VTA_OrdenBN->getMonedaCod() == 'LO' )
                            {
                                echo number_format( $o_MST_ListaPrecioDetalleBN->getPrecioVenta() * $o_VTA_OrdenBN->getMonedaCambioValor(), 2 );
                            }
                            if( $o_VTA_OrdenBN->getMonedaCod() == 'EX' )
                            {
                                echo number_format( $o_MST_ListaPrecioDetalleBN->getPrecioVenta(), 2 );
                            }
                        }
                        ?>
                    </td>
                    <td align="center" >
                        <?php
                        echo GSS_MonedaMastFN::getSiglaxId( $o_VTA_OrdenBN->getMonedaCod() )."&nbsp;";
                        if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "LO" ) //MONEDA DE LA LISTA DE PRECIOS ES SOLES
                        {
                            if( $o_VTA_OrdenBN->getMonedaCod() == 'LO' )
                            {
                                echo number_format( $o_MST_ListaPrecioDetalleBN->getPrecioVentaIGV(), 2 );
                            }
                            if( $o_VTA_OrdenBN->getMonedaCod() == 'EX' )
                            {
                                echo number_format( $o_MST_ListaPrecioDetalleBN->getPrecioVentaIGV() / $o_VTA_OrdenBN->getMonedaCambioValor(), 2 );
                            }
                        }
                        if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "EX" ) //MONEDA DE LA LISTA DE PRECIOS ES DOLARES
                        {
                            if( $o_VTA_OrdenBN->getMonedaCod() == 'LO' )
                            {
                                echo number_format( $o_MST_ListaPrecioDetalleBN->getPrecioVentaIGV() * $o_VTA_OrdenBN->getMonedaCambioValor(), 2 );
                            }
                            if( $o_VTA_OrdenBN->getMonedaCod() == 'EX' )
                            {
                                echo number_format( $o_MST_ListaPrecioDetalleBN->getPrecioVentaIGV(), 2 );
                            }
                        }
                        ?>
                    </td>
                </tr>
            <?php } ?>
            </tbody>
        </table>
    </form>
</div>

<script>
    setTimeout
    (
        function()
        {
            $( "#txt_precio" ).focus();
        },
        500
    );
</script>

<script>
    calcularTotalOrden();
    //ESCAPE, DETECTA EL F5, CTRL+F5
    $( document ).bind
                    (
                        'keyup',
                        function( e )
                        {
                            //pr( e.which );
                            if( e.which === 116 ) { }
                            if( e.which === 82 && e.ctrlKey ) { }
                            if( e.which === 119 ) { }
                            if( e.which === 107 ){ buscarProductosPopup(); } // tecla +
                            if( e.which === 109 ){ buscarServiciosPopup(); } // tecla -
                            if( e.which === 27 ) //ESCAPE
                            {
                                parent.ocultarModal( 'exampleModalScrollable' );
                            }
                            if( e.which === 13 ) //ESCAPE
                            {
                                asignarIdPrecio( 'P' );
                            }
                        }
                    );
</script>