<?php
class ListOrdFcoAction extends wtActions
{
    public function execute()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->i_OrdId  = intval( $this->getRequestParameter( 'ord_id' ) );
        $this->s_OrdNum = $this->getRequestParameter( 'ord_num' );

        $this->b_Control         = false;
        $this->b_Edicion         = true;
        $this->s_MensajeError    = "";
        $s_TipoProc              = $this->getRequestParameter( 'tipoproc' );

        $this->a_FCO_DocRecibo   = array();

        $con = null;
        
        try
        {
            $this->o_VTA_OrdenBN = VTA_OrdenFN::findOrdenByNum( $this->s_OrdNum );
            if
            ( 
                $this->o_VTA_OrdenBN->getOrdenEstado() == VTA_OrdenBN::ESTADO_CERRADO  || 
                $this->o_VTA_OrdenBN->getOrdenEstado() == VTA_OrdenBN::ESTADO_ANULADO  ||
                $this->o_VTA_OrdenBN->getOrdenEstado() == VTA_OrdenBN::ESTADO_FACTURA 
            )
            {
                $this->b_Edicion = false;
            }
            
            $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
            $this->o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $this->o_VTA_OrdenBN->getMonedaCod() );
            $this->s_PrfMonedaOrd = $this->o_GSS_MonedaMastBN->getSigla();

            $o_MST_PersonaMastFN = new MST_PersonaMastFN();
            $this->o_MST_PersonaMastFN = $o_MST_PersonaMastFN->setIdPersona( $this->o_VTA_OrdenBN->getClienteId() );

            $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
            $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_ALM_AlmacenMastFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
            $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();

            //FORMA DE PAGO
            $o_VTA_FormaPagoFN = new VTA_FormaPagoFN();
            $o_VTA_FormaPagoFN->setEstado( "A" );
            $o_VTA_FormaPagoFN->addOrderBy( VTA_FormaPagoFN::DescripcionLocal );

            //AHORA PREGUNTAMOS SI ESTA ACTIVO LA NOTA DE VENTA
            $this->a_GSS_SucursalDocumento = null;
            if( $this->o_VTA_OrdenBN->getClienteDocCod() == "DNI" )
            {
                $o_GSS_SucursalDocumentoFN = new GSS_SucursalDocumentoFN();
                $o_GSS_SucursalDocumentoFN->setIdTipoDocumento( "NV" );
                $o_GSS_SucursalDocumentoFN->setEstado( "A" );
                $this->a_GSS_SucursalDocumento = $o_GSS_SucursalDocumentoFN->select();
            }

            if( $this->getRequestParameter( 'control' ) )
            {
                $con = Conexion::getConexion();
                $con->begin();

                myUser::getUser()->validar_session();
                
                switch ( $s_TipoProc ) 
                {
                    case 'del':
                        $i_IdDocRecibo  = intval( $this->getRequestParameter( 'iddocrecibo' ) );
                        $i_IdAplicacion = intval( $this->getRequestParameter( 'idaplicacion' ) );

                        $o_FCO_DocReciboFN = new FCO_DocReciboFN();
                        $o_FCO_DocReciboBN = $o_FCO_DocReciboFN->selectByPK( $i_IdDocRecibo );
                        if( !$o_FCO_DocReciboBN )
                        {
                            throw new Exception( "No se encontro el Recibo como Referencia para proceder a eliminar." );
                        }
                        if( $o_FCO_DocReciboBN->getFlujoEstado() != FCO_DocReciboBN::FLUESTADO_PENDIENTE )
                        {
                            throw new Exception( "El Recibo tiene un estado diferente, no se puede eliminar." );
                            //aqui se tiene que evaluar mas a detalle
                            //por ejemplo si tiene un estado aprobado, solo se tiene que separar la aplicacion, entonces ahi pasa por el recalculo de saldo
                        }

                        //ahroa revisamos la aplicacion
                        $o_FCO_OrdenReciboFN = new FCO_OrdenReciboFN();
                        $o_FCO_OrdenReciboBN = $o_FCO_OrdenReciboFN->selectByPK( $i_IdAplicacion, $i_IdDocRecibo );
                        if( !$o_FCO_OrdenReciboBN )
                        {
                            throw new Exception( "No se encontro la Aplicacion como Referencia para proceder a eliminar." );
                        }

                        $o_FCO_DocReciboDP = new FCO_DocReciboDP();
                        $o_FCO_DocReciboDP->setIdDocRecibo( $i_IdDocRecibo );
                        $o_FCO_DocReciboDP->delete();

                        $o_FCO_OrdenReciboDP = new FCO_OrdenReciboDP();
                        $o_FCO_OrdenReciboDP->setOrdenId( $i_IdAplicacion );
                        $o_FCO_OrdenReciboDP->setIdDocRecibo( $i_IdDocRecibo );
                        $o_FCO_OrdenReciboDP->delete();
                    break;
                }
                $con->commit();
                //redirect
                $s_Dir = Constantes::ROOT_DIR_APP;
                header( "Location:".$s_Dir."vta.php/cot/listOrdFco/ord_id/".$this->i_OrdId."/ord_num/".$this->s_OrdNum );
                exit;
            }

            $this->b_CtrlFactura = false;
            if( $this->o_VTA_OrdenBN->getOrdenEstado() == VTA_OrdenBN::ESTADO_FACTURA )
            {
                $o_VTA_DocumentoFN = VTA_DocumentoFN::findByDocumentoParentCod( $this->s_OrdNum );

                $o_FCO_DocReciboFN = new FCO_DocReciboFN();
                $o_FCO_DocReciboFN->setIdDocNumRef( $o_VTA_DocumentoFN->getNumeroDocumento() );
                $o_FCO_DocReciboFN->setEstado( FCO_DocReciboBN::ESTADO_ACTIVO );
                $o_FCO_DocReciboFN->addCondition( FCO_DocReciboFN::Saldo, '>', 0, false );
                $this->a_FCO_DocRecibo = $o_FCO_DocReciboFN->buscarRecibosPorDocRef();

                $this->b_CtrlFactura = true;
            }
            else
            {
                $o_FCO_DocReciboFN = new FCO_DocReciboFN();
                $o_FCO_DocReciboFN->setIdDocNumRef( $this->i_OrdId );
                $o_FCO_DocReciboFN->setEstado( FCO_DocReciboBN::ESTADO_ACTIVO );
                $o_FCO_DocReciboFN->addCondition( FCO_DocReciboFN::Saldo, '>', 0, false );
                $this->a_FCO_DocRecibo = $o_FCO_DocReciboFN->buscarOrdenRecibosPorDocRef();
                if( $this->a_FCO_DocRecibo )
                {
                    $a_ClaseNombre = array();
                    foreach ( $this->a_FCO_DocRecibo as $o_FCO_DocReciboBN ) 
                    {
                        $a_ClaseNombre[$o_FCO_DocReciboBN->getClaseNombre()] = $o_FCO_DocReciboBN->getClaseNombre();
                    }
                    VTA_OrdenDP::actualizarFormaPago( $this->i_OrdId, implode( ", ", $a_ClaseNombre ) );
                }
            }
        }
        catch ( Exception $o_Exception )
        {
            if( $con )
            {
                $con->rollback();
            }
            $this->s_MensajeError = $o_Exception->getMessage();
            //$a_Rs['error']        = true;
            //$a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        
        
    }
}