<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>

<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/responsive/2.2.5/css/responsive.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/fixedheader/3.1.7/css/fixedHeader.dataTables.min.css" />

<!--<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" />-->

<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/responsive.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/fixedheader/3.1.7/js/dataTables.fixedHeader.min.js"></script>

<style type="text/css">
/*
#example_wrapper .row
{
    margin-right: 0;
    margin-left: 0;
}
table.dataTable tbody tr:hover 
{
   background-color: #DAE6FE !important;;
}
*/
.table td, .table th 
{
    /*padding: 8px;*/
    font-size: 13px;
}
th { white-space: nowrap; }
a:hover {
    color: #0056b3;
    text-decoration: underline;
}

a {
    color: #007bff;
    text-decoration: none;
    background-color: transparent;
    -webkit-text-decoration-skip: objects;
}
</style>

<div class="shadow-sm p-3 mb-2 bg-white rounded card card-body">
    <div class="row">
        <div class="col mb-1">
            <h4 class="text-info text-nowrap mb-0">Cuenta Corriente - Cliente</h4>
        </div>
        <div class="form-row mx-1">
            
        </div>
    </div>
</div>

<script type="text/javascript">
procesarForm = function()
{
    var IdPersona = $( "#ClienteNumero" ).val()
    if( IdPersona == "" )
    {
        if( $( "#NumeroComprobante" ).val().trim() == "" )
        {
            showAlertBootStrap( 'content_alert', 'alert-danger', "Debe de seleccionar el Cliente." );
            return false;
        }
    }
    
    return true;
}
</script>

<div id="content_alert" style=""></div>

<div class="card" id="content_datos_cliente">
    <h5 class="card-header">Datos de Cliente</h5>
    <div class="card-body" style="padding: 10px;">
        <form class="" name="form1" id="form1" method="POST" action=""  onsubmit="return procesarForm();">
            <input type="hidden" name="Control" id="Control" value="1">
            
            <div class="form-row mx-0">
                <div class="col-md-10 mb-1">
                    <div class="form-row mx-0">
                        <div class="col-md-4 mb-1">
                            <select class="form-control form-control-sm custom-select my-0 mr-sm-2" name="TipoDocCliente" id="TipoDocCliente" onchange="">
                            <?php foreach ( MST_PersonaMastBN::getArrayTipoDocumento() as $s_Key => $s_TipoDoc ){ ?>
                                <option value="<?=$s_Key?>" <?php if( $o_FCO_DocReciboBN->getTipoDocCliente() == $s_Key ){ echo "SELECTED"; } ?> > <?=$s_Key?> </option>
                            <?php } ?>
                            </select>
                            <div class="input-group mb-0">
                                <input type="hidden" name="ClienteNumero" id="ClienteNumero" value="<?=$s_ClienteNumero?>">
                                <input type="text" id="NumDocuCliente" name="NumDocuCliente" class="form-control" onfocus="this.select();" value="<?=$s_NumDocuCliente?>" onkeypress="return NumCheckEntero( event, this );" placeholder="Numero Doc Cliente">
                            </div>
                        </div>
                        <div class="col-md-4 mb-1">
                            <label for="NombreCliente" class="col-form-label">Nombres | Raz&oacute;n Social:</label>
                            <input type="text" class="form-control" id="NombreCliente" placeholder="" name="NombreCliente" value="<?=$s_NombreCliente?>" autocomplete="off" >
                        </div>
                        <div class="col-md-4 mb-1">
                            <div class="col-auto">
                                <label class="sr-only" for="FechaDocumento1">Emitido Desde</label>
                                <div class="input-group mb-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text"><?=addImgButton( "calendar.png", array( "class"=>"", "height"=>24 ) )?></div>
                                    </div>
                                    <input type="text" class="form-control text-center" id="FechaDocumento1" name="FechaDocumento1" placeholder="Emitido Desde" value="<?=$s_FechaDocumento1?>" autocomplete="off">
                                    <script type="text/javascript">
                                    $( "#FechaDocumento1" ).datepicker( { dateFormat: "yy-mm-dd", changeYear:true, yearRange: "-2:+0", changeMonth: true, onClose: function (){ this.focus(); } } );
                                    </script>
                                </div>
                            </div>
                            <div class="col-auto">
                                <label class="sr-only" for="FechaDocumento2">Emitido Hasta</label>
                                <div class="input-group mb-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text"><?=addImgButton( "calendar.png", array( "class"=>"", "height"=>24 ) )?></div>
                                    </div>
                                    <input type="text" class="form-control text-center" id="FechaDocumento2" name="FechaDocumento2" placeholder="Emitido Hasta" value="<?=$s_FechaDocumento2?>" autocomplete="off">
                                    <script type="text/javascript">
                                    $( "#FechaDocumento2" ).datepicker( { dateFormat: "yy-mm-dd", changeYear:true, yearRange: "-2:+0", changeMonth: true, onClose: function (){ this.focus(); } } );
                                    </script>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-row mx-0">
                        <div class="col-md-4 mb-1">
                            <label class="col-form-label" for="IdTipoDocumento">Tipo de Documento</label>
                            <select class="form-control" name="IdTipoDocumento" id="IdTipoDocumento">
                                <option value=""> - SELECCIONE - </option>
                                <?php foreach( VTA_TipoDocumentoFN::selectActivo()  as $o_VTA_TipoDocumentoBN ){ ?>
                                    <option value="<?=$o_VTA_TipoDocumentoBN->getIdTipoDocumento()?>" <?php if( $s_IdTipoDocumento==$o_VTA_TipoDocumentoBN->getIdTipoDocumento() ){ echo "SELECTED"; } ?>> 
                                        <?=$o_VTA_TipoDocumentoBN->getDescripcionLocal()?> 
                                    </option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-1">
                            <label for="NumeroComprobante" class="col-form-label">Numero Comprobante:</label>
                            <input type="text" class="form-control" id="NumeroComprobante" placeholder="" name="NumeroComprobante" value="<?=$s_NumeroComprobante?>" autocomplete="off" >
                        </div>
                        <div class="col-md-4 mb-1">
                            <label class="col-form-label" for="MetodoBusqueda">Metodo de Busqueda</label>
                            <select class="form-control" name="MetodoBusqueda" id="MetodoBusqueda">
                                <option value=""> - SELECCIONE - </option>
                                <option value="CONDEUDA" <?php if( $s_MetodoBusqueda=="CONDEUDA" ){ echo "SELECTED"; } ?> > CON DEUDA </option>
                                <option value="SINDEUDA" <?php if( $s_MetodoBusqueda=="SINDEUDA" ){ echo "SELECTED"; } ?> > SIN DEUDA </option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-md-2 mb-1">
                    <button type="submit" class="btn btn-primary btn-block">BUSCAR</button>
                    <button type="button" class="btn btn-primary btn-block">EXPORTAR EXCEL</button>
                </div>
                
            </div>
        </form>
    </div>
</div>



<script type="text/javascript">
$( "#NumDocuCliente" ).autocomplete
(
    {
        source: function(request, response) 
        {
            $.getJSON
            (
                "<?=buildUrlComplet( 'vta.php/recephabit/requestUbicacion' )?>",
                { term:request.term, tipo_proc:'AutocompleteDoc', tipo_doc: $( '#TipoDocCliente' ).val() }, 
                response
            );
        },
        minLength: 2,
        select: function( event, ui ) 
        {
            $( "#ClienteNumero" ).val( ui.item.id );
            blockContent( 'content_datos_cliente' );
            buscarInfoCliente();
        }
    }
);

$( "#NombreCliente" ).autocomplete
(
    {
        source: "<?=buildUrlComplet( 'vta.php/recephabit/requestUbicacion', "tipo_proc=Autocomplete" )?>",
        minLength: 2,
        select: function( event, ui ) 
        {
            $( "#ClienteNumero" ).val( ui.item.id );
            $( "#TipoDocCliente" ).val( ui.item.tipo_doc );
            $( "#NumDocuCliente" ).val( ui.item.num_doc );
            blockContent( 'content_datos_cliente' );
            buscarInfoCliente();
        }
    }
);

buscarInfoCliente = function()
{
    //limpiarValores();
    /////////
    
    var ClienteNumero = $( "#ClienteNumero" ).val();
    var strFormSerialize = "tipo_proc=getClienteInfo&ClienteNumero=" + ClienteNumero;
    
    executeAjaxJson
    ( 
        "<?php echo buildUrlComplet( 'vta.php/recephabit/requestUbicacion', "" ) ?>", 
        strFormSerialize,
        function( o_json )
        {
            console.log( o_json );
            
            if( o_json.error )
            {
                //mostrarMensajeError( o_json.mensaje_error );
                return false;
            }
            $( "#NombreCliente" ).val( o_json.Nombre );
            $( "#NumDocuCliente" ).val( o_json.Documento );
            $( "#TipoDocCliente" ).val( o_json.TipoDocumento );
            //$( "#DireccionCliente" ).val( o_json.Direccion );
            //$( "#IdVendedor" ).val( o_json.CodVendedor );
            //$( "#sDepartamento" ).val( o_json.DepartamentoDesc );
            //$( "#sProvincia" ).val( o_json.ProvinciaDesc );
            //$( "#sDistrito" ).val( o_json.DistritoDesc );
            //$( "#IdUbigeo" ).val( o_json.IdUbigeo );
            //$( "#cboCanal" ).val( o_json.CanalCliente );
            //$( "#sPais" ).val( "PERU" );
            
            unBlockContent( 'content_datos_cliente' );
            
        }
    );
}
</script>

<div class="dropdown-divider"></div>

<!-- <table class="table table-sm table-bordered table-hover"> -->
<table id="example" class="table table-striped table-bordered" border="1" style="width:100%">
    <thead class="">
        <tr class="table-primary">
            <th style="text-align: center;" scope="col" rowspan="2"><b>Nro</b></th>
            <th style="text-align: center;" scope="col" rowspan="2"><b>Emitido</b></th>
            <th style="text-align: center;" scope="col" rowspan="2"><b>Cotizaci&oacute;n</b></th>
            <th style="text-align: center;" scope="col" rowspan="2"><b>TipoDoc</b></th>
            <th style="text-align: center;" scope="col" rowspan="2"><b>Comprobante</b></th>
            <th style="text-align: center;" scope="col" rowspan="2"><b>Moneda</b></th>
            <th style="text-align: center;" scope="col" rowspan="2"><b>Monto Total</b></th>
            <th style="text-align: center;" scope="col" colspan="7"><b>Aplicaciones</b></th>

            <th style="text-align: center;" scope="col" rowspan="2"><b>Vence</b></th>
            <th style="text-align: center;" scope="col" rowspan="2"><b>D&iacute;as</b></th>

            <th style="text-align: center;" scope="col" rowspan="2"><b>Deuda</b></th>
            <th style="text-align: center;" scope="col" rowspan="2"><b>Estado</b></th>
        </tr>
        <tr class="table-primary">
            <th style="text-align: center;" scope="col"><b>Fecha Apli</b></th>
            <th style="text-align: center;" scope="col"><b>Metodo Pago</b></th>
            <th style="text-align: center;" scope="col"><b>Nro Operacion</b></th>
            <th style="text-align: center;" scope="col"><b>Observaciones</b></th>
            <th style="text-align: center;" scope="col"><b>Moneda</b></th>
            <th style="text-align: center;" scope="col"><b>Monto Apli</b></th>
            <th style="text-align: center;" scope="col"><b>Monto Conv</b></th>
        </tr>
    </thead>
    
    <tbody id="">
    <?php $i_CntIni = 1 ?>
    <?php foreach ( $a_VTA_Documento as $i_Key => $o_VTA_DocumentoBN ){ ?>
        <?php
        $o_FCO_AplicacionFN = new FCO_AplicacionFN();
        $o_FCO_AplicacionFN->setIdDocNumRef( $o_VTA_DocumentoBN->getNumeroDocumento() );
        $a_FCO_Aplicacion = $o_FCO_AplicacionFN->select();
        
        $i_rowspan = ( count( $a_FCO_Aplicacion ) > 0 ? count( $a_FCO_Aplicacion ) : 1 );
        
        $s_Estado = $o_VTA_DocumentoBN->getCobranzaEstado() == "PE" ? "PENDIENTE" : "COBRADO";
        //if( $i_rowspan!=1 ){ continue; }

        $s_FechaDocumento   = substr( $o_VTA_DocumentoBN->getFechaDocumento(), 0, 10 );
        $s_FechaVencimiento = substr( $o_VTA_DocumentoBN->getFechaVencimiento(), 0, 10 );
        $s_FechaActual      = date( "Y-m-d" );
        $o_CantDias         = UtilDate::datetimeDiff( $s_FechaVencimiento, $s_FechaActual );
        if( $o_VTA_DocumentoBN->getCobranzaEstado() != "PE" )
        {
            $o_CantDias->day = "";
        }
        ?>

        <tr>
            <td nowrap="nowrap" style="text-align: center;" rowspan="<?php echo $i_rowspan; ?>"><?=$i_CntIni?></td>
            <td nowrap="nowrap" style="text-align: center;" rowspan="<?php echo $i_rowspan; ?>"><?=$s_FechaDocumento?></td>
            <td nowrap="nowrap" style="text-align: center;" rowspan="<?php echo $i_rowspan; ?>"><a href="javascript:void(0)" onclick="abrirPopupCotizacion( '<?=$o_VTA_DocumentoBN->getDocumentoParentId()?>' );"><?=$o_VTA_DocumentoBN->getDocumentoParentCod()?></a></td>
            <td nowrap="nowrap" style="text-align: center;" rowspan="<?php echo $i_rowspan; ?>"><?=$o_VTA_DocumentoBN->getDocumentoCod()?></td>
            <td nowrap="nowrap" style="text-align: center;" rowspan="<?php echo $i_rowspan; ?>"><a href="javascript:void(0)" onclick="abrirPopupComprobante( '<?=$o_VTA_DocumentoBN->getIdTipoDocumento()?>', '<?=$o_VTA_DocumentoBN->getIdCompania()?>', '<?=$o_VTA_DocumentoBN->getNumeroDocumento()?>' );"><?=$o_VTA_DocumentoBN->getNumeroComprobante()?></a></td>
            <td nowrap="nowrap" style="text-align: center;" rowspan="<?php echo $i_rowspan; ?>"><?=$o_VTA_DocumentoBN->getObjectMoneda()->getDescripcion()?></td>
            <td nowrap="nowrap" style="text-align: right;" rowspan="<?php echo $i_rowspan; ?>"><?=number_format( $o_VTA_DocumentoBN->getMontoTotal(), 2 )?></td>
            
            <?php if( count( $a_FCO_Aplicacion ) > 0 ){ ?>

                <?php $i_Contador = 1 ?>
                <?php $i_CntIni++ ?>
                <?php foreach ( $a_FCO_Aplicacion as $i_aplication => $o_FCO_AplicacionBN ){ ?>
                    
                    <?php if( $i_aplication > 0 ){ ?>

                    </tr>
                    <tr>
                    <?php } ?>

                    <?php if( $i_Contador > 1 ){ ?>

                    <td style="display: none;"><?=$i_CntIni?></td>
                    <td style="display: none;">&nbsp;</td>
                    <td style="display: none;">&nbsp;</td>
                    <td style="display: none;">&nbsp;</td>
                    <td style="display: none;">&nbsp;</td>
                    <td style="display: none;">&nbsp;</td>
                    <td style="display: none;">&nbsp;</td>
                    <?php } ?>
                    
                    <td style="text-align: center;"><?=substr( $o_FCO_AplicacionBN->getFechaAplicacion(), 0, 10 )?></td>
                    <td style="text-align: center;"><?=$o_FCO_AplicacionBN->getTipoPagoNombre()?></td>
                    <td style="text-align: center;"><?=$o_FCO_AplicacionBN->getReciboNumero()?></td>
                    <td style="text-align: center;" nowrap="nowrap"><?=$o_FCO_AplicacionBN->getObjectDocRecibo()->getBancoDesc()?> <?=$o_FCO_AplicacionBN->getObjectDocRecibo()->getObjectCuentaBancaria()->getNumeroCuentaCorto()?></td>
                    <td style="text-align: center;"><?=$o_FCO_AplicacionBN->getMonedaDes()?></td>
                    <td style="text-align: right;"><?=number_format( $o_FCO_AplicacionBN->getMontoAplicado(), 2 )?></td>
                    <td style="text-align: right;"><?=number_format( $o_FCO_AplicacionBN->getMontoAplicacionMN(), 2 )?></td>

                    <?php if( $i_Contador > 1 ){ ?>

                    <td style="display: none;">&nbsp;</td>
                    <td style="display: none;">&nbsp;</td>
                    <?php } ?>
                    
                    <?php if( $i_aplication == 0 ){ ?>

                    <td nowrap="" style="text-align: right;" rowspan="<?php echo $i_rowspan; ?>"><?=$s_FechaVencimiento?></td>
                    <td style="text-align: right;" rowspan="<?php echo $i_rowspan; ?>"><?=$o_CantDias->day?></td>
                    <td style="text-align: right;" rowspan="<?php echo $i_rowspan; ?>"><?=number_format( $o_VTA_DocumentoBN->getMontoSaldo(), 2 )?></td>
                    <td style="text-align: center;" rowspan="<?php echo $i_rowspan; ?>"><?=$s_Estado?></td>
                    
                    <?php } ?>

                    <?php $i_Contador++ ?>

                <?php } ?>
            
            <?php }else{ ?>
            
            <td align="left" valign="top" colspan="" rowspan="<?php echo $i_rowspan; ?>">&nbsp;</td>
            <td align="left" valign="top" colspan="" rowspan="<?php echo $i_rowspan; ?>">&nbsp;</td>
            <td align="left" valign="top" colspan="" rowspan="<?php echo $i_rowspan; ?>">&nbsp;</td>
            <td align="left" valign="top" colspan="" rowspan="<?php echo $i_rowspan; ?>">&nbsp;</td>
            <td align="left" valign="top" colspan="" rowspan="<?php echo $i_rowspan; ?>">&nbsp;</td>
            <td align="left" valign="top" colspan="" rowspan="<?php echo $i_rowspan; ?>">&nbsp;</td>
            <td align="left" valign="top" colspan="" rowspan="<?php echo $i_rowspan; ?>">&nbsp;</td>
            
            <td nowrap="" style="text-align: right;" rowspan="<?php echo $i_rowspan; ?>"><?=$s_FechaVencimiento?></td>
            <td style="text-align: right;" rowspan="<?php echo $i_rowspan; ?>"><?=$o_CantDias->day?></td>
            <td style="text-align: right;" rowspan="<?php echo $i_rowspan; ?>"><?=number_format( $o_VTA_DocumentoBN->getMontoSaldo(), 2 )?></td>
            <td style="text-align: center;" rowspan="<?php echo $i_rowspan; ?>"><?=$s_Estado?></td>
                <?php $i_CntIni++ ?>
            <?php } ?>
            
        </tr>


    <?php } ?>
    </tbody>
    <tbody>
        <tr class="table-primary">
            <td > &nbsp; </td>
            <td > &nbsp; </td>
            <td > &nbsp; </td>
            <td > &nbsp; </td>
            <td > &nbsp; </td>
            <td > &nbsp; </td>
            <td > &nbsp; </td>
            <td > &nbsp; </td>
            <td > &nbsp; </td>
            <td > &nbsp; </td>
            <td > &nbsp; </td>
            <td > &nbsp; </td>
            <td > &nbsp; </td>
            <td > &nbsp; </td>
            <td > &nbsp; </td>
            <td > &nbsp; </td>
            <td > &nbsp; </td>
            <td > &nbsp; </td>
        </tr>
    </tbody>
</table>

<script type="text/javascript">
    var table = null;
    configurarDataTable = function()
    {
        table = $( '#example' ).DataTable
        (
            {
                language:       { "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json" },
                responsive:     false,
                searching:      false,
                info:           false,
                lengthChange:   false,
                paging:         false,
                ordering:       false,
                dom:            'lrtip',
                fixedHeader:
                {
                    header: true,
                    footer: true
                }
            }
        );
    }

    setTimeout
    (
        function ()
        {
            configurarDataTable();
        },
        1000
    );
</script>

<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->
<style type="text/css">
.modal
{
 padding: 0 !important;
}
.modal-dialog {
  max-width: 95% !important;
  height: 90%;
/*  padding: 0;
  margin: 0;*/
}

.modal-content {
  /*border-radius: 0 !important;*/
  height: 90%;
}
</style>
<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->

<!-- Modal - NUEVO CLIENTE -->
<div class="modal hide fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle"></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <iframe id="iframe_id" src="" style="zoom:0.60;" width="99.6%" height="99.6%" frameborder="0"></iframe>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <!--<button type="button" class="btn btn-primary">Save changes</button>-->
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
abrirPopupComprobante = function( Tipo, Compania, NumeroDocumento )
{
    var s_param_ajax = "s_TipoProc/shw/i_Id/" + Tipo + "_" + Compania + "_" + NumeroDocumento;
    var frameSrc = "<?=buildUrlComplet( 'vta.php/pro/detailVta' )?>" + s_param_ajax;
    $( '#iframe_id' ).attr( "src", frameSrc );
    $( "#exampleModalLongTitle" ).html( "Resumen Cotizaci&oacute;n" );
    $( '#exampleModalCenter' ).modal( { show:true } );
}
abrirPopupCotizacion = function( Id )
{
	var s_param_ajax = "readonly/1/i_Id/" + Id;
    var frameSrc = "<?=buildUrlComplet( 'vta.php/cot/detailVta' )?>" + s_param_ajax;
    $( '#iframe_id' ).attr( "src", frameSrc );
    $( "#exampleModalLongTitle" ).html( "Resumen Cotizaci&oacute;n" );
    $( '#exampleModalCenter' ).modal( { show:true } );
}
asignarValores = function( idpersona )
{
    $( "#ClienteNumero" ).val( idpersona );
    buscarInfoCliente();
    ocultarModal();
}
ocultarModal = function()
{
    $( '#exampleModalCenter' ).modal( 'hide' );
}
</script>
<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->

<style>
    #example tbody tr.even:hover, #example tbody tr.even td.highlighted
    {
        background-color: #becedf;
    }

    #example tbody tr.odd:hover, #example tbody tr.odd td.highlighted
    {
        background-color: #becedf;
    }

    #example td.highlight
    {
        background-color: #b8daff !important;
    }
</style>

<script>
    /*
    $('#example tbody')
        .on
        (
            'mouseenter', 'td', function ()
            {
                var colIdx = table.cell(this).index().column;

                $( table.cells().nodes() ).removeClass( 'highlight' );
                $( table.column( colIdx ).nodes() ).addClass( 'highlight' );
            }
        );
    */
</script>