<?php
$sDirBase = dirname(__FILE__).'/../../../../../';
require $sDirBase.'plugins/dompdf-master/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

class CobranzaPDFAction extends wtActions
{
    public function execute()
    {
        $s_IdDocRecibo = $this->getRequestParameter( 'IdDocRecibo' );
        
        $o_FCO_DocReciboFN = new FCO_DocReciboFN();
        $o_FCO_DocReciboBN = $o_FCO_DocReciboFN->selectByPK( $s_IdDocRecibo );
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $o_FCO_DocReciboBN->getIdCompania() );
        
        $s_Class   = ParameterWR::getInstance()->getModule();
        $s_Module  = strtolower( $s_Class );
        $s_Action  = ParameterWR::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );
        
        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";
        
        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();
        
        //echo $html;         exit;
        
        $options = new Options();
        //$options->set( 'isRemoteEnabled', TRUE );
        $options->setIsPhpEnabled( true );
        
        //$dompdf = new Dompdf();
        $dompdf = new Dompdf( $options );
        $dompdf->loadHtml( $html );
        $dompdf->setPaper( 'A4', 'portrait' );
        $dompdf->render();
        
        //For Footer
        $canvas = $dompdf->get_canvas();
        $footer = $canvas->open_object();
        $font = "";
        $font_metrics = $dompdf->getFontMetrics();
        $font = $font_metrics->getFont( "helvetica", "bold" );
        //$canvas->page_text(35, 823, "HiveDesk Screenshot Report", $font, 8, array( 0, 0, 0 ) );
        $canvas->page_text( 250, 823, "Pagina:  {PAGE_NUM} de {PAGE_COUNT}", $font, 8, array( 0, 0, 0 ) );
        $canvas->page_text( 500, 823, date( "Y-m-d H:i:s" ), $font, 8, array( 0, 0, 0 ) );
        $canvas->close_object();
        $canvas->add_object( $footer, "all" );
        
        $dompdf->stream( 'Documento_', array( "Attachment" => 0 ) );
        
        exit;
        
    }
}