<?php
$sDirBase = dirname(__FILE__).'/../../../../../';
require $sDirBase.'plugins/dompdf-master/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

class servicioActions extends wtActions
{
    public function executePrintPDF()
    {
        ////////////////////////////////////////////////////////////////////////////////////////////
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( myUser::getUser()->getIdBusiness() );
        
        $Id = $this->getRequestParameter( 'Id' );
        $Ste_SertTecFN =  new STE_ServicioTecnicoFN();
        $Data = $Ste_SertTecFN->selectByPK($Id);
        $SerTecId = "STE-" . str_pad($Data->getIdServicio(),8,0,STR_PAD_LEFT);

        ////////////////////////////////////////////////////////////////////////////////////////////
        
        $s_Class   = ParameterWR::getInstance()->getModule();
        $s_Module  = strtolower( $s_Class );
        $s_Action  = ParameterWR::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );
        
        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";
        
        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();
        
        //pr($Data); pr($DetallesSerie); echo $html;         exit;
        
        $options = new Options();
        //$options->set( 'isRemoteEnabled', TRUE );
        $options->setIsPhpEnabled( true );
        
        //$dompdf = new Dompdf();
        $dompdf = new Dompdf( $options );
        $dompdf->loadHtml( $html );
        $dompdf->setPaper( 'A4', 'portrait' );
        $dompdf->render();
        
        //For Footer
        $canvas = $dompdf->get_canvas();
        $footer = $canvas->open_object();
        $font = "";
        $font_metrics = $dompdf->getFontMetrics();
        $font = $font_metrics->getFont( "helvetica", "bold" );
        //$canvas->page_text(35, 823, "HiveDesk Screenshot Report", $font, 8, array( 0, 0, 0 ) );
        $canvas->page_text( 250, 823, "Pagina:  {PAGE_NUM} de {PAGE_COUNT}", $font, 8, array( 0, 0, 0 ) );
        $canvas->page_text( 500, 823, date( "Y-m-d H:i:s" ), $font, 8, array( 0, 0, 0 ) );
        $canvas->close_object();
        $canvas->add_object( $footer, "all" );
        
        $dompdf->stream( 'Documento_', array( "Attachment" => 0 ) );
        
        exit;
    }
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->Titulo = "Servicio Tecnico";
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
    	$o_GSS_CompaniaFN->addOrderBy( GSS_CompaniaFN::DescripcionCorta );
    	$this->a_GSS_Compania = $o_GSS_CompaniaFN->select();
    }

    public function executeGrid()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );
        
        //*set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new STE_ServicioTecnicoFN() );

        $o_GridAction->addAssignFilter( "SerieItem" );
        // $o_GridAction->addAssignFilter( "IdUsuario" );
        //$o_GridAction->addAssignFilter( "IdServicio" );
        $o_GridAction->addConditionFilter( "IdServicio", STE_ServicioTecnicoFN::IdServicio, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "NombreAtendido", STE_ServicioTecnicoFN::ClienteNombre, "LIKE", "%%s%" );
        $o_GridAction->addAssignFilter( "Estado" );
        // $o_GridAction->addAssignFilter( "OrdenId" );
        //$o_GridAction->addConditionFilter( "OrdenId", STE_ServicioTecnicoFN::OrdenId, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "FechaDocumento1", "LEFT(".STE_ServicioTecnicoFN::FechaCreacion.",10)", ">=" );
        $o_GridAction->addConditionFilter( "FechaDocumento2", "LEFT(".STE_ServicioTecnicoFN::FechaCreacion.",10)", "<=" );

        if( !$this->getRequestParameter( 'Estado' ) )
        {
            //$o_GridAction->addMethodDefault( "Estado", array( 'Condition'=>'IN', 'Value' => "('1','2','3','4','5','6')" ) );
        }
        
        $o_GridAction->addOrderDefault( 1 , false );

        $o_GridAction->addRowsToShow( "IdServicio", "SerieItem", "DiagnosticoUsuario", "ClienteNombre", "Estado", "OrdenId", "OrdenNum", 'RecepcionFecha', "EstadoDesc", "TipoServicioDesc" );
              
        $o_GridAction->setNumberRecordsShow( 15 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;  
        
    }
    
    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_TipoProc = $this->getRequestParameter( 'tipo_proc' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
       
        $Default = new STE_ServicioTecnicoFN();
        $this->o_Default = $Default->selectByPK( $this->i_Id );
    }
    
    public function executeSaveServicio()
    {
        $s_TipoProc = $this->getRequestParameter( 'tipo_proc' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        
        $DiagnosticoRevision      = $this->getRequestParameter( 'DiagnosticoRevision' ) ;
        $DiagnosticoComentario    = $this->getRequestParameter( 'DiagnosticoComentario' ) ;
        $CubreGarantiaFlag        = $this->getRequestParameter( 'CubreGarantiaFlag' );
        $ReparacionPrecioTotalIGV = floatval( $this->getRequestParameter( 'ReparacionPrecioTotalIGV' ) );

        $ReperacionAccionTomada   = $this->getRequestParameter( 'ReperacionAccionTomada' ) ;
        $ReparacionComentario     = $this->getRequestParameter( 'ReparacionComentario' ) ;

        try
        {
            $o_STE_ServicioTecnicoFN = new STE_ServicioTecnicoFN();
            $o_STE_ServicioTecnicoBN = $o_STE_ServicioTecnicoFN->selectByPK($i_Id);
            $s_EstadoServicio = $o_STE_ServicioTecnicoBN->getEstado();

            $o_STE_ServicioTecnicoDP = new STE_ServicioTecnicoDP();
            $o_STE_ServicioTecnicoDP->setIdServicio( ( int ) $i_Id );

            if( $s_EstadoServicio == STE_ServicioTecnicoBN::ESTADO_DIAGNOSTICO )
            {
                $o_STE_ServicioTecnicoDP->setDiagnosticoRevision( $DiagnosticoRevision );
                $o_STE_ServicioTecnicoDP->setDiagnosticoComentario( $DiagnosticoComentario );
                $o_STE_ServicioTecnicoDP->setDiagnosticoFechaFin( date( "Y-m-d H:i:s" ) );
                $o_STE_ServicioTecnicoDP->setReparacionPrecioTotalIGV( $ReparacionPrecioTotalIGV );
                $o_STE_ServicioTecnicoDP->setCubreGarantiaFlag( intval( $CubreGarantiaFlag ) );
                $o_STE_ServicioTecnicoDP->setEstado( STE_ServicioTecnicoBN::ESTADO_DIAGNOSTICO_C );
            }

            if( $s_EstadoServicio == STE_ServicioTecnicoBN::ESTADO_REPARACION )
            {
                $o_STE_ServicioTecnicoDP->setReperacionAccionTomada( $ReperacionAccionTomada );
                $o_STE_ServicioTecnicoDP->setReparacionComentario( $ReparacionComentario );
                $o_STE_ServicioTecnicoDP->setReparacionFechaFin( date( "Y-m-d H:i:s" ) );
                $o_STE_ServicioTecnicoDP->setEstado( STE_ServicioTecnicoBN::ESTADO_LISTO_ENTREGA );
            }

            $o_STE_ServicioTecnicoDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
            $o_STE_ServicioTecnicoDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
            //pr( $o_STE_ServicioTecnicoDP );
            $o_STE_ServicioTecnicoDP->update();
            
            $i_IdServicio = $i_Id;
            
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_IdServicio;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }

    public function executeRequestServicioTecnico()
    {
        $s_IdServicico = $this->getRequestParameter( 'IdServicico' );
        $s_TipoProc    = $this->getRequestParameter( 'TipoProc' );

        $a_lst       = array( "Result" => false, "error" => false );

        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            $o_STE_ServicioTecnicoFN = new STE_ServicioTecnicoFN();
            $o_STE_ServicioTecnicoBN = $o_STE_ServicioTecnicoFN->selectByPK( $s_IdServicico );
            if( !$o_STE_ServicioTecnicoBN )
            {
                throw new Exception( "No se encontro el registro $s_IdServicico" );
            }

            switch ( $s_TipoProc )
            {
                case "EditarReparacion":

                    $o_STE_ServicioTecnicoDP = new STE_ServicioTecnicoDP();
                    $o_STE_ServicioTecnicoDP->setIdServicio( intval( $s_IdServicico ) );
                    $o_STE_ServicioTecnicoDP->setEstado( STE_ServicioTecnicoBN::ESTADO_REPARACION );
                    $o_STE_ServicioTecnicoDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                    $o_STE_ServicioTecnicoDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                    $o_STE_ServicioTecnicoDP->update();

                break;
                case "IniciarReparacion":

                    $o_STE_ServicioTecnicoDP = new STE_ServicioTecnicoDP();
                    $o_STE_ServicioTecnicoDP->setIdServicio( intval( $s_IdServicico ) );
                    $o_STE_ServicioTecnicoDP->setEstado( STE_ServicioTecnicoBN::ESTADO_REPARACION );
                    $o_STE_ServicioTecnicoDP->setReparacionFechaIni( date( "Y-m-d H:i:s" ) );
                    $o_STE_ServicioTecnicoDP->setReparacionUsuario( myUser::getUser()->getUserId() );
                    $o_STE_ServicioTecnicoDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                    $o_STE_ServicioTecnicoDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                    $o_STE_ServicioTecnicoDP->update();

                break;
                case "IniciarDiagnostico":

                    $o_STE_ServicioTecnicoDP = new STE_ServicioTecnicoDP();
                    $o_STE_ServicioTecnicoDP->setIdServicio( intval( $s_IdServicico ) );
                    $o_STE_ServicioTecnicoDP->setEstado( STE_ServicioTecnicoBN::ESTADO_DIAGNOSTICO );
                    $o_STE_ServicioTecnicoDP->setDiagnosticoFechaIni( date( "Y-m-d H:i:s" ) );
                    $o_STE_ServicioTecnicoDP->setDiagnosticoUsuario( myUser::getUser()->getUserId() );
                    $o_STE_ServicioTecnicoDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                    $o_STE_ServicioTecnicoDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                    $o_STE_ServicioTecnicoDP->update();

                break;
                case "EditarDiagnostico":

                    $o_STE_ServicioTecnicoDP = new STE_ServicioTecnicoDP();
                    $o_STE_ServicioTecnicoDP->setIdServicio( intval( $s_IdServicico ) );
                    $o_STE_ServicioTecnicoDP->setEstado( STE_ServicioTecnicoBN::ESTADO_DIAGNOSTICO );
                    $o_STE_ServicioTecnicoDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                    $o_STE_ServicioTecnicoDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                    $o_STE_ServicioTecnicoDP->update();

                break;
            }

            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_lst['error']         = true;
            $a_lst['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_lst );
        return ViewResponse::NONE;
    }
}