<?php
class asistenciaActions extends wtActions
{
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->i_IdCompania = myUser::getUser()->getIdBusiness();
    }

    public function executeGrid()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );
        
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new PLA_AsistenciaFN() );

        $o_GridAction->addAssignFilter( "TipoDocumento" );
        $o_GridAction->addAssignFilter( "NumeroDocumento" );
        $o_GridAction->addAssignFilter( "IdRegistro" );
        $o_GridAction->addAssignFilter( "IdTipo" );

        $o_GridAction->addConditionFilter( "NumeroDocumento", PLA_AsistenciaFN::NumeroDocumento, "LIKE", "%%s%" );

        $o_GridAction->addConditionFilter( "FechaDocumento1", PLA_AsistenciaFN::Fecha,  ">=", '00:00:00' );
        $o_GridAction->addConditionFilter( "FechaDocumento2", PLA_AsistenciaFN::Fecha,  "<=", '23:59:59' );
        
        //$o_GridAction->addConditionFilter( "Descripcion", MST_CategoriaHabitacionMastFN::Descripcion, "LIKE", "%%s%" );
        
        //$o_GridAction->addOrder( "Estado", MST_CategoriaHabitacionMastFN::Estado );
        
        $o_GridAction->addOrderDefault( PLA_AsistenciaFN::IdAsistencia, true );
        
        $o_GridAction->addRowsToShow
        (
            "IdAsistencia", "IdRegistro", "IdTipo", "IdPersona", "Fecha", "TipoDocumento", "NumeroDocumento", "HoraMinuto", "HoraMinutoPactado", "MontoDescuento",
            "NombreEmpleadoCompleto", "MarcacionRegistroDesc", "MarcacionTipoDesc"
        );
              
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        
        if( $this->getRequestParameter( 'excel' ) )
        {
            $this->executeExportarExcel( $a_ResultJson );
        }

        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;   
    }

    private function executeExportarExcel( $a_ResultJson )
    {
        set_header_toexcel( "asistencia_".date( "Ymd" ) );

        $table = new HTML_Table(); 
        $table->headings( array( "Empleado", "Tipo Doc", "Documento", "Registro", "Tipo", "Hora", "Hora Pactada", "Descuento" ) );

        foreach ( $a_ResultJson['rows'] as $a_Values ) 
        {
            $table->addRow
            (
                array
                (
                    $a_Values['NombreEmpleadoCompleto'], 
                    $a_Values['TipoDocumento'], 
                    $a_Values['NumeroDocumento'], 
                    $a_Values['MarcacionRegistroDesc'], 
                    $a_Values['MarcacionTipoDesc'], 
                    $a_Values['HoraMinuto'], 
                    $a_Values['HoraMinutoPactado'], 
                    $a_Values['MontoDescuento'], 
                )
            );
        }
        
        echo $table->render();

        exit;
    }
}