<?php
class RepMovCtasxPagarAction extends wtActions
{
    public function execute()
    {
        $s_TipoSalida       = trim( $this->getRequestParameter( 'TipoSalida' ) );
        $this->s_FechaDesde = trim( $this->getRequestParameter( 'FechaDocumento1' ) );
        $this->s_FechaHasta = trim( $this->getRequestParameter( 'FechaDocumento2' ) );

        if( $s_TipoSalida == "EXCEL" )
        {
            header( 'Content-Type: application/vnd.ms-excel' );
            header( 'Content-Disposition: attachment;filename="Movimiento_Ctas_x_Pagar_Clientes_'.date( "Ymd" ).'.xls"' );
            header( 'Cache-Control: max-age=0' );
        }

        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( myUser::getUser()->getIdCompania() );

        $o_CP_ObligacionesFN = new CP_ObligacionesFN();
        $o_CP_ObligacionesFN->setEstado( CP_ObligacionesBN::ESTADO_VALIDADO );
        if( $this->getRequestParameter( "s_FechaDocumento" ) )
        {
            $o_CP_ObligacionesFN->addCondition( CP_ObligacionesFN::FechaEmision, ">=", $this->getRequestParameter( "s_FechaDocumento" ) );
        }
        if( $this->getRequestParameter( "s_FechaDocumento2" ) )
        {
            $o_CP_ObligacionesFN->addCondition( CP_ObligacionesFN::FechaEmision, "<=", $this->getRequestParameter( "s_FechaDocumento" ) );
        }
        if( $this->getRequestParameter( "TipoDocCliente" ) )
        {
            $o_CP_ObligacionesFN->setProveedorDocTipo( $this->getRequestParameter( "TipoDocCliente" ) );
        }
        if( $this->getRequestParameter( "NumTipoDocCliente" ) )
        {
            $o_CP_ObligacionesFN->setProveedorDocNum( $this->getRequestParameter( "NumTipoDocCliente" ) );
        }
        if( $this->getRequestParameter( "ClienteNumero" ) )
        {
            $o_CP_ObligacionesFN->setProveedorId( $this->getRequestParameter( "ClienteNumero" ) );
        }
        if( $this->getRequestParameter( "NombreCliente" ) )
        {
            $o_CP_ObligacionesFN->addCondition( CP_ObligacionesFN::ProveedorNombre, "LIKE", "'%".$this->getRequestParameter( "NombreCliente" )."%'", false );
        }
        if( $this->getRequestParameter( "ReciboNumero" ) )
        {
            $o_CP_ObligacionesFN->addCondition( CP_ObligacionesFN::DocumentoNumero, "LIKE", "'%".$this->getRequestParameter( "ReciboNumero" )."%'", false );
        }
        if( $this->getRequestParameter( "IdMoneda" ) )
        {
            $o_CP_ObligacionesFN->setIdMoneda( $this->getRequestParameter( "IdMoneda" ) );
        }
        if( $this->getRequestParameter( "CobranzaEstado" ) )
        {
            $o_CP_ObligacionesFN->setEstadoPagado( $this->getRequestParameter( "CobranzaEstado" ) );
        }
        $o_CP_ObligacionesFN->addGroupBy( CP_ObligacionesFN::ProveedorId );
        $o_CP_ObligacionesFN->addOrderBy( CP_ObligacionesFN::ProveedorNombre );
        $a_CP_Obligaciones = $o_CP_ObligacionesFN->select();

        $a_Data = array();
        foreach( $a_CP_Obligaciones as $o_CP_ObligacionesBN )
        {
            $o_FCO_AplicacionBN;
            $o_VTA_DocumentoFN = new CP_ObligacionesFN();
            $o_VTA_DocumentoFN->setProveedorId( $o_CP_ObligacionesBN->getProveedorId() );
            if( $this->getRequestParameter( "s_FechaDocumento" ) )
            {
                $o_VTA_DocumentoFN->addCondition( CP_ObligacionesFN::FechaEmision, ">=", $this->getRequestParameter( "s_FechaDocumento" ) );
            }
            if( $this->getRequestParameter( "s_FechaDocumento2" ) )
            {
                $o_VTA_DocumentoFN->addCondition( CP_ObligacionesFN::FechaEmision, "<=", $this->getRequestParameter( "s_FechaDocumento" ) );
            }
            /*if( $this->getRequestParameter( "TipoDocCliente" ) )
            {
                $o_CP_ObligacionesFN->setProveedorDocTipo( $this->getRequestParameter( "TipoDocCliente" ) );
            }
            if( $this->getRequestParameter( "NumTipoDocCliente" ) )
            {
                $o_CP_ObligacionesFN->setProveedorDocNum( $this->getRequestParameter( "NumTipoDocCliente" ) );
            }
            if( $this->getRequestParameter( "ClienteNumero" ) )
            {
                $o_CP_ObligacionesFN->setProveedorId( $this->getRequestParameter( "ClienteNumero" ) );
            }
            if( $this->getRequestParameter( "NombreCliente" ) )
            {
                $o_CP_ObligacionesFN->addCondition( CP_ObligacionesFN::ProveedorNombre, "LIKE", "'%".$this->getRequestParameter( "NombreCliente" )."%'", false );
            }*/
            if( $this->getRequestParameter( "ReciboNumero" ) )
            {
                $o_VTA_DocumentoFN->addCondition( CP_ObligacionesFN::DocumentoNumero, "LIKE", "'%".$this->getRequestParameter( "ReciboNumero" )."%'", false );
            }
            if( $this->getRequestParameter( "IdMoneda" ) )
            {
                $o_VTA_DocumentoFN->setIdMoneda( $this->getRequestParameter( "IdMoneda" ) );
            }
            if( $this->getRequestParameter( "CobranzaEstado" ) )
            {
                $o_VTA_DocumentoFN->setEstadoPagado( $this->getRequestParameter( "CobranzaEstado" ) );
            }
            $a_VTA_Documento = $o_VTA_DocumentoFN->select();

            $a_DataDoc = array();
            foreach( $a_VTA_Documento as $o_VTA_DocumentoBN )
            {
                $o_FCO_AplicacionFN = new CP_AplicacionFN();
                $o_FCO_AplicacionFN->setIdDocNumRef( $o_VTA_DocumentoBN->getObligacionesId() );
                $o_FCO_AplicacionFN->addOrderBy( CP_AplicacionFN::IdAplicacion );
                $a_FCO_Aplicacion2 = $o_FCO_AplicacionFN->select();

                $o_CP_ObligacionesFN = new CP_ObligacionesFN();
                $o_CP_ObligacionesFN->setComprobanteRefId( $o_VTA_DocumentoBN->getObligacionesId() );
                $o_CP_ObligacionesFN->addOrderBy( CP_ObligacionesFN::FechaCreacion );
                $a_CP_Obligaciones = $o_CP_ObligacionesFN->select();

                $a_DataDoc[$o_VTA_DocumentoBN->getDocumentoSerieNumero()] = array( "DOCUMENTO" => $o_VTA_DocumentoBN, "APLICACIONES" => $a_FCO_Aplicacion2, "DOCUMENTOS_ADICIONALES" => $a_CP_Obligaciones );
            }

            $a_Data[$o_CP_ObligacionesBN->getProveedorId()] = array( "TIPO" => $o_CP_ObligacionesBN->getProveedorDocTipo(), "NUMERO" => $o_CP_ObligacionesBN->getProveedorDocNum(), "NOMBRE" => $o_CP_ObligacionesBN->getProveedorNombre(), "COMPROBANTES" => $a_DataDoc );
        }

        $this->a_Data = $a_Data;

        if( $this->s_FechaDesde == "" )
        {
            $this->s_FechaDesde = "- - - - ";
        }
        if( $this->s_FechaHasta == "" )
        {
            $this->s_FechaHasta = date( "Y-m-d" );
        }

        ViewResponse::getInstance()->setMethodAjax();
    }
}