<?php
/**
 * @var array $a_DataRsFinal
 * @var int $export_excel
 * @var string $a_ItemDesc
 */
?>
<?php if( !$export_excel ){ ?>
    <link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/responsive/2.2.5/css/responsive.bootstrap4.min.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/fixedheader/3.1.7/css/fixedHeader.dataTables.min.css" />

    <!--<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" />-->

    <script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/dataTables.responsive.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/responsive.bootstrap4.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/fixedheader/3.1.7/js/dataTables.fixedHeader.min.js"></script>
<?php } ?>

<?php if( !$export_excel ){ ?>
    <div class="table-responsive">
<?php } ?>

<?php
$i_TotalUnidadesFinal = 0;
$f_TotalVentaFinal = 0;
?>
<table id="example" class="table table-striped table-bordered" border="1" style="width:100%">
    <?php foreach ( $a_DataRsFinal as $s_LineaDesc => $a_Data1 ){ ?>
    <tr class="table-dark">
        <td><?=$s_LineaDesc?></td>
    </tr>
        <?php foreach ( $a_Data1 as $s_FamiliaDesc => $a_Data2 ){ ?>
            <tr class="table-success">
                <td><?=$s_FamiliaDesc?></td>
            </tr>
            <?php foreach ( $a_Data2 as $s_ItemCod => $a_Data3 ){ ?>
                <tr class="table-warning">
                    <td><?=$s_ItemCod?> - <?=$a_ItemDesc[$s_ItemCod]?></td>
                </tr>

                <tr>
                    <td>
                        <table id="example" class="table table-striped table-bordered" border="1" style="width:100%">
                            <tr class="table-primary">
                                <th scope="col" class="text-center">Nro pedido</th>
                                <th scope="col" class="text-center">Fecha</th>
                                <th scope="col" class="text-left">Cliente</th>
                                <th scope="col" class="text-center">Vendedor</th>
                                <th scope="col" class="text-left">Cantidad</th>
                                <th scope="col" class="text-left">Pr. Unidad</th>
                                <th scope="col" class="text-left">Dsc. Unidad</th>
                                <th scope="col" class="text-left">Pre-Venta</th>
                                <th scope="col" class="text-left">Dscto</th>
                                <th scope="col" class="text-left">Sub-Total</th>
                            </tr>
                            <?php
                            $i_TotalUnidades = 0;
                            $f_TotalVenta = 0;
                            ?>
                            <?php foreach ( $a_Data3 as $i_Key => $a_Data4 ){ ?>
                                <?php
                                $i_TotalUnidades = intval( $a_Data4['CantidadPedida'] ) + $i_TotalUnidades;
                                $f_TotalVenta = floatval( $a_Data4['TotalFinalMN'] ) + $f_TotalVenta;
                                $i_TotalUnidadesFinal = $i_TotalUnidadesFinal + $i_TotalUnidades;
                                $f_TotalVentaFinal = $f_TotalVentaFinal + $f_TotalVenta;
                                ?>
                            <tr>
                                <td class="text-center"><?=$a_Data4['DocumentoParentCod']?></td>
                                <td class="text-center"><?=$a_Data4['FechaDocumento']?></td>
                                <td class=""><?=$a_Data4['ClienteNombre']?></td>
                                <td class="text-center"><?=$a_Data4['Vendedor']?></td>
                                <td class="text-center"><?=$a_Data4['CantidadPedida']?></td>
                                <td class="text-center"><?=number_format( $a_Data4['PrecioUnidadIncImpuesto'], 2 )?></td>
                                <td class="text-center"><?=number_format( ( $a_Data4['OrdenDetalleDsctoUnidadMN'] / intval( $a_Data4['CantidadPedida'] ) ), 2 )?></td>
                                <td class="text-center"><?=number_format( $a_Data4['OrdenDetalleSubTotalNetoMN'], 2 )?></td>
                                <td class="text-center"><?=number_format( $a_Data4['OrdenDetalleDsctoUnidadMN'], 2 )?></td>
                                <td class="text-center"><?=number_format( $a_Data4['TotalFinalMN'], 2 )?></td>
                            </tr>
                            <?php } ?>
                            <tr>
                                <td colspan="3">&nbsp;</td>
                                <th scope="col" class="text-center">Total Unidades</th>
                                <td class="text-center"><?=$i_TotalUnidades?></td>
                                <th colspan="4" scope="col" class="text-center">Total Venta</th>
                                <td class="text-center"><?=number_format( $f_TotalVenta, 2 )?></td>
                            </tr>
                        </table>
                    </td>
                </tr>
            <?php } ?>
        <?php } ?>
    <?php } ?>
</table>
<br>
<table id="example" class="table table-striped table-bordered" border="1" style="width:100%">
    <tr>
        <th scope="col" class="text-center">Total Unidades</th>
        <td class="text-center"><?=number_format( $i_TotalUnidadesFinal, 2 )?></td>
        <th colspan="2" scope="col" class="text-center">Total Venta</th>
        <td class="text-center"><?=number_format( $f_TotalVentaFinal, 2 )?></td>
    </tr>
</table>