<?php if( !$export_excel ){ ?>
    <link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/responsive/2.2.5/css/responsive.bootstrap4.min.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/fixedheader/3.1.7/css/fixedHeader.dataTables.min.css" />

    <!--<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" />-->

    <script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/dataTables.responsive.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/responsive.bootstrap4.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/fixedheader/3.1.7/js/dataTables.fixedHeader.min.js"></script>
<?php } ?>

<?php if( !$export_excel ){ ?>
<div class="table-responsive">
<?php } ?>
    <!--<table class="table table-bordered table-hover" id="example">-->
    <table id="example" class="table table-striped table-bordered" border="1" style="width:100%">
        <thead class="">
        <tr class="table-primary">
            <th scope="col" class="text-center">Nro</th>
            <?php if( arrayClass::existeValorEnArray( "CLIENTE", $a_Params['MostrarColumnas'] ) ){ ?>
            <th scope="col" class="text-left">Cliente</th>
            <?php } ?>
            <?php if( $a_Params['Vendedor'] ){ ?>
                <th scope="col" class="text-left">Vendedor</th>
            <?php } ?>
            <th scope="col" class="text-center">Codigo</th>
            <!--<th scope="col" class="text-center">Marca</th>
            <th scope="col" class="text-center">Linea</th>
            <th scope="col" class="text-center">Familia</th>-->
            <th scope="col" class="text-left">Descripcion</th>

            <?php if( arrayClass::existeValorEnArray( "UNIDADES", $a_Params['MostrarColumnas'] ) ){ ?>
            <th scope="col" class="text-center">Cantidad</th>
            <?php } ?>
            <?php if( arrayClass::existeValorEnArray( "MONTOS", $a_Params['MostrarColumnas'] ) ){ ?>
            <th scope="col" class="text-center">SubTotal</th>
            <?php } ?>

            <?php if( arrayClass::existeValorEnArray( "MARGEN", $a_Params['MostrarColumnas'] ) ){ ?>
            <th scope="col" class="text-center">Margen</th>
            <?php } ?>
            <?php if( arrayClass::existeValorEnArray( "MARGENPOR", $a_Params['MostrarColumnas'] ) ){ ?>
            <th scope="col" class="text-center" nowrap="">Margen %</th>
            <?php } ?>
        </tr>
        </thead>
        <tbody>
            <?php
            //pr( $a_Params );
            $f_SumaPorCantidades = 0;
            $f_SumaPorSubTotales = 0;

            $f_SumaMargenVenta  = 0;
            $f_SumaCostoAlmacen = 0;
            ?>
            <?php foreach ( $a_DataRs as $i_Key => $o_Row ){ ?>
                <?php
                //CALCULAR LA UTILIDAD
                $f_CostoAlmacen  = 0;
                $f_UtilidadResta = 0;
                $f_Utilidad      = 0;

                $f_Cantidad     = floatval( $o_Row['SumCantidad'] );
                $f_CostoAlmacen = round( floatval( $o_Row['CostoUnirarioPromedio'] ), 2 );

                if( $f_CostoAlmacen <= 0 )
                {
                    $o_MST_ListaPrecioDetalleBN = MST_ListaPrecioDetalleFN::buscarPrecioGeneral( $o_Row['IdItem'] );
                    if( $o_MST_ListaPrecioDetalleBN )
                    {
                        $f_CostoAlmacen = $o_MST_ListaPrecioDetalleBN->getPrecioCosto();
                    }
                }

                $f_SumaCostoAlmacen   = $f_SumaCostoAlmacen + ( $f_CostoAlmacen * $f_Cantidad );
                $f_OrdenSubTotalFinal = floatval( $o_Row['SumMontoFinal'] );

                if( $f_SumaCostoAlmacen && $f_OrdenSubTotalFinal )
                {
                    $f_UtilidadResta   = utilMath::fnround( $f_OrdenSubTotalFinal - ( $f_CostoAlmacen * $f_Cantidad ), 2 );
                    //pr( "$f_UtilidadResta   = utilMath::fnround( $f_OrdenSubTotalFinal - ( $f_CostoAlmacen * $f_Cantidad ), 2 );" );
                    $f_SumaMargenVenta = $f_SumaMargenVenta + $f_UtilidadResta;
                    $f_Utilidad        = utilMath::fnround( ( ( $f_OrdenSubTotalFinal - ( $f_CostoAlmacen * $f_Cantidad ) ) / $f_OrdenSubTotalFinal ) * 100, 2 );
                }

                ?>
            <tr>
                <td class="text-center"><?=$i_Key+1?></td>

                <?php if( arrayClass::existeValorEnArray( "CLIENTE", $a_Params['MostrarColumnas'] ) ){ ?>
                <td class="text-left"><?=$o_Row['ClienteNombre']?></td>
                <?php } ?>
                <?php if( $a_Params['Vendedor'] ){ ?>
                    <td class="text-left"><?=$o_Row['Vendedor']?></td>
                <?php } ?>
                <td class="text-center"><?=$o_Row['IdItem']?></td>
                <!--<td class="text-center"><?=$o_Row['DescripcionMarca']?></td>
                <td class="text-center"><?=$o_Row['DescripcionLinea']?></td>
                <td class="text-center"><?=$o_Row['DescripcionFamilia']?></td>-->
                <td class=""><?=$o_Row['DescripcionCompleta']?></td>

                <?php if( arrayClass::existeValorEnArray( "UNIDADES", $a_Params['MostrarColumnas'] ) ){ ?>
                <td class="text-center"><?=number_format( $o_Row['SumCantidad'], 0 )?></td>
                <?php } ?>
                <?php if( arrayClass::existeValorEnArray( "MONTOS", $a_Params['MostrarColumnas'] ) ){ ?>
                <td class="text-right"><?= number_format( $o_Row['SumMontoFinal'], 2 )?></td>
                <?php } ?>

                <?php if( arrayClass::existeValorEnArray( "MARGEN", $a_Params['MostrarColumnas'] ) ){ ?>
                <td class="text-right"><?=number_format( $f_UtilidadResta, 2 )?></td>
                <?php } ?>
                <?php if( arrayClass::existeValorEnArray( "MARGENPOR", $a_Params['MostrarColumnas'] ) ){ ?>
                <td class="text-center"><?=number_format( $f_Utilidad, 2 )?></td>
                <?php } ?>

            </tr>
                <?php
                $f_SumaPorCantidades = $f_SumaPorCantidades + floatval( $o_Row['SumCantidad'] );
                $f_SumaPorSubTotales = $f_SumaPorSubTotales + floatval( $o_Row['SumMontoFinal'] );
                ?>
            <?php } ?>
        </tbody>

        <tbody>
        <tr class="table-primary">
            <td > &nbsp; </td>

            <?php if( arrayClass::existeValorEnArray( "CLIENTE", $a_Params['MostrarColumnas'] ) ){ ?>
            <td > &nbsp; </td>
            <?php } ?>
            <?php if( $a_Params['Vendedor'] ){ ?>
                <td > &nbsp; </td>
            <?php } ?>
            <!--<td > &nbsp; </td>
            <td > &nbsp; </td>
            <td > &nbsp; </td>-->
            <td > &nbsp; </td>
            <td class="text-right"> <b>TOTALES</b> </td>
            <?php if( arrayClass::existeValorEnArray( "UNIDADES", $a_Params['MostrarColumnas'] ) ){ ?>
            <td class="text-center"><?=number_format( $f_SumaPorCantidades, 2 )?></td>
            <?php } ?>
            <?php if( arrayClass::existeValorEnArray( "MONTOS", $a_Params['MostrarColumnas'] ) ){ ?>
            <td class="text-right"><?=number_format( $f_SumaPorSubTotales, 2 )?></td>
            <?php } ?>

            <?php if( arrayClass::existeValorEnArray( "MARGEN", $a_Params['MostrarColumnas'] ) ){ ?>
            <td class="text-right"><?=number_format( $f_SumaMargenVenta, 2 )?></td>
            <?php } ?>
            <?php if( arrayClass::existeValorEnArray( "MARGENPOR", $a_Params['MostrarColumnas'] ) ){ ?>
            <td > &nbsp; </td>
            <?php } ?>
        </tr>
        </tbody>
    </table>
<?php if( !$export_excel ){ ?>
</div>
<?php } ?>

<?php if( !$export_excel ){ ?>
    <script type="text/javascript">
        var table = null;
        configurarDataTable = function()
        {
            table = $( '#example' ).DataTable
                                   (
                                       {
                                           language:       { "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json" },
                                           responsive:     false,
                                           searching:      false,
                                           info:           false,
                                           lengthChange:   false,
                                           paging:         false,
                                           ordering:       true,
                                           dom:            'lrtip',
                                           fixedHeader:
                                               {
                                                   header: true,
                                                   footer: true
                                               }
                                       }
                                   );
        }

        setTimeout
        (
            function ()
            {
                configurarDataTable();

                $('#example tbody').on
                                   (
                                       'mouseenter', 'td', function ()
                                       {
                                           var colIdx = table.cell(this).index().column;

                                           $( table.cells().nodes() ).removeClass( 'highlight' );
                                           $( table.column( colIdx ).nodes() ).addClass( 'highlight' );
                                       }
                                   );
            },
            1000
        );
    </script>

    <style>
        #example tbody tr.even:hover, #example tbody tr.even td.highlighted
        {
            background-color: #becedf;
        }

        #example tbody tr.odd:hover, #example tbody tr.odd td.highlighted
        {
            background-color: #becedf;
        }

        #example td.highlight
        {
            background-color: #b8daff !important;
        }
    </style>

    <script>

    </script>
<?php } ?>


