<?php
class cierreActions extends wtActions
{
    public function executeIndex()
    {
    }
    
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->Ejercicio = $this->getRequestParameter( 'Ejercicio' );
        $s_Control       = $this->getRequestParameter( 'Control' );
        $s_TipoProc      = $this->getRequestParameter( 'TipoProc' );

        $s_IdCompania = myUser::getUser()->getIdCompania();

        $a_Meses = Constantes::$a_meses;

        $a_DataPeriodo = array();

        if( $this->getRequestParameter( 'Control' ) )
        {
            if( $s_TipoProc == "CAMBIAR_ESTADO" )
            {
                $s_Param1 = $this->getRequestParameter( 'Parametro1' );
                $s_Param2 = $this->getRequestParameter( 'Parametro2' );

                //ESTADOS DEL PERIODO:
                // 1 -> ABIERTO
                // 0 -> CERRADO

                $o_PRO_CierreMensualFN = new PRO_CierreMensualFN();
                $o_PRO_CierreMensualFN->setIdCompania( $s_IdCompania );
                $o_PRO_CierreMensualFN->setAnio( $this->Ejercicio );
                $o_PRO_CierreMensualFN->setMes( $s_Param1 );
                $a_PRO_CierreMensual = $o_PRO_CierreMensualFN->select();

                if( $a_PRO_CierreMensual )
                {
                    $o_PRO_CierreMensualDP = new PRO_CierreMensualDP();
                    $o_PRO_CierreMensualDP->setIdCompania( $s_IdCompania );
                    $o_PRO_CierreMensualDP->setIdPeriodo( $this->Ejercicio.$s_Param1 );
                    $o_PRO_CierreMensualDP->setAnio( $this->Ejercicio );
                    $o_PRO_CierreMensualDP->setMes( $s_Param1 );
                    $o_PRO_CierreMensualDP->setEstado( $s_Param2 );
                    //$o_PRO_CierreMensualDP->setComentario(  );
                    $o_PRO_CierreMensualDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_PRO_CierreMensualDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_PRO_CierreMensualDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_PRO_CierreMensualDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_PRO_CierreMensualDP->update();
                }
                else
                {
                    $o_PRO_CierreMensualDP = new PRO_CierreMensualDP();
                    $o_PRO_CierreMensualDP->setIdCompania( $s_IdCompania );
                    $o_PRO_CierreMensualDP->setIdPeriodo( $this->Ejercicio.$s_Param1 );
                    $o_PRO_CierreMensualDP->setAnio( $this->Ejercicio );
                    $o_PRO_CierreMensualDP->setMes( $s_Param1 );
                    $o_PRO_CierreMensualDP->setEstado( $s_Param2 );
                    //$o_PRO_CierreMensualDP->setComentario(  );
                    $o_PRO_CierreMensualDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_PRO_CierreMensualDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_PRO_CierreMensualDP->save();
                }
            }

            foreach ( $a_Meses as $Cod => $MesDesc )
            {
                $o_PRO_CierreMensualFN = new PRO_CierreMensualFN();
                $o_PRO_CierreMensualFN->setIdCompania( $s_IdCompania );
                $o_PRO_CierreMensualFN->setAnio( $this->Ejercicio );
                $o_PRO_CierreMensualFN->setMes( $Cod );
                $a_PRO_CierreMensual = $o_PRO_CierreMensualFN->select();

                $s_Estado = "No Abierto";
                if( $a_PRO_CierreMensual )
                {
                    $o_PRO_CierreMensualBN = $a_PRO_CierreMensual[0];

                    if( $o_PRO_CierreMensualBN->getEstado() )
                    {
                        $s_Estado = "Abierto";
                    }
                    else
                    {
                        $s_Estado = "Cerrado";
                    }
                }

                $s_Dia = date( "d",( mktime( 0, 0, 0, intval( $Cod ) + 1, 1, $this->Ejercicio ) -1 ) );
                $s_FechaFin = $this->Ejercicio."-".$Cod."-".$s_Dia;

                $a_DataPeriodo[$Cod] = array
                (
                    "Periodo"  => $this->Ejercicio."-".$Cod,
                    "Estado"   => $s_Estado,
                    "Nombre"   => $this->Ejercicio."-".$MesDesc,
                    "FechaIni" => $this->Ejercicio."-".$Cod."-01",
                    "FechaFin" => $s_FechaFin,
                );
            }
        }

        $this->a_DataPeriodo = $a_DataPeriodo;
    }
    
    public function executeGrid()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );
        
        //*set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new PRO_CierreMensualFN() );
        
        //$o_GridAction->addConditionFilter( "Descripcion", GSS_ImpuestoFN::Descripcion, "LIKE", "%%s%" );
        $o_GridAction->addAssignFilter( "Estado" );
        
        //$o_GridAction->addOrder( "Descripcion", GSS_ImpuestoFN::Descripcion );
        //$o_GridAction->addOrder( "Codigo",      GSS_ImpuestoFN::Codigo );
        
        $o_GridAction->addOrderDefault( PRO_CierreMensualFN::IdPeriodo, false );
        
        $o_GridAction->addRowsToShow( "IdCierre", "PeriodoDesc", "EstadoDesc", "Comentario", "Estado", "UsuarioCreacion", "AbrirPeriodoFlag" );
              
        $o_GridAction->setNumberRecordsShow( 15 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;   
    }
    
    public function executeCierrePeriodo()
    {
        set_memory_max_time();
        
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        
        $Estado     = $this->getRequestParameter( 'Estado' );
        try 
        {
            list( $i_IdCompania, $s_IdPeriodo ) = explode( "_", $i_Id );
            
            $o_PRO_CierreMensualFN = new PRO_CierreMensualFN();
            $o_PRO_CierreMensualBN = $o_PRO_CierreMensualFN->selectByPK( $i_IdCompania, $s_IdPeriodo );
            /*$o_PRO_CierreMensualBN = new PRO_CierreMensualBN();
            $o_PRO_CierreMensualBN->setIdCompania( ( int ) $i_IdCompania );
            $o_PRO_CierreMensualBN->setIdPeriodo( $s_IdPeriodo );*/
            if( $o_PRO_CierreMensualBN )
            {
                $o_ProcesoCierreBL = new ProcesoCierreBL();
                $o_ProcesoCierreBL->realizarCierreMensual( $o_PRO_CierreMensualBN );
            }
            else 
            {
                throw new Exception( "No Existe Periodo." );
            }
            
            $a_Rs['type_sub'] = 1;
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeAbrirPeriodo()
    {
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        
        $Estado     = $this->getRequestParameter( 'Estado' );
        try
        {
            list( $i_IdCompania, $s_IdPeriodo ) = explode( "_", $i_Id );
        
            $o_PRO_CierreMensualFN = new PRO_CierreMensualFN();
            $o_PRO_CierreMensualBN = $o_PRO_CierreMensualFN->selectByPK( $i_IdCompania, $s_IdPeriodo );
            /*$o_PRO_CierreMensualBN = new PRO_CierreMensualBN();
             $o_PRO_CierreMensualBN->setIdCompania( ( int ) $i_IdCompania );
             $o_PRO_CierreMensualBN->setIdPeriodo( $s_IdPeriodo );*/
            if( $o_PRO_CierreMensualBN )
            {
                $o_ProcesoCierreBL = new ProcesoCierreBL();
                $o_ProcesoCierreBL->realizarAbrirPeriodo( $o_PRO_CierreMensualBN );
            }
            else
            {
                throw new Exception( "No Existe Periodo." );
            }
        
            $a_Rs['type_sub'] = 1;
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeAudi()
    {
        $block          = $this->getRequestParameter( 'block' );
        $i_Id           = $this->getRequestParameter( 'i_Id' );
        $this->s_Topico = "Impuesto";
        $o_DefaultFN = new GSS_ImpuestoFN();
        $this->o_ObjectBN = $o_DefaultFN->selectByPK( $i_Id );
    }
    
    public function executeViewdel()
    {
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $o_DefaultFN = new GSS_ImpuestoFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
    }
    
    public function executeDeleteRow()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        try 
        {
            $o_DefaultDP = new GSS_ImpuestoDP();
            $o_DefaultDP->setIdImpuesto( ( int ) $i_Id );
            $o_DefaultDP->delete();

            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = "No se pudo eliminar el registro.";
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
}