<?php
$sDirBase = dirname(__FILE__).'/../../../../../';
require $sDirBase.'plugins/dompdf-master/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

class valalqActions extends wtActions
{
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        try
        {
            myUser::getUser()->validar_session();
        }
        catch ( Exception $o_Exception )
        {
            pr( $o_Exception->getMessage() );
        }
    }

    public function executeListRepo()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        try
        {
            myUser::getUser()->validar_session();
        }
        catch ( Exception $o_Exception )
        {
            pr( $o_Exception->getMessage() );
        }
    }

    public function executeListLimp()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        try
        {
            myUser::getUser()->validar_session();
        }
        catch ( Exception $o_Exception )
        {
            pr( $o_Exception->getMessage() );
        }
    }

    public function executeListRepa()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        try
        {
            myUser::getUser()->validar_session();
        }
        catch ( Exception $o_Exception )
        {
            pr( $o_Exception->getMessage() );
        }
    }

    public function executeGrid()
    {
        $this->s_Tipo     = $this->getRequestParameter( 'Tipo' );

        $this->s_IdProyecto     = $this->getRequestParameter( 'IdProyecto' );
        $this->s_NombreProyecto = $this->getRequestParameter( 'NombreProyecto' );
        $this->s_FechaCorte     = $this->getRequestParameter( 'FechaDocumento1' );

        $this->a_DataRs = array();
        if( $this->s_IdProyecto && trim( $this->s_FechaCorte ) != "" )
        {
            $b_ControlCorte = false;
            $s_Sql = "SELECT * FROM SR_CotizacionDevolucionCab WHERE IdProyecto={$this->s_IdProyecto} "; //AND EstadoCorte='P';
            $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
            if( $o_ResultSet->getRecordCount() > 0 )
            {
                while ( $o_ResultSet->next() )
                {
                    $a_SQLRow = $o_ResultSet->getRow();

                    $s_IdItem = $a_SQLRow['IdItem'];

                    $o_ALM_ItemMastBN = ALM_ItemMastFN::buscarItemxId( $s_IdItem );

                    //se recupera el precio por alquiler
                    $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
                    $o_MST_ListaPrecioDetalleFN->setIdTipoLista( 2 ); //ALQUILER
                    $o_MST_ListaPrecioDetalleFN->setIdRango( $o_ALM_ItemMastBN->getIdRangoAlquiler() ); //RANGO ALQUILER
                    $o_MST_ListaPrecioDetalleFN->setIdItem( $s_IdItem );
                    $a_MST_ListaPrecioDetalle = $o_MST_ListaPrecioDetalleFN->select();
                    foreach ( $a_MST_ListaPrecioDetalle as $o_TMP_MST_ListaPrecioDetalleBN )
                    {
                        $f_PrecioSinIGV = $o_TMP_MST_ListaPrecioDetalleBN->getPrecioVenta();
                        $f_PrecioSinIGV = round( $f_PrecioSinIGV / 30, 2 );
                    }

                    //INFORMACION PARA SALDO INICIAL
                    //f.PrecioUnitarioAlq
                    $o_SR_DevolucionDetCorteFN = new SR_DevolucionDetCorteFN();
                    $o_SR_DevolucionDetCorteFN->setIdProyecto( $this->s_IdProyecto );
                    $o_SR_DevolucionDetCorteFN->setEstado( "P" );
                    $i_Num = $o_SR_DevolucionDetCorteFN->selectNumRows();
                    if( $i_Num )
                    {
                        $o_SR_DevolucionDetCorteFN = new SR_DevolucionDetCorteFN();
                        $o_SR_DevolucionDetCorteFN->setIdProyecto( $this->s_IdProyecto );
                        $o_SR_DevolucionDetCorteFN->setIdItem( $s_IdItem );
                        $o_SR_DevolucionDetCorteFN->setEstado( "P" );
                        $a_SR_DevolucionDetCorte = $o_SR_DevolucionDetCorteFN->select();
                        
                        foreach ( $a_SR_DevolucionDetCorte as $i_Key => $o_SR_DevolucionDetCorteBN )
                        {
                            $s_IdItem = $o_SR_DevolucionDetCorteBN->getIdItem();
                            
                            $a_DataFinal['FechaInicioAlq'] = $o_SR_DevolucionDetCorteBN->getFechaIni();
                            $a_DataFinal['FechaFinAlq'] = $o_SR_DevolucionDetCorteBN->getFechaFin();
                            $a_DataFinal['Tipo'] = $o_SR_DevolucionDetCorteBN->getTipo();
                            $a_DataFinal['Documento'] = "";
                            $a_DataFinal['IdItem'] = $s_IdItem;
                            $a_DataFinal['Descripcion'] = $o_SR_DevolucionDetCorteBN->getDescripcionItem();
                            $a_DataFinal['PrecioUnitarioAlq'] = $o_SR_DevolucionDetCorteBN->getPrecioUnitario();
                            $a_DataFinal['Cantidad'] = $o_SR_DevolucionDetCorteBN->getCantidad();
                            $a_DataFinal['EstadoDevolucionId'] = "";
                            
                            $this->a_DataRs[$s_IdItem][] = $a_DataFinal;
                        }
                    }

                    //INFORMACION PARA DESPACHO
                    $s_Sql = "SELECT
                                  g.FechaInicioAlq, g.FechaFinAlq, 'DESPACHO' Tipo, CONCAT(g.GuiaSerie, '-', g.GuiaNumero) Documento, d.IdItem, d.Descripcion, 0 PrecioUnitarioAlq, d.Cantidad, '' EstadoDevolucionId 
                                FROM SR_GuiaRemisionH g
                                  LEFT JOIN SR_GuiaRemisionDet d ON g.GuiaRemisionId=d.GuiaRemisionId
                                    LEFT JOIN VTA_ProductoFinalDet f ON f.ProFinalDetId=d.ProFinalDetId
                                WHERE g.IdProyecto={$this->s_IdProyecto} AND d.IdItem='$s_IdItem'
                                    AND CONCAT(g.GuiaSerie, '-', g.GuiaNumero) NOT IN ( SELECT Documento FROM SR_DevolucionDetCorte WHERE 1=1 AND IdProyecto=7 AND Tipo='DESPACHO' AND IdItem=d.IdItem ) ";
                    $o_ResultSet2 = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
                    while ( $o_ResultSet2->next() )
                    {
                        $a_SQLRow2 = $o_ResultSet2->getRow();

                        $a_SQLRow2['PrecioUnitarioAlq'] = $f_PrecioSinIGV;

                        $this->a_DataRs[$s_IdItem][] = $a_SQLRow2;
                    }

                    //INFORMACION PARA DEVOLUCION
                    $a_RowTMP = array();
                    $s_Sql = "SELECT c.FechaDevolucion FechaInicioAlq, 'DEVOLUCION' Tipo, LPAD( c.DevolucionCabId, 10, '0' ) Documento, d.IdItem, d.ItemDescripcion Descripcion, ( d.CantidadDevolucion * -1 ) Cantidad, d.EstadoDevolucionId, d.ComentarioDevolucion
                                FROM SR_DevolucionCabecera c
                                  LEFT JOIN SR_DevolucionDetalle d ON d.DevolucionCabId=c.DevolucionCabId
                                WHERE 1=1
                                  AND c.IdProyecto={$this->s_IdProyecto} AND d.IdItem='$s_IdItem' AND c.EstadoCorte='P';";
                    //pr( $s_Sql );
                    $o_ResultSet2 = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
                    while ( $o_ResultSet2->next() )
                    {
                        $a_SQLRow2 = $o_ResultSet2->getRow();
                        $a_SQLRow2['FechaFinAlq'] = $a_SQLRow2['FechaInicioAlq'];
                        $a_SQLRow2['PrecioUnitarioAlq'] = $f_PrecioSinIGV;

                        if ( $a_SQLRow2['EstadoDevolucionId'] == "RE" )
                        {
                            $a_RowTMP[] = $a_SQLRow2;
                        }

                        $this->a_DataRs[$s_IdItem][] = $a_SQLRow2;
                    }

                    if ( $a_RowTMP )
                    {
                        /*
                        //se recupera el precio por venta
                        $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
                        $o_MST_ListaPrecioDetalleFN->setIdTipoLista( 1 ); //VENTA
                        $o_MST_ListaPrecioDetalleFN->setIdRango( $o_ALM_ItemMastBN->getIdRangoVenta() ); //RANGO ALQUILER
                        $o_MST_ListaPrecioDetalleFN->setIdItem( $s_IdItem );
                        $a_MST_ListaPrecioDetalle = $o_MST_ListaPrecioDetalleFN->select( 0, 1 );
                        foreach ( $a_MST_ListaPrecioDetalle as $o_TMP_MST_ListaPrecioDetalleBN )
                        {
                            $f_PrecioSinIGV = $o_TMP_MST_ListaPrecioDetalleBN->getPrecioVenta();
                        }

                        foreach ( $a_RowTMP as $a_Rw )
                        {

                            $a_Rw['Tipo'] = "POR FACTURAR";
                            $a_Rw['Cantidad'] = abs( $a_Rw['Cantidad'] );
                            $a_Rw['PrecioUnitarioAlq'] = $f_PrecioSinIGV;

                            $this->a_DataRs[$s_IdItem][] = $a_Rw;
                        }
                        */
                    }
                }
            }
            
            if( $b_ControlCorte )
            {
                
            }
            
            //pr( $this->a_DataRs ); exit;

            if( $this->s_Tipo == "EXCEL" )
            {
                header( 'Content-Type: application/vnd.ms-excel' );
                header( 'Content-Disposition: attachment;filename="Liquidacion_Alquiler.xls"' );
                header( 'Cache-Control: max-age=0' );
            }

            if( $this->s_Tipo == "PDF" )
            {
                $this->generarPDF();
            }

        }

        //pr( $this->a_DataRs );

        ViewResponse::getInstance()->setMethodAjax();
    }

    public function generarPDF()
    {
        $s_Tipo             = $this->s_Tipo;
        $a_DataRs           = $this->a_DataRs;
        $s_IdProyecto       = $this->s_IdProyecto;
        $s_NombreProyecto   = $this->s_NombreProyecto;
        $s_FechaCorte       = $this->s_FechaCorte;

        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( myUser::getUser()->getIdCompania() );

        $s_Class  = ParameterWR::getInstance()->getModule();
        $s_Module = strtolower( $s_Class );
        $s_Action = ParameterWR::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );

        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";

        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();

        //echo $html;         exit;

        $dompdf = new Dompdf();
        $dompdf->loadHtml( $html );
        $dompdf->setPaper( 'A4', 'landscape' );
        $dompdf->render();
        $dompdf->stream( 'Liquidacion_'.date( "Ymd" ), array( "Attachment" => 0 ) );

        exit;
    }
}