<?php
class ubicacionActions extends wtActions
{
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
    }

    public function executeGrid()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );
        
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new MST_UbicacionFN() );

        $o_GridAction->addAssignFilter( "IdPisos" );
        $o_GridAction->addAssignFilter( "IdTipoUbicacion" );
        $o_GridAction->addAssignFilter( "IdCategoria" );
        
        $o_GridAction->addConditionFilter( "Nombre", MST_UbicacionFN::Nombre, "LIKE", "%%s%" );

        $o_GridAction->addMethodDefault( MST_UbicacionFN::IdUbicacionPertenece, array( 'Condition'=>'<>', 'Value'=>"0" ) );
        
        $o_GridAction->addOrder( "Estado", MST_UbicacionFN::Estado );
        
        $o_GridAction->addOrderDefault( MST_UbicacionFN::Nombre, true );
        
        $o_GridAction->addRowsToShow( "IdUbicacion", "Nombre", "Estado", "ParentPiso", "TipoUbicacionNombre", "CategoriaUbicacionDescripcion", "TopePersonas", "Tolerancia" );
              
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;   
    }

    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $this->s_Titulo = "Nuevo Ubicaci&oacute;n";

        $this->o_ObjectBN = new MST_UbicacionBN();

        if( $this->s_TipoProc == "upd" )
        {
            $this->s_Titulo = "Editar Ubicaci&oacute;n";
            $o_MST_UbicacionFN = new MST_UbicacionFN();
            $this->o_ObjectBN = $o_MST_UbicacionFN->selectByPK( $this->i_Id );
        }
    }

    public function executeSaveAddEdit()
    {
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $TypeSub    = $this->getRequestParameter( 'TypeSub' );

        //$s_IdUbicacionPertenece = $this->getRequestParameter( 'IdUbicacionPertenece' );

        $s_IdTipoUbicacion = $this->getRequestParameter( 'IdTipoUbicacion' );
        $s_IdCategoria     = $this->getRequestParameter( 'IdCategoria' );
        $s_IdPisos         = $this->getRequestParameter( 'IdPisos' );
        $s_TopePersonas    = $this->getRequestParameter( 'TopePersonas' );
        $s_Tolerancia      = $this->getRequestParameter( 'Tolerancia' );
        $s_Nombre          = $this->getRequestParameter( 'Nombre' );
        $s_Descripcion     = $this->getRequestParameter( 'Descripcion' );
        $s_Estado          = $this->getRequestParameter( 'Estado' );

        $s_IdUbicacionPertenece = $s_IdPisos;

        try 
        {
            $o_ObjectBN = new MST_UbicacionDP();
            $o_ObjectBN->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_ObjectBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
            
            if( $s_IdUbicacionPertenece )
            {
                $o_ObjectBN->setIdUbicacionPertenece( ( int ) $s_IdUbicacionPertenece );
            }
            else
            {
                $o_ObjectBN->setIdUbicacionPertenece( 0 );
            }
            
            $o_ObjectBN->setIdTipoUbicacion( ( int ) $s_IdTipoUbicacion );
            $o_ObjectBN->setIdCategoria( ( int ) $s_IdCategoria );
            $o_ObjectBN->setIdPisos( ( int ) $s_IdPisos );
            $o_ObjectBN->setTopePersonas( ( int ) $s_TopePersonas );
            $o_ObjectBN->setTolerancia( ( int ) $s_Tolerancia );
            $o_ObjectBN->setNombre( $s_Nombre );
            $o_ObjectBN->setDescripcion( $s_Descripcion );
            $o_ObjectBN->setEstado( $s_Estado );

            if( $s_TipoProc == "nvo" )
            {
                //nuevo
                $i_IdTabla = MST_UbicacionDP::recuperarId();
                $o_ObjectBN->setIdUbicacion( $i_IdTabla );
                $o_ObjectBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_ObjectBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_ObjectBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_ObjectBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_ObjectBN->save();
                $i_Id = $i_IdTabla;
            }
            else
            {
                //actualizar
                $o_ObjectBN->setIdUbicacion( intval( $i_Id ) );
                $o_ObjectBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_ObjectBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_ObjectBN->update();
            }

            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }

    public function executeViewdel()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        
        $this->s_Titulo = "Ubicacion";

        $o_MST_UbicacionFN = new MST_UbicacionFN();
        $this->o_ObjectBN = $o_MST_UbicacionFN->selectByPK( $i_Id );
    }

    public function executeAudi()
    {
        $block          = $this->getRequestParameter( 'block' );
        $i_Id           = $this->getRequestParameter( 'i_Id' );

        $this->s_Topico = "Ubicacion";

        $o_MST_UbicacionFN = new MST_UbicacionFN();
        $this->o_ObjectBN = $o_MST_UbicacionFN->selectByPK( $i_Id );
    }
}