<?php
class stockrepActions extends wtActions
{
    public function executeIndex()
    {
    }
    
    public function executeRequest()
    {
        set_header_utf8();
        $block          = $this->getRequestParameter( 'block' );
        $TipoProc       = $this->getRequestParameter( 'TipoProc' );
        
        $IdCompania     = $this->getRequestParameter( 'IdCompania' );
        $IdSucursal     = $this->getRequestParameter( 'IdSucursal' );
        $IdLinea        = $this->getRequestParameter( 'IdLinea' );
        
        $a_lst = array();
        
        switch ( $TipoProc )
        {
            case "GetSucursal":
                $o_GSS_SucursalFN = new GSS_SucursalFN();
                $o_GSS_SucursalFN->setIdCompania( $IdCompania );
                $a_Result = $o_GSS_SucursalFN->select();
                
                $s_NameId  = "getIdSucursal";
                $s_NameDes = "getDescripcion";
            break;
            case "GetAlmacen":
                $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
                $o_ALM_AlmacenMastFN->setIdCompania( $IdCompania );
                $o_ALM_AlmacenMastFN->setIdSucursal( $IdSucursal );
                $a_Result = $o_ALM_AlmacenMastFN->select();
                $s_NameId  = "getIdAlmacen";
                $s_NameDes = "getDescripcionLocal";
            break;
            case "GetFamilia":
                $o_MST_ClaseFamiliaFN = new MST_ClaseFamiliaFN();
                $o_MST_ClaseFamiliaFN->setIdLinea( $IdLinea );
                $a_Result = $o_MST_ClaseFamiliaFN->select();
                
                $s_NameId  = "getIdFamilia";
                $s_NameDes = "getDescripcion";
            break;
        }
        foreach ( $a_Result as $i_Key => $o_ObjectBN )
        {
            $a_lst[$o_ObjectBN->$s_NameId()] = utf8_encode( $o_ObjectBN->$s_NameDes() );
        }
        echo json_encode( $a_lst );
        return ViewResponse::NONE;
    }    
    
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->block = $this->getRequestParameter( 'block' );
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaFN->addOrderBy( GSS_CompaniaFN::DescripcionCorta );
        $this->a_GSS_Compania = $o_GSS_CompaniaFN->select();
        
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( "SI" );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
    }
    
    public function executeGrid()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );
        
        //*set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new MST_StockReposicionCabeceraFN() );

        $o_GridAction->addAssignFilter( "IdCompania" );
        $o_GridAction->addAssignFilter( "IdPersona" );
        $o_GridAction->addAssignFilter( "IdSucursal" );
        $o_GridAction->addAssignFilter( "Estado" );
        //$o_GridAction->addConditionFilter( "Descripcion", GSS_ImpuestoFN::Descripcion, "LIKE", "%%s%" );
        
        //$o_GridAction->addOrder( "Descripcion", GSS_ImpuestoFN::Descripcion );
        //$o_GridAction->addOrder( "Codigo",      GSS_ImpuestoFN::Codigo );
        
        $o_GridAction->addOrderDefault( MST_StockReposicionCabeceraFN::FechaCreacion , true );
        
        $o_GridAction->addRowsToShow( "IdStockRepo", "AlmacenDesc", "Estado", "ProveedorDes", "FechaCreacion", 'UsuarioCreacion' );
              
        $o_GridAction->setNumberRecordsShow( 15 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;   
    }
    
    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $this->s_Titulo = "Nuevo Stock Reposici&oacute;n";
        
        $o_DefaultBN = new MST_StockReposicionCabeceraBN();
        $o_DefaultBN->setEstado( 'A' );
        $this->o_DefaultBN = $o_DefaultBN;
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaFN->addOrderBy( GSS_CompaniaFN::DescripcionCorta );
        $this->a_GSS_Compania = $o_GSS_CompaniaFN->select();
        
        //SE RECUPERA LOS PROVEEDORES
        /*$o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( 'SI' );
        $o_MST_PersonaMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_MST_PersonaMastFN->setEstado( 'A' );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();*/
        $this->a_MST_PersonaMast = array();

        $this->a_GSS_Sucursal = array();

        $this->a_ALM_AlmacenMast = array();
        
        if( $this->s_TipoProc == "upd" )
        {
            $this->s_Titulo = "Editar Stock Reposici&oacute;n";

            $this->a_GSS_Sucursal = array();
            
            $o_DefaultFN = new MST_StockReposicionCabeceraFN();
            $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
        }

        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_ALM_AlmacenMastFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
    }
    
    public function executeSaveAddEdit()
    {
        $this->block = $this->getRequestParameter( 'block' );
        $i_Id        = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc  = $this->getRequestParameter( 's_TipoProc' );
        $TypeSub     = $this->getRequestParameter( 'TypeSub' );
        
        $IdCompania = myUser::getUser()->getIdBusiness();
        $IdSucursal = myUser::getUser()->getIdSucursal();
        $IdAlmacen  = $this->getRequestParameter( 'IdAlmacen' );
        $IdPersona  = $this->getRequestParameter( 'IdPersona' );
        $Estado     = $this->getRequestParameter( 'Estado' );
        try 
        {
            $o_DefaultDP = new MST_StockReposicionCabeceraDP();
            
            $o_DefaultDP->setEstado( $Estado );
            if( $s_TipoProc == "nvo" )
            {
                //validacion por el mismo almacen
                $o_MST_StockReposicionCabeceraFN = new MST_StockReposicionCabeceraFN();
                $o_MST_StockReposicionCabeceraFN->setIdCompania( $IdCompania );
                $o_MST_StockReposicionCabeceraFN->setIdSucursal( $IdSucursal );
                $o_MST_StockReposicionCabeceraFN->setIdAlmacen( $IdAlmacen );
                $a_MST_StockReposicionCabecera = $o_MST_StockReposicionCabeceraFN->select();
                if( $a_MST_StockReposicionCabecera )
                {
                    throw new Exception( "Actualmente ya existe el almacen." );
                }

                //NUEVO
                $i_IdStockRepo = MST_StockReposicionCabeceraDP::recuperarId();
                $o_DefaultDP->setIdStockRepo( $i_IdStockRepo );
                $o_DefaultDP->setIdCompania( $IdCompania );
                $o_DefaultDP->setIdSucursal( $IdSucursal );
                $o_DefaultDP->setIdAlmacen( $IdAlmacen );
                if( $IdPersona )
                {
                    $o_DefaultDP->setIdPersona($IdPersona);
                }
                $o_DefaultDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_DefaultDP->save();
                $i_Id = $i_IdStockRepo;
            }
            else 
            {
                //UPDATE
                $i_Id = intval( $this->getRequestParameter( 'i_Id' ) );

                $o_DefaultDP->setIdStockRepo( $i_Id );
                $o_DefaultDP->setIdCompania( $IdCompania );
                $o_DefaultDP->setIdSucursal( $IdSucursal );
                //$o_DefaultDP->setIdAlmacen( $IdAlmacen );
                //$o_DefaultDP->setIdPersona( $IdPersona );
                $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_DefaultDP->update();
            }
            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeDetail()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $this->s_Titulo = "Editar Stock Reposici&oacute;n";

        $this->IdLinea             = $this->getRequestParameter( 'IdLinea' );
        $this->IdFamilia           = $this->getRequestParameter( 'IdFamilia' );
        $this->IdItem              = $this->getRequestParameter( 'IdItem' );
        $this->DescripcionCompleta = $this->getRequestParameter( 'DescripcionCompleta' );
        $this->MayorCero           = $this->getRequestParameter( 'MayorCero' );
        
        $o_MST_ClaseLineaFN = new MST_ClaseLineaFN();
        $o_MST_ClaseLineaFN->addOrderBy( MST_ClaseLineaFN::Descripcion );
        $this->a_MST_ClaseLinea = $o_MST_ClaseLineaFN->select();
        
        $this->a_MST_ClaseFamilia = array();
        if( $this->IdLinea )
        {
            $o_MST_ClaseFamiliaFN = new MST_ClaseFamiliaFN();
            $o_MST_ClaseFamiliaFN->setIdLinea( $this->IdLinea );
            $this->a_MST_ClaseFamilia = $o_MST_ClaseFamiliaFN->select();
        }
        
        $o_DefaultFN = new MST_StockReposicionCabeceraFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
        
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        //$o_ALM_ItemMastFN->setIdPersona( $IdPersona );
        //$o_ALM_ItemMastFN->addCondition( "IdItem", "IN", "( SELECT IdItem FROM ALM_ItemAlmacenStock WHERE IdAlmacen='$IdAlmacen' )", false );
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //PARAMETROS
        if( $this->IdLinea )
        {
            $o_ALM_ItemMastFN->setIdLinea( $this->IdLinea );
        }
        if( $this->IdFamilia )
        {
            $o_ALM_ItemMastFN->setIdFamilia( $this->IdFamilia );
        }
        if( $this->IdItem )
        {
            $o_ALM_ItemMastFN->addCondition( "IdItem", "LIKE", "%".$this->IdItem."%" );
        }
        if( $this->DescripcionCompleta )
        {
            $o_ALM_ItemMastFN->addCondition( "DescripcionCompleta", "LIKE", "%".$this->DescripcionCompleta."%" );
        }
        if( $this->MayorCero )
        {
            $o_ALM_ItemMastFN->addCondition( "IdItem", "IN", "( SELECT IdItem FROM MST_StockReposicionDetalle WHERE 1=1 AND IdAlmacen='$IdAlmacen' AND IdPersona='$IdPersona' AND StockMinimo>0 )", false );
        }
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_ALM_ItemMastFN->addOrderBy( ALM_ItemMastFN::DescripcionCompleta );
        $this->a_ALM_ItemMast = $o_ALM_ItemMastFN->select();
    }
    
    public function executeSaveDetail()
    {
        $i_Id     = intval( $this->getRequestParameter( 'i_Id' ) );
        $TypeSub  = $this->getRequestParameter( 'TypeSub' );
        
        $a_IdItem = $this->getRequestParameter( 'IdItem' );
        $a_StockMin = $this->getRequestParameter( 'StockMin' );
        $a_StockMax = $this->getRequestParameter( 'StockMax' );
            
        //$a_Ids = explode( "_", $i_Id );
        $IdCompania = myUser::getUser()->getIdBusiness();
        $IdSucursal = myUser::getUser()->getIdSucursal();

        try 
        {
            $o_MST_StockReposicionCabeceraFN = new MST_StockReposicionCabeceraFN();
            $o_MST_StockReposicionCabeceraBN = $o_MST_StockReposicionCabeceraFN->selectByPK( $i_Id );

            $IdAlmacen  = $o_MST_StockReposicionCabeceraBN->getIdAlmacen();
            $IdPersona  = $o_MST_StockReposicionCabeceraBN->getIdPersona();

            foreach ( $a_StockMax as $i_Key => $s_Value )
            {
                $IdItem      = $a_IdItem[$i_Key];
                $i_StockMin  = $a_StockMin[$i_Key];
                $StockActual = ALM_ItemAlmacenStockFN::recuperarStockActual( $IdCompania, $IdItem, $IdAlmacen );
                
                $o_MST_StockReposicionDetalleFN = new MST_StockReposicionDetalleFN();
                $o_MST_StockReposicionDetalleFN->setIdStockRepo( $o_MST_StockReposicionCabeceraBN->getIdStockRepo() );
                $o_MST_StockReposicionDetalleFN->setIdItem( $IdItem );
                $a_MST_StockReposicionDetalle = $o_MST_StockReposicionDetalleFN->select();
                if( $a_MST_StockReposicionDetalle )
                {
                    //AHORA SE GUARDA EN EL LOG
                    /*$o_MST_StockReposicionDetalleLogDP =  new MST_StockReposicionDetalleLogDP();
                    $o_MST_StockReposicionDetalleLogDP->setIdCompania( $o_MST_StockReposicionDetalleBN->getIdCompania() );
                    $o_MST_StockReposicionDetalleLogDP->setIdSucursal( $o_MST_StockReposicionDetalleBN->getIdSucursal() );
                    $o_MST_StockReposicionDetalleLogDP->setIdAlmacen( $o_MST_StockReposicionDetalleBN->getIdAlmacen() );
                    $o_MST_StockReposicionDetalleLogDP->setIdPersona( $o_MST_StockReposicionDetalleBN->getIdPersona() );
                    $o_MST_StockReposicionDetalleLogDP->setIdItem( $o_MST_StockReposicionDetalleBN->getIdItem() );
                    $o_MST_StockReposicionDetalleLogDP->setEstado( $o_MST_StockReposicionDetalleBN->getEstado() );
                    $o_MST_StockReposicionDetalleLogDP->setStockMinimo( $o_MST_StockReposicionDetalleBN->getStockMinimo() );
                    $o_MST_StockReposicionDetalleLogDP->setStockMaximo( $o_MST_StockReposicionDetalleBN->getStockMaximo() );
                    $o_MST_StockReposicionDetalleLogDP->setStockActual( $o_MST_StockReposicionDetalleBN->getStockActual() );
                    $o_MST_StockReposicionDetalleLogDP->setUsuarioCreacion( $o_MST_StockReposicionDetalleBN->getUsuarioCreacion() );
                    $o_MST_StockReposicionDetalleLogDP->setFechaCreacion( $o_MST_StockReposicionDetalleBN->getFechaCreacion() );
                    $o_MST_StockReposicionDetalleLogDP->setUsuarioModificcion( $o_MST_StockReposicionDetalleBN->getUsuarioModificacion() );
                    $o_MST_StockReposicionDetalleLogDP->setUsuarioLog( myUser::getUser()->getUserId() );
                    $o_MST_StockReposicionDetalleLogDP->setFechaLog(date( "Y-m-d H:i:s" ) );
                    $o_MST_StockReposicionDetalleLogDP->save();*/

                    $o_MST_StockReposicionDetalleBN = $a_MST_StockReposicionDetalle[0];
                    
                    //UPDATE
                    $o_MST_StockReposicionDetalleDP = new MST_StockReposicionDetalleDP();
                    $o_MST_StockReposicionDetalleDP->setIdStockRepoDet( $o_MST_StockReposicionDetalleBN->getIdStockRepoDet() );
                    $o_MST_StockReposicionDetalleDP->setIdItem( $IdItem );
                    $o_MST_StockReposicionDetalleDP->setStockMaximo( floatval( $s_Value ) );
                    $o_MST_StockReposicionDetalleDP->setStockMinimo( floatval( $i_StockMin ) );
                    $o_MST_StockReposicionDetalleDP->setStockActual( floatval( $StockActual ) );
                    $o_MST_StockReposicionDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_MST_StockReposicionDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_MST_StockReposicionDetalleDP->update();
                    $i_IdDet  = $o_MST_StockReposicionDetalleBN->getIdStockRepoDet();
                }
                else 
                {
                    //INSERT
                    $i_IdStockRepoDet = MST_StockReposicionDetalleDP::recuperarId();
                    $o_MST_StockReposicionDetalleDP = new MST_StockReposicionDetalleDP();
                    $o_MST_StockReposicionDetalleDP->setIdStockRepoDet( $i_IdStockRepoDet );
                    $o_MST_StockReposicionDetalleDP->setIdStockRepo( $i_Id );
                    $o_MST_StockReposicionDetalleDP->setIdItem( $IdItem );
                    $o_MST_StockReposicionDetalleDP->setEstado( "A" );
                    $o_MST_StockReposicionDetalleDP->setStockMaximo( floatval( $s_Value ) );
                    $o_MST_StockReposicionDetalleDP->setStockMinimo( floatval( $i_StockMin ) );
                    $o_MST_StockReposicionDetalleDP->setStockActual( floatval( $StockActual ) );
                    $o_MST_StockReposicionDetalleDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_MST_StockReposicionDetalleDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_MST_StockReposicionDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_MST_StockReposicionDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_MST_StockReposicionDetalleDP->save();
                    $i_IdDet = $i_IdStockRepoDet;
                }
                
                $o_ALM_ItemMastDP = new ALM_ItemMastDP();
                $o_ALM_ItemMastDP->setIdItem( $IdItem );
                $o_ALM_ItemMastDP->setStockMinimo( floatval( $i_StockMin ) );
                $o_ALM_ItemMastDP->setStockMaximo( floatval( $s_Value ) );
                $o_ALM_ItemMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_ALM_ItemMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_ALM_ItemMastDP->update();
                
                $a_Rs['id']       = $i_IdDet;
            }
            
            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']    = false;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeAudi()
    {
        $this->block    = $this->getRequestParameter( 'block' );
        $i_Id           = $this->getRequestParameter( 'i_Id' );
        $this->s_Topico = "Impuesto";
        $o_DefaultFN = new GSS_ImpuestoFN();
        $this->o_ObjectBN = $o_DefaultFN->selectByPK( $i_Id );
    }
    
    public function executeViewdel()
    {
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $o_DefaultFN = new GSS_ImpuestoFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
    }
    
    public function executeDeleteRow()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        try 
        {
            $o_DefaultDP = new GSS_ImpuestoDP();
            $o_DefaultDP->setIdImpuesto( ( int ) $i_Id );
            $o_DefaultDP->delete();

            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = "No se pudo eliminar el registro.";
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
}