<?php
use PhpOffice\PhpSpreadsheet\Reader\Xlsx;
class ImportPrMasivoAction extends wtActions
{
    public function execute()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->b_Control      = $this->getRequestParameter( "Control" );
        $this->s_MensajeError = "";
        $this->s_Mensaje      = "";
        $this->a_DataError    = array();

        if( $this->b_Control )
        {
            $con = Conexion::getConexion();
            $con->begin();
            try
            {
                myUser::getUser()->validar_session();

                //pr( $_FILES );

                //$s_NombreCompleto = $_FILES['customFile']['name'];
                $s_TipoCompleto   = $_FILES['customFile']['type'];
                //$i_TamanioFile    = intval( $_FILES['customFile']['size'] );
                $fileTmpPath      = $_FILES['customFile']['tmp_name'];

                $phpFileUploadErrors = array
                (
                    0 => 'There is no error, the file uploaded with success',
                    1 => 'El fichero subido excede la directiva upload_max_filesize de php.ini.',
                    2 => 'El fichero subido excede la directiva MAX_FILE_SIZE especificada en el formulario HTML.',
                    3 => 'El fichero fue sólo parcialmente subido.',
                    4 => 'No se subió ningún fichero.',
                    6 => 'Falta la carpeta temporal.',
                    7 => 'No se pudo escribir el fichero en el disco.',
                    8 => 'Una extensión de PHP detuvo la subida de ficheros. PHP no proporciona una forma de determinar la extensión que causó la parada de la subida de ficheros; el examen de la lista de extensiones cargadas con phpinfo() puede ayudar.',
                    9 => 'Solo se permite archivos Excel.'
                );

                if( !$_FILES['customFile']['error'] )
                {
                    if( $s_TipoCompleto != "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" )
                    {
                        $_FILES['customFile']['error'] = 9;
                    }
                }

                if ( $_FILES['customFile']['error'] )
                {
                    throw new Exception( $phpFileUploadErrors[$_FILES['customFile']['error']] );
                }

                require_once( SF_ROOT_DIR.DIRECTORY_SEPARATOR.'plugins'.DIRECTORY_SEPARATOR.'vendor_excel'.DIRECTORY_SEPARATOR.'autoload.php' );

                # Create a new Xls Reader
                $reader = new Xlsx();

                // Tell the reader to only read the data. Ignore formatting etc.
                $reader->setReadDataOnly( true );

                // Read the spreadsheet file.
                $spreadsheet = $reader->load( $fileTmpPath );

                $sheet      = $spreadsheet->getSheet( $spreadsheet->getFirstSheetIndex() );
                $highestRow = $sheet->getHighestRow();

                $i     = 1;
                $i_Ini = 2;
                for( $row = $i_Ini; $row <= $highestRow; $row++ )
                {
                    //pr( $sheet->getCell( "A".$row ), false ); pr( get_class_methods( $sheet->getCell( "A".$row ) ), false ); /* getCalculatedValue()[recupera valor de una formula] */  exit;
                    $i_IdListaPreciDet      = intval( $sheet->getCell( "A".$row )->getValue() );
                    $s_IdListaPreciCab      = intval( $sheet->getCell( "B".$row )->getValue() );
                    $i_IdTipoLista          = intval( $sheet->getCell( "C".$row )->getValue() );
                    $i_IdRango              = intval( $sheet->getCell( "D".$row )->getValue() );
                    $i_IdRangoDetalle       = intval( $sheet->getCell( "E".$row )->getValue() );
                    $s_IdItem               = substr( $sheet->getCell( "F".$row )->getValue(), -5 );
                    $s_ProductoDescripcion  = trim( $sheet->getCell( "G".$row )->getValue() );
                    $s_LineaDescripcion     = trim( $sheet->getCell( "H".$row )->getValue() );
                    $s_FamiliaDescripcion   = trim( $sheet->getCell( "I".$row )->getValue() );
                    $s_MarcaDescripcion     = trim( $sheet->getCell( "J".$row )->getValue() );
                    $s_TipoListaDescripcion = trim( $sheet->getCell( "K".$row )->getValue() );
                    $s_RangoDescripcion     = trim( $sheet->getCell( "L".$row )->getValue() );
                    $s_RangoDetDescripcion  = trim( $sheet->getCell( "M".$row )->getValue() );
                    $f_ProductoCosto        = floatval( trim( $sheet->getCell( "N".$row )->getValue() ) );
                    $f_ProductoCostoIGV     = floatval( trim( $sheet->getCell( "O".$row )->getValue() ) );
                    $f_ProductoPrecio       = round( floatval( trim( $sheet->getCell( "P".$row )->getCalculatedValue() ) ), 2 );
                    //$f_ProductoIGV          = floatval( trim( $sheet->getCell( "Q".$row )->getCalculatedValue() ) );
                    $f_ProductoPrecioIGV    = round( floatval( trim( $sheet->getCell( "R".$row )->getCalculatedValue() ) ), 2 );
                    $f_ProductoIGV          = $f_ProductoPrecioIGV - $f_ProductoPrecio;
                    $s_IdTipoPrecio         = "1";

                    //pr( " $s_IdListaPreciDet - $s_IdListaPreciCab - $s_IdTipoLista - $s_IdRango - $s_IdRangoDetalle - $s_IdItem - $s_ProductoDescripcion - [$f_ProductoCosto] - [$f_ProductoCostoIGV] - [$f_ProductoPrecio] - [$f_ProductoIGV] - [$f_ProductoPrecioIGV] " );

                    $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                    $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $s_IdItem );
                    if( !$o_ALM_ItemMastBN )
                    {
                        throw new Exception( "El codigo de Producto [$s_IdItem] no se encuentra registrado." );
                    }

                    $i_AfectoIGV = 1;
                    if( !$o_ALM_ItemMastBN->EsAfectoaIGV() )
                    {
                        $i_AfectoIGV = 0;
                    }

                    if( $i_IdListaPreciDet )
                    {
                        $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
                        $o_MST_ListaPrecioDetalleBN = $o_MST_ListaPrecioDetalleFN->selectByPK( $i_IdListaPreciDet );
                        if( !$o_MST_ListaPrecioDetalleBN )
                        {
                            throw new Exception( "El Id no se encuentra registrado." );
                        }

                        $o_DefaultDP = new MST_ListaPrecioDetalleDP();
                        $o_DefaultDP->setIdListaPreciDet( $i_IdListaPreciDet );
                        $o_DefaultDP->setAfectoIGV( $i_AfectoIGV );
                        $o_DefaultDP->setPrecioVenta( $f_ProductoPrecio );
                        $o_DefaultDP->setMontoIGV( $f_ProductoIGV );
                        $o_DefaultDP->setPrecioVentaIGV( $f_ProductoPrecioIGV );
                        $o_DefaultDP->setMontoDescuento( 0 );
                        $o_DefaultDP->setPorcentajeDescuento( 0 );
                        $o_DefaultDP->setDescuentoFlag( "N" );
                        $o_DefaultDP->setEstado( "A" );
                        $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_DefaultDP->update();
                    }
                    else
                    {
                        $i_IdDet = MST_ListaPrecioDetalleDP::recuperarId();

                        $o_DefaultDP = new MST_ListaPrecioDetalleDP();
                        $o_DefaultDP->setIdListaPreciDet( $i_IdDet );
                        $o_DefaultDP->setIdCompania( myUser::getUser()->getIdCompania() );
                        $o_DefaultDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
                        $o_DefaultDP->setIdListaPreciCab( $s_IdListaPreciCab );
                        $o_DefaultDP->setIdItem( $s_IdItem );
                        $o_DefaultDP->setIdTipoLista( $i_IdTipoLista );
                        $o_DefaultDP->setIdRango( $i_IdRango );
                        $o_DefaultDP->setIdRangoDetalle( $i_IdRangoDetalle );
                        $o_DefaultDP->setIdTipoPrecio( $s_IdTipoPrecio );
                        $o_DefaultDP->setAfectoIGV( $i_AfectoIGV );
                        $o_DefaultDP->setPrecioVenta( $f_ProductoPrecio );
                        $o_DefaultDP->setMontoIGV( $f_ProductoIGV );
                        $o_DefaultDP->setPrecioVentaIGV( $f_ProductoPrecioIGV );
                        $o_DefaultDP->setMontoDescuento( 0 );
                        $o_DefaultDP->setPorcentajeDescuento( 0 );
                        $o_DefaultDP->setDescuentoFlag( "N" );
                        $o_DefaultDP->setEstado( "A" );
                        $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_DefaultDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                        $o_DefaultDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                        $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_DefaultDP->save();
                    }
                }

                if( !$this->a_DataError )
                {
                    $this->s_Mensaje = "Se registro el listado de Precios satisfactoriamente.";
                }

                $con->commit();
            }
            catch ( Exception $o_Exception )
            {
                pr( $o_Exception );
                $con->rollback();
                $this->a_DataError[] = $o_Exception->getMessage();
            }
        }
    }
}
