
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>http://stackoverflow.com/q/18885087/315935</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" >
    <link rel="stylesheet" type="text/css" href="http://ajax.googleapis.com/ajax/libs/jqueryui/1.10.3/themes/redmond/jquery-ui.css" />
    <link rel="stylesheet" type="text/css" href="http://www.ok-soft-gmbh.com/jqGrid/jquery.jqGrid-4.5.2/css/ui.jqgrid.css" />
    <style type="text/css">
        html, body { font-size: 75%; }
        .ui-menu { position: absolute; width: 100px; }
        .ui-jqgrid .ui-buttonset { margin-right: 0 }
        .myButtonSet { text-align: center; margin-left: -3px; }
    </style>
    <script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.3/jquery.min.js"></script>
    <script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.10.3/jquery-ui.min.js"></script>
    <script type="text/javascript" src="http://www.ok-soft-gmbh.com/jqGrid/jquery.jqGrid-4.5.2/js/i18n/grid.locale-en.js"></script>
    <script type="text/javascript">
        $.jgrid.no_legacy_api = true;
        $.jgrid.useJSON = true;
    </script>
    <script type="text/javascript" src="http://www.ok-soft-gmbh.com/jqGrid/jquery.jqGrid-4.5.2/js/jquery.jqGrid.src.js"></script>
    <script type="text/javascript">
    //<![CDATA[
        /*global $ */
        /*jslint browser: true */
        $(function () {
            "use strict";
            var mydata = [
                    {id: "1",  invdate: "2007-10-01", name: "test",   note: "note",   amount: "200.00", tax: "10.00", closed: true,  ship_via: "TN", total: "210.00"},
                    {id: "2",  invdate: "2007-10-02", name: "test2",  note: "note2",  amount: "300.00", tax: "20.00", closed: false, ship_via: "FE", total: "320.00"},
                    {id: "3",  invdate: "2007-09-01", name: "test3",  note: "note3",  amount: "400.00", tax: "30.00", closed: false, ship_via: "FE", total: "430.00"},
                    {id: "4",  invdate: "2007-10-04", name: "test4",  note: "note4",  amount: "200.00", tax: "10.00", closed: true,  ship_via: "TN", total: "210.00"},
                    {id: "5",  invdate: "2007-10-31", name: "test5",  note: "note5",  amount: "300.00", tax: "20.00", closed: false, ship_via: "FE", total: "320.00"},
                    {id: "6",  invdate: "2007-09-06", name: "test6",  note: "note6",  amount: "400.00", tax: "30.00", closed: false, ship_via: "FE", total: "430.00"},
                    {id: "7",  invdate: "2007-10-04", name: "test7",  note: "note7",  amount: "200.00", tax: "10.00", closed: true,  ship_via: "TN", total: "210.00"},
                    {id: "8",  invdate: "2007-10-03", name: "test8",  note: "note8",  amount: "300.00", tax: "20.00", closed: false, ship_via: "FE", total: "320.00"},
                    {id: "9",  invdate: "2007-09-01", name: "test9",  note: "note9",  amount: "400.00", tax: "30.00", closed: false, ship_via: "TN", total: "430.00"},
                    {id: "10", invdate: "2007-09-08", name: "test10", note: "note10", amount: "500.00", tax: "30.00", closed: true,  ship_via: "TN", total: "530.00"},
                    {id: "11", invdate: "2007-09-08", name: "test11", note: "note11", amount: "500.00", tax: "30.00", closed: false, ship_via: "FE", total: "530.00"},
                    {id: "12", invdate: "2007-09-10", name: "test12", note: "note12", amount: "500.00", tax: "30.00", closed: false, ship_via: "FE", total: "530.00"}
                ];

            $("#list").jqGrid({
                datatype: "local",
                data: mydata,
                colNames: ["Inv No", "Date", "Client", "Amount", "Tax", "Total", "Closed", "Shipped via", "Notes", ""],
                colModel: [
                    {name: "id", width: 65, align: "center", sorttype: "int", hidden: true},
                    {name: "invdate", width: 80, align: "center", sorttype: "date",
                        formatter: "date", formatoptions: {newformat: "d-M-Y"}, datefmt: "d-M-Y"},
                    {name: "name", width: 70},
                    {name: "amount", width: 75, formatter: "number", sorttype: "number", align: "right"},
                    {name: "tax", width: 55, formatter: "number", sorttype: "number", align: "right", hidden: true},
                    {name: "total", width: 65, formatter: "number", sorttype: "number", align: "right"},
                    {name: "closed", width: 75, align: "center", formatter: "checkbox",
                        edittype: "checkbox", editoptions: {value: "Yes:No", defaultValue: "Yes"}},
                    {name: "ship_via", width: 100, align: "center", formatter: "select",
                        edittype: "select", editoptions: {value: "FE:FedEx;TN:TNT;IN:Intim", defaultValue: "Intime"}},
                    {name: "note", width: 70, sortable: false},
                    {name: "confirm", width: 108,
                        formatter: function () {
                            return "<div class=\"myButtonSet\">" +
                                       "<button name=\"rerun\">My Action</button>" +
                                       "<button name=\"select\">Bla bla</button>" +
                                   "</div>";
                        }}
                ],
                rowNum: 10,
                rowList: [5, 10, 20],
                pager: "#pager",
                gridview: true,
                rownumbers: true,
                sortname: "invdate",
                viewrecords: true,
                sortorder: "desc",
                height: "auto",
                loadComplete: function() {
                    var $self = $(this);
                    $self.find("button[name=rerun]").each(function () {
                        $(this).button()
                            .click(function() {
                                alert( "Running the last action" );
                            })
                            .next()
                                .button({
                                    text: false,
                                    icons: {
                                        primary: "ui-icon-triangle-1-s"
                                    }
                                })
                                .click(function() {
                                    var rowid = $(this).closest("tr.jqgrow").attr("id");
                                    $("#splitButtonMenu").show()
                                        .position({
                                            my: "left top",
                                            at: "left bottom",
                                            of: this
                                        })
                                        .data("rowid", rowid);
                                    return false;
                                })
                                .parent().buttonset();
                    });
                }
            });
            $("#splitButtonMenu").menu().hide().mouseleave(function() {
                $(this).hide();
            }).find(">li>a").click(function() {
                var $menu = $(this).parent().parent(),
                    rowid = $menu.data("rowid");
                alert("\"" + $(this).text() + "\"" + " menu is clicked in the row with id=" + rowid);
                $menu.hide();
                return false;
            });
        });
    //]]>
    </script>
</head>
<body>
    <table id="list"><tr><td></td></tr></table>
    <div id="pager"></div>
    <ul id="splitButtonMenu">
        <li><a href=\"#\">Open...</a></li>
        <li><a href=\"#\">Save</a></li>
        <li><a href=\"#\">Delete</a></li>
    </ul>
</body>
</html>