<?php
class impuestoActions extends wtActions
{
    public function executeIndex()
    {
    }
    
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
    	$this->block = $this->getRequestParameter( 'block' );
    }
    
    public function executeGrid()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );
        
        //*set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new GSS_ImpuestoFN() );
        
        $o_GridAction->addConditionFilter( "Descripcion", GSS_ImpuestoFN::Descripcion, "LIKE", "%%s%" );
        
        $o_GridAction->addOrder( "Descripcion", GSS_ImpuestoFN::Descripcion );
        $o_GridAction->addOrder( "Codigo",      GSS_ImpuestoFN::Codigo );
        
        $o_GridAction->addOrderDefault( GSS_ImpuestoFN::IdImpuesto , true );
        
        $o_GridAction->addRowsToShow( "IdImpuesto", "Codigo", "CodigoSunat", "CuentaContable", "Descripcion", 'TipoRegistro' );
              
        $o_GridAction->setNumberRecordsShow( 15 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;   
    }
    
    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $this->s_Titulo = "Nuevo Impuesto";
        
        /************/
        
        $o_DefaultBN = new GSS_ImpuestoBN();
        $o_DefaultBN->setEstado( 'A' );
        $this->o_DefaultBN = $o_DefaultBN;
        
        /*************/
        //$this->o_MST_UnidadMastBN = new MST_UnidadMastBN();
        if( $this->s_TipoProc == "upd" )
        {
            $this->s_Titulo = "Editar Impuesto";
            $o_DefaultFN = new GSS_ImpuestoFN();
            $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
        }
    }
    
    public function executeSaveAddEdit()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $TypeSub    = $this->getRequestParameter( 'TypeSub' );
        
        $Codigo         = $this->getRequestParameter( 'Codigo' );
        $Descripcion    = $this->getRequestParameter( 'Descripcion' );
        $Valor          = $this->getRequestParameter( 'Valor' );
        $CodigoSunat    = $this->getRequestParameter( 'CodigoSunat' );
        $CuentaContable = $this->getRequestParameter( 'CuentaContable' );
        $TipoRegistro   = $this->getRequestParameter( 'TipoRegistro' );
        $Estado         = $this->getRequestParameter( 'Estado' );
        try 
        {
            $o_DefaultDP = new GSS_ImpuestoDP();
            $o_DefaultDP->setCodigo( $Codigo );
            $o_DefaultDP->setDescripcion( $Descripcion );
            $o_DefaultDP->setValor( floatval( $Valor ) );
            $o_DefaultDP->setCodigoSunat( $CodigoSunat );
            $o_DefaultDP->setCuentaContable( $CuentaContable );
            $o_DefaultDP->setTipoRegistro( $TipoRegistro );
            $o_DefaultDP->setEstado( $Estado );
            if( $s_TipoProc == "nvo" )
            {
                //NUEVO
                $IdImpuesto = GSS_ImpuestoFN::recuperarId();
                
                $o_DefaultDP->setIdImpuesto( $IdImpuesto );
                $o_DefaultDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_DefaultDP->save();
                $i_Id = $IdImpuesto;
            }
            else 
            {
                //UPDATE
                $o_DefaultDP->setIdImpuesto( ( int ) $i_Id );
                $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_DefaultDP->update();
            }
            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeAudi()
    {
        $block          = $this->getRequestParameter( 'block' );
        $i_Id           = $this->getRequestParameter( 'i_Id' );
        $this->s_Topico = "Impuesto";
        $o_DefaultFN = new GSS_ImpuestoFN();
        $this->o_ObjectBN = $o_DefaultFN->selectByPK( $i_Id );
    }
    
    public function executeViewdel()
    {
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $o_DefaultFN = new GSS_ImpuestoFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
    }
    
    public function executeDeleteRow()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        try 
        {
            $o_DefaultDP = new GSS_ImpuestoDP();
            $o_DefaultDP->setIdImpuesto( ( int ) $i_Id );
            $o_DefaultDP->setEstado( "I" );
            $o_DefaultDP->update();

            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = "No se pudo eliminar el registro.";
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
}