<?php
class estadoshabActions extends wtActions
{
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
    }

    public function executeGrid()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );
        
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new MST_EstadosHabitacionMastFN() );
        
        $o_GridAction->addConditionFilter( "Nombre", MST_EstadosHabitacionMastFN::Nombre, "LIKE", "%%s%" );
        
        $o_GridAction->addOrder( "Estado", MST_EstadosHabitacionMastFN::Estado );
        
        $o_GridAction->addOrderDefault( MST_EstadosHabitacionMastFN::IdEstados, true );
        
        $o_GridAction->addRowsToShow( "IdEstados", "Nombre", "Estado" );
              
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;   
    }

    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $this->s_Titulo = "Nuevo Estado";

        $this->o_ObjectBN = new MST_EstadosHabitacionMastBN();

        if( $this->s_TipoProc == "upd" )
        {
            $this->s_Titulo = "Editar Estados";
            $o_MST_EstadosHabitacionMastFN = new MST_EstadosHabitacionMastFN();
            $this->o_ObjectBN = $o_MST_EstadosHabitacionMastFN->selectByPK( $this->i_Id );
        }
    }

    public function executeSaveAddEdit()
    {
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $TypeSub    = $this->getRequestParameter( 'TypeSub' );

        $s_Nombre = $this->getRequestParameter( 'Nombre' );
        $s_Estado = $this->getRequestParameter( 'Estado' );

        $s_CodigoColorImg       = $this->getRequestParameter( 'CodigoColorImg' );
        $s_CodigoColorPrincipal = $this->getRequestParameter( 'CodigoColorPrincipal' );

        try 
        {
            $o_ObjectBN = new MST_EstadosHabitacionMastDP();
            $o_ObjectBN->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_ObjectBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
            $o_ObjectBN->setNombre( $s_Nombre );
            $o_ObjectBN->setCodigoColorImg( $s_CodigoColorImg );
            $o_ObjectBN->setCodigoColorPrincipal( $s_CodigoColorPrincipal );
            $o_ObjectBN->setEstado( $s_Estado );

            if( $s_TipoProc == "nvo" )
            {
                //nuevo
                $i_IdTabla = MST_EstadosHabitacionMastDP::recuperarId();
                $o_ObjectBN->setIdEstados( $i_IdTabla );
                $o_ObjectBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_ObjectBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_ObjectBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_ObjectBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_ObjectBN->save();
                $i_Id = $i_IdTabla;
            }
            else
            {
                //actualizar
                $o_ObjectBN->setIdEstados( intval( $i_Id ) );
                $o_ObjectBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_ObjectBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_ObjectBN->update();
            }

            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }

    public function executeViewdel()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        
        $this->s_Titulo = "Piso";

        $o_MST_EstadosHabitacionMastFN = new MST_EstadosHabitacionMastFN();
        $this->o_ObjectBN = $o_MST_EstadosHabitacionMastFN->selectByPK( $i_Id );
    }

    public function executeAudi()
    {
        $block          = $this->getRequestParameter( 'block' );
        $i_Id           = $this->getRequestParameter( 'i_Id' );

        $this->s_Topico = "Estados";

        $o_MST_EstadosHabitacionMastFN = new MST_EstadosHabitacionMastFN();
        $this->o_ObjectBN = $o_MST_EstadosHabitacionMastFN->selectByPK( $i_Id );
    }
}