<?php
class cuentabancariaActions extends wtActions
{
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
    }
    
    public function executeGrid()
    {
        $page  = $this->getRequestParameter( 'page' );
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new MST_CuentaBancariaFN() );
        
        $o_GridAction->addConditionFilter( "DescripcionCuenta", MST_CuentaBancariaFN::DescripcionCuenta, "LIKE", "%%s%" );
        
        $o_GridAction->addOrderDefault( MST_CuentaBancariaFN::IdCuenta , true );
        
        $o_GridAction->addRowsToShow( "IdCuenta", "DescripcionCuenta", "NumeroCuenta", "NumeroCuentaCCI", "Estado", "EsVisible", "EsDetraccion", "NombreMoneda" );
        
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );
        
        return ViewResponse::NONE;
    }
    
    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $this->s_Titulo = "Nuevo Cuenta Bancaria";
        
        $o_DefaultBN = new MST_CuentaBancariaFN();
        $o_DefaultBN->setEstado('A');
        $this->o_DefaultBN = $o_DefaultBN;
        if( $this->s_TipoProc == "upd" )
        {
            $this->s_Titulo = "Editar Cuenta Bancaria";
            $o_DefaultFN = new MST_CuentaBancariaFN();
            $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
        }
    }
    
    public function executeSaveAddEdit()
    {
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $TypeSub    = $this->getRequestParameter( 'TypeSub' );
        
        $s_IdBanco      = $this->getRequestParameter( 'IdBanco' );
        $s_NumeroCuenta = $this->getRequestParameter( 'NumeroCuenta' );
        $s_IdMoneda     = $this->getRequestParameter( 'IdMoneda' );
        $s_IdUbigeo     = $this->getRequestParameter( 'IdUbigeo' );
        $s_Estado       = $this->getRequestParameter( 'Estado' );
        
        $s_NumeroCuentaCCI = $this->getRequestParameter( 'NumeroCuentaCCI' );
        
        $i_FlagDetraccion    = is_null( $this->getRequestParameter( 'FlagDetraccion' ) ) ? 0 : 1;
        $i_FlagMostrarCuenta = is_null( $this->getRequestParameter( 'FlagMostrarCuenta' ) ) ? 0 : 1;
        
        try
        {
            $s_CodigoBanco       = GSS_BancoFN::getObjectById( $s_IdBanco )->getCodigo();
            $s_NombreMoneda      = GSS_MonedaMastFN::getDescripcionxId( $s_IdMoneda );
            $s_NombreSucursal    = MST_UbigeoFN::getDescripcionPorId( $s_IdUbigeo );
            $s_DescripcionCuenta = "$s_CodigoBanco $s_NombreMoneda $s_NombreSucursal";
            $s_NumeroCuentaCorto = str_pad( substr( $s_NumeroCuenta, -4 ), strlen( $s_NumeroCuenta ), "X", STR_PAD_LEFT );
            
            $o_DefaultDP = new MST_CuentaBancariaDP();
            $o_DefaultDP->setIdBanco( intval( $s_IdBanco ) );
            $o_DefaultDP->setNumeroCuenta( $s_NumeroCuenta );
            $o_DefaultDP->setNumeroCuentaCCI( $s_NumeroCuentaCCI );
            $o_DefaultDP->setIdMoneda( $s_IdMoneda );
            $o_DefaultDP->setIdUbigeo( $s_IdUbigeo );
            $o_DefaultDP->setNombreMoneda( $s_NombreMoneda );
            $o_DefaultDP->setNombreSucursal( $s_NombreSucursal );
            $o_DefaultDP->setDescripcionCuenta( $s_DescripcionCuenta );
            $o_DefaultDP->setNumeroCuentaCorto( $s_NumeroCuentaCorto );
            $o_DefaultDP->setEstado( $s_Estado );
            $o_DefaultDP->setFlagDetraccion( $i_FlagDetraccion );
            $o_DefaultDP->setFlagMostrarCuenta( $i_FlagMostrarCuenta );
            if( $s_TipoProc == "nvo" )
            {
                //NUEVO
                $i_Id = MST_CuentaBancariaDP::recuperarId();
                
                $o_DefaultDP->setIdCuenta( $i_Id );
                $o_DefaultDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_DefaultDP->save();
            }
            else
            {
                //UPDATE
                $i_Id = ( int ) $this->getRequestParameter( 'i_Id' );
                $o_DefaultDP->setIdCuenta( $i_Id );
                $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_DefaultDP->update();
            }
            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeViewdel()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $this->s_Titulo = "Cuenta Bancaria";
        
        $o_DefaultFN = new MST_CuentaBancariaFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
    }
}