<?php
class bancoActions extends wtActions
{
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
    }
    
    public function executeGrid()
    {
        $page  = $this->getRequestParameter( 'page' );
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new GSS_BancoFN() );
        
        $o_GridAction->addConditionFilter( "DescripcionLocal", GSS_BancoFN::DescripcionLocal, "LIKE", "%%s%" );
        
        $o_GridAction->addOrderDefault( GSS_BancoFN::IdBanco , true );
        
        $o_GridAction->addRowsToShow( "IdBanco", "Codigo", "DescripcionLocal", "Estado" );
        
        $o_GridAction->setNumberRecordsShow( 15 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );
        
        return ViewResponse::NONE;
    }
    
    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $this->s_Titulo = "Nuevo Banco";
        $o_DefaultBN = new GSS_BancoFN();
        $o_DefaultBN->setEstado('A');
        $this->o_DefaultBN = $o_DefaultBN;
        if( $this->s_TipoProc == "upd" )
        {
            $this->s_Titulo = "Editar Banco";
            $o_DefaultFN = new GSS_BancoFN();
            $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
        }
    }
    
    public function executeSaveAddEdit()
    {
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $TypeSub    = $this->getRequestParameter( 'TypeSub' );
        
        $s_Descripcion = $this->getRequestParameter( 'DescripcionLocal' );
        $s_Codigo      = $this->getRequestParameter( 'Codigo' );
        $s_CodigoSunat = $this->getRequestParameter( 'CodigoSunat' );
        $s_Estado      = $this->getRequestParameter( 'Estado' );
        try
        {
            $o_DefaultDP = new GSS_BancoDP();
            $o_DefaultDP->setDescripcionLocal( $s_Descripcion );
            $o_DefaultDP->setCodigo( $s_Codigo );
            $o_DefaultDP->setCodigoSunat( $s_CodigoSunat );
            $o_DefaultDP->setEstado( $s_Estado );
            if( $s_TipoProc == "nvo" )
            {
                //NUEVO
                $i_Id = GSS_BancoDP::recuperarId();
                
                $o_DefaultDP->setIdBanco( $i_Id );
                $o_DefaultDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_DefaultDP->save();
            }
            else
            {
                //UPDATE
                $i_Id = ( int ) $this->getRequestParameter( 'i_Id' );
                $o_DefaultDP->setIdBanco( $i_Id );
                $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_DefaultDP->update();
            }
            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeViewdel()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $this->s_Titulo = "Banco";
        
        $o_DefaultFN = new GSS_BancoFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
    }
}