<?php
class feriadosActions extends wtActions
{
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        LayoutTemplate::getInstance()->addLibTemplate( 'bootstrap'.DIRECTORY_SEPARATOR.'year-calendar', false );

        //ahora se busca registros para cargar los feriados
        $o_GSS_FeriadosMastFN = new GSS_FeriadosMastFN();
        $a_GSS_FeriadosMast = $o_GSS_FeriadosMastFN->select();

        $this->a_Data = array();
        foreach ( $a_GSS_FeriadosMast as $o_GSS_FeriadosMastBN ) 
        {
            $this->a_Data[] = array( "anio" => $o_GSS_FeriadosMastBN->getAnio(), "mes" => intval( $o_GSS_FeriadosMastBN->getMes() ), "dia" => intval( $o_GSS_FeriadosMastBN->getDia() ) );
        }

        $this->a_Data = json_encode( $this->a_Data );
    }

    public function executeRequest()
    {
        $s_TipoProc = $this->getRequestParameter( 'tipo_proc' );
        $a_Feriados = $this->getRequestParameter( 'feriados' );

        $a_Result = array( "Result" => false, "error" => false );

        try
        {
            switch ( $s_TipoProc )
            {
                case "guardar_feriados":
                    
                    $o_GSS_FeriadosMastDP = new GSS_FeriadosMastDP();
                    $o_GSS_FeriadosMastDP->limpiarMaestro();

                    //ahora se busca el DiaNumero de la Tabla DiaSemana para asociar
                    $o_MST_DiaSemanaFN = new MST_DiaSemanaFN();
                    $o_MST_DiaSemanaFN->setEsFeriadoFlag( "S" );
                    $a_MST_DiaSemana = $o_MST_DiaSemanaFN->select();
                    if( count( $a_MST_DiaSemana ) == 1 )
                    {
                        $o_MST_DiaSemanaBN = $a_MST_DiaSemana[0];
                        $i_DiaNumero = $o_MST_DiaSemanaBN->getDiaNumero();
                    }
                    else
                    {
                        throw new Exception( "No se encontro el codigo del Maestro de Dia de Semana para Feriado." );
                    }

                    foreach ( $a_Feriados as $Value ) 
                    {
                        $a_Values = explode( "-", $Value );

                        $s_Anio = $a_Values[0];
                        $s_Mes  = str_pad( $a_Values[1], 2, "0", STR_PAD_LEFT );
                        $s_Dia  = str_pad( $a_Values[2], 2, "0", STR_PAD_LEFT );

                        //insert
                        $i_IdFeriado = GSS_FeriadosMastDP::recuperarId();
                        $o_GSS_FeriadosMastDP->setIdFeriado( $i_IdFeriado );
                        $o_GSS_FeriadosMastDP->setIdCompania( myUser::getUser()->getIdBusiness() );
                        $o_GSS_FeriadosMastDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
                        $o_GSS_FeriadosMastDP->setAnio( $s_Anio );
                        $o_GSS_FeriadosMastDP->setMes( $s_Mes );
                        $o_GSS_FeriadosMastDP->setDia( $s_Dia );
                        $o_GSS_FeriadosMastDP->setDiaNumero( $i_DiaNumero );
                        $o_GSS_FeriadosMastDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                        $o_GSS_FeriadosMastDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                        $o_GSS_FeriadosMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_GSS_FeriadosMastDP->save();
                    }
                break;
            }
        }
        catch ( Exception $o_Exception )
        {
            $a_Result['error']         = true;
            $a_Result['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Result );
        return ViewResponse::NONE;
    }
}