<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>

<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/responsive/2.2.5/css/responsive.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/fixedheader/3.1.7/css/fixedHeader.dataTables.min.css" />

<!--<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" />-->

<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/responsive.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/fixedheader/3.1.7/js/dataTables.fixedHeader.min.js"></script>

<script type="text/javascript">
crearArchivoParaImprimirGuia = function()
{
    if ( !$( '#SerieDocumentoFiscal' ).val() ) 
    {
         alert( "Debe de ingresar la Serie." );
         return false;
    }
    if ( !$( '#NumeroDocumentoFiscal' ).val() ) 
    {
         alert( "Debe de ingresar el Numero de Guia." );
         return false;
    }
    x = confirm( "Esta seguro que desea imprimir la Guia?" );
    if( x )
    {
        blockContent( "form1" );
        
        var strFormSerialize = $( 'form' ).serialize();
        strFormSerialize += "&TipoProc=CrearArchivoPrintGuia";
        
        executeAjaxJson
        ( 
            "<?php echo buildUrl( 'transporte/request' ) ?>", 
            strFormSerialize,
            function( o_json )
            {
                console.log( o_json );
                unBlockContent( "form1" );
                if( o_json.error )
                {
                    mostrarMensajeError( o_json.mensaje_error );
                    return false;
                }
                actualizarDocumentoFiscalGuiaRem();
                imprimirEnLocalhost( o_json.nombre_archivo );

                parent.buscarRutaAsignada();
                parent.closeWindow();
            } 
        );
    }
}
imprimirEnLocalhost = function( nombre_archivo )
{
    blockContent( "form1" );
    
    var strFormSerialize = $( 'form' ).serialize();
    strFormSerialize += "&nombre_archivo=" + nombre_archivo;
    
    console.log( JSON.stringify( strFormSerialize ) );

    $.ajax
    (
        {
            url: "http://localhost/print_doc/imprimir_guia.php",
            type: "POST",
            crossDomain: true,
            //data: JSON.stringify( strFormSerialize ),
            data: strFormSerialize,
            dataType: "json",
            success: function ( o_json ) 
            {
                console.log( o_json );
                unBlockContent( "form1" );
                if( o_json.error )
                {
                    mostrarMensajeError( o_json.mensaje_error );
                    return false;
                }
                //actualizarDocumentoFiscalGuiaRem();
            },
            error: function ( xhr, status ) 
            {
                alert("error");
            }
        }
    );
}

saveForm = function()
{
	pr( "ing" );
	return true;
}
</script>

<style type="text/css">
/*
#example_wrapper .row
{
    margin-right: 0;
    margin-left: 0;
}
table.dataTable tbody tr:hover 
{
   background-color: #DAE6FE !important;;
}
*/
.table td, .table th 
{
    /*padding: 8px;*/
    font-size: 13px;
}
th { white-space: nowrap; }

fieldset.scheduler-border 
{
    border: 1px solid #ccc !important;
    padding: 0 0.5em 0.5em 0.5em !important;
    margin: 0 0 0.5em 0 !important;
    -webkit-box-shadow: 0px 0px 0px 0px #000;
    box-shadow: 0px 0px 0px 0px #000;
}

legend.scheduler-border 
{
    font-size: 1em !important;
    font-weight: bold !important;
    text-align: left !important;
    width: auto;
    padding: 0 5px;
    border-bottom: none;
    margin-bottom: 0;    
}

</style>

<div class="marco">
    <div class="table-responsive">
        <table class="table table-borderless" style="margin-bottom: 0px; line-height: 0.5; padding: .50rem; ">
            <tbody>
                <tr>
                    <th class="text-nowrap" scope="row">Nro Comprobante:</th>
                    <td class="text-nowrap" style="color: #fc6d00;"><?=$o_VTA_DocumentoBN->getDocumentoTipoSerieNumero()  ?></td>
                    <th class="text-nowrap" scope="row">Fecha:</th>
                    <td class="text-nowrap"><?=str_pad( $o_VTA_DocumentoBN->getFechaDocumento(), 10, "0", STR_PAD_LEFT )?></td>
                    <th class="text-nowrap" scope="row">Cliente:</th>
                    <td class="text-nowrap" ><?=$o_VTA_DocumentoBN->getClienteNombre();?></td>
                    <th class="text-nowrap" scope="row">Cliente Documento:</th>
                    <td class="text-nowrap" ><?=$o_VTA_DocumentoBN->getClienteTipoDoc();?> <?=$o_VTA_DocumentoBN->getClienteRUC();?></td> 
                </tr>
                <tr>
                    <th class="text-nowrap" scope="row">Doc Referencia:</th>
                    <td class="text-nowrap" style="color: #fc6d00;" ><?=$o_VTA_OrdenBN->getOrdenNum();?></td>
                    <th class="text-nowrap" scope="row">Ruta Origen:</th>
                    <td class="text-nowrap" ><?=$s_RutaOrigen?></td>
                    <th class="text-nowrap" scope="row">Ruta Destino:</th>
                    <td class="text-nowrap" ><?=$s_RutaDestino?></td>
                    <td>&nbsp;</td><td>&nbsp;</td>

                </tr>
                <tr>
                    <th class="text-nowrap" scope="row">Direcci&oacute;n Origen:</th>
                    <td class="text-nowrap" colspan="3"><?=$s_DireccionOrigen;?></td>
                    <th class="text-nowrap" scope="row">Direcci&oacute;n Destino:</th>
                    <td class="text-nowrap" colspan="3"><?=$s_DireccionDestino;?></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<div id="content_alert" style=""></div>

<?php
$f_CantidadControl = 0;
?>

<!-- <form id="form1" name="form1" method="POST" onsubmit="return enviarForumulario();"  enctype="multipart/form-data"> -->
<form name="form1" id="form1" method="POST" action="" onsubmit="return saveForm();">
	<input type="hidden" name="Control" value="1"/>
    <input type="hidden" name="TipoProceso" value="<?=$s_TipoProceso?>"/>
    <input type="hidden" name="IdRuta" value="<?=$s_IdRuta?>"/>
    <input type="hidden" name="IdRutaLinea" value="<?=$s_IdRutaLinea?>"/>
    <input type="hidden" name="IdMovimientoSerie" value="<?=$s_IdMovimientoSerie?>"/>
    <input type="hidden" name="IdTransferencia" value="<?=$s_IdTransferencia?>"/>
    
    <input type="hidden" name="ControlProdFinal" value="<?=$b_ControlProdFinal?>"/>
    
    <fieldset class="scheduler-border">
        <legend class="scheduler-border">Gu&iacute;a de Transportista</legend>
        
        <input type="hidden" name="TipoDocumentoFiscal" id="TipoDocumentoFiscal" value="GR">        
        <div class="form-row mx-0">
            <div class="col-md-6 mb-1">
                <label class="col-form-label font-weight-bold" for="SerieDocumentoFiscal">Serie</label>
                <input type="text" class="form-control text-center" name="SerieDocumentoFiscal" id="SerieDocumentoFiscal" placeholder="Serie" maxlength="4" 
                    onfocus="this.select();" value="<?=$o_Default->getGuiaSerie();?>" required
                    >
            </div>
            <div class="col-md-6 mb-1">
                <label class="col-form-label font-weight-bold" for="NumeroDocumentoFiscal">Numero</label>
                <input type="text" class="form-control text-center" name="NumeroDocumentoFiscal" id="NumeroDocumentoFiscal" placeholder="Numero" maxlength="10" 
                    onfocus="this.select();" onkeypress="return NumCheckEntero( event, this );" value="<?=$o_Default->getGuiaNumero();?>" required
                    >
            </div>
        </div>
        
    </fieldset>
    
    <div class="dropdown-divider"></div>

<script type="text/javascript">
agregarGuias = function()
{
	$( "#content_guias" ).append( $( "#content_guias_hidden" ).html() );
}
</script>


    <!--SE TIENE Q CAMBIAR: AQUI SE VA A MOSTRAR LOS DETALLES DE LA ORDEN O COTIZACION, O NOTA DE INGRESO, OSEA EL SERVICIO SELECCIONADO Y EL COMENTARIO.-->

    <fieldset class="scheduler-border">
        <legend class="scheduler-border">
        	 Resumen Detalle
        </legend>


        <?php foreach ($a_VTA_DocumentoDetalle as $Detalle) { ?>
        <div class="content"><?= $Detalle->getDescripcion() ?></div>
        <?php } ?>

    </fieldset>
    
    <div class="dropdown-divider"></div>
    
    <fieldset class="scheduler-border">
        <legend class="scheduler-border">Peso Acumulado (Kg)</legend>
        <div class="form-row mx-0">
            <div class="col-md-6 mb-1 text-right">
                <label class="col-form-label font-weight-bold" for="SumaPesoTotal">Peso Total</label>
            </div>
            <div class="col-md-6 mb-1">
                <input type="text" class="form-control text-center" name="SumaPesoTotal" id="SumaPesoTotal"  value="<?=$i_PesoTotal?>"
                    onfocus="this.select();" readonly="readonly"
                    >
            </div>
        </div>
    </fieldset>
    
    <div class="dropdown-divider"></div>
    
    <fieldset class="scheduler-border">
        <legend class="scheduler-border">Direcci&oacute;n de Origen</legend>
        
        <div class="form-row mx-0">
            <div class="col-md-4 mb-1">
                <label class="col-form-label" for="DepartamentoOrigen">Departamento</label>
                <select class="form-control" name="DepartamentoOrigen" id="DepartamentoOrigen" 
                        onchange="$('#ProvinciaOrigen')[0].options.length=1; $('#DistritoOrigen')[0].options.length=1; publicForSelectAjaxJSON('<?php echo buildUrl( 'transporte/request' ) ?>', 'TipoProc=Provincia&Departamento='+this.value, 'ProvinciaOrigen');"
                        >
                    <option value=""> - SELECCIONE - </option>
                    <?php foreach ( $a_DptMST_Ubigeo as $i_Key => $o_DptMST_UbigeoBN ){ ?>
                    <option value="<?=$o_DptMST_UbigeoBN->getIdUbigeo()?>" <?php if( $o_Default->getDepartamentoOrigen()==$o_DptMST_UbigeoBN->getDescripcion() ){ echo "SELECTED"; } ?>> <?=$o_DptMST_UbigeoBN->getDescripcion()?> </option>
                    <?php } ?>
                </select>
            </div>
            <div class="col-md-4 mb-1">
                <label class="col-form-label" for="ProvinciaOrigen">Provincia</label>
                <select class="form-control" name="ProvinciaOrigen" id="ProvinciaOrigen"
                        onchange="$('#DistritoOrigen')[0].options.length = 1; publicForSelectAjaxJSON('<?php echo buildUrl( 'transporte/request' ) ?>', 'TipoProc=Distrito&Provincia='+this.value, 'DistritoOrigen');"
                        >
                    <option value=""> - SELECCIONE - </option>
                    <?php if( $o_Default->getGuiaRemisionId() ){ ?>
                    	<?php
                    	$o_MST_UbigeoFN = new MST_UbigeoFN();
                    	$o_MST_UbigeoFN->setTipo( "PROV" );
                    	$a_MST_Ubigeo = $o_MST_UbigeoFN->select();
                    	?>
                    	<?php foreach ( $a_MST_Ubigeo as $o_MST_UbigeoBN ){ ?>
                    	<option value="<?=$o_MST_UbigeoBN->getIdUbigeo()?>" <?php if( $o_Default->getProvinciaOrigen()==$o_MST_UbigeoBN->getDescripcion() ){ echo "SELECTED"; } ?>> <?=$o_MST_UbigeoBN->getDescripcion()?> </option>
                    	
                    	<?php } ?>
					<?php } ?>
                </select>
            </div>
            <div class="col-md-4 mb-1">
                <label class="col-form-label" for="DistritoOrigen">Distrito</label>
                <select class="form-control" name="DistritoOrigen" id="DistritoOrigen">
                    <option value=""> - SELECCIONE - </option>
                    <?php if( $o_Default->getGuiaRemisionId() ){ ?>
                    	<?php
                    	$o_MST_UbigeoFN = new MST_UbigeoFN();
                    	$o_MST_UbigeoFN->setTipo( "DIST" );
                    	$a_MST_Ubigeo = $o_MST_UbigeoFN->select();
                    	?>
                    	<?php foreach ( $a_MST_Ubigeo as $o_MST_UbigeoBN ){ ?>
                    	<option value="<?=$o_MST_UbigeoBN->getIdUbigeo()?>" <?php if( $o_Default->getDistritoOrigen()==$o_MST_UbigeoBN->getDescripcion() ){ echo "SELECTED"; } ?>> <?=$o_MST_UbigeoBN->getDescripcion()?> </option>
                    	
                    	<?php } ?>
					<?php } ?>
                </select>
            </div>
        </div>
        
        <div class="form-group m-1">
            <label for="DireccionOrigen" class="col-form-label">Direcci&oacute;n:</label>
            <textarea class="form-control" id="DireccionOrigen" name="DireccionOrigen" rows="1" ><?=$o_Default->getDireccionOrigen()?></textarea>
        </div>
    </fieldset>
    
    <div class="dropdown-divider"></div>
    
    <fieldset class="scheduler-border">
        <legend class="scheduler-border">Direcci&oacute;n de Destino</legend>
        
        <div class="form-row mx-0">
            <div class="col-md-4 mb-1">
                <label class="col-form-label" for="DepartamentoDestino">Departamento</label>
                <select class="form-control" name="DepartamentoDestino" id="DepartamentoDestino" 
                        onchange="$('#ProvinciaDestino')[0].options.length=1; $('#DistritoDestino')[0].options.length=1; publicForSelectAjaxJSON('<?php echo buildUrl( 'transporte/request' ) ?>', 'TipoProc=Provincia&Departamento='+this.value, 'ProvinciaDestino');"
                        >
                    <option value=""> - SELECCIONE - </option>
                    <?php foreach ( $a_DptMST_Ubigeo as $i_Key => $o_DptMST_UbigeoBN ){ ?>
                    <option value="<?=$o_DptMST_UbigeoBN->getIdUbigeo()?>" <?php if( $o_Default->getDepartamentoDestino()==$o_DptMST_UbigeoBN->getDescripcion() ){ echo "SELECTED"; } ?>> <?=$o_DptMST_UbigeoBN->getDescripcion()?> </option>
                    <?php } ?>
                </select>
            </div>
            <div class="col-md-4 mb-1">
                <label class="col-form-label" for="ProvinciaDestino">Provincia</label>
                <select class="form-control" name="ProvinciaDestino" id="ProvinciaDestino"
                        onchange="$('#DistritoDestino')[0].options.length=1; publicForSelectAjaxJSON('<?php echo buildUrl( 'transporte/request' ) ?>', 'TipoProc=Distrito&Provincia='+this.value, 'DistritoDestino');"
                        >
                    <option value=""> - SELECCIONE - </option>
                    <?php if( $o_Default->getGuiaRemisionId() ){ ?>
                    	<?php
                    	$o_MST_UbigeoFN = new MST_UbigeoFN();
                    	$o_MST_UbigeoFN->setTipo( "PROV" );
                    	$a_MST_Ubigeo = $o_MST_UbigeoFN->select();
                    	?>
                    	<?php foreach ( $a_MST_Ubigeo as $o_MST_UbigeoBN ){ ?>
                    	<option value="<?=$o_MST_UbigeoBN->getIdUbigeo()?>" <?php if( $o_Default->getProvinciaDestino()==$o_MST_UbigeoBN->getDescripcion() ){ echo "SELECTED"; } ?>> <?=$o_MST_UbigeoBN->getDescripcion()?> </option>
                    	<?php } ?>
					<?php } ?>
                </select>
            </div>
            <div class="col-md-4 mb-1">
                <label class="col-form-label" for="DistritoDestino">Distrito</label>
                <select class="form-control" name="DistritoDestino" id="DistritoDestino">
                    <option value=""> - SELECCIONE - </option>
                    <?php if( $o_Default->getGuiaRemisionId() ){ ?>
                    	<?php
                    	$o_MST_UbigeoFN = new MST_UbigeoFN();
                    	$o_MST_UbigeoFN->setTipo( "DIST" );
                    	$a_MST_Ubigeo = $o_MST_UbigeoFN->select();
                    	?>
                    	<?php foreach ( $a_MST_Ubigeo as $o_MST_UbigeoBN ){ ?>
                    	<option value="<?=$o_MST_UbigeoBN->getIdUbigeo()?>" <?php if( $o_Default->getDistritoDestino()==$o_MST_UbigeoBN->getDescripcion() ){ echo "SELECTED"; } ?>> <?=$o_MST_UbigeoBN->getDescripcion()?> </option>
                    	<?php } ?>
					<?php } ?>
                </select>
            </div>
        </div>
        
        <div class="form-group m-1">
            <label for="DireccionDestino" class="col-form-label">Direcci&oacute;n:</label>
            <textarea class="form-control" id="DireccionDestino" name="DireccionDestino" rows="1" ><?=$o_Default->getDireccionDestino()?></textarea>
        </div>
    </fieldset>
    
    <div class="form-row mx-0" style="padding: 10px;" id="content_buttons">
        <div class="col-md-6 mb-1">
            <!-- <button type="button" class="btn btn-primary btn-lg btn-block" onclick="actualizarDocumentoFiscalGuiaRem();">ACTUALIZAR</button> -->
            <button type="button" class="btn btn-danger btn-lg btn-block" onclick="parent.closeWindow();">CANCELAR</button>
        </div>
        <!-- <div class="col-md-4 mb-1">
            <button type="button" class="btn btn-primary btn-lg btn-block" onclick="crearArchivoParaImprimirGuia();">IMPRIMIR</button>
        </div> -->
        <div class="col-md-6 mb-1">
            <button type="submit" class="btn btn-primary btn-lg btn-block" onclick="">GENERAR GUIA</button>
        </div>
    </div>


</form>

<div id="content_guias_hidden" style="display: none;">
    <div class="form-row mx-0">
    	<input type="hidden" name="TipoDocumentoRef[]" id="" value="GR">
        <div class="col-md-5 mb-1">
            <label class="col-form-label font-weight-bold" for="">Serie</label>
            <input type="text" class="form-control text-center" name="SerieDocumentoRef[]" id="" placeholder="Serie" maxlength="4" 
                onfocus="this.select();" value=""
                >
        </div>
        <div class="col-md-5 mb-1">
            <label class="col-form-label font-weight-bold" for="">Numero</label>
            <input type="text" class="form-control text-center" name="NumeroDocumentoRef[]" id="" placeholder="Numero" maxlength="10" 
                onfocus="this.select();" onkeypress="return NumCheckEntero( event, this );" value="" 
                >
        </div>
        <div class="col-md-2 mb-1">
            <label class="col-form-label font-weight-bold" for="">&nbsp;</label>
            <button type="button" class="form-control btn btn-primary" onclick="$( $( this ).closest( '.form-row' ) ).remove();">Eliminar</button>
        </div>
    </div>
</div>

<script type="text/javascript">
configurarDataTable = function()
{
    $( '#example' ).DataTable
    (
        {
            language:       { "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json" },
            responsive:     false,
            searching:      false,
            info:           false,
            lengthChange:   false,
            paging:         false,
            dom:            'lrtip'/*,
            fixedHeader: 
            {
                header: true,
                footer: true
            }*/
        }
    );
}

setTimeout
(
    function () 
    {
        configurarDataTable();
    }, 
    500
);
</script>

<script type="text/javascript">
<?php if( $b_Control ){ ?>
parent.buscarRutaAsignada( '<?=$s_IdRuta?>' );
parent.closeWindow();
<?php } ?>

<?php if( $mensaje_error ){ ?>
showAlertBootStrap( 'content_alert', 'alert-danger', "<?=$mensaje_error?>" );
<?php } ?>
</script>