<?php
$sDirBase = dirname(__FILE__).'/../../../../../';
require $sDirBase.'plugins/dompdf-master/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

class ShippingRoutePdfAction extends wtActions
{
    public function execute()
    {
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $IdRuta  = $this->getRequestParameter( 'IdRuta' );
        
        $o_TR_RutaFN = new TR_RutaFN();
        $o_Ruta = $o_TR_RutaFN->selectByPK( $IdRuta );
        
        $o_TR_RutaDetalleFN = new TR_RutaDetalleFN();
        $o_TR_RutaDetalleFN->setIdRuta( $IdRuta );
        $o_RutaDetalle = $o_TR_RutaDetalleFN->select();
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( myUser::getUser()->getIdBusiness() );

        $o_TR_RutaDetalleBN = $o_RutaDetalle[0];

        $o_VTA_DocumentoBN = $o_TR_RutaDetalleBN->getObjectVTADocumento();
        $a_VTA_DocumentoDetalle = $o_VTA_DocumentoBN->getArrayObjectDetalles();


        //RECUPERAMOS LA DIRECCION DE ORIGEN Y DESTINO
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( $o_VTA_DocumentoBN->getObjectAlmacen()->getIdSucursal() );

        $a_DataUbigeoOrigen = MST_UbigeoFN::getArrayDireccionCompleta( $o_GSS_SucursalBN->getDistrito() );
        $s_RutaOrigen = $a_DataUbigeoOrigen['Departamento']." - ".$a_DataUbigeoOrigen['Provincia']." - ".$a_DataUbigeoOrigen['Distrito'];
        $s_DireccionOrigen = $a_DataUbigeoOrigen['Departamento']." - ".$a_DataUbigeoOrigen['Provincia']." - ".$a_DataUbigeoOrigen['Distrito']." - ".$o_GSS_SucursalBN->getDireccion();

        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( $o_VTA_DocumentoBN->getObjectAlmacenDespacho()->getIdSucursal() );

        $a_DataUbigeoDestino = MST_UbigeoFN::getArrayDireccionCompleta( $o_GSS_SucursalBN->getDistrito() );
        $s_RutaDestino = $a_DataUbigeoDestino['Departamento']." - ".$a_DataUbigeoDestino['Provincia']." - ".$a_DataUbigeoDestino['Distrito'];
        $s_DireccionDestino = $a_DataUbigeoDestino['Departamento']." - ".$a_DataUbigeoDestino['Provincia']." - ".$a_DataUbigeoDestino['Distrito']." - ".$o_TR_RutaDetalleBN->getRutaDetDir2();
        
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $s_Class   = ParameterWR::getInstance()->getModule();
        $s_Module  = strtolower( $s_Class );
        $s_Action  = ParameterWR::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );
        
        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";
        
        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();
        
        //echo $html;         exit;
        
        $options = new Options();
        //$options->set( 'isRemoteEnabled', TRUE );
        $options->setIsPhpEnabled( true );
        
        //$dompdf = new Dompdf();
        $dompdf = new Dompdf( $options );
        $dompdf->loadHtml( $html );
        $dompdf->setPaper( 'A4', 'landscape' );
        $dompdf->render();
        
        //For Footer
        $canvas = $dompdf->get_canvas();
        $footer = $canvas->open_object();
        $font = "";
        $font_metrics = $dompdf->getFontMetrics();
        $font = $font_metrics->getFont( "helvetica", "bold" );
        //$canvas->page_text(35, 823, "HiveDesk Screenshot Report", $font, 8, array( 0, 0, 0 ) );
        $canvas->page_text( 250, 823, "Pagina:  {PAGE_NUM} de {PAGE_COUNT}", $font, 8, array( 0, 0, 0 ) );
        $canvas->page_text( 500, 823, date( "Y-m-d H:i:s" ), $font, 8, array( 0, 0, 0 ) );
        $canvas->close_object();
        $canvas->add_object( $footer, "all" );
        
        $dompdf->stream( 'Documento_', array( "Attachment" => 0 ) );
        
        exit;
    }
}