<?php
class RequestAction extends wtActions 
{
    public function execute()
    {
        $this->TipoProc = $this->getRequestParameter( 'TipoProc' );
        $a_lst = array( "Result" => false );

        $Departamento   = $this->getRequestParameter( 'Departamento' );
        $Provincia      = $this->getRequestParameter( 'Provincia' );
        
        switch ( $this->TipoProc )
        {
            case "Provincia":
                $o_MST_UbigeoFN = new MST_UbigeoFN();
                $o_MST_UbigeoFN->setTipo( "PROV" );
                $o_MST_UbigeoFN->setPertenece( $Departamento );
                $a_Result  = $o_MST_UbigeoFN->select();
                $s_NameId  = "getIdUbigeo";
                $s_NameDes = "getDescripcion";
                $a_lst = array();
                foreach ( $a_Result as $i_Key => $o_ObjectBN )
                {
                    $a_lst[$o_ObjectBN->$s_NameId()] = utf8_encode( $o_ObjectBN->$s_NameDes() );
                }
                echo json_encode( $a_lst );
                exit;
            break;
            case "Distrito":
                $o_MST_UbigeoFN = new MST_UbigeoFN();
                $o_MST_UbigeoFN->setTipo( "DIST" );
                $o_MST_UbigeoFN->setPertenece( $Provincia );
                $a_Result  = $o_MST_UbigeoFN->select();
                $s_NameId  = "getIdUbigeo";
                $s_NameDes = "getDescripcion";
                $a_lst = array();
                foreach ( $a_Result as $i_Key => $o_ObjectBN )
                {
                    $a_lst[$o_ObjectBN->$s_NameId()] = utf8_encode( $o_ObjectBN->$s_NameDes() );
                }
                echo json_encode( $a_lst );
                exit;
            break;
            case "registrar_guia_rem":
            
                //ahora se guarda la guia o guias que se generen
                /*foreach ( $a_NombreArchivoFinal as $key => $a_Values ) 
                {
                    $o_SR_GuiaRemisionHDP = new SR_GuiaRemisionHDP();
                    $o_SR_GuiaRemisionHDP->setGuiaRemisionId( $a_Values['Serie'].$a_Values['Numero'] );
                    $o_SR_GuiaRemisionHDP->setGuiaSerie( $a_Values['Serie'] );
                    $o_SR_GuiaRemisionHDP->setGuiaNumero( $a_Values['Numero'] );
                    $o_SR_GuiaRemisionHDP->setGuiaFecha( $a_Values['Fecha'] );
                    $o_SR_GuiaRemisionHDP->setReferenciaTipo( $a_Values['TipoRef'] );
                    $o_SR_GuiaRemisionHDP->setReferenciaNumero( $a_Values['NumRef'] );
                    $o_SR_GuiaRemisionHDP->setMovimientoId( intval( $a_Values['IdMov'] ) );
                    $o_SR_GuiaRemisionHDP->setEstado( "A" );
                    $o_SR_GuiaRemisionHDP->setFechaRegistro( date( "Y-m-d H:i:s" ) );
                    $o_SR_GuiaRemisionHDP->setUsuarioRegistro( myUser::getUser()->getUserId() );
                    $o_SR_GuiaRemisionHDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_SR_GuiaRemisionHDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_SR_GuiaRemisionHDP->save();
                }

                if( $s_TipoProceso == "DespachoInmediato" )
                {
                    //ahora se cambia el estado de impresion al movimiento
                    $o_SR_MovimientoDP = new SR_MovimientoDP();
                    $o_SR_MovimientoDP->setMovimientoId( intval( $s_IdMovimientoSerie ) );
                    $o_SR_MovimientoDP->setImpresionEstado( "C" );
                    $o_SR_MovimientoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_SR_MovimientoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_SR_MovimientoDP->update();
                }
                
                $a_lst['error'] = false;
                $a_lst['nombre_archivo'] = implode( ",", $a_NombreArchivo );*/
            break;
            case "lstVehiculo":
                $this->FechaProgramada = $this->getRequestParameter( 'FechaProgramada' );
                $this->Turno           = $this->getRequestParameter( 'Turno' );
                ViewResponse::getInstance()->setMethodAjax();
            break;
            case "lstChofer":
                $this->FechaProgramada = $this->getRequestParameter( 'FechaProgramada' );
                $this->Turno           = $this->getRequestParameter( 'Turno' );
                $this->Vehiculo        = $this->getRequestParameter( 'Vehiculo' );
                
                $this->i_IdSelect = "";
                
                if( $this->Vehiculo )
                {
                    $o_TR_RutaFN = new TR_RutaFN();
                    $o_TR_RutaFN->setRutaFechaProgramada( $this->FechaProgramada );
                    $o_TR_RutaFN->setIdTurno( $this->Turno );
                    $o_TR_RutaFN->setIdVehiculo( $this->Vehiculo );
                    $a_TR_Ruta = $o_TR_RutaFN->select();
                    if( $a_TR_Ruta )
                    {
                        if( count( $a_TR_Ruta ) == 1 )
                        {
                            $this->o_TR_RutaBN = $a_TR_Ruta[0];
                            $this->i_IdSelect = $this->o_TR_RutaBN->getIdChofer(); 
                        }
                    }
                }
                ViewResponse::getInstance()->setMethodAjax();
            break;
            
            case "IdTransaccion":
                
                $a_lst['error']      = false;
                $a_lst['Result']     = true;
                
                echo json_encode( $a_lst );
                return ViewResponse::NONE;
            break;
            
            case "CrearArchivoPrintGuia":
                $con = Conexion::getConexion();
                $con->begin();
                try 
                {
                    myUser::getUser()->validar_session();

                    $s_TipoProceso       = $this->getRequestParameter( "TipoProceso" );
                    $s_IdRuta            = $this->getRequestParameter( "IdRuta" );
                    $s_IdRutaLinea       = $this->getRequestParameter( "IdRutaLinea" );
                    $s_ParaProvincia     = $this->getRequestParameter( "ParaProvincia" );
                    $s_IdMovimientoSerie = $this->getRequestParameter( "IdMovimientoSerie" );
                    $s_DepartamentoOrigen = $this->getRequestParameter( "DepartamentoOrigen" );
                    $s_ProvinciaOrigen = $this->getRequestParameter( "ProvinciaOrigen" );
                    $s_DistritoOrigen = $this->getRequestParameter( "DistritoOrigen" );
                    $s_DireccionOrigen = $this->getRequestParameter( "DireccionOrigen" );
                    $s_DepartamentoDestino = $this->getRequestParameter( "DepartamentoDestino" );
                    $s_ProvinciaDestino = $this->getRequestParameter( "ProvinciaDestino" );
                    $s_DistritoDestino = $this->getRequestParameter( "DistritoDestino" );
                    $s_DireccionDestino = $this->getRequestParameter( "DireccionDestino" );

                    $s_Tipo       = $this->getRequestParameter( "TipoDocumentoFiscal" );
                    $i_SerieGuia  = intval( $this->getRequestParameter( "SerieDocumentoFiscal" ) );
                    $i_NumeroGuia = intval( $this->getRequestParameter( "NumeroDocumentoFiscal" ) );

                    $s_TipoRef = "";
                    $s_NumeRef = "";
                    
                    $a_DataUniTransporte = array( "RutaDetDir" => "", "MarcaPlaca" => "", "Conductor" => "", "NroLicencia" => "" );

                    if( $s_TipoProceso == "Despacho" )
                    {
                        $o_TR_RutaFN = new TR_RutaFN();
                        $o_TR_RutaBN = $o_TR_RutaFN->selectByPK( $s_IdRuta );
                        
                        $o_TR_RutaDetalleFN = new TR_RutaDetalleFN();
                        $o_TR_RutaDetalleBN = $o_TR_RutaDetalleFN->selectByPK( $s_IdRuta, $s_IdRutaLinea );
                        
                        $o_VTA_DocumentoBN = $o_TR_RutaDetalleBN->getObjectVTADocumento();
                        
                        //ahora se recupera el id de SR_Movimiento
                        if( $o_VTA_DocumentoBN->getDocumentoParentCod() )
                        {
                            $o_SR_MovimientoFN = new SR_MovimientoFN();
                            $o_SR_MovimientoFN->setReferenciaTipo( "OS" );
                            $o_SR_MovimientoFN->setReferenciaNumero( $o_VTA_DocumentoBN->getDocumentoParentCod() );
                            $a_SR_Movimiento = $o_SR_MovimientoFN->select();
                            if( $a_SR_Movimiento )
                            {
                                $s_IdMovimientoSerie = $a_SR_Movimiento[0]->getMovimientoId();
                                $s_ReferenciaNumero  = $a_SR_Movimiento[0]->getReferenciaNumero();
                                $s_TipoRef           = $a_SR_Movimiento[0]->getReferenciaTipo();
                                $s_NumeRef           = $s_ReferenciaNumero;
                            }
                        }
                        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                        //PARAMETROS
                        $s_VehiculoMarcaPlaca   = $s_ParaProvincia ? "" : $o_TR_RutaBN->getVehiculoDesc();
                        $s_NombreTransportista  = $s_ParaProvincia ? "" : $o_TR_RutaBN->getChoferDesc();
                        $s_LicenciaConductor    = $s_ParaProvincia ? "" : $o_TR_RutaBN->getObjectChofer()->getChoferLicencia();
                        //$s_FechaEmision         = substr( $o_TR_RutaBN->getRutaFechaProgramada(), 0, 10 );
                        //$s_FechaTraslado        = substr( $o_TR_RutaBN->getRutaFechaProgramada(), 0, 10 )." ".$o_TR_RutaBN->getTurnoDesc();
                        
                        $a_DataUniTransporte = array( "RutaDetDir" => "", "MarcaPlaca" => $s_VehiculoMarcaPlaca, "Conductor" => $s_NombreTransportista, "NroLicencia" => $s_LicenciaConductor );
                        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    }
                    if( $s_TipoProceso == "DespachoInmediato" )
                    {
                        $o_SR_MovimientoFN = new SR_MovimientoFN();
                        $o_SR_MovimientoBN = $o_SR_MovimientoFN->selectByPK( $s_IdMovimientoSerie );
                        if( $o_SR_MovimientoBN )
                        {
                            if( $o_SR_MovimientoBN->getTipoMovimiento() == "VTA" )
                            {
                                $s_ReferenciaNumero = $o_SR_MovimientoBN->getReferenciaNumero();
                                $s_TipoRef          = $o_SR_MovimientoBN->getReferenciaTipo();
                                $s_NumeRef          = $s_ReferenciaNumero;
                                switch( $o_SR_MovimientoBN->getReferenciaTipo() )
                                {
                                    case "OS":
                                        //$o_VTA_OrdenBN = VTA_OrdenFN::findOrdenByNum( $s_ReferenciaNumero );
                                        $o_VTA_DocumentoBN = VTA_DocumentoFN::findByDocumentoParentCod( $s_ReferenciaNumero );
                                    break;
                                    case "BOL":
                                    case "FAC":
                                        $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $o_SR_MovimientoBN->getReferenciaId() );
                                    break;
                                }
                            }
                        }
                    }
                    
                    if( !$o_VTA_DocumentoBN )
                    {
                        throw new Exception( "No se encontro Comprobantes como referencia, el Documento no puede imprimirse." );
                    }

                    $a_Detalle = $o_VTA_DocumentoBN->getArrayObjectDetalles();

                    $a_NombreArchivoFinal = array();
                    $a_NombreArchivo      = array();
                    $b_Control            = true;

                    do
                    {
                        $o_UtilImprimir = new UtilImprimir();

                        $b_Continue = true;
                        $s_Serie  = str_pad( $i_SerieGuia, 3, "0", STR_PAD_LEFT );
                        $s_Numero = str_pad( $i_NumeroGuia, 8, "0", STR_PAD_LEFT );
                        $s_NombreArchivo = $s_Tipo."_".$s_Serie."-".$s_Numero;

                        $this->guia_cabecera( $o_UtilImprimir, 'VTA_Documento', $o_VTA_DocumentoBN, $a_DataUniTransporte );
                        
                        //los detalles empieza en la linea 27
                        $w = 1;
                        $i = 1;
                        foreach ( $a_Detalle as $key => $o_DetalleBN ) 
                        {
                            //$s_codItem = substr( $o_DetalleBN->getItemCodigo(), 0, 9 );
                            
                            //ahora se agrega las series escaneadas del item
                            $a_Series = $o_DetalleBN->getSeriesEscaneadasxIdMov( $s_IdMovimientoSerie );
                            if( $a_Series )
                            {
                                $a_Series = $this->guia_ordenar_serie( $a_Series );
                                
                                $w++;
                                foreach ( $a_Series as $value ) 
                                {
                                    $w++;
                                }

                                if( $w >= 27 )
                                {
                                    $b_Continue = false;
                                    break;
                                }

                                //se agrega codigo, descripcion y cantidad
                                $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 1=>$o_DetalleBN->getItemCodigo(), 14=> $o_DetalleBN->getCantidadPedida(), 22=>utf8_decode( $o_DetalleBN->getDescripcion() ) ) )."\n" );
                                $i++;
                                foreach ( $a_Series as $value ) 
                                {
                                    $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 1=>$value ) )."\n" );
                                    $i++;
                                }
                            }
                            else
                            {
                                $w++;
                                
                                if( $w >= 27 )
                                {
                                    $b_Continue = false;
                                    break;
                                }

                                //se agrega codigo, descripcion y cantidad
                                $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 1=>$o_DetalleBN->getItemCodigo(), 14=> $o_DetalleBN->getCantidadPedida(), 22=>$o_DetalleBN->getDescripcion() ) )."\n" );
                                $i++;
                            }
                            unset( $a_Detalle[$key] );
                        }

                        for ( $j=$i; $j<27; $j++ ){ $o_UtilImprimir->addTexts( self::fomat_linea_print(  )."\n" ); } //array( 1=>$j )
                        
                        $this->guia_pie_pagina( $o_UtilImprimir );

                        $o_UtilImprimir->saltoPagina();
                        $s_NombreArchivo = $o_UtilImprimir->crearArchivoWeb( $s_NombreArchivo );

                        $a_NombreArchivo[] = $s_NombreArchivo;
                        $a_NombreArchivoFinal[] = array( "Serie" => $s_Serie, "Numero" => $s_Numero, "Fecha" => date( "Y-m-d H:i:s" ), "TipoRef" => $s_TipoRef, "NumRef" => $s_NumeRef, "IdMov" => $s_IdMovimientoSerie );

                        if( $b_Continue )
                        {
                            $b_Control = false;
                        }
                        else
                        {
                            $i_NumeroGuia++;
                        }
                    }
                    while( $b_Control );

                    //primero se valida la re-impresion, se limpia guia asociado anteriomente - 2020-08-08
                    $o_SR_GuiaRemisionHDP = new SR_GuiaRemisionHDP();
                    $o_SR_GuiaRemisionHDP->setReferenciaTipo( $s_TipoRef );
                    $o_SR_GuiaRemisionHDP->setReferenciaNumero( $s_NumeRef );
                    $o_SR_GuiaRemisionHDP->limpiar_data_guia();
                    
                    //ahora se guarda la guia o guias que se generen
                    foreach ( $a_NombreArchivoFinal as $key => $a_Values ) 
                    {
                        $o_SR_GuiaRemisionHFN = new SR_GuiaRemisionHFN();
                        $o_SR_GuiaRemisionHBN = $o_SR_GuiaRemisionHFN->selectByPK( $a_Values['Serie'].$a_Values['Numero'] );
                        if( $o_SR_GuiaRemisionHBN )
                        {
                            //update
                            $o_SR_GuiaRemisionHDP = new SR_GuiaRemisionHDP();
                            $o_SR_GuiaRemisionHDP->setGuiaRemisionId( $a_Values['Serie'].$a_Values['Numero'] );
                            $o_SR_GuiaRemisionHDP->setGuiaSerie( $a_Values['Serie'] );
                            $o_SR_GuiaRemisionHDP->setGuiaNumero( $a_Values['Numero'] );
                            $o_SR_GuiaRemisionHDP->setGuiaFecha( $a_Values['Fecha'] );
                            $o_SR_GuiaRemisionHDP->setReferenciaTipo( $a_Values['TipoRef'] );
                            $o_SR_GuiaRemisionHDP->setReferenciaNumero( $a_Values['NumRef'] );
                            $o_SR_GuiaRemisionHDP->setMovimientoId( intval( $a_Values['IdMov'] ) );
                            $o_SR_GuiaRemisionHDP->setEstado( "A" );
                            $o_SR_GuiaRemisionHDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                            $o_SR_GuiaRemisionHDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                            $o_SR_GuiaRemisionHDP->update();
                        }
                        else
                        {
                            //insert
                            $o_SR_GuiaRemisionHDP = new SR_GuiaRemisionHDP();
                            $o_SR_GuiaRemisionHDP->setGuiaRemisionId( $a_Values['Serie'].$a_Values['Numero'] );
                            $o_SR_GuiaRemisionHDP->setGuiaSerie( $a_Values['Serie'] );
                            $o_SR_GuiaRemisionHDP->setGuiaNumero( $a_Values['Numero'] );
                            $o_SR_GuiaRemisionHDP->setGuiaFecha( $a_Values['Fecha'] );
                            $o_SR_GuiaRemisionHDP->setReferenciaTipo( $a_Values['TipoRef'] );
                            $o_SR_GuiaRemisionHDP->setReferenciaNumero( $a_Values['NumRef'] );
                            $o_SR_GuiaRemisionHDP->setMovimientoId( intval( $a_Values['IdMov'] ) );
                            $o_SR_GuiaRemisionHDP->setEstado( "A" );
                            $o_SR_GuiaRemisionHDP->setFechaRegistro( date( "Y-m-d H:i:s" ) );
                            $o_SR_GuiaRemisionHDP->setUsuarioRegistro( myUser::getUser()->getUserId() );
                            $o_SR_GuiaRemisionHDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                            $o_SR_GuiaRemisionHDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                            $o_SR_GuiaRemisionHDP->save();
                        }
                    }

                    if( $s_TipoProceso == "DespachoInmediato" )
                    {
                        //ahora se cambia el estado de impresion al movimiento
                        $o_SR_MovimientoDP = new SR_MovimientoDP();
                        $o_SR_MovimientoDP->setMovimientoId( intval( $s_IdMovimientoSerie ) );
                        $o_SR_MovimientoDP->setImpresionEstado( "C" );
                        $o_SR_MovimientoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_SR_MovimientoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_SR_MovimientoDP->update();
                    }
                    
                    $a_lst['error'] = false;
                    $a_lst['nombre_archivo'] = implode( ",", $a_NombreArchivo );

                    $con->commit();
                }
                catch ( Exception $o_Exception )
                {
                    $con->rollback();
                    $a_lst['error'] = true;
                    $a_lst['mensaje_error'] = $o_Exception->getMessage();
                }
                echo json_encode( $a_lst );
                exit;
                return ViewResponse::NONE;
            break;
            case "actualizarGuiaRemision":
                try 
                {
                    $s_IdRuta      = $this->getRequestParameter( "IdRuta" );
                    $s_IdRutaLinea = $this->getRequestParameter( "IdRutaLinea" );
                    
                    $s_TipoDocumentoFiscal   = $this->getRequestParameter( "TipoDocumentoFiscal" );
                    $s_SerieDocumentoFiscal  = str_pad( $this->getRequestParameter( 'SerieDocumentoFiscal' ), 3, "0", STR_PAD_LEFT );
                    $s_NumeroDocumentoFiscal = str_pad( $this->getRequestParameter( 'NumeroDocumentoFiscal' ), 8, "0", STR_PAD_LEFT );
                    
                    $Departamento = $this->getRequestParameter( "Departamento" );
                    $Provincia    = $this->getRequestParameter( "Provincia" );
                    $Distrito     = $this->getRequestParameter( "Distrito" );
                    $Direccion    = trim( $this->getRequestParameter( "Direccion" ) );

                    $o_MST_UbigeoFN = new MST_UbigeoFN();

                    if( $Departamento )
                    {
                        $o_MST_UbigeoBN = $o_MST_UbigeoFN->selectByPK( $Departamento );
                        $s_DepartamentoDesc = $o_MST_UbigeoBN->getDescripcion();
                    }
                    if( $Provincia )
                    {
                        $o_MST_UbigeoBN = $o_MST_UbigeoFN->selectByPK( $Provincia );
                        $s_ProvinciaDesc = $o_MST_UbigeoBN->getDescripcion();
                    }
                    if( $Distrito )
                    {
                        $o_MST_UbigeoBN = $o_MST_UbigeoFN->selectByPK( $Distrito );
                        $s_CiudadDesc = $o_MST_UbigeoBN->getDescripcion();
                    }

                    $o_TR_RutaDetalleDP = new TR_RutaDetalleDP();
                    $o_TR_RutaDetalleDP->setIdRuta( ( int ) $s_IdRuta );
                    $o_TR_RutaDetalleDP->setIdRutaLinea( ( int ) $s_IdRutaLinea );
                    $o_TR_RutaDetalleDP->setTipoDocRef( $s_TipoDocumentoFiscal );
                    $o_TR_RutaDetalleDP->setSerieDocumentoRef( $s_SerieDocumentoFiscal );
                    $o_TR_RutaDetalleDP->setNumeroDocumentoRef( $s_NumeroDocumentoFiscal );

                    if( $Departamento )
                    {
                        $o_TR_RutaDetalleDP->setRutaDetDpto( $s_DepartamentoDesc );
                    }
                    if( $Provincia )
                    {
                        $o_TR_RutaDetalleDP->setRutaDetCiudad( $s_ProvinciaDesc );
                    }
                    if( $Distrito )
                    {
                        $o_TR_RutaDetalleDP->setRutaDetDir1( $s_CiudadDesc );
                        $o_TR_RutaDetalleDP->setIdUbigeo( $Distrito );
                    }
                    if( $Direccion )
                    {
                        $o_TR_RutaDetalleDP->setRutaDetDir2( $Direccion );
                    }

                    $o_TR_RutaDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_TR_RutaDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    
                    $b_Result = $o_TR_RutaDetalleDP->update();
                    
                    $a_lst['error'] = false;
                }
                catch ( Exception $o_Exception )
                {
                    $a_lst['error'] = true;
                    $a_lst['mensaje_error'] = $o_Exception->getMessage();
                }
                echo json_encode( $a_lst );
                exit;
            break;
        }
    }

    public function guia_ordenar_serie( $a_Series )
    {
        $i_MaxAncho = 95;

        $i_Format = 0;
        foreach ( $a_Series as $value ) 
        {
            if( strlen( $value ) > $i_Format )
            {
                $i_Format = strlen( $value );
            }
        }

        $a_lineas = array();
        $s_Linea = "";
        foreach ( $a_Series as $key => $value ) 
        {
            $value_txt = str_pad( strtoupper( $value ), ( $i_Format + 1 )  );
            $i_SumStrLen = strlen( $s_Linea ) + strlen( $value_txt );
            if( $i_SumStrLen <= 95 )
            {
                $s_Linea .= $value_txt;
            }
            else
            {
                $a_lineas[] = $s_Linea;
                $s_Linea = "";
                $s_Linea .= $value_txt;
            }
            if( count( $a_Series ) == ( $key + 1 ) )
            {
                $a_lineas[] = $s_Linea;
            }
            //$s_Linea .= " ";
        }
        return $a_lineas;
    }

    public function guia_cabecera( &$o_UtilImprimir, $Tipo, $o_VTA_DocumentoBN, $a_Param )
    {
        $s_NombresDestinatario = "";
        $s_NumeroRucDocPersona = "";
        $s_FechaEmision        = "";
        $s_FechaTraslado       = "";
        $s_RutaDirLlegada_1    = "";
        $s_RutaDirLlegada_2    = "";
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //PARAMETROS
        $s_FechaEmision = substr( $o_VTA_DocumentoBN->getFechaDocumento(), 0, 10 );
        $s_FechaTraslado = date( "Y-m-d" );
        
        $s_MarcaPlaca  = $a_Param['MarcaPlaca'];
        $s_Conductor   = $a_Param['Conductor'];
        $s_NroLicencia = $a_Param['NroLicencia'];
        
        if( $a_Param['RutaDetDir'] != "" )
        {
            $s_RutaDirLlegada   = preg_replace("/[\r\n|\n|\r]+/", " ", utf8_decode( $a_Param['RutaDetDir'] ) );
            $s_RutaDirLlegada_1 = trim( substr( $s_RutaDirLlegada, 0,  42 ) );
            $s_RutaDirLlegada_2 = trim( substr( $s_RutaDirLlegada, 42, 44 ) );
        }
        else
        {
            $o_MST_PersonaMastBN = $o_VTA_DocumentoBN->getObjectCliente();
            $s_DireccionLLegada  = preg_replace("/[\r\n|\n|\r]+/", " ", utf8_decode( $o_MST_PersonaMastBN->getDireccion() ) );
            $s_RutaDirLlegada_1 = trim( substr( $s_DireccionLLegada, 0,  42 ) );
            $s_RutaDirLlegada_2 = trim( substr( $s_DireccionLLegada, 42, 44 ) );
        }
        
        $s_RutaDirLlegada2_1 = $s_RutaDirLlegada_1;
        $s_RutaDirLlegada2_2 = $s_RutaDirLlegada_2;
        
        if( $this->getRequestParameter( 'Direccion' ) )
        {
            $s_Direccion      = $this->getRequestParameter( 'Direccion' );
            $s_DistritoId     = $this->getRequestParameter( 'Distrito' );
            $s_ProvinciaId    = $this->getRequestParameter( 'Provincia' );
            $s_DepartamentoId = $this->getRequestParameter( 'Departamento' );
            
            $s_DepartamentoDesc = MST_UbigeoFN::getDescripcionPorId( $s_DepartamentoId );
            $s_ProvinciaDesc    = MST_UbigeoFN::getDescripcionPorId( $s_ProvinciaId );
            $s_DistritoDesc     = MST_UbigeoFN::getDescripcionPorId( $s_DistritoId );

            $s_DistritoDesc = $s_Direccion." - ".$s_DistritoDesc." - ".$s_ProvinciaDesc." - ".$s_DepartamentoDesc;
            
            $s_RutaDirLlegada2_1 = trim( substr( $s_DistritoDesc, 0,  42 ) );
            $s_RutaDirLlegada2_2 = trim( substr( $s_DistritoDesc, 42, 44 ) );
            
            //pr( $s_DistritoDesc ); exit;
        }

        if( $o_MST_PersonaMastBN->getEsPersonaNatural() )
        {
            $s_NombresDestinatario   = $o_MST_PersonaMastBN->getNombreConcatenado();
            $s_TipoDocumento         = $o_MST_PersonaMastBN->getTipoDocumento();
            $s_NumeroRucDocPersona   = $o_MST_PersonaMastBN->getDocumento();
            $s_NumeroDocumentoPerson = $s_TipoDocumento." ".$o_MST_PersonaMastBN->getDocumento();
        }
        else 
        {
            $s_NombresDestinatario   = $o_MST_PersonaMastBN->getNombreCompleto();
            $s_TipoDocumento         = $o_MST_PersonaMastBN->getTipoDocumento();
            $s_NumeroRucDocPersona   = $o_MST_PersonaMastBN->getDocumento();
            $s_NumeroDocumentoPerson = "";
        }
        
        $s_NombresDestinatario = $o_VTA_DocumentoBN->getClienteNombre();
        $s_NumeroRucDocPersona = $o_VTA_DocumentoBN->getClienteRUC();
        

        //$s_TipoDocFiscal = substr( $o_VTA_DocumentoBN->getObjectTipoDocumento()->getDescripcionLocal(), 0, 7 );
        $s_TipoDocFiscal   = $o_VTA_DocumentoBN->getObjectTipoDocumento()->getDescripcionLocal();
        $a_TipoDocFiscal   = explode( " ", $s_TipoDocFiscal );
        $s_FormaPagoDesc    = substr( $o_VTA_DocumentoBN->getFormaPagoDes(), 0, 14 );
        $s_NumeroDocFiscal = $o_VTA_DocumentoBN->getDocumentoSerieNumero();
        $s_Vendedor        = $o_VTA_DocumentoBN->getVendedor();
        $s_OrdenCompraref  = $o_VTA_DocumentoBN->getOrdenCompraRef();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
        $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
        $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
        $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
        $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
        $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
        $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
        $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
        $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
        $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
        //$o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
        $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 12=>$s_NombresDestinatario ) )."\n" ); //linea 12
        $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 56=>"Jr. Julio C. Tello 1040 Dpt 404" ) )."\n" ); //linea 13
        $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 19=>$s_NumeroRucDocPersona, 59=>"Lince" ) )."\n" ); //linea 14
        $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 19=>$s_FechaEmision ) )."\n" );  //linea 15
        $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 19=>$s_FechaTraslado ) )."\n" ); //linea 16
        $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 5 => $s_RutaDirLlegada_1, 52 => $s_RutaDirLlegada2_1 ) )."\n" ); //linea 17
        $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 5 => $s_RutaDirLlegada_2, 52 => $s_RutaDirLlegada2_2 ) )."\n" ); //linea 18

        $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
        $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 17 => $s_MarcaPlaca ) )."\n" );
        $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 6 => $s_Conductor ) )."\n" );
        $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 18 => $s_NroLicencia ) )."\n" );
        $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
        //$o_UtilImprimir->addTexts( self::fomat_linea_print( array( 13 => $a_TipoDocFiscal[0], 30 => $s_NumeroDocFiscal, 59 => $s_OrdenCompraref,  81 => $s_Vendedor ) )."\n" ); //linea 24        
        $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 13 => $s_FormaPagoDesc, 30 => $s_NumeroDocFiscal, 59 => $s_OrdenCompraref,  81 => $s_Vendedor ) )."\n" ); //linea 24        
        $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
        $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
    }

    public function guia_pie_pagina( &$o_UtilImprimir )
    {
        $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
        $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
        $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
        $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
        $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
        $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
        $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
        //$o_UtilImprimir->addTexts( self::fomat_linea_print( array( 46=>$s_NombreTransportista ) )."\n" );
    }

    public static function fomat_linea_print( $a_Param=null )
    {
        $i_LineaLargo = 59; //maximo hoja continua
        $i_LineaAncho = 95;
        $s_Tx = " ";
        
        $s_Text = "";
        
        for ( $i=1; $i<=95; $i++ )
        {
            if( $a_Param )
            {
                foreach ( $a_Param as $i_Key => $s_Value )
                {
                    if( $i == $i_Key )
                    {
                        $s_Text .= $s_Value;
                        $i_TamTexto = strlen( $s_Value );
                        $i = $i + $i_TamTexto;
                        $b_Control = false;
                    }
                }
            }
            $s_Text .= $s_Tx;
        }
        return $s_Text;
    }
}