<?php
use_helper( 'UrlFunctions' );
class ReEnviarGuiaRemAction extends wtActions
{
    public function execute()
    {
        $s_TipoProceso       = $this->getRequestParameter( 'TipoProceso' ); //POR AHORA SOLO HAY 2 TIPOS -> TR[TRANSFERENCIA] DE[DESPACHO][PARA VENTA]
        $s_IdMovimientoSerie = intval( $this->getRequestParameter( "IdMovimientoSerie" ) );
        $s_ControlProdFinal  = intval( $this->getRequestParameter( "ControlProdFinal" ) );
        $s_Tipo              = $this->getRequestParameter( "TipoDocumentoFiscal" );
        $s_Observaciones     = $this->getRequestParameter( "Observaciones" );

        $s_ParentGuiaRemisionId = $this->getRequestParameter( "GuiaRemisionId" );

        $a_Result = array( "error" => false );

        $s_CodigoError    = "";
        $b_ControlImpr    = true;

        $con = Conexion::getConexion();
        try
        {
            $con->begin();

            myUser::getUser()->validar_session();

            //VALIDACION DE PERIODO
            $s_Periodo     = date( "Ym" );
            $b_FlagPeriodo = PRO_CierreMensualFN::flagPeriodoAbierto( $s_Periodo );
            if( !$b_FlagPeriodo )
            {
                throw new Exception( "El Periodo se encuentra Cerrado." );
            }
            ///////////////////////

            //////////////////////////////////////////////////////////////////////////////////////////////////////
            //se recupera serie y numero de guia
            $s_Serie               = "";
            $s_Numero              = "";
            $s_FechaGuia           = date( "Y-m-d H:i:s" );
            $s_FechaInicioTraslado = $this->getRequestParameter( "FechaIniTraslado" );

            $i_IdCompania = null;
            $i_IdSucursal = null;

            $o_VTA_OrdenBN          = null;
            $o_VTA_DocumentoBN      = null;
            $a_VTA_DocumentoDetalle = null;

            $o_GSS_SucursalDocumentoFN = new GSS_SucursalDocumentoFN();
            $o_GSS_SucursalDocumentoFN->setIdCompania( myUser::getUser()->getIdBusiness() );
            if( myUser::getUser()->getIdSucursal() )
            {
                $o_GSS_SucursalDocumentoFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
            }
            $o_GSS_SucursalDocumentoFN->setIdTipoDocumento( $s_Tipo ); //GR -> Guia de Remision
            $a_GSS_SucursalDocumento = $o_GSS_SucursalDocumentoFN->select();
            if( $a_GSS_SucursalDocumento )
            {
                $o_GSS_SucursalDocumentoBN = $a_GSS_SucursalDocumento[0];

                $s_Serie  = $o_GSS_SucursalDocumentoBN->getSerieFormatoFinal();
                $s_Numero = $o_GSS_SucursalDocumentoBN->getNumeroActualFormato();
            }
            else
            {
                throw new Exception( "No se encuentra configurado el correlativo para la Guia de Remision." );
            }

            $o_SR_MovimientoFN = new SR_MovimientoFN();
            $o_SR_MovimientoBN = $o_SR_MovimientoFN->selectByPK( $s_IdMovimientoSerie );

            if( $o_SR_MovimientoBN->getTipoMovimiento() == "VTA" ) //&& $o_SR_MovimientoBN->getReferenciaTipo() == "OS"
            {
                $o_VTA_OrdenBN     = $o_SR_MovimientoBN->getObjectDocumentoReferencia();
                $o_VTA_DocumentoBN = $o_VTA_OrdenBN->getObjectVTADocumento();

                $s_IdTipoDocumento = $o_VTA_DocumentoBN->getIdTipoDocumento();
                $s_NumeroDocumento = $o_VTA_DocumentoBN->getNumeroDocumento();
                $s_DocumentoCod    = $o_VTA_DocumentoBN->getDocumentoCod();
                $s_DocumentoSerie  = $o_VTA_DocumentoBN->getDocumentoSerie();
                $s_DocumentoNumero = $o_VTA_DocumentoBN->getDocumentoNumero();

                $a_VTA_DocumentoDetalle = $o_VTA_DocumentoBN->getArrayObjectDetalles();

                $i_IdCompania = $o_VTA_DocumentoBN->getIdCompania();

                $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $o_VTA_DocumentoBN->getClienteNumero() );

                ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                /// validacion por direccion, se le da direccion del proyecto
                if( $o_VTA_DocumentoBN->getIdTipoDocumento() == VTA_DocumentoBN::TIPO_DOCUMENTO_BOLETA_VAL || $o_VTA_DocumentoBN->getIdTipoDocumento() == "NV" )
                {
                    if( !$o_VTA_DocumentoBN->getClienteDireccion() )
                    {
                        if( $o_VTA_DocumentoBN->getIdProyecto() )
                        {
                            $o_VTA_PrsProyectosFN       = new VTA_PrsProyectosFN();
                            $o_VTA_PrsProyectosBN = $o_VTA_PrsProyectosFN->selectByPK( $o_VTA_DocumentoBN->getIdProyecto() );

                            $o_VTA_DocumentoBN->setClienteDireccion( $o_VTA_PrsProyectosBN->getDireccion() );

                            $o_MST_PersonaMastBN->setDepartamento( $o_VTA_PrsProyectosBN->getDepartamento() );
                            $o_MST_PersonaMastBN->setProvincia( $o_VTA_PrsProyectosBN->getProvincia() );
                            $o_MST_PersonaMastBN->setDistrito( $o_VTA_PrsProyectosBN->getDistrito() );
                            $o_MST_PersonaMastBN->setDireccion( $o_VTA_PrsProyectosBN->getDireccion()." - ".$o_VTA_PrsProyectosBN->getDepartamentoDesc()." - ".$o_VTA_PrsProyectosBN->getProvinciaDesc()." - ".$o_VTA_PrsProyectosBN->getDistritoDesc() );
                        }
                    }
                }
                ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                $s_AlmacenDespacho = $o_SR_MovimientoBN->getAlmacen();
                $i_IdSucursal      = ALM_AlmacenMastFN::recuperarIdSucursal( $s_AlmacenDespacho );

                $o_GSS_SucursalFN = new GSS_SucursalFN();
                $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( $i_IdSucursal );

                //ahora se recupera la direccion de Partida
                $s_PuntoPartidaUbigeo = $o_GSS_SucursalBN->getDistrito();
                $s_DepartamentoOrigen = MST_UbigeoFN::getDescripcionPorId( $o_GSS_SucursalBN->getDepartamento() );
                $s_ProvinciaOrigen    = MST_UbigeoFN::getDescripcionPorId( $o_GSS_SucursalBN->getProvincia() );
                $s_DistritoOrigen     = MST_UbigeoFN::getDescripcionPorId( $o_GSS_SucursalBN->getDistrito() );
                $s_DireccionOrigen    = $o_GSS_SucursalBN->getDireccion(); //." - ".$s_DepartamentoOrigen." - ".$s_ProvinciaOrigen." - ".$s_DistritoOrigen;

                //ahora se recupera la direccion de Destino
                $s_PuntoLlegadaUbigeo  = $o_MST_PersonaMastBN->getDistrito();
                $s_DepartamentoDestino = $o_MST_PersonaMastBN->getDepartamentoDesc();
                $s_ProvinciaDestino    = $o_MST_PersonaMastBN->getProvinciaDesc();
                $s_DistritoDestino     = $o_MST_PersonaMastBN->getDistritoDesc();
                $s_DireccionDestino    = $o_MST_PersonaMastBN->getDireccion(); //." - ".$s_DepartamentoDestino." - ".$s_ProvinciaDestino." - ".$s_DistritoDestino;
                $s_ClienteDireccion    = $o_MST_PersonaMastBN->getDireccion();

                $s_ClienteEmail        = $o_MST_PersonaMastBN->getEmail();

                //informacion
                $s_TipoDocumento     = $o_VTA_DocumentoBN->getClienteTipoDoc();
                $s_ClienteDocumento  = $o_VTA_DocumentoBN->getClienteRUC();
                $s_ClienteNombre     = $o_VTA_DocumentoBN->getClienteNombre();
                $s_TipoDocumentoDesc = $o_VTA_DocumentoBN->getTipoDocumentoDesc();
                $s_TipoSerieNumero   = $o_VTA_DocumentoBN->getDocumentoTipoSerieNumero();

                $o_GSS_CompaniaFN = new GSS_CompaniaFN();
                $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $i_IdCompania );

                $s_EmpresaNumDocumento  = $o_GSS_CompaniaBN->getRuc();
                $s_EmpresaDireccion     = $o_GSS_CompaniaBN->getDireccionComun();
                $s_EmpresaInfoAdicional = $o_GSS_CompaniaBN->getDireccionAdicional();

                $this->realizarTransaccionSeriesVTA( $o_VTA_DocumentoBN, $o_VTA_OrdenBN );
            }

            //////////////////////////////////////////////////////////////////////////////////////////////////////
            if( $o_VTA_DocumentoBN )
            {
                $s_Observaciones = "Comprobante: ".$o_VTA_DocumentoBN->getDocumentoTipoSerieNumero()." Cotizacion: ".$o_VTA_DocumentoBN->getDocumentoParentCod()." | ".$s_Observaciones;
            }
            else
            {
                throw new Exception( "No se encontro el comprobante." );
            }

            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //direccion de Partida - personalizado
            if( $this->getRequestParameter( 'DepartamentoOrigen' ) )
            {
                $s_DepartamentoOrigen = MST_UbigeoFN::getDescripcionPorId( $this->getRequestParameter( 'DepartamentoOrigen' ) );
            }
            if( $this->getRequestParameter( 'ProvinciaOrigen' ) )
            {
                $s_ProvinciaOrigen = MST_UbigeoFN::getDescripcionPorId( $this->getRequestParameter( 'ProvinciaOrigen' ) );
            }
            if( $this->getRequestParameter( 'DistritoOrigen' ) )
            {
                $s_PuntoPartidaUbigeo = $this->getRequestParameter( 'DistritoOrigen' );
                $s_DistritoOrigen     = MST_UbigeoFN::getDescripcionPorId( $this->getRequestParameter( 'DistritoOrigen' ) );
            }
            if( $this->getRequestParameter( 'DireccionOrigen' ) )
            {
                $s_DireccionOrigen = $this->getRequestParameter( 'DireccionOrigen' );
            }
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //direccion de Destino - personalizado
            if( $this->getRequestParameter( 'DepartamentoDestino' ) )
            {
                $s_DepartamentoDestino = MST_UbigeoFN::getDescripcionPorId( $this->getRequestParameter( 'DepartamentoDestino' ) );
            }
            if( $this->getRequestParameter( 'ProvinciaDestino' ) )
            {
                $s_ProvinciaDestino = MST_UbigeoFN::getDescripcionPorId( $this->getRequestParameter( 'ProvinciaDestino' ) );
            }
            if( $this->getRequestParameter( 'DistritoDestino' ) )
            {
                $s_PuntoLlegadaUbigeo = $this->getRequestParameter( 'DistritoDestino' );
                $s_DistritoDestino    = MST_UbigeoFN::getDescripcionPorId( $this->getRequestParameter( 'DistritoDestino' ) );

                if( !$o_MST_PersonaMastBN->getDistrito() )
                {
                    $o_MST_PersonaMastDP = new MST_PersonaMastDP();
                    $o_MST_PersonaMastDP->setIdPersona( $o_MST_PersonaMastBN->getIdPersona() );
                    $o_MST_PersonaMastDP->setDepartamento( $this->getRequestParameter( 'DepartamentoDestino' ) );
                    $o_MST_PersonaMastDP->setProvincia( $this->getRequestParameter( 'ProvinciaDestino' ) );
                    $o_MST_PersonaMastDP->setDistrito( $this->getRequestParameter( 'DistritoDestino' ) );
                    $o_MST_PersonaMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_MST_PersonaMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_MST_PersonaMastDP->update();
                }
            }
            if( $this->getRequestParameter( 'DireccionDestino' ) )
            {
                $s_DireccionDestino = $this->getRequestParameter( 'DireccionDestino' );
                if( !$s_ClienteDireccion )
                {
                    $s_ClienteDireccion = $this->getRequestParameter( 'DireccionDestino' );
                }
            }
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //VALIDACIONES:
            if( !$s_DireccionOrigen )
            {
                throw new Exception( "Error en punto de partida direccion" );
            }
            if( !$s_PuntoPartidaUbigeo )
            {
                throw new Exception( "Error en ubigeo en punto de PARTIDA" );
            }
            if( !$s_PuntoLlegadaUbigeo )
            {
                throw new Exception( "Error en ubigeo en punto de LLEGADA" );
            }
            if( !$s_DireccionDestino )
            {
                throw new Exception( "Error en punto de llegada direccion" );
            }
            if( !$s_ClienteDireccion )
            {
                throw new Exception( "Error en el cliente direccion" );
            }
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            //se recupera los parametros
            $a_IdItem        = $this->getRequestParameter( "IdItem" );
            $a_Secuencia     = $this->getRequestParameter( "Secuencia" );
            $a_ProFinalId    = $this->getRequestParameter( "ProFinalId" );
            $a_ProFinalDetId = $this->getRequestParameter( "ProFinalDetId" );
            $a_IdUnidad      = $this->getRequestParameter( "IdUnidad" );
            $a_Cantidad      = $this->getRequestParameter( "Cantidad" );

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            $s_MotivoTrasladoId = $this->getRequestParameter( "MotivoTrasladoId" );

            $a_DataMotivo = SR_GuiaRemisionHBN::getArrayMotivoTraslado( $s_MotivoTrasladoId );
            $s_MotivoTrasladoProv = $a_DataMotivo['CodigoSunatPr'];

            $s_TipoDeTransporte   = $this->getRequestParameter( "TipoDeTransporteId" );
            $a_DataTipoTransporte = SR_GuiaRemisionHBN::getArrayTipoDeTransporte( $s_TipoDeTransporte );
            $s_TipoDeTransporteId = $a_DataTipoTransporte['CodigoSunatPr'];

            $i_IdChofer   = null;
            $i_IdVehiculo = null;

            $s_ConductorDocumentoTipo   = $this->getRequestParameter( "ConductorDocumentoTipo" ); //1 DNI | 6 = RUC  |
            $s_ConductorDocumentoNumero = utilString::eliminar_espacios( $this->getRequestParameter( "ConductorDocumentoNumero" ) );
            $s_ConductorDenominacion    = $this->getRequestParameter( "ConductorDenominacion" ); //nombre del conductor
            $s_ConductorNombre          = trim( $this->getRequestParameter( "ConductorNombre" ) ); //
            $s_ConductorApellido        = trim( $this->getRequestParameter( "ConductorApellido" ) ); //
            $s_ConductorNroLicencia     = trim( $this->getRequestParameter( "ConductorNroLicencia" ) ); //

            $s_TransportistaDocumentoTipo   = $this->getRequestParameter( "TransportistaDocumentoTipo" ); //1 DNI | 6 = RUC  |
            $s_TransportistaDocumentoNumero = utilString::eliminar_espacios( $this->getRequestParameter( "TransportistaDocumentoNumero" ) );
            $s_TransportistaDenominacion    = $this->getRequestParameter( "TransportistaDenominacion" ); //nombre del transportista
            $s_TransportistaPlacaNumero     = $this->getRequestParameter( "TransportistaPlacaNumero" );
            if( !$s_ConductorDenominacion )
            {
                $s_ConductorDenominacion = $s_ConductorNombre." ".$s_ConductorApellido;
            }

            if( $this->getRequestParameter( "TransporteDinamico" ) )
            {
                $i_IdChofer   = intval( $this->getRequestParameter( "IdChofer" ) );
                $i_IdVehiculo = intval( $this->getRequestParameter( "IdVehiculo" ) );

                $o_TR_VehiculoFN = new TR_VehiculoFN();
                $o_TR_VehiculoBN = $o_TR_VehiculoFN->selectByPK( $i_IdVehiculo );

                $s_TransportistaDocumentoTipo   = $o_TR_VehiculoBN->getTransportTipoDoc(); //1 DNI | 6 = RUC  |
                $s_TransportistaDocumentoNumero = $o_TR_VehiculoBN->getTransportNumDoc();
                $s_TransportistaDenominacion    = $o_TR_VehiculoBN->getTransportNombre(); //nombre del transportista
                $s_TransportistaPlacaNumero     = $o_TR_VehiculoBN->getVehiculoPlaca();

                $o_TR_ChoferFN = new TR_ChoferFN();
                $o_TR_ChoferBN = $o_TR_ChoferFN->selectByPK( $i_IdChofer );

                $s_ConductorDocumentoTipo   = $o_TR_ChoferBN->getChoferTipoDocumento(); //1 DNI | 6 = RUC  |
                $s_ConductorDocumentoNumero = $o_TR_ChoferBN->getChoferDocumento();
                $s_ConductorDenominacion    = $o_TR_ChoferBN->getChoferNombre()." ".$o_TR_ChoferBN->getChoferApellidoP()." ".$o_TR_ChoferBN->getChoferApellidoM(); //nombre del conductor
                $s_ConductorNombre          = $o_TR_ChoferBN->getChoferNombre();
                $s_ConductorApellido        = $o_TR_ChoferBN->getChoferApellidoP()." ".$o_TR_ChoferBN->getChoferApellidoM();
                $s_ConductorNroLicencia     = $o_TR_ChoferBN->getChoferLicencia();
            }
            if( $s_TransportistaDocumentoNumero == "" )
            {
                throw new Exception( "Es necesario el numero de documento del Transportista." );
            }
            if( $s_TransportistaDenominacion == "" )
            {
                throw new Exception( "Es necesario el nombre del Transportista." );
            }
            if( $s_ConductorDocumentoNumero == "" )
            {
                throw new Exception( "Es necesario el numero de documento del Conductor." );
            }
            if( $s_ConductorDocumentoTipo == "1" )
            {
                if( strlen( $s_ConductorDocumentoNumero ) < 8 )
                {
                    throw new Exception( "Es necesario el numero de documento del Conductor." );
                }
            }
            if( $s_ConductorDenominacion == "" && $s_TipoDeTransporte == "01" )
            {
                //throw new Exception( "Es necesario el nombre del Conductor." );
                $s_ConductorDenominacion = $s_ConductorNombre;
            }
            if( $s_ConductorNombre == "" )
            {
                throw new Exception( "Es necesario el nombre del Conductor." );
            }
            if( $s_ConductorApellido == "" )
            {
                throw new Exception( "Es necesario el apellido del Conductor." );
            }
            if( $s_ConductorNroLicencia == "" )
            {
                throw new Exception( "Es necesario la licencia del Conductor." );
            }
            if( strlen( $s_ConductorNroLicencia ) < 9 )
            {
                throw new Exception( "Número de Licencia de conducir del conductor es demasiado corto (9 caracteres mínimo)" );
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            //LUEGO DE LAS VALIDACIONES
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //PARA INCREMENTAR EL CORRELATIVO
            //if( $o_VTA_DocumentoBN->getIdTipoDocumento() == "FC" || $o_VTA_DocumentoBN->getIdTipoDocumento() == "BV" ) //SOLO DE DEBE DE INCRMENTAR CUANDO ES FACTURA Y BOLETA Q SUBE A LA SUNAT
            //{                                                                                                          //PARA NOTA DE VENTA NO DEBERIA DE INCREMENTAR, PERO EL CORRELATIVO ES LA CONCATENACION DE SERIE Y NUMERO, SE TIENE Q CAMBIAR :-(
            $o_TMP_VTA_DocumentoBN = new VTA_DocumentoBN();
            $o_TMP_VTA_DocumentoBN->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_TMP_VTA_DocumentoBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
            $o_TMP_VTA_DocumentoBN->setIdTipoDocumento( $s_Tipo );
            $o_TMP_VTA_DocumentoBN->setDocumentoSerie( $s_Serie );
            $o_TMP_VTA_DocumentoBN->setDocumentoNumero( $s_Numero );
            $o_TMP_VTA_DocumentoBN->setEsGuiaRemision( true );

            $o_OrdenVentaBL = new OrdenVentaBL();
            $o_OrdenVentaBL->incrementarDocumentoNumero( $o_TMP_VTA_DocumentoBN );
            $s_Numero = $o_TMP_VTA_DocumentoBN->getDocumentoNumero();
            //}
            //////////////////////////////////////////////////////////////////////////////////////////////////////

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            $f_SumaPesoTotal = 0;
            $f_NumeroBultos  = intval( $this->getRequestParameter( "TotalBulto" ) );
            if( $f_NumeroBultos <= 0 )
            {
                throw new Exception( "Es necesario la cantidad de Bultos." );
            }

            //$o_TMP_SR_GuiaRemisionHFN = new SR_GuiaRemisionHFN();
            //$o_TMP_SR_GuiaRemisionHBN = $o_TMP_SR_GuiaRemisionHFN->selectByPK( $s_ParentGuiaRemisionId );

            //ahora se registra la cabecera de la guia
            $s_NumeroGuiaConcat   = $s_Serie."-".$s_Numero;
            $s_GuiaRemisionId     = $s_Serie.$s_Numero;
            $o_SR_GuiaRemisionHDP = new SR_GuiaRemisionHDP();
            $o_SR_GuiaRemisionHDP->setGuiaRemisionId( $s_GuiaRemisionId );
            $o_SR_GuiaRemisionHDP->setIdCompania( $i_IdCompania );
            $o_SR_GuiaRemisionHDP->setIdSucursal( $i_IdSucursal );
            $o_SR_GuiaRemisionHDP->setTipoGuia( "DE" );
            $o_SR_GuiaRemisionHDP->setGuiaSerie( $s_Serie );
            $o_SR_GuiaRemisionHDP->setGuiaNumero( $s_Numero );
            $o_SR_GuiaRemisionHDP->setGuiaFecha( $s_FechaGuia );
            $o_SR_GuiaRemisionHDP->setFechaIniTraslado( $s_FechaInicioTraslado );
            $o_SR_GuiaRemisionHDP->setEstado( SR_GuiaRemisionHBN::ESTADO_COMPLETADO );
            //$o_SR_GuiaRemisionHDP->setEstadoDevolucion( SR_GuiaRemisionHBN::ESTADO_DEVOLUCION_PENDIENTE );
            $o_SR_GuiaRemisionHDP->setEstadoSunat( "P" );
            $o_SR_GuiaRemisionHDP->setComentario( $s_Observaciones );
            $o_SR_GuiaRemisionHDP->setConductorDocumentoTipo( ( int ) $s_ConductorDocumentoTipo ); //1 DNI | 6 = RUC  |
            $o_SR_GuiaRemisionHDP->setConductorDocumentoNumero( $s_ConductorDocumentoNumero );
            $o_SR_GuiaRemisionHDP->setConductorDenominacion( $s_ConductorDenominacion );
            $o_SR_GuiaRemisionHDP->setConductorNombre( $s_ConductorNombre );
            $o_SR_GuiaRemisionHDP->setConductorApellido( $s_ConductorApellido );
            $o_SR_GuiaRemisionHDP->setConductorNumeroLicencia( $s_ConductorNroLicencia );
            $o_SR_GuiaRemisionHDP->setTransportistaDocumentoTipo( ( int ) $s_TransportistaDocumentoTipo );  //1 DNI | 6 = RUC  |
            $o_SR_GuiaRemisionHDP->setTransportistaDocumentoNumero( $s_TransportistaDocumentoNumero );
            $o_SR_GuiaRemisionHDP->setTransportistaDenominacion( $s_TransportistaDenominacion );
            $o_SR_GuiaRemisionHDP->setTransportistaPlacaNumero( $s_TransportistaPlacaNumero );
            $o_SR_GuiaRemisionHDP->setPesoTotal( $f_SumaPesoTotal );
            $o_SR_GuiaRemisionHDP->setNumeroBultos( $f_NumeroBultos );
            $o_SR_GuiaRemisionHDP->setIdProyecto( $o_VTA_OrdenBN->getIdProyecto() );
            $o_SR_GuiaRemisionHDP->setOrdenTipoComercialId( $o_VTA_OrdenBN->getOrdenTipoComercialId() );
            $o_SR_GuiaRemisionHDP->setReferenciaParentId( $o_VTA_OrdenBN->getOrdenId() );
            $o_SR_GuiaRemisionHDP->setReferenciaParentNum( $o_VTA_OrdenBN->getOrdenNum() );
            $o_SR_GuiaRemisionHDP->setReferenciaIdTipoDocumento( $s_IdTipoDocumento );
            $o_SR_GuiaRemisionHDP->setReferenciaTipo( $s_DocumentoCod );
            $o_SR_GuiaRemisionHDP->setReferenciaNumero( $s_DocumentoSerie."-".$s_DocumentoNumero );
            $o_SR_GuiaRemisionHDP->setReferenciaNumeroDocumento( $s_NumeroDocumento );

            $o_SR_GuiaRemisionHDP->setEmpresaTipoDoc( "RUC" );
            $o_SR_GuiaRemisionHDP->setEmpresaNumDoc( $s_EmpresaNumDocumento );
            $o_SR_GuiaRemisionHDP->setEmpresaDireccion( $s_EmpresaDireccion );
            $o_SR_GuiaRemisionHDP->setEmpresaInfoAdicional( $s_EmpresaInfoAdicional );

            $o_SR_GuiaRemisionHDP->setMovimientoId( $s_IdMovimientoSerie );

            $s_FechaInicioAlq = $this->getRequestParameter( 'FechaInicioAlq' );
            $s_FechaFinAlq    = $this->getRequestParameter( 'FechaFinAlq' );
            $o_SR_GuiaRemisionHDP->setFechaInicioAlq( $s_FechaInicioAlq );
            $o_SR_GuiaRemisionHDP->setFechaFinAlq( $s_FechaFinAlq );

            $o_SR_GuiaRemisionHDP->setClienteNombre( $s_ClienteNombre );
            $o_SR_GuiaRemisionHDP->setClienteTipoDocumento( $s_TipoDocumento );
            $o_SR_GuiaRemisionHDP->setClienteNumDocumento( $s_ClienteDocumento );

            $o_SR_GuiaRemisionHDP->setDepartamentoOrigen( $s_DepartamentoOrigen );
            $o_SR_GuiaRemisionHDP->setProvinciaOrigen( $s_ProvinciaOrigen );
            $o_SR_GuiaRemisionHDP->setDistritoOrigen( $s_DistritoOrigen );
            $o_SR_GuiaRemisionHDP->setDireccionOrigen( $s_DireccionOrigen );
            $o_SR_GuiaRemisionHDP->setUbigeoOrigen( $s_PuntoPartidaUbigeo );
            $o_SR_GuiaRemisionHDP->setDepartamentoDestino( $s_DepartamentoDestino );
            $o_SR_GuiaRemisionHDP->setProvinciaDestino( $s_ProvinciaDestino );
            $o_SR_GuiaRemisionHDP->setDistritoDestino( $s_DistritoDestino );
            $o_SR_GuiaRemisionHDP->setDireccionDestino( $s_DireccionDestino );
            $o_SR_GuiaRemisionHDP->setUbigeoDestino( $s_PuntoLlegadaUbigeo );
            $o_SR_GuiaRemisionHDP->setIdChofer( $i_IdChofer );
            $o_SR_GuiaRemisionHDP->setIdVehiculo( $i_IdVehiculo );
            $o_SR_GuiaRemisionHDP->setMotivoTrasladoId( $s_MotivoTrasladoId );
            $o_SR_GuiaRemisionHDP->setModalidadTransporteId( $s_TipoDeTransporte );
            $o_SR_GuiaRemisionHDP->setFechaRegistro( date( "Y-m-d H:i:s" ) );
            $o_SR_GuiaRemisionHDP->setUsuarioRegistro( myUser::getUser()->getUserId() );
            $o_SR_GuiaRemisionHDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_SR_GuiaRemisionHDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_SR_GuiaRemisionHDP->save();

            //AHORA CUENTO CUANTAS GUIAS HAY POR LA COTIZACION
            $o_SR_GuiaRemisionHFN = new SR_GuiaRemisionHFN();
            //$o_SR_GuiaRemisionHFN->setReferenciaParentId( $o_VTA_OrdenBN->getOrdenId() );
            $o_SR_GuiaRemisionHFN->setIdProyecto( $o_VTA_OrdenBN->getIdProyecto() );
            $i_ContadorGuia = $o_SR_GuiaRemisionHFN->selectNumRows();

            //aqui se registra los detalles de la guia
            $a_TMP_VTA_DocumentoDetalle = array();
            $f_SumaPesoTotal            = 0;

            //se registra los detalles
            $o_SR_GuiaRemisionDetFN = new SR_GuiaRemisionDetFN();
            $o_SR_GuiaRemisionDetFN->setGuiaRemisionId( $s_ParentGuiaRemisionId );
            $o_SR_GuiaRemisionDetFN->addOrderBy( SR_GuiaRemisionDetFN::Secuencia );
            $a_SR_GuiaRemisionDet = $o_SR_GuiaRemisionDetFN->select();
            foreach( $a_SR_GuiaRemisionDet as $i_Key => $o_SR_GuiaRemisionDetBN )
            {
                $i_GuiaRemisionDetId = SR_GuiaRemisionDetDP::recuperarId();

                $o_SR_GuiaRemisionDetDP = new SR_GuiaRemisionDetDP();
                $o_SR_GuiaRemisionDetDP->setGuiaRemisionDetId( $i_GuiaRemisionDetId );
                $o_SR_GuiaRemisionDetDP->setGuiaRemisionId( $s_GuiaRemisionId );
                $o_SR_GuiaRemisionDetDP->setMovimientoId( $o_SR_GuiaRemisionDetBN->getMovimientoId() );
                $o_SR_GuiaRemisionDetDP->setIdItem( $o_SR_GuiaRemisionDetBN->getIdItem() );
                $o_SR_GuiaRemisionDetDP->setDescripcion( $o_SR_GuiaRemisionDetBN->getDescripcion() );
                $o_SR_GuiaRemisionDetDP->setSecuencia( $o_SR_GuiaRemisionDetBN->getSecuencia() );
                $o_SR_GuiaRemisionDetDP->setProFinalId( $o_SR_GuiaRemisionDetBN->getProFinalId() );
                $o_SR_GuiaRemisionDetDP->setProFinalDetId( $o_SR_GuiaRemisionDetBN->getProFinalDetId() );
                $o_SR_GuiaRemisionDetDP->setIdUnidad( $o_SR_GuiaRemisionDetBN->getIdUnidad() );
                $o_SR_GuiaRemisionDetDP->setCantidad( $o_SR_GuiaRemisionDetBN->getCantidad() );
                $o_SR_GuiaRemisionDetDP->setPesoUnitario( $o_SR_GuiaRemisionDetBN->getPesoUnitario() );
                $o_SR_GuiaRemisionDetDP->setPesoTotal( $o_SR_GuiaRemisionDetBN->getPesoTotal() );
                $o_SR_GuiaRemisionDetDP->save();
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        }
        catch ( Exception $o_Exception )
        {
            //pr( $o_Exception );
            $con->rollback();
            $a_Result['error'] = true;
            $a_Result['mensaje_error'] = $o_Exception->getMessage();
        }

        if( !$a_Result['error'] )
        {
            try
            {
                $o_iDespacho = new iDespacho();
                $a_Data = $o_iDespacho->enviarSunatGuiaRemision( $s_GuiaRemisionId );
                $a_Result['enlace_pdf'] = $a_Data['EnlaceDelPdf'];
                $a_Result['enlace_pdf'] = buildUrlComplet( "alm.php/transporte/printGuiaPDF", "Id=".$s_GuiaRemisionId );
                $con->commit();
            }
            catch ( Exception $o_Exception )
            {
                //pr( $o_Exception );
                $con->rollback();
                $a_Result['error'] = true;
                $a_Result['mensaje_error'] = $o_Exception->getMessage();
            }
        }

        echo json_encode( $a_Result );
        exit;
        return ViewResponse::NONE;
    }

    public function realizarTransaccionSeriesVTA( VTA_DocumentoBN $o_VTA_DocumentoBN, VTA_OrdenBN $o_VTA_OrdenBN )
    {
        if( $o_VTA_DocumentoBN )
        {
            //por ahora la referencia principal es la orden de venta
            if( $o_VTA_OrdenBN )
            {
                $a_VTA_OrdenDetalle = $o_VTA_OrdenBN->getArrayDetalles();
                foreach ( $a_VTA_OrdenDetalle as $o_VTA_OrdenDetalleBN )
                {
                    $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                    $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $o_VTA_OrdenDetalleBN->getItemCod() );

                    if( $o_VTA_OrdenDetalleBN->getItemTipo() != VTA_OrdenDetalleBN::TIPO_COMENTARIO )
                    {
                        if( $o_ALM_ItemMastBN->SiManejaSerie() )
                        {
                            $o_SR_MovimientoFN = new SR_MovimientoFN();
                            $o_SR_MovimientoFN->setTipoMovimiento( VTA_DocumentoBN::TRANSACCION_X_DEFECTO );
                            $o_SR_MovimientoFN->setOperacion( ALM_TransaccionCabeceraBN::TIPO_SALIDA );
                            $o_SR_MovimientoFN->setAlmacen( $o_VTA_DocumentoBN->getAlmacenDespacho() );
                            $o_SR_MovimientoFN->setReferenciaTipo( $o_VTA_DocumentoBN->getIdTipoDocumento() ); //OS
                            $o_SR_MovimientoFN->setReferenciaNumero( $o_VTA_DocumentoBN->getNumeroDocumento() ); //$o_VTA_OrdenBN->getOrdenNum()
                            //$o_SR_MovimientoFN->setReferenciaFecha( $o_VTA_OrdenBN->getOrdenFecha() );
                            $o_SR_MovimientoFN->setEstado( "C" );
                            $a_SR_Movimiento = $o_SR_MovimientoFN->select();
                            if( $a_SR_Movimiento )
                            {
                                $o_SR_MovimientoBN = $a_SR_Movimiento[0];

                                $o_SR_MovimientoDetalleBN = new SR_MovimientoDetalleBN();
                                $o_SR_MovimientoDetalleBN->setMovimientoId( $o_SR_MovimientoBN->getMovimientoId() );
                                $o_SR_MovimientoDetalleBN->setProductoId( $o_ALM_ItemMastBN->getIdItem() );

                                $o_SR_MovimientoBN->setMovimientoDetalleObject( $o_SR_MovimientoDetalleBN );

                                $o_SerieBL = new SerieBL();
                                $o_SerieBL->realizarTransaccionH( $o_SR_MovimientoBN );
                            }
                        }
                    }
                }
            }
        }
    }
}