<?php
$sDirBase = dirname(__FILE__).'/../../../../../';
require $sDirBase.'plugins/dompdf-master/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;
use Dompdf\FontMetrics;

class PrintGuiaPDFAction extends wtActions
{
    public function execute()
    {
        $s_Id = $this->getRequestParameter( 'Id' );

        $o_SR_GuiaRemisionHFN = new SR_GuiaRemisionHFN();
        $o_SR_GuiaRemisionHBN = $o_SR_GuiaRemisionHFN->selectByPK( $s_Id );

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $s_ConductorDocumentoTipo   = "-"; //1 DNI | 6 = RUC  |
        $s_ConductorDocumentoNumero = "-";
        $s_ConductorDenominacion    = "-"; //nombre del conductor

        $s_TransportistaDocumentoTipo   = "-"; //1 DNI | 6 = RUC  |
        $s_TransportistaDocumentoNumero = "-";
        $s_TransportistaDenominacion    = "-"; //nombre del transportista
        $s_TransportistaPlacaNumero     = "-";

        if( $o_SR_GuiaRemisionHBN->getConductorDenominacion() )
        {
            $s_ConductorDenominacion = $o_SR_GuiaRemisionHBN->getConductorDocumentoNumero()." ".$o_SR_GuiaRemisionHBN->getConductorDenominacion();
        }
        if( $o_SR_GuiaRemisionHBN->getTransportistaPlacaNumero() )
        {
            $s_TransportistaPlacaNumero = $o_SR_GuiaRemisionHBN->getTransportistaPlacaNumero();
        }
        if( $o_SR_GuiaRemisionHBN->getTransportistaDenominacion() )
        {
            $s_TransportistaDenominacion = $o_SR_GuiaRemisionHBN->getTransportistaDocumentoNumero()." ".$o_SR_GuiaRemisionHBN->getTransportistaDenominacion();
        }

        $i_IdChofer   = $o_SR_GuiaRemisionHBN->getIdChofer();
        $i_IdVehiculo = $o_SR_GuiaRemisionHBN->getIdVehiculo();

        if( $i_IdChofer )
        {
            $o_TR_ChoferFN = new TR_ChoferFN();
            $o_TR_ChoferBN = $o_TR_ChoferFN->selectByPK( $i_IdChofer );

            $s_ConductorDocumentoTipo   = "1"; //1 DNI | 6 = RUC  |
            $s_ConductorDocumentoNumero = $o_TR_ChoferBN->getChoferDocumento();
            $s_ConductorDenominacion    = $o_TR_ChoferBN->getChoferNombre()." ".$o_TR_ChoferBN->getChoferApellidoP()." ".$o_TR_ChoferBN->getChoferApellidoM(); //nombre del conductor
        }

        if( $i_IdVehiculo )
        {
            $o_TR_VehiculoFN = new TR_VehiculoFN();
            $o_TR_VehiculoBN = $o_TR_VehiculoFN->selectByPK( $i_IdVehiculo );

            $s_TransportistaPlacaNumero     = $o_TR_VehiculoBN->getVehiculoPlaca();
            $s_TransportistaDocumentoTipo   = "1";
            $s_TransportistaDocumentoNumero = $o_TR_ChoferBN->getChoferDocumento();
            $s_TransportistaDenominacion    = $o_TR_ChoferBN->getChoferNombre()." ".$o_TR_ChoferBN->getChoferApellidoP()." ".$o_TR_ChoferBN->getChoferApellidoM(); //nombre del conductor
        }
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $o_SR_GuiaRemisionHBN->getIdCompania() );

        $a_SR_GuiaRemisionDet = $o_SR_GuiaRemisionHBN->getArrayObjectDetalles();

        $f_SumaPesoTotal = 0;
        foreach( $a_SR_GuiaRemisionDet as $o_SR_GuiaRemisionDetBN )
        {
            $f_Cantidad       = $o_SR_GuiaRemisionDetBN->getCantidad();
            $o_ALM_ItemMastBN = $o_SR_GuiaRemisionDetBN->getObjectItem();
            $f_SumaPesoTotal = $f_SumaPesoTotal + ( $o_ALM_ItemMastBN->getPesoGramos() * $f_Cantidad );
        }
        ///////////////////////////////////////////////////////////////////////////


        //////////////////////////////////////////////////////////////////////////////////////

        $s_Class  = ParameterWR::getInstance()->getModule();
        $s_Module = strtolower( $s_Class );
        $s_Action = ParameterWR::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );

        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";

        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();

        //echo $html; exit;

        $dompdf = new Dompdf();
        $dompdf->loadHtml( $html );
        $dompdf->setPaper( 'A4', 'portrait' );
        $dompdf->render();

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /*$text = "ANULADO";
        $size = "75";
        $canvas = $dompdf->getCanvas();

        $options = new Options();
        $options->set( 'isPhpEnabled', 'true' );

        $fontMetrics = new FontMetrics( $canvas, $options );
        $font = $fontMetrics->getFont( 'times' );
        $txtHeight = $fontMetrics->getFontHeight( $font, 75);
        $textWidth = $fontMetrics->getTextWidth( $text, $font, 75 );

        $canvas->set_opacity( .3 );

        $w = $canvas->get_width();
        $h = $canvas->get_height();

        $x = ( ( $w - $textWidth ) /2 );
        $y = ( ( $h - $txtHeight ) / 2 );

        $canvas->text( $x, $y, $text, $font, $size, $color = array( 139, 0, 0), $word_space = 0.0, $char_space = 3.0, $angle = -10 );*/
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        $dompdf->stream( 'Guia_de_Remision_'.$o_SR_GuiaRemisionHBN->getGuiaSerieNumeroConcat(), array( "Attachment" => 0 ) );

        exit;
    }
}
