<!-- https://ourcodeworld.com/articles/read/687/how-to-configure-a-header-and-footer-in-dompdf -->
<?php
/**
 * @var ALM_TransferenciaCabeceraBN $o_DefaultBN
 */
?>
<html>
    <head>
        <style type="text/css">
            @page 
            {
                size: A4 portrait;
                margin: 0cm 0cm;
            }

            header 
            {
                position: fixed;
                top: 0cm;
                left: 0cm;
                right: 0cm;
                height: 3cm;
            }

            footer 
            {
                position: fixed; 
                bottom: 0cm; 
                left: 0cm; 
                right: 0cm;
                height: 2cm;
            }

            body 
            {
                margin-top: 0.5cm;
                margin-left: 0.5cm;
                margin-right: 0.5cm;
                margin-bottom: 2cm;
            }
        </style>
    </head>
    <body>

        <table style="text-align: left; width: 100%;" border="1" cellpadding="2" cellspacing="0">
            <tbody>
                <tr>
                    <td width="60%">
                        <table cellpadding="5" cellspacing="0" border="0" style="width: 100%">
                            <tr>
                                <td colspan="2" style="width: 30%" align="center"><img src="<?=$o_GSS_CompaniaBN->getLogoFileToPDF()?>" style="width: <?=$o_GSS_CompaniaBN->getLogoFileAncho()?>px; height: <?=$o_GSS_CompaniaBN->getLogoFileAlto()?>px;" ></td>
                            </tr>
                            <tr>
                                <td align="center">Emisi&oacute;n: <b><?=substr( $o_DefaultBN->getFechaDocumento(), 0, 10 )?></b></td>
                                <td align="center">Inicio del Traslado: <b><?=substr( $o_DefaultBN->getFechaDocumento(), 0, 10 )?></b></td>
                            </tr>
                        </table>
                        
                    </td>
                    <td width="40%">
                        <table cellpadding="5" cellspacing="0" border="0" style="width: 100%; font-size: 20px;">
                            <tr>
                                <td align="center" style="">
                                    <label>R.U.C <?=$o_GSS_CompaniaBN->getRuc()?></label>
                                </td>
                            </tr>
                            <tr>
                                <td align="center" style="">
                                    <b>GUIA DE REMISION</b>
                                </td>
                            </tr>
                            <tr>
                                <td align="center" style="">
                                    <b><?=$o_DefaultBN->getReferenciaSerieDocumento()?> - <?=$o_DefaultBN->getReferenciaNumeroDocumento()?></b>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
        </table>
        <br>
        <table style="width: 100%; text-align: left; margin-left: auto; margin-right: auto; margin-top: 10px;" border="0" cellpadding="2" cellspacing="2">
            <tr>
                <td style="text-align: center;" width="50%">
                    <fieldset style="margin-top:0px">
                        <legend >Punto de Partida</legend>
                        <table style="width: 100%; text-align: left; margin-left: auto; margin-right: auto;" border="0" cellpadding="2" cellspacing="2">
                            <tr>
                                <td>
                                    <b><?=$o_DefaultBN->getAlmacenOrigenDesc()?></b>
                                </td>
                            </tr>
                        </table>
                    </fieldset>
                </td>
                <td style="text-align: center;" width="50%">
                    <fieldset style="margin-top:0px">
                        <legend >Punto de Llegada</legend>
                        <table style="width: 100%; text-align: left; margin-left: auto; margin-right: auto;" border="0" cellpadding="2" cellspacing="2">
                            <tr>
                                <td>
                                    <b><?=$o_DefaultBN->getAlmacenDestinoDesc()?></b>
                                </td>
                            </tr>
                        </table>
                    </fieldset>
                </td>
            </tr>
        </table>
        <br>
        <table style="width: 100%; text-align: left; margin-left: auto; margin-right: auto;" border="0" cellpadding="0" cellspacing="0">
            <tr>
                <td style="text-align: center;" width="50%">
                    <fieldset style="margin-top:0px">
                        <legend >Motivo de Traslado</legend>
                        <table style="width: 100%; text-align: left; margin-left: auto; margin-right: auto;" border="0" cellpadding="2" cellspacing="2">
                            <tr>
                                <td>
                                    <b>Traslado entre Establecimientos de la misma empresa</b>
                                </td>
                            </tr>
                        </table>
                    </fieldset>            
                </td>
            </tr>
        </table>
        <br>
        <table style="width: 100%; text-align: left; margin-left: auto; margin-right: auto; " border="0" cellpadding="0" cellspacing="0">
            <tr>
                <td style="text-align: center;" width="50%">
                    <fieldset style="margin-top:0px">
                        <legend >Detalles</legend>
                        <table style="text-align: left; width: 100%; margin-top: 10px; border-bottom: 1px solid #000000; font-size:10px;" border="0" cellpadding="5" cellspacing="0">
                            <tbody>
                            <tr>
                                <th style="text-align: center; background-color: #D4D0C8; width: 2%;">#</th>
                                <th style="text-align: center; background-color: #D4D0C8; width: 8%;">C&oacute;digo</th>
                                <th style=" background-color: #D4D0C8; width: 35%;">Descripci&oacute;n</th>
                                <th style="text-align: center; background-color: #D4D0C8; width: 8%;">Cantidad</th>
                            </tr>
                            <?php
                            $a_ALM_TransferenciaDetalle = $o_DefaultBN->getArrayObjetosDetalles();
                            ?>
                            <?php if( $a_ALM_TransferenciaDetalle ){ ?>
                                <?php foreach ( $a_ALM_TransferenciaDetalle as $i_Key => $o_ALM_TransferenciaDetalleBN ){ ?>
                                    <tr>
                                        <td style="text-align: center;"><?=$i_Key+1?></td>
                                        <td style="text-align: center;"><?=$o_ALM_TransferenciaDetalleBN->getIdItem()?></td>
                                        <td><?=$o_ALM_TransferenciaDetalleBN->getDescripcionItem()?></td>
                                        <td style="text-align: center;"><?=$o_ALM_TransferenciaDetalleBN->getCantidad()?></td>
                                    </tr>
                                <?php } ?>
                            <?php } ?>
                            </tbody>
                        </table>
                    </fieldset>
                </td>
            </tr>
        </table>
        <br>
        <table style="width: 100%; text-align: left; margin-left: auto; margin-right: auto; margin-top: 10px;" border="0" cellpadding="2" cellspacing="2">
            <tr>
                <td style="text-align: center;" width="50%">
                    <fieldset style="margin-top:0px">
                        <legend >Responsable</legend>
                        <table style="width: 100%; text-align: left; margin-left: auto; margin-right: auto;" border="0" cellpadding="2" cellspacing="2">
                            <tr>
                                <td>
                                    <b><?=$o_DefaultBN->getResponsableTraslado()?></b>
                                </td>
                            </tr>
                        </table>
                    </fieldset>
                </td>
            </tr>
        </table>
        <table style="width: 100%; text-align: left; margin-left: auto; margin-right: auto; margin-top: 10px;" border="0" cellpadding="2" cellspacing="2">
            <tr>
                <td style="text-align: center;" width="50%">
                    <fieldset style="margin-top:0px">
                        <legend >Comentario</legend>
                        <table style="width: 100%; text-align: left; margin-left: auto; margin-right: auto;" border="0" cellpadding="2" cellspacing="2">
                            <tr>
                                <td>
                                    <b><?=$o_DefaultBN->getComentario()?></b>
                                </td>
                            </tr>
                        </table>
                    </fieldset>
                </td>
            </tr>
        </table>
        <!--<table style="width: 100%; text-align: left; margin-left: auto; margin-right: auto; margin-top: 10px;" border="0" cellpadding="2" cellspacing="2">
            <tr>
                <td style="text-align: center;" width="50%">
                    <fieldset style="margin-top:0px">
                        <legend >Datos del Transportista</legend>
                        <table style="width: 100%; text-align: left; margin-left: auto; margin-right: auto;" border="0" cellpadding="2" cellspacing="2">
                            <tr>
                                <td>
                                    Apellidos y Nombres:<br>
                                    <b><?/*=$o_DefaultBN->getResponsableTraslado()*/?></b>
                                </td>
                            </tr>
                        </table>
                    </fieldset>            
                </td>
                <td style="text-align: center;" width="50%">
                    <fieldset style="margin-top:0px">
                        <legend >Datos de la Unidad de Transporte y Conductor</legend>
                        <table style="width: 100%; text-align: left; margin-left: auto; margin-right: auto;" border="0" cellpadding="2" cellspacing="2">
                            <tr>
                                <td>
                                    Marca y Placa:<br>
                                    <b><?/*=$o_DefaultBN->getVehiculoMarca()*/?> <?/*=$o_DefaultBN->getVehiculoPlaca()*/?></b>
                                </td>
                                <td>
                                    Licencia de Conducir:<br>
                                    <b><?/*=$o_DefaultBN->getLicenciaConducir()*/?></b>
                                </td>
                            </tr>
                        </table>
                    </fieldset>            
                </td>
            </tr>
        </table>-->

        <BR><BR>
        <BR><BR>

        <table style="width: 100%; text-align: center; margin-left: auto; margin-right: auto;" border="0" cellpadding="0" cellspacing="0">
            <tr>
                <td style="text-align: center;">
                    <table cellpadding="0" cellspacing="0" border="0" width="100%">
                        <tr>
                            <td width="5%">&nbsp;</td>
                            <td width="20%">&nbsp;</td>
                            <td width="5%">&nbsp;</td>
                            <td width="20%">&nbsp;</td>
                            <td width="5%">&nbsp;</td>
                            <td width="20%">&nbsp;</td>
                            <td width="5%">&nbsp;</td>
                        </tr>
                        <tr><td colspan="6">&nbsp;</td></tr>
                        <tr><td colspan="6">&nbsp;</td></tr>
                        <tr>
                            <td>&nbsp;</td>
                            <td align="center" style="border-top: 2px solid #000000; font-size: 12px;"><?=myUser::getUser()->getObjectUsuario()->getUsuarioNombre()?></td>
                            <td>&nbsp;</td>
                            <td align="center" style="border-top: 2px solid #000000; font-size: 12px;">RESPONSABLE</td>
                            <td>&nbsp;</td>
                            <td align="center" style="border-top: 2px solid #000000; font-size: 12px;">CONFORMIDAD</td>
                            <td>&nbsp;</td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </body>