<?php use_helper('UrlFunctions'); ?>
<?php use_helper( 'IncludePartial' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>

<style type="text/css">
    .table td, .table th
    {
        /*padding: 8px;*/
        font-size: 13px;
    }
    th { white-space: nowrap; }

</style>

<style type="text/css">
    /*
    .table td, .table th
    {
        font-size: 13px;
    }
    th { white-space: nowrap; }
    */

    fieldset.scheduler-border
    {
        border: 1px solid #ccc !important;
        padding: 0 0.5em 0.5em 0.5em !important;
        margin: 0 0 0.5em 0 !important;
        -webkit-box-shadow: 0px 0px 0px 0px #000;
        box-shadow: 0px 0px 0px 0px #000;
    }

    legend.scheduler-border
    {
        font-size: 1em !important;
        font-weight: bold !important;
        text-align: left !important;
        width: auto;
        padding: 0 5px;
        border-bottom: none;
        margin-bottom: 0;
    }

</style>

<div class="shadow-sm p-3 mb-2 bg-white rounded card card-body">
    <div class="row">
        <div class="col mb-1">
            <h4 class="text-info text-nowrap mb-0">Registro de Importaciones</h4>
        </div>
        <?php if( $o_COM_ImportacionCabeceraBN->getEstado() != COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_COMPLETADO ){ ?>
        <div class="col-md-8 text-right">
            <button type="button" class="btn btn-outline-primary" onclick="location.href='<?=buildUrl( 'import/list' ) ?>'">LISTADO</button>
        </div>
        <?php } ?>
    </div>
</div>

<div class="marco">
    <?php
    include_partial
    (
        "infohead",
        array(
            "o_COM_OrdenCompraCabeceraBN"    => $o_COM_OrdenCompraCabeceraBN,
            "o_GSS_CompaniaBN"               => $o_GSS_CompaniaBN,
            "o_COM_OrdenItemClasificacionBN" => $o_COM_OrdenItemClasificacionBN,
            "o_GSS_MonedaMastBN"             => $o_GSS_MonedaMastBN,
            "o_ALM_AlmacenMastBN"            => $o_ALM_AlmacenMastBN,
        ),
        array( "Module"=>"oc" )
    );
    ?>
</div>

<div class="dropdown-divider"></div>

<div id="content_alert"></div>

<script>
    guardarFormularioImport = function ()
    {
        x = confirm( "Esta seguro de guardar?" );
        if( x )
        {
            blockContent( 'content_data_import' );
            var strFormSerialize = $( '#form1' ).serialize();

            executeAjaxJson
            (
                "<?php echo buildUrl( 'import/guardarFormularioImport', "" ) ?>",
                strFormSerialize,
                function( o_json )
                {
                    unBlockContent( 'content_data_import' );
                    if( o_json.error )
                    {
                        showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                        //mostrarMensajeError( o_json.mensaje_error );
                        return false;
                    }

                    //$( '#form2' )[0].reset();
                }
            );
        }
        return false;
    }

    completarImportacion = function()
    {
        x = confirm( "Esta seguro de Terminar la Importacion?" );
        if( x )
        {
            blockContent( 'content_data_import' );
            blockContent( 'content_gastos' );
            blockContent( 'content_grid_det' );

            var strFormSerialize = "Id=<?=$s_Id?>";

            executeAjaxJson
            (
                "<?php echo buildUrl( 'import/terminarProcesoImport', "" ) ?>",
                strFormSerialize,
                function( o_json )
                {
                    unBlockContent( 'content_data_import' );
                    unBlockContent( 'content_gastos' );
                    unBlockContent( 'content_grid_det' );

                    if( o_json.error )
                    {
                        showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                        //mostrarMensajeError( o_json.mensaje_error );
                        return false;
                    }

                    location.reload();
                }
            );
        }
        return false;
    }
</script>
<div class="card" id="content_data_import">
    <form class="" name="form1" id="form1" method="POST" action="" onsubmit="return guardarFormularioImport();">
        <input type="hidden" name="ConcatIdOC" value="<?=$s_Id?>" >
        <div class="form-row mx-0">
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="DuaSerie">No DUA</label>
                <div class="form-inline">
                    <select class="form-control w-25" name="DuaSerie" id="DuaSerie" required="">
                        <?php foreach( MST_AduanaFN::selectActivos() as $o_MST_AduanaBN ){ ?>
                        <option value="<?=$o_MST_AduanaBN->getId()?>" <?php if( $o_COM_ImportacionCabeceraBN->getDuaSerie() == $o_MST_AduanaBN->getId() ){ echo "SELECTED"; } ?> ><?=$o_MST_AduanaBN->getId()?> - <?=$o_MST_AduanaBN->getDescripcion()?></option>
                        <?php } ?>
                    </select>
                    <input type="text" class="form-control w-75 text-center" name="DuaNumero" id="DuaNumero" value="<?=$o_COM_ImportacionCabeceraBN->getDuaNumero()?>" placeholder="Numero" autocomplete="off" onfocus="this.select()" required>
                </div>
            </div>
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="DuaPagoFecha">Fecha Pago DUA</label>
                <input type="text" class="form-control text-center" name="DuaPagoFecha" id="DuaPagoFecha" value="<?=$o_COM_ImportacionCabeceraBN->getDuaPagoFecha()?>" autocomplete="off" required>
                <script type="text/javascript">
                    $( "#DuaPagoFecha" ).datepicker( { dateFormat: "yy-mm-dd", changeYear:true, yearRange: "-1:+1", changeMonth: true, onClose: function (){ this.focus(); } } );
                    $( "#DuaPagoFecha" ).blur
                    (
                        function ( elm )
                        {
                            if( $( elm.target ).val().trim() != "" )
                            {
                                blockContent( 'content_tipo_cambio' );
                                var strFormSerialize = "Fecha=" + $( "#DuaPagoFecha" ).val();
                                executeAjaxJson
                                (
                                    "<?php echo buildUrl( 'fact/requestFactAlm', 'TipoProc=BuscarTipoCambio' ) ?>",
                                    strFormSerialize,
                                    function( o_json )
                                    {
                                        unBlockContent( 'content_tipo_cambio' );

                                        $( "#TipoCambio" ).val( o_json.TipoCambio );
                                        $( "#TipoCambio2" ).val( o_json.TipoCambio );
                                    }
                                );
                            }
                        }
                    );
                </script>
            </div>
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="InvoiceSerie">No Invoice</label>
                <div class="form-inline">
                    <input type="text" class="form-control w-25 text-center" name="InvoiceSerie" id="InvoiceSerie" value="<?=$o_COM_ImportacionCabeceraBN->getInvoiceSerie()?>" placeholder="Serie" autocomplete="off" onfocus="this.select()" required>
                    <input type="text" class="form-control w-75 text-center" name="InvoiceNumero" id="InvoiceNumero" value="<?=$o_COM_ImportacionCabeceraBN->getInvoiceNumero()?>" placeholder="Numero" autocomplete="off" onfocus="this.select()" required>
                </div>
            </div>
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="InvoiceFecha">Fecha Invoice</label>
                <input type="text" class="form-control text-center" name="InvoiceFecha" id="InvoiceFecha" value="<?=$o_COM_ImportacionCabeceraBN->getInvoiceFecha()?>" autocomplete="off" required>
                <script type="text/javascript">
                    $( "#InvoiceFecha" ).datepicker( { dateFormat: "yy-mm-dd", changeYear:true, yearRange: "-1:+1", changeMonth: true, onClose: function (){ this.focus(); } } );
                </script>
            </div>
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="DuaNroOrden">No Orden DUA</label>
                <input type="text" class="form-control text-center" name="DuaNroOrden" id="DuaNroOrden" value="<?=$o_COM_ImportacionCabeceraBN->getDuaNroOrden()?>" autocomplete="off" onfocus="this.select()" required>
            </div>
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="IncotermsCod">Incoterms</label>
                <select class="form-control" name="IncotermsCod" id="IncotermsCod" required="" onchange="identificarExwork();">
                    <?php foreach( COM_ImportacionCabeceraBN::getArrayIncoterms() as $s_Cod => $s_Desc ){ ?>
                        <option value="<?=$s_Cod?>" <?php if( $o_COM_ImportacionCabeceraBN->getIncotermsCod() == $s_Cod ){ echo "SELECTED"; } ?> ><?=$s_Cod?> - <?=$s_Desc?></option>
                    <?php } ?>
                </select>
            </div>
        </div>

        <script>
            identificarExwork  = function()
            {
                if( $( "#IncotermsCod" ).val() == "EXW" )
                {
                    $( "#content_exwork" ).show();
                }
                else
                {
                    $( '#TotalTransPuerto' ).val( '0' );
                    $( '#TotalEmicionBL' ).val( '0' );
                    $( '#TotalOtrosGastosEXW' ).val( '0' );

                    $( "#content_exwork" ).hide();
                }

                actualizarTotalCIF();
            }

            actualizarTotalCIF = function()
            {
                var TotalFOB    = floatval( '<?=$o_COM_OrdenCompraCabeceraBN->getMontoBruto()?>' );
                var TotalFlete  = floatval( $( "#TotalFlete" ).val() );
                var TotalSeguro = floatval( $( "#TotalSeguro" ).val() );

                var TotalTransPuerto    = floatval( $( "#TotalTransPuerto" ).val() );
                var TotalEmicionBL      = floatval( $( "#TotalEmicionBL" ).val() );
                var TotalOtrosGastosEXW = floatval( $( "#TotalOtrosGastosEXW" ).val() );

                $( "#TotalCIF" ).val( number_format( TotalFOB + TotalFlete + TotalSeguro + TotalTransPuerto + TotalEmicionBL + TotalOtrosGastosEXW, 2 ) );
            }
        </script>

        <div class="form-row mx-0" id="content_exwork" style="display: none;" >
            <div class="col-md-2 mb-1">
                &nbsp;
            </div>
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="TotalTransPuerto">Transporte al Puerto</label>
                <input type="text" class="form-control text-right" name="TotalTransPuerto" id="TotalTransPuerto" value="<?=$o_COM_ImportacionCabeceraBN->getTotalTransPuerto()?>" onblur="actualizarTotalCIF();" autocomplete="off" onfocus="this.select()" >
            </div>
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="TotalEmicionBL">Emici&oacute;n de BL</label>
                <input type="text" class="form-control text-right" name="TotalEmicionBL" id="TotalEmicionBL" value="<?=$o_COM_ImportacionCabeceraBN->getTotalEmicionBL()?>" onblur="actualizarTotalCIF();" autocomplete="off" onfocus="this.select()" >
            </div>
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="TotalOtrosGastosEXW">Otros Gastos EXW</label>
                <input type="text" class="form-control text-right" name="TotalOtrosGastosEXW" id="TotalOtrosGastosEXW" value="<?=$o_COM_ImportacionCabeceraBN->getTotalOtrosGastosEXW()?>" onblur="actualizarTotalCIF();" autocomplete="off" onfocus="this.select()" >
            </div>
        </div>

        <div class="form-row mx-0">
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="TotalFOB">FOB</label>
                <input type="text" class="form-control text-right" name="TotalFOB" id="TotalFOB" value="<?=number_format( ( $o_COM_OrdenCompraCabeceraBN->getMontoBruto() ), 2 )?>" autocomplete="off" readonly>
            </div>
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="TotalFlete">Flete</label>
                <input type="text" class="form-control text-right" name="TotalFlete" id="TotalFlete" value="<?=$o_COM_ImportacionCabeceraBN->getTotalFlete()?>" autocomplete="off" onblur="actualizarTotalCIF();" onfocus="this.select()" required>
            </div>
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="TotalSeguro">Seguro</label>
                <input type="text" class="form-control text-right" name="TotalSeguro" id="TotalSeguro" value="<?=$o_COM_ImportacionCabeceraBN->getTotalSeguro()?>" autocomplete="off" onblur="actualizarTotalCIF();" onfocus="this.select()" required>
            </div>
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="TotalCIF">CIF</label>
                <input type="text" class="form-control text-right" name="TotalCIF" id="TotalCIF" value="<?=number_format( $o_COM_ImportacionCabeceraBN->getTotalCIF(), 2 )?>" autocomplete="off" readonly>
            </div>
            <div class="col-md-2 mb-1" id="content_tipo_cambio">
                <label class="col-form-label" for="TipoCambio">Tipo Cambio</label>
                <div class="input-group mb-0 " >
                    <input type="text" class="form-control text-right" name="TipoCambio" id="TipoCambio" value="<?=$o_COM_ImportacionCabeceraBN->getTipoCambio()?>" autocomplete="off" readonly>
                    <div class="input-group-append">
                        <button class="btn btn-outline-secondary" id="btnBuscarTipoCambio" type="button">...</button>
                        <script type="text/javascript">
                            $( "#btnBuscarTipoCambio" )
                                .click
                                (
                                    function()
                                    {
                                        blockContent( 'content_tipo_cambio' );
                                        var strFormSerialize = "fecha=" + $( "#DuaPagoFecha" ).val();
                                        executeAjaxJson
                                        (
                                            "<?php echo buildUrlComplet( 'vta/pro/request', 'TipoProc=registrar_tc' ) ?>",
                                            strFormSerialize,
                                            function( o_json )
                                            {
                                                unBlockContent( 'content_tipo_cambio' );
                                                //location.reload();
                                                $( "#TipoCambio" ).val( o_json.f_SunatVenta );
                                                $( "#TipoCambio2" ).val( o_json.f_SunatVenta );
                                            }
                                        );
                                    }
                                );
                        </script>
                    </div>
                </div>
            </div>
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="PaisProcedenciaCod">Pa&iacute;s de Procedencia</label>
                <select class="form-control" name="PaisProcedenciaCod" id="PaisProcedenciaCod" required="">
                    <option value=""> - Seleccione - </option>
                    <?php foreach( MST_PaisFN::selectActivos() as $o_MST_PaisBN ){ ?>
                        <option value="<?=$o_MST_PaisBN->getId()?>" <?php if( $o_COM_ImportacionCabeceraBN->getPaisProcedenciaCod() == $o_MST_PaisBN->getId() ){ echo "SELECTED"; } ?> > <?=$o_MST_PaisBN->getNombre()?> </option>
                    <?php } ?>
                </select>
            </div>
        </div>

        <script>
            actualizarTotalIGV = function()
            {
                var TotalIPM   = floatval( $( "#TotalIPM2" ).val() );
                var TotalIGV16 = floatval( $( "#TotalIGV16" ).val() );
                $( "#SumaTotalIGV" ).val( number_format( TotalIPM + TotalIGV16, 2 ) );
            }
        </script>

        <div class="form-row mx-0">
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="TotalAdValorem">Ad-Valorem</label>
                <input type="text" class="form-control text-right" name="TotalAdValorem" id="TotalAdValorem" value="<?=$o_COM_ImportacionCabeceraBN->getTotalAdValorem()?>" autocomplete="off" onfocus="this.select()" required>
            </div>
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="TotalIPM2">IPM 2%</label>
                <input type="text" class="form-control text-right" name="TotalIPM2" id="TotalIPM2" value="<?=$o_COM_ImportacionCabeceraBN->getTotalIPM2()?>" onblur="actualizarTotalIGV();" autocomplete="off" onfocus="this.select()" required>
            </div>
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="TotalIGV16">IGV 16%</label>
                <input type="text" class="form-control text-right" name="TotalIGV16" id="TotalIGV16" value="<?=$o_COM_ImportacionCabeceraBN->getTotalIGV16()?>" onblur="actualizarTotalIGV();" autocomplete="off" onfocus="this.select()" required>
            </div>
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="SumaTotalIGV">Total IGV</label>
                <input type="text" class="form-control text-right" name="SumaTotalIGV" id="SumaTotalIGV" value="<?=number_format( $o_COM_ImportacionCabeceraBN->getSumaTotalIGV(), 2 )?>" autocomplete="off" readonly>
            </div>
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="TotalServicioDespacho">Servicio Despacho</label>
                <input type="text" class="form-control text-right" name="TotalServicioDespacho" id="TotalServicioDespacho" value="<?=$o_COM_ImportacionCabeceraBN->getTotalServicioDespacho()?>" autocomplete="off" onfocus="this.select()" required>
            </div>
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="TotalPercepcion">Percepcion 3.5%</label>
                <input type="text" class="form-control text-right" name="TotalPercepcion" id="TotalPercepcion" value="<?=$o_COM_ImportacionCabeceraBN->getTotalPercepcion()?>" autocomplete="off" onfocus="this.select()" required>
            </div>
        </div>

        <?php if( $o_COM_ImportacionCabeceraBN->getEstado() != COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_COMPLETADO ){ ?>
        <div class="dropdown-divider"></div>

        <div class="form-row mx-0">
            <div class="col-md-6 mb-1">
                <button type="submit" class="btn btn-primary btn-block">GUARDAR</button>
            </div>
            <div class="col-md-6 mb-1">
                <button type="button" class="btn btn-primary btn-block" onclick="completarImportacion();">COMPLETAR</button>
            </div>
        </div>
        <?php } ?>
    </form>
</div>

<div class="dropdown-divider"></div>

<div id="content_alert2"></div>

<script>
    guardarGastosImport = function ()
    {
        x = confirm( "Esta seguro de guardar?" );
        if( x )
        {
            blockContent( 'content_gastos' );
            var strFormSerialize = $( '#form2' ).serialize();

            executeAjaxJson
            (
                "<?php echo buildUrl( 'import/guardarGastosImport', "" ) ?>",
                strFormSerialize,
                function( o_json )
                {
                    unBlockContent( 'content_gastos' );
                    if( o_json.error )
                    {
                        showAlertBootStrap( 'content_alert2', 'alert-danger', o_json.mensaje_error );
                        //mostrarMensajeError( o_json.mensaje_error );
                        return false;
                    }

                    $( '#form2' )[0].reset();
                    buscarGridGastosImportacion();
                }
            );
        }
        return false;
    }

    calcularConversionMontoGastos = function( tipo )
    {
        var TipoCambio = parseFloat( $( "#TipoCambio2" ).val() );

        var MontoSoles   = 0;
        var MontoDolares = 0;

        if( tipo )
        {
            if( $( "#MontoSoles" ).val().trim() != "" )
            {
                MontoSoles = parseFloat($("#MontoSoles").val());
                MontoDolares = redondear( ( MontoSoles / TipoCambio ), 2);
            }
        }
        else
        {
            if( $( "#MontoDolares" ).val().trim() != "" )
            {
                MontoDolares = parseFloat($("#MontoDolares").val());
                MontoSoles = redondear((MontoDolares * TipoCambio), 2);
            }
        }

        $( "#MontoSoles" ).val( MontoSoles );
        $( "#MontoDolares" ).val( MontoDolares );
    }

    buscarGridGastosImportacion = function()
    {
        blockContent( "content_grid_gastos" );

        var a_Params = [];
        a_Params.push( "Id=<?=$s_Id?>" );

        executeAjaxUpdater
        (
            "content_grid_gastos",
            "<?php echo buildUrl( 'import/gridGastosImport' ) ?>",
            a_Params.join( "&" ),
            function( response )
            {

            }
        );
    }

    eliminarGastoImportDet = function( IdOC, IdDet )
    {
        x = confirm( "Esta seguro de eliminar?" );
        if( x )
        {
            blockContent( 'content_gastos' );
            var strFormSerialize = "IdOC=" + IdOC + "&IdDet=" + IdDet;

            executeAjaxJson
            (
                "<?php echo buildUrl( 'import/eliminarGastosImport', "" ) ?>",
                strFormSerialize,
                function( o_json )
                {
                    unBlockContent( 'content_gastos' );
                    if( o_json.error )
                    {
                        showAlertBootStrap( 'content_alert2', 'alert-danger', o_json.mensaje_error );
                        //mostrarMensajeError( o_json.mensaje_error );
                        return false;
                    }

                    buscarGridGastosImportacion();
                }
            );
        }
        return false;
    }
</script>
<fieldset class="scheduler-border" id="content_gastos">
    <legend class="scheduler-border">Gatos de la Importaci&oacute;n</legend>
    <form class="" name="form2" id="form2" method="POST" action="" onsubmit="return guardarGastosImport();">

        <?php if( $o_COM_ImportacionCabeceraBN->getEstado() != COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_COMPLETADO ){ ?>
        <input type="hidden" name="ConcatIdOC" value="<?=$s_Id?>" >
        <div class="form-row mx-0">
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="TipoGastoId">Tipo de Gasto</label>
                <select class="form-control" name="TipoGastoId" id="TipoGastoId" required="">
                    <?php foreach( COM_GastosImportacionDetBN::getArrayTipoGastos() as $s_TipoCod => $s_TipoDesc ){ ?>
                        <option value="<?=$s_TipoCod?>" > <?=$s_TipoDesc?> </option>
                    <?php } ?>
                </select>
            </div>
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="TipoCambio2">Tipo Cambio</label>
                <input type="text" class="form-control text-right" name="TipoCambio" id="TipoCambio2" value="<?=$o_COM_ImportacionCabeceraBN->getTipoCambio()?>" autocomplete="off" readonly>
            </div>
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="MontoDolares">Monto Dolares</label>
                <input type="text" class="form-control text-right" name="MontoDolares" id="MontoDolares" value="" autocomplete="off" onfocus="this.select()" onblur="calcularConversionMontoGastos(0);" required>
            </div>
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="MontoSoles">Monto Soles</label>
                <input type="text" class="form-control text-right" name="MontoSoles" id="MontoSoles" value="" autocomplete="off" onfocus="this.select()" onblur="calcularConversionMontoGastos(1);" required>
            </div>
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="TipoGastoDescripcion">Descripci&oacute;n</label>
                <input type="text" class="form-control text-left" name="TipoGastoDescripcion" id="TipoGastoDescripcion" value="" autocomplete="off" onfocus="this.select()" onblur="this.value=this.value.toUpperCase();" required>
            </div>
            <div class="col-md-2 mb-1">
                <div class="form-row mx-0">
                    <div class="col-md-6 mb-1">
                        <button type="reset" class="btn btn-danger btn-block" onclick="buscarGridGastosImportacion();">LIMPIAR</button>
                    </div>
                    <div class="col-md-6 mb-1">
                        <button type="submit" class="btn btn-primary btn-block" id="" >GUARDAR</button>
                    </div>
                </div>
            </div>
        </div>
        <?php } ?>

        <div class="table-responsive" id="content_grid_gastos">
            <table style="margin-bottom: 0;" class="table table-sm table-bordered table-hover" id="">
                <thead >
                <tr class="table-primary">
                    <th width="1%"  style="text-align: center" ><b>No</b></th>
                    <th width="10%" style="text-align: center" ><b>Tipo</b></th>
                    <th width="20%" style="text-align: left" ><b>Descripci&oacute;n</b></th>
                    <th width="10%" style="text-align: center" ><b>Tipo de Cambio</b></th>
                    <th width="10%" align=""><b>Monto Dolares</b></th>
                    <th width="10%" style="text-align: center" ><b>Monto Soles</b></th>
                    <th width="10%" style="text-align: center" ><b>Opciones</b></th>
                </tr>
                </thead>
            </table>
        </div>
    </form>

</fieldset>

<div class="dropdown-divider"></div>
<br>

<div id="content_grid_det">
    <div class="table-responsive">
        <nav>
            <div class="nav nav-tabs" id="myTab" role="tablist">
                <a class="nav-item nav-link active" id="nav-home-tab" data-toggle="tab" href="#nav-home" role="tab" aria-controls="nav-home" aria-selected="true">Detalles de Importaci&oacute;n</a>
                <a class="nav-item nav-link" id="nav-file-tab" data-toggle="tab" href="#nav-file" role="tab" aria-controls="nav-file" aria-selected="false">Costeo Importaci&oacute;n</a>
            </div>
        </nav>
    </div>

    <div class="tab-content" id="nav-tabContent">
        <div class="tab-pane fade show active" id="nav-home" role="tabpanel" aria-labelledby="nav-home-tab">
            <div class="" style="border-left: 1px solid rgba(0,0,0,.125); border-right: 1px solid rgba(0,0,0,.125); border-bottom: 1px solid rgba(0,0,0,.125); padding: 10px;">

                <div class="table-responsive">
                    <table style="margin-bottom: 0;" class="table table-sm table-bordered table-hover" id="example">
                        <thead id="">
                        <tr class="table-primary">
                            <th width="1%"  style="text-align: center" ><b>No</b></th>
                            <th width="8%" style="text-align: center" ><b>C&oacute;digo</b></th>
                            <!--<th width="8%" style="text-align: center" ><b>S.K.U.</b></th>-->
                            <th width="35%" align=""><b>Descripci&oacute;n</b></th>
                            <th width="8%" style="text-align: center" ><b>Tipo</b></th>
                            <th width="8%" style="text-align: center" ><b>Cantidad</b></th>
                            <th width="8%" style="text-align: center" ><b>Precio</b></th>
                            <th width="8%" style="text-align: center" ><b>Total</b></th>
                        </tr>
                        </thead>

                        <tbody id="content_all_row">
                        <?php $f_MontoTotal = 0.00 ?>
                        <?php foreach ( $a_COM_OrdenCompraDetalle as $i_Key => $o_COM_OrdenCompraDetalleBN ){ ?>
                            <?php

                            ?>
                            <tr class="content_row">
                                <td  align="center"><?=( $i_Key + 1 )?></td>
                                <td  align="center" style="cursor:pointer; color:#2743B2; text-decoration:underline;" onclick="buscarResumenStock( $( this ).html() );"><?=$o_COM_OrdenCompraDetalleBN->getIdItem()?></td>
                                <!--<td  align="" id="">
                                    <input type="text" class="form-control text-center" name="" id="" value="" autocomplete="off" onfocus="this.select()" >
                                </td>-->
                                <td  align="" id=""><?=$o_COM_OrdenCompraDetalleBN->getDescripcion()?></td>
                                <td  align="center"><?=$o_COM_OrdenCompraDetalleBN->getObjectItem()->getObjectTipoItem()->getDescripcionLocal()?></td>
                                <td  align="center"><?=number_format( $o_COM_OrdenCompraDetalleBN->getCantidadPedida(), 2 )?></td>
                                <td  align="center"><?=number_format( $o_COM_OrdenCompraDetalleBN->getPrecioUnitario(), 2 )?></td>
                                <td  align="center"><?=number_format( $o_COM_OrdenCompraDetalleBN->getSubTotal(), 2 )?></td>
                            </tr>
                            <?php $f_MontoTotal = ( $f_MontoTotal + floatval( $o_COM_OrdenCompraDetalleBN->getSubTotal() ) ) ?>
                        <?php } ?>
                        </tbody>
                        <tbody>
                        <tr>
                            <td colspan="7">&nbsp;</td>
                        </tr>
                        <tr>
                            <td align="right" colspan="6">Sub Total <?=GSS_MonedaMastFN::getSiglaxId( $o_COM_OrdenCompraCabeceraBN->getIdMoneda() )?></td>
                            <td align="center"><?=number_format( ( $o_COM_OrdenCompraCabeceraBN->getMontoAfecto() + $o_COM_OrdenCompraCabeceraBN->getMontoNoAfecto() ), 2 )?></td>
                        </tr>
                        <tr>
                            <td align="right" colspan="6">IGV <?=GSS_ParametroMastFN::getTextoIgvActual()?> <?=GSS_MonedaMastFN::getSiglaxId( $o_COM_OrdenCompraCabeceraBN->getIdMoneda() )?></td>
                            <td align="center"><?=number_format( $o_COM_OrdenCompraCabeceraBN->getMontoIGV(), 2 )?></td>
                        </tr>
                        <tr>
                            <td align="right" colspan="6">Total <?=GSS_MonedaMastFN::getSiglaxId( $o_COM_OrdenCompraCabeceraBN->getIdMoneda() )?></td>
                            <td align="center"><?=number_format( ( $o_COM_OrdenCompraCabeceraBN->getMontoBruto() ), 2 )?></td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="tab-pane fade" id="nav-file" role="tabpanel" aria-labelledby="nav-file-tab">
            <div id="content_grid_costeo" class="" style="border-left: 1px solid rgba(0,0,0,.125); border-right: 1px solid rgba(0,0,0,.125); border-bottom: 1px solid rgba(0,0,0,.125); padding: 10px;">

            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    buscarGridCosteoImport = function( tipo )
    {
        blockContent( "nav-tabContent" );

        var a_Params = [];
        a_Params.push( "Id=<?=$s_Id?>" );
        a_Params.push( "CalcularCosto=" + tipo );

        executeAjaxUpdater
        (
            "content_grid_costeo",
            "<?php echo buildUrl( 'import/gridCosteoImport' ) ?>",
            a_Params.join( "&" ),
            function( response )
            {
                unBlockContent( 'nav-tabContent' );
            }
        );
    }

    $( '#myTab a' ).on
    (
        'click', function ( e )
        {

            pr( $( e.currentTarget ).attr( "aria-controls" ) );

            var id_content = $( e.currentTarget ).attr( "aria-controls" );
            if( id_content == "nav-file" )
            {
                buscarGridCosteoImport( 0 );
            }

            e.preventDefault()

            $( this ).tab( 'show' );
        }
    );

    buscarCosteoImportacion = function()
    {
        blockContent( "content_result_grid1" );

        var OrdenId  = <?=$s_Id?>;
        var a_Params = [];
        a_Params.push( "i_Id=" + i_Id );

        executeAjaxUpdater
        (
            "content_result_grid1",
            "<?php echo buildUrl( 'import/guardarGastosImport' ) ?>",
            a_Params.join( "&" ),
            function( response )
            {

            }
        );
    }

    buscarGridGastosImportacion();
    identificarExwork();

    $( "#TipoGastoId" ).val( "04" );

</script>

<br> <br>

<?php if( $o_COM_ImportacionCabeceraBN->getEstado() == COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_COMPLETADO ){ ?>
<script>
    convertirDisabledTodosLosInputs();
</script>
<?php } ?>