<?php
class importActions extends wtActions
{
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

    }

    public function executeTerminarProcesoImport()
    {
        $s_Id = $this->getRequestParameter( "Id" );

        $a_Rs = array();

        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            $a_Ids = explode( "_", $s_Id );
            $IdCompania    = $a_Ids[0];
            $IdOrdenCompra = $a_Ids[1];

            $o_COM_OrdenCompraCabeceraFN     = new COM_OrdenCompraCabeceraFN();
            $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );

            $o_COM_ImportacionCabeceraFN = new COM_ImportacionCabeceraFN();
            $o_COM_ImportacionCabeceraBN = $o_COM_ImportacionCabeceraFN->selectByPK( $IdOrdenCompra );

            $TipodeCambio = $o_COM_ImportacionCabeceraBN->getTipoCambio();

            //PARAMETROS
            //CABECERA
            $FechaDocumento             = date( "Y-m-d H:i:s" );
            $IdTransaccionOperacion     = COM_OrdenCompraCabeceraBN::TIPO_TRANSACCION_X_DEFECTO;
            $IdAlmacen                  = $o_COM_OrdenCompraCabeceraBN->getIdAlmacenIngreso();
            $IdTransaccion              = COM_OrdenCompraCabeceraBN::TRANSACCION_X_DEFECTO;
            $AlmacenTraslado            = ""; //ALMACEN DE DESTINO
            $IdTipoDocumento            = COM_OrdenCompraCabeceraBN::TIPO_DOCUMENTO;
            $ReferenciaTipoDocumento    = COM_OrdenCompraCabeceraBN::REF_TIPO_DOCUMENTO_DEFECTO;
            $ReferenciaNumeroDocumento  = $IdOrdenCompra;
            $GuiaProveedor              = $o_COM_ImportacionCabeceraBN->getDuaSerieNumero();
            $Comentario                 = "POR IMPORTACION"; //
            $MonedaCod                  = "LO"; //POR DEFECTO LA TRX ES SOLES //$o_COM_OrdenCompraCabeceraBN->getIdMoneda();

            //PARAMETROS PARA LA GUIA DE REMISION - en este caso solo se permite una guia por proveedor
            $TipoDocumentoFiscal    = "FC"; //
            $SerieDocumentoFiscal   = $o_COM_ImportacionCabeceraBN->getInvoiceSerie();
            $NumeroDocumentoFiscal  = $o_COM_ImportacionCabeceraBN->getInvoiceNumero();
            $CodigoProveedor        = $o_COM_OrdenCompraCabeceraBN->getIdProveedor();
            $IdOrdenGuia            = "";
            $SerieNumeroFactura     = "FAC".$o_COM_ImportacionCabeceraBN->getInvoiceSerieNumero();

            //AQUI SE GUARDA LA INFORMACION PARA LA TRANSACCION:
            $o_ALM_TransaccionCabeceraBN = new ALM_TransaccionCabeceraBN();
            $o_ALM_TransaccionCabeceraBN->setIdTransaccion( $IdTransaccion );
            $o_ALM_TransaccionCabeceraBN->setAlmacenTraslado( $AlmacenTraslado );
            $o_ALM_TransaccionCabeceraBN->setIdAlmacen( $IdAlmacen );
            $o_ALM_TransaccionCabeceraBN->setIdTransaccionOperacion( $IdTransaccionOperacion );
            $o_ALM_TransaccionCabeceraBN->setFechaDocumento( $FechaDocumento );
            $o_ALM_TransaccionCabeceraBN->setMonedaCod( $MonedaCod );
            $o_ALM_TransaccionCabeceraBN->setTipodeCambio( floatval( $TipodeCambio ) );
            $o_ALM_TransaccionCabeceraBN->setReferenciaTipoDocumento( $ReferenciaTipoDocumento );
            $o_ALM_TransaccionCabeceraBN->setReferenciaNumeroDocumento( $ReferenciaNumeroDocumento );
            $o_ALM_TransaccionCabeceraBN->setGuiaProveedor( $GuiaProveedor );
            $o_ALM_TransaccionCabeceraBN->setReferenciaNumeroInterno( $IdOrdenGuia ); //se implementa para asociar el documento fiscal 2021-01-04
            $o_ALM_TransaccionCabeceraBN->setIdCompania( ( int ) $IdCompania );
            $o_ALM_TransaccionCabeceraBN->setIdTipoDocumento( $IdTipoDocumento );
            $o_ALM_TransaccionCabeceraBN->setComentario( $Comentario );

            $o_ALM_TransaccionCabeceraBN->setTipoDocumentoFiscal( $TipoDocumentoFiscal );
            $o_ALM_TransaccionCabeceraBN->setSerieDocumentoFiscal( $SerieDocumentoFiscal );
            $o_ALM_TransaccionCabeceraBN->setNumeroDocumentoFiscal( $NumeroDocumentoFiscal );
            $o_ALM_TransaccionCabeceraBN->setCodigoProveedor( ( string ) $CodigoProveedor );

            //AHORA LOS DETALLES
            $o_COM_OrdenCompraDetalleFN = new COM_OrdenCompraDetalleFN();
            $o_COM_OrdenCompraDetalleFN->setIdOrdenCompra( $IdOrdenCompra );
            $o_COM_OrdenCompraDetalleFN->setIdCompania( $IdCompania );
            $o_COM_OrdenCompraDetalleFN->addOrderBy( COM_OrdenCompraDetalleFN::IdSecuencia );
            $a_COM_OrdenCompraDetalle = $o_COM_OrdenCompraDetalleFN->select();
            foreach( $a_COM_OrdenCompraDetalle as $o_TMP_COM_OrdenCompraDetalleBN )
            {
                $o_ALM_TransaccionDetalleBN = new ALM_TransaccionDetalleBN();
                $o_ALM_TransaccionDetalleBN->setIdItem( $o_TMP_COM_OrdenCompraDetalleBN->getIdItem() );
                $o_ALM_TransaccionDetalleBN->setUnidadCodigo( $o_TMP_COM_OrdenCompraDetalleBN->getIdUnidad() );
                $o_ALM_TransaccionDetalleBN->setReferenciaSecuencia( $o_TMP_COM_OrdenCompraDetalleBN->getIdSecuencia() );
                $o_ALM_TransaccionDetalleBN->setReferenciaTipoDocumento( COM_OrdenCompraCabeceraBN::REF_TIPO_DOCUMENTO_DEFECTO );
                $o_ALM_TransaccionDetalleBN->setReferenciaNumeroDocumento( $IdOrdenCompra );
                $o_ALM_TransaccionDetalleBN->setCantidad( $o_TMP_COM_OrdenCompraDetalleBN->getCantidadPedida() );
                $o_ALM_TransaccionDetalleBN->setPrecioUnitario( $o_TMP_COM_OrdenCompraDetalleBN->getCostoFinalSoles() );
                $o_ALM_TransaccionDetalleBN->setPrecioUnitarioDolares( $o_TMP_COM_OrdenCompraDetalleBN->getCostoFinalDolares() );

                $a_MovientoDetalle[] = $o_ALM_TransaccionDetalleBN;

                $o_COM_OrdenCompraDetalleBN = new COM_OrdenCompraDetalleBN();
                $o_COM_OrdenCompraDetalleBN->setIdOrdenCompra( ( int ) $IdOrdenCompra );
                $o_COM_OrdenCompraDetalleBN->setIdCompania( ( int ) $IdCompania );
                $o_COM_OrdenCompraDetalleBN->setIdSecuencia( $o_TMP_COM_OrdenCompraDetalleBN->getIdSecuencia() );
                $o_COM_OrdenCompraDetalleBN->setIdUnidad( $o_TMP_COM_OrdenCompraDetalleBN->getIdUnidad() );
                $o_COM_OrdenCompraDetalleBN->setPrecioUnitarioFinal( $o_TMP_COM_OrdenCompraDetalleBN->getPrecioUnitarioFinal() );
                $o_COM_OrdenCompraDetalleBN->setCantidadRecibida( $o_TMP_COM_OrdenCompraDetalleBN->getCantidadPedida() );
                $o_COM_OrdenCompraDetalleBN->setComentario( "" );

                $a_ArrayOrdenCompraDetalle[] = $o_COM_OrdenCompraDetalleBN;
            }

            $o_ALM_TransaccionCabeceraBN->setArrayMovientoDetalle( $a_MovientoDetalle );

            //OBJETO ORDEN DE COMPRA
            $o_COM_OrdenCompraCabeceraBN = new COM_OrdenCompraCabeceraBN();
            $o_COM_OrdenCompraCabeceraBN->setIdCompania( myUser::getUser()->getIdCompania() );
            $o_COM_OrdenCompraCabeceraBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
            $o_COM_OrdenCompraCabeceraBN->setIdProveedor( ( int ) $CodigoProveedor );
            $o_COM_OrdenCompraCabeceraBN->setIdOrdenCompra( ( int ) $IdOrdenCompra );
            $o_COM_OrdenCompraCabeceraBN->setObjectTransaccion( $o_ALM_TransaccionCabeceraBN );
            $o_COM_OrdenCompraCabeceraBN->setArrayOrdenCompraDetalle( $a_ArrayOrdenCompraDetalle );
            $o_COM_OrdenCompraCabeceraBN->setIdAlmacenEntrega( $IdAlmacen );
            $o_COM_OrdenCompraCabeceraBN->setObservacion( $Comentario );
            $o_COM_OrdenCompraCabeceraBN->setObservacionEntrega( $SerieNumeroFactura );

            //$o_COM_OrdenCompraCabeceraBN->setSecuenciaSerieNumero( ( int ) $SecuenciaSerieNum );
            $o_COM_OrdenCompraCabeceraBN->setSerieDocumentoFiscal( $o_COM_ImportacionCabeceraBN->getDuaSerie() );
            $o_COM_OrdenCompraCabeceraBN->setNumeroDocumentoFiscal( $o_COM_ImportacionCabeceraBN->getDuaNumero() );

            $o_OrdenCompraBL = new OrdenCompraBL();
            $o_OrdenCompraBL->realizarProcesoRecepcionOrdenCompra( $o_COM_OrdenCompraCabeceraBN );

            $i_Id = $o_ALM_TransaccionCabeceraBN->getIdTransaccionCabeceraConcat();

            //AHORA CAMBIAS EL ESTADO DE LAS TABLAS ADICIONALES
            $o_COM_OrdenCompraCabeceraFN     = new COM_OrdenCompraCabeceraFN();
            $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );

            //AHORA SE CAMBIA EL ESTADO A LOS DEMAS COMPONENTES
            $O_COM_ImportacionCabeceraDP = new COM_ImportacionCabeceraDP();
            $O_COM_ImportacionCabeceraDP->setIdOrdenCompra( $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
            $O_COM_ImportacionCabeceraDP->setEstado( $o_COM_OrdenCompraCabeceraBN->getEstado() );
            $O_COM_ImportacionCabeceraDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
            $O_COM_ImportacionCabeceraDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
            $O_COM_ImportacionCabeceraDP->update();

            $o_COM_GastosImportacionDetFN = new COM_GastosImportacionDetFN();
            $o_COM_GastosImportacionDetFN->setIdOrdenCompra( $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
            $a_COM_GastosImportacionDet = $o_COM_GastosImportacionDetFN->select();
            foreach( $a_COM_GastosImportacionDet as $o_COM_GastosImportacionDetBN )
            {
                $o_COM_GastosImportacionDetDP = new COM_GastosImportacionDetDP();
                $o_COM_GastosImportacionDetDP->setIdOrdenCompra( $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
                $o_COM_GastosImportacionDetDP->setGastosImportacionId( $o_COM_GastosImportacionDetBN->getGastosImportacionId() );
                $o_COM_GastosImportacionDetDP->setEstado( $o_COM_OrdenCompraCabeceraBN->getEstado() );
                $o_COM_GastosImportacionDetDP->update();
            }

            $a_Rs['error'] = false;

            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }

        header( 'Content-Type: application/json' );
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }

    public function executeAddeditImport()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_TipoProc = $this->getRequestParameter( "TipoProc" );
        $this->s_Id       = $this->getRequestParameter( "Id" );
        $this->b_Control  = $this->getRequestParameter( "Control" );

        $a_Ids = explode( "_", $this->s_Id );
        $IdCompania    = $a_Ids[0];
        $IdOrdenCompra = $a_Ids[1];

        $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
        $this->o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );

        $o_COM_ImportacionCabeceraFN = new COM_ImportacionCabeceraFN();
        $this->o_COM_ImportacionCabeceraBN = $o_COM_ImportacionCabeceraFN->selectByPK( $IdOrdenCompra );
        if( !$this->o_COM_ImportacionCabeceraBN )
        {
            $this->o_COM_ImportacionCabeceraBN = new COM_ImportacionCabeceraBN();
            $this->o_COM_ImportacionCabeceraBN->setTotalFlete( 0 );
            $this->o_COM_ImportacionCabeceraBN->setTotalSeguro( 0 );
            $this->o_COM_ImportacionCabeceraBN->setTotalAdValorem( 0 );
            $this->o_COM_ImportacionCabeceraBN->setTotalIPM2( 0 );
            $this->o_COM_ImportacionCabeceraBN->setTotalIGV16( 0 );
            $this->o_COM_ImportacionCabeceraBN->setTotalServicioDespacho( 0 );
            $this->o_COM_ImportacionCabeceraBN->setTotalPercepcion( 0 );
            $this->o_COM_ImportacionCabeceraBN->setTotalTransPuerto( 0 );
            $this->o_COM_ImportacionCabeceraBN->setTotalEmicionBL( 0 );
            $this->o_COM_ImportacionCabeceraBN->setTotalOtrosGastosEXW( 0 );
        }

        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdCompania() );

        $o_ALM_ItemTipoFN = new ALM_ItemTipoFN();
        $this->o_ALM_ItemTipoBN = $o_ALM_ItemTipoFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdOrdenClasificacion() );

        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $this->o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdMoneda() );

        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $this->o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega() );

        $o_COM_OrdenItemClasificacionFN = new COM_OrdenItemClasificacionFN();
        $this->o_COM_OrdenItemClasificacionBN = $o_COM_OrdenItemClasificacionFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdOrdenClasificacion() );

        $o_COM_OrdenCompraDetalleFN = new COM_OrdenCompraDetalleFN();
        $o_COM_OrdenCompraDetalleFN->setIdOrdenCompra( $IdOrdenCompra );
        $o_COM_OrdenCompraDetalleFN->setIdCompania( $IdCompania );
        $o_COM_OrdenCompraDetalleFN->addOrderBy( COM_OrdenCompraDetalleFN::IdSecuencia );
        $this->a_COM_OrdenCompraDetalle = $o_COM_OrdenCompraDetalleFN->select();
    }

    public function executeGuardarFormularioImport()
    {
        $ConcatIdOC            = $this->getRequestParameter( "ConcatIdOC" );
        $DuaSerie              = $this->getRequestParameter( "DuaSerie" );
        $DuaNumero             = $this->getRequestParameter( "DuaNumero" );
        $DuaPagoFecha          = $this->getRequestParameter( "DuaPagoFecha" );
        $InvoiceSerie          = str_pad( $this->getRequestParameter( "InvoiceSerie" ), 4, "0", STR_PAD_LEFT );
        $InvoiceNumero         = str_pad( $this->getRequestParameter( "InvoiceNumero" ), 10, "0", STR_PAD_LEFT );
        $InvoiceFecha          = $this->getRequestParameter( "InvoiceFecha" );
        $DuaNroOrden           = $this->getRequestParameter( "DuaNroOrden" );
        $IncotermsCod          = $this->getRequestParameter( "IncotermsCod" );
        $TotalFOB              = floatval( $this->getRequestParameter( "TotalFOB" ) );
        $TotalFlete            = floatval( $this->getRequestParameter( "TotalFlete" ) );
        $TotalSeguro           = floatval( $this->getRequestParameter( "TotalSeguro" ) );
        $TotalCIF              = floatval( $this->getRequestParameter( "TotalCIF" ) );
        $TipoCambio            = floatval( $this->getRequestParameter( "TipoCambio" ) );
        $PaisProcedenciaCod    = $this->getRequestParameter( "PaisProcedenciaCod" );
        $TotalAdValorem        = floatval( $this->getRequestParameter( "TotalAdValorem" ) );
        $TotalIPM2             = floatval( $this->getRequestParameter( "TotalIPM2" ) );
        $TotalIGV16            = floatval( $this->getRequestParameter( "TotalIGV16" ) );
        $SumaTotalIGV          = floatval( $this->getRequestParameter( "SumaTotalIGV" ) );
        $TotalServicioDespacho = floatval( $this->getRequestParameter( "TotalServicioDespacho" ) );
        $TotalPercepcion       = floatval( $this->getRequestParameter( "TotalPercepcion" ) );

        $TotalTransPuerto      = floatval( $this->getRequestParameter( "TotalTransPuerto" ) );
        $TotalEmicionBL        = floatval( $this->getRequestParameter( "TotalEmicionBL" ) );
        $TotalOtrosGastosEXW   = floatval( $this->getRequestParameter( "TotalOtrosGastosEXW" ) );

        $a_Ids = explode( "_", $ConcatIdOC );
        $IdCompania    = intval( $a_Ids[0] );
        $IdOrdenCompra = intval( $a_Ids[1] );

        $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
        $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );

        $TotalFOB     = $o_COM_OrdenCompraCabeceraBN->getMontoBruto();
        $TotalCIF     = $TotalFOB + $TotalFlete + $TotalSeguro + $TotalTransPuerto + $TotalEmicionBL + $TotalOtrosGastosEXW;
        $SumaTotalIGV = $TotalIPM2 + $TotalIGV16;

        $o_MST_PaisFN = new MST_PaisFN();
        $o_MST_PaisBN = $o_MST_PaisFN->selectByPK( $PaisProcedenciaCod );

        $a_Rs = array();

        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            $o_COM_ImportacionCabeceraFN = new COM_ImportacionCabeceraFN();
            $o_COM_ImportacionCabeceraFN->setIdOrdenCompra( $IdOrdenCompra );

            $o_COM_ImportacionCabeceraBN = new COM_ImportacionCabeceraBN();
            $o_COM_ImportacionCabeceraBN->setIdOrdenCompra( $IdOrdenCompra );
            $o_COM_ImportacionCabeceraBN->setDuaSerie( $DuaSerie );
            $o_COM_ImportacionCabeceraBN->setDuaNumero( str_pad( $DuaNumero, 10, "0", STR_PAD_LEFT ) );
            $o_COM_ImportacionCabeceraBN->setDuaSerieNumero( str_pad( $DuaSerie, 4, "0", STR_PAD_LEFT )."-".str_pad( $DuaNumero, 10, "0", STR_PAD_LEFT ) );
            $o_COM_ImportacionCabeceraBN->setDuaPagoFecha( $DuaPagoFecha );
            $o_COM_ImportacionCabeceraBN->setInvoiceSerie( $InvoiceSerie );
            $o_COM_ImportacionCabeceraBN->setInvoiceNumero( $InvoiceNumero );
            $o_COM_ImportacionCabeceraBN->setInvoiceSerieNumero( $InvoiceSerie."-".$InvoiceNumero );
            $o_COM_ImportacionCabeceraBN->setInvoiceFecha( $InvoiceFecha );
            $o_COM_ImportacionCabeceraBN->setDuaNroOrden( $DuaNroOrden );
            $o_COM_ImportacionCabeceraBN->setIncotermsCod( $IncotermsCod );
            $o_COM_ImportacionCabeceraBN->setIncotermsDesc( COM_ImportacionCabeceraBN::getArrayIncoterms( $IncotermsCod ) );
            $o_COM_ImportacionCabeceraBN->setPaisProcedenciaCod( $PaisProcedenciaCod );
            $o_COM_ImportacionCabeceraBN->setPaisProcedenciaDesc( $o_MST_PaisBN->getNombre() );
            $o_COM_ImportacionCabeceraBN->setTotalFOB( $TotalFOB );
            $o_COM_ImportacionCabeceraBN->setTotalTransPuerto( $TotalTransPuerto );
            $o_COM_ImportacionCabeceraBN->setTotalEmicionBL( $TotalEmicionBL );
            $o_COM_ImportacionCabeceraBN->setTotalOtrosGastosEXW( $TotalOtrosGastosEXW );
            $o_COM_ImportacionCabeceraBN->setTotalFlete( $TotalFlete );
            $o_COM_ImportacionCabeceraBN->setTotalSeguro( $TotalSeguro );
            $o_COM_ImportacionCabeceraBN->setTotalCIF( $TotalCIF );
            $o_COM_ImportacionCabeceraBN->setTipoCambio( $TipoCambio );
            $o_COM_ImportacionCabeceraBN->setTotalAdValorem( $TotalAdValorem );
            $o_COM_ImportacionCabeceraBN->setTotalIPM2( $TotalIPM2 );
            $o_COM_ImportacionCabeceraBN->setTotalIGV16( $TotalIGV16 );
            $o_COM_ImportacionCabeceraBN->setSumaTotalIGV( $SumaTotalIGV );
            $o_COM_ImportacionCabeceraBN->setTotalServicioDespacho( $TotalServicioDespacho );
            $o_COM_ImportacionCabeceraBN->setTotalPercepcion( $TotalPercepcion );
            $o_COM_ImportacionCabeceraBN->setPorIGV( intval( GSS_ParametroMastFN::getTextoIgvActual( 'Texto' ) ) );
            $o_COM_ImportacionCabeceraBN->setEstado( $o_COM_OrdenCompraCabeceraBN->getEstado() );

            if( $o_COM_ImportacionCabeceraFN->selectNumRows() > 0 )
            {
                //update
                $o_COM_ImportacionCabeceraBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_COM_ImportacionCabeceraBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );

                $O_COM_ImportacionCabeceraDP = new COM_ImportacionCabeceraDP( $o_COM_ImportacionCabeceraBN );
                $O_COM_ImportacionCabeceraDP->update();
            }
            else
            {
                //insert
                $o_COM_ImportacionCabeceraBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_COM_ImportacionCabeceraBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );

                $O_COM_ImportacionCabeceraDP = new COM_ImportacionCabeceraDP( $o_COM_ImportacionCabeceraBN );
                $O_COM_ImportacionCabeceraDP->save();
            }

            $con->commit();

            $a_Rs['error']    = false;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Rs );

        return ViewResponse::NONE;
    }

    public function executeGuardarGastosImport()
    {
        $s_IdOC                 = $this->getRequestParameter( "ConcatIdOC" );
        $s_TipoGastoId          = $this->getRequestParameter( "TipoGastoId" );
        $s_TipoCambio           = $this->getRequestParameter( "TipoCambio" );
        $s_MontoSoles           = $this->getRequestParameter( "MontoSoles" );
        $s_MontoDolares         = $this->getRequestParameter( "MontoDolares" );
        $s_TipoGastoDescripcion = $this->getRequestParameter( "TipoGastoDescripcion" );

        $a_Ids = explode( "_", $s_IdOC );
        $IdCompania    = intval( $a_Ids[0] );
        $IdOrdenCompra = intval( $a_Ids[1] );

        $a_Rs = array();

        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
            $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );

            $i_GastoDetId = COM_GastosImportacionDetDP::recuperarId( $IdOrdenCompra );
            $s_Secuencia  = str_pad( $i_GastoDetId, 3, "0", STR_PAD_LEFT );

            $S_TipoGastoDesc = COM_GastosImportacionDetBN::getArrayTipoGastos( $s_TipoGastoId );

            $O_COM_GastosImportacionDetDP = new COM_GastosImportacionDetDP();
            $O_COM_GastosImportacionDetDP->setIdOrdenCompra( $IdOrdenCompra );
            $O_COM_GastosImportacionDetDP->setGastosImportacionId( $i_GastoDetId );
            $O_COM_GastosImportacionDetDP->setSecuencia( $s_Secuencia );
            $O_COM_GastosImportacionDetDP->setTipoGastoId( $s_TipoGastoId );
            $O_COM_GastosImportacionDetDP->setTipoGastoDesc( $S_TipoGastoDesc );
            $O_COM_GastosImportacionDetDP->setDescripcion( strtoupper( trim( $s_TipoGastoDescripcion ) ) );
            $O_COM_GastosImportacionDetDP->setMontoSoles( floatval( $s_MontoSoles ) );
            $O_COM_GastosImportacionDetDP->setMontoDolares( floatval( $s_MontoDolares ) );
            $O_COM_GastosImportacionDetDP->setTipoCambio( floatval( $s_TipoCambio ) );
            $O_COM_GastosImportacionDetDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
            $O_COM_GastosImportacionDetDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
            $O_COM_GastosImportacionDetDP->setEstado( $o_COM_OrdenCompraCabeceraBN->getEstado() );
            $O_COM_GastosImportacionDetDP->save();

            $con->commit();

            $a_Rs['error']    = false;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Rs );

        return ViewResponse::NONE;
    }

    public function executeGridGastosImport()
    {
        $s_IdOC = $this->getRequestParameter( "Id" );

        $a_Ids = explode( "_", $s_IdOC );
        $IdCompania    = intval( $a_Ids[0] );
        $IdOrdenCompra = intval( $a_Ids[1] );

        $o_COM_GastosImportacionDetFN = new COM_GastosImportacionDetFN();
        $o_COM_GastosImportacionDetFN->setIdOrdenCompra( $IdOrdenCompra );
        $this->a_COM_GastosImportacionDet = $o_COM_GastosImportacionDetFN->select();
        //pr( $this->a_COM_GastosImportacionDet );

        ViewResponse::getInstance()->setMethodAjax();
    }

    public function executeEliminarGastosImport()
    {
        $IdOrdenCompra = intval( $this->getRequestParameter( "IdOC" ) );
        $i_GatoId      = intval( $this->getRequestParameter( "IdDet" ) );

        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            $O_COM_GastosImportacionDetDP = new COM_GastosImportacionDetDP();
            $O_COM_GastosImportacionDetDP->setIdOrdenCompra( $IdOrdenCompra );
            $O_COM_GastosImportacionDetDP->setGastosImportacionId( $i_GatoId );
            $O_COM_GastosImportacionDetDP->delete();

            $con->commit();

            $a_Rs['error']    = false;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Rs );

        return ViewResponse::NONE;
    }

    public function executeGridCosteoImport()
    {
        $s_IdOC = $this->getRequestParameter( "Id" );
        $this->CalcularCosto = $this->getRequestParameter( "CalcularCosto" );

        $a_Ids = explode( "_", $s_IdOC );
        $IdCompania    = intval( $a_Ids[0] );
        $IdOrdenCompra = intval( $a_Ids[1] );

        $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
        $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );

        $o_COM_OrdenCompraDetalleFN = new COM_OrdenCompraDetalleFN();
        $o_COM_OrdenCompraDetalleFN->setIdOrdenCompra( $IdOrdenCompra );
        $o_COM_OrdenCompraDetalleFN->setIdCompania( $IdCompania );
        $o_COM_OrdenCompraDetalleFN->addOrderBy( COM_OrdenCompraDetalleFN::IdSecuencia );
        $this->a_COM_OrdenCompraDetalle = $o_COM_OrdenCompraDetalleFN->select();
        //pr( $this->a_COM_OrdenCompraDetalle );

        $this->SumaTotalGastos = 0;
        $this->DivisionTotal   = 0;
        $this->PorcentajeTotal = 0;
        $this->TipoCambio      = 0;

        $o_COM_GastosImportacionDetFN = new COM_GastosImportacionDetFN();
        $o_COM_GastosImportacionDetFN->setIdOrdenCompra( $IdOrdenCompra );
        $a_COM_GastosImportacionDet = $o_COM_GastosImportacionDetFN->select();
        foreach( $a_COM_GastosImportacionDet as $o_COM_GastosImportacionDetBN )
        {
            $this->SumaTotalGastos = $this->SumaTotalGastos + $o_COM_GastosImportacionDetBN->getMontoDolares();
        }

        $o_COM_ImportacionCabeceraFN = new COM_ImportacionCabeceraFN();
        $o_COM_ImportacionCabeceraBN = $o_COM_ImportacionCabeceraFN->selectByPK( $IdOrdenCompra );
        if( $o_COM_ImportacionCabeceraBN )
        {
            $this->TipoCambio = $o_COM_ImportacionCabeceraBN->getTipoCambio();

            $this->SumaTotalGastos = $this->SumaTotalGastos + $o_COM_ImportacionCabeceraBN->getTotalTransPuerto();
            $this->SumaTotalGastos = $this->SumaTotalGastos + $o_COM_ImportacionCabeceraBN->getTotalEmicionBL();
            $this->SumaTotalGastos = $this->SumaTotalGastos + $o_COM_ImportacionCabeceraBN->getTotalOtrosGastosEXW();

            $this->SumaTotalGastos = $this->SumaTotalGastos + $o_COM_ImportacionCabeceraBN->getTotalFlete();
            $this->SumaTotalGastos = $this->SumaTotalGastos + $o_COM_ImportacionCabeceraBN->getTotalSeguro();
            $this->SumaTotalGastos = $this->SumaTotalGastos + $o_COM_ImportacionCabeceraBN->getTotalIPM2();
            $this->SumaTotalGastos = $this->SumaTotalGastos + $o_COM_ImportacionCabeceraBN->getTotalIGV16();
            $this->SumaTotalGastos = $this->SumaTotalGastos + $o_COM_ImportacionCabeceraBN->getTotalPercepcion();
        }

        if( $this->SumaTotalGastos )
        {
            $this->DivisionTotal = $this->SumaTotalGastos / $o_COM_OrdenCompraCabeceraBN->getMontoBruto();

            $this->PorcentajeTotal = round( $this->DivisionTotal * 100, 2 );
        }

        if( $this->CalcularCosto )
        {
            foreach( $this->a_COM_OrdenCompraDetalle as $o_COM_OrdenCompraDetalleBN )
            {
                $f_CostoDolares = round( $o_COM_OrdenCompraDetalleBN->getPrecioUnitario() * ( 1 + $this->DivisionTotal ), 2 );
                $f_CostoSoles   = round( ( $o_COM_OrdenCompraDetalleBN->getPrecioUnitario() * ( 1 + $this->DivisionTotal ) ) * $this->TipoCambio, 2 );

                $o_COM_OrdenCompraDetalleDP = new COM_OrdenCompraDetalleDP();
                $o_COM_OrdenCompraDetalleDP->setIdOrdenCompra( $o_COM_OrdenCompraDetalleBN->getIdOrdenCompra() );
                $o_COM_OrdenCompraDetalleDP->setIdCompania( $o_COM_OrdenCompraDetalleBN->getIdCompania() );
                $o_COM_OrdenCompraDetalleDP->setIdSecuencia( $o_COM_OrdenCompraDetalleBN->getIdSecuencia() );
                $o_COM_OrdenCompraDetalleDP->setCostoFinalDolares( $f_CostoDolares );
                $o_COM_OrdenCompraDetalleDP->setCostoFinalSoles( $f_CostoSoles );
                $o_COM_OrdenCompraDetalleDP->update();
            }
        }

        ViewResponse::getInstance()->setMethodAjax();
    }
}
