<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>

<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/responsive/2.2.5/css/responsive.bootstrap4.min.css" />
<!--<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" />-->

<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/responsive.bootstrap4.min.js"></script>

<div class="shadow-sm p-3 mb-2 bg-white rounded card card-body">
    <div class="row">
        <div class="col mb-1">
            <h4 class="text-info text-nowrap mb-0"> Registro de Obligaciones </h4>
        </div>
    </div>
</div>

<div id="content_alert" style=""></div>

<form name="form1" id="form1" method="POST" action="" onsubmit="">
    <input type="hidden" name="Control" id="Control" value="1">
    <input type="hidden" name="TipoProc" id="TipoProc" value="<?=$s_TipoProc?>">
    <input type="hidden" name="Id" id="Id" value="<?=$o_CP_ObligacionesBN->getObligacionesId()?>">

    <div class="card">

        <div class="form-row p-1 mx-0">

            <div class="col-md-6">

                <div class="card">
                    <h5 class="card-header" >Informaci&oacute;n del Proveedor</h5>
                    <div class="card-body" style="padding: 10px;">
                        <div class="form-row mx-0">
                            <div class="col-md-6 mb-1">
                                <div class="form-row">
                                    <div class="col-md-4 mb-1">
                                        <label for="ProveedorNombre" class="col-form-label">Proveedor:</label>
                                    </div>
                                    <div class="col-md-8 mb-1">
                                        <input type="text" class="form-control" id="ProveedorNombre"  name="ProveedorNombre" autocomplete="off" value="<?=$o_CP_ObligacionesBN->getProveedorNombre()?>" required>
                                        <script>
                                            $( "#ProveedorNombre" ).autocomplete
                                                                   (
                                                                       {
                                                                           source: "<?=buildUrl( 'fact/requestFactAlm', "TipoProc=AutocompleteProv" )?>",
                                                                           minLength: 2,
                                                                           select: function( event, ui )
                                                                           {
                                                                               $( "#ProveedorId" ).val( ui.item.id );
                                                                               buscarInfoProveedor();
                                                                           }
                                                                       }
                                                                   );
                                        </script>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 mb-1">
                                <div class="form-row">
                                    <div class="col-md-4 mb-1">
                                        <label class="col-form-label" for="ProveedorDocNum">Documento:</label>
                                    </div>
                                    <div class="col-md-8 mb-1">
                                        <div class="input-group mb-0">
                                            <input type="hidden" name="ProveedorId" id="ProveedorId" value="<?=$o_CP_ObligacionesBN->getProveedorId()?>">
                                            <input type="text" id="ProveedorDocNum" name="ProveedorDocNum" class="form-control text-center" autocomplete="off" onfocus="this.select();" value="<?=$o_CP_ObligacionesBN->getProveedorDocNum()?>" required>
                                            <script>
                                                $( "#ProveedorDocNum" ).autocomplete
                                                (
                                                    {
                                                        source: function( request, response )
                                                        {
                                                            $.getJSON
                                                            (
                                                                "<?=buildUrl( 'fact/requestFactAlm' )?>",
                                                                { term: request.term, TipoProc:'AutocompleteDocProv', TipoDoc: '' },
                                                                response
                                                            );
                                                        },
                                                        minLength: 2,
                                                        select: function( event, ui )
                                                        {
                                                            $( "#ProveedorId" ).val( ui.item.id );
                                                            buscarInfoProveedor();
                                                        }
                                                    }
                                                );
                                            </script>
                                            <div class="input-group-append">
                                                <button class="btn btn-outline-secondary" id="btnBusProv" type="button">...</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-row mx-0">
                            <div class="col-md-6 mb-1">
                                <div class="form-row">
                                    <div class="col-md-4 mb-1">
                                        <label for="ProyectoNombre" class="col-form-label">Proyecto:</label>
                                    </div>
                                    <div class="col-md-8 mb-1">
                                        <div class="input-group mb-0">
                                            <input type="hidden" name="IdProyecto" id="IdProyecto" value="<?=$o_CP_ObligacionesBN->getIdProyecto()?>">
                                            <input type="text" id="ProyectoNombre" name="ProyectoNombre" class="form-control" autocomplete="off" onfocus="this.select();" value="<?=$o_CP_ObligacionesBN->getProyectoNombre()?>" >
                                            <div class="input-group-append">
                                                <button class="btn btn-outline-secondary" id="btnProyectoBus" type="button">...</button>
                                                <script>
                                                    $( "#btnProyectoBus" )
                                                        .click
                                                        (
                                                            function()
                                                            {
                                                                var frameSrc = "<?=buildUrlComplet( 'vta.php/cot/listProyectos', 'IdPersona=' )?>";
                                                                $( "#exampleModalLongTitle" ).html( "Buscar Proyecto" );
                                                                $( '#iframe_id' ).attr( "src", frameSrc );
                                                                $( '#exampleModalCenter' ).modal( { show:true } );
                                                            }
                                                        );
                                                    asignarCotizacion = function( IdProyecto, Nombre, IdPersona )
                                                    {
                                                        $( "#IdProyecto" ).val( IdProyecto );
                                                        $( "#ProyectoNombre" ).val( Nombre );
                                                        ocultarModal();
                                                    }
                                                    $( "#ProyectoNombre" ).blur
                                                    (
                                                        function ( elm )
                                                        {
                                                            if( $( elm.target ).val().trim() == "" )
                                                            {
                                                                $( "#IdProyecto" ).val( '' );
                                                            }
                                                        }
                                                    );
                                                </script>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 mb-1">
                                <div class="form-row">
                                    <div class="col-md-4 mb-1">
                                        <label class="col-form-label" for="IdOrdenCompra">No OC:</label>
                                    </div>
                                    <div class="col-md-8 mb-1">
                                        <div class="input-group mb-0">
                                            <input type="text" id="IdOrdenCompra" name="IdOrdenCompra" class="form-control text-center" value="<?=$o_CP_ObligacionesBN->getNumeroOC()?>" autocomplete="off" onfocus="this.select();">
                                            <div class="input-group-append">
                                                <button class="btn btn-outline-secondary" id="btnBusOC" type="button">...</button>
                                                <script>
                                                    asignarOrdenCompra = function( IdOrdenCompra )
                                                    {
                                                        $( "#IdOrdenCompra" ).val( IdOrdenCompra );
                                                        ocultarModal2();
                                                        buscarInfoOrdenCompra();

                                                        //dataTableProv.destroy();
                                                        //$('#example').DataTable().destroy();
                                                    }
                                                    $( "#btnBusOC" )
                                                        .click
                                                        (
                                                            function()
                                                            {
                                                                if( $( "#ProveedorId" ).val() == "" )
                                                                {
                                                                    showAlertBootStrap( 'content_alert', 'alert-danger', "Debe seleccionar el Proveedor." );
                                                                    return false;
                                                                }

                                                                $( "#exampleModalLongTitle2" ).html( "Buscar Orden de Compra" );
                                                                $( '#exampleModalCenter2' ).modal( { show:true } );

                                                                if ( $.fn.DataTable.isDataTable( '#example') )
                                                                {
                                                                    $( '#example' ).DataTable().destroy();
                                                                }

                                                                $( '#example tbody' ).empty();

                                                                $( '#example' ).DataTable
                                                                               (
                                                                                   {
                                                                                       ajax: '<?=buildUrl( 'fact/requestFactAlm', "TipoProc=BuscarOrdenCompra" )?>/ProveedorId/' + $( "#ProveedorId" ).val(),
                                                                                       language: {"url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json"},
                                                                                       //responsive: { details: true },
                                                                                       responsive: true,
                                                                                       //destroy: true,
                                                                                       bRetrieve: true,
                                                                                       aoColumns :
                                                                                           [
                                                                                               { "mData": "IdOrdenCompra", 'sClass': 'text-center', "title": "Nro OC" },
                                                                                               { "mData": "TipoOCDesc", 'sClass': 'text-center', "title": "Tipo" },
                                                                                               { "mData": "ClasificacionDesc", 'sClass': 'text-center', "title": "Clasificacion" },
                                                                                               { "mData": "Descripcion", 'sClass': 'text-center', "title": "Descripcion" },
                                                                                               { "mData": "NombreProveedor", "title": "Nombre Proveedor" },
                                                                                               { "mData": "FechaEntrega", 'sClass': 'text-center', "title": "Fecha Entrega" },
                                                                                               { "mData": "MonedaDesc", 'sClass': 'text-center', "title": "Moneda" },
                                                                                               { "mData": "MontoBruto", 'sClass': 'text-center', "title": "Total" },
                                                                                               { "mData": "MontoSaldo", 'sClass': 'text-center', "title": "Saldo" },
                                                                                               { "mData": "UsuarioCreacion", 'sClass': 'text-center', "title": "Comprador" },
                                                                                               {
                                                                                                   'sClass': 'text-center',
                                                                                                   "title": "",
                                                                                                   'mData': function ( data, type, full )
                                                                                                   {
                                                                                                       return '<a href=\'javascript:void(0);\' ><i class=\'ace-icon fa fa-search-plus bigger-130\' onclick="asignarOrdenCompra(\'' + data.IdOrdenCompra + '\')" ></i></a>';
                                                                                                   }
                                                                                               }
                                                                                           ]
                                                                                   }
                                                                               );

                                                                //$('#example').DataTable().destroy();
                                                            }
                                                        );
                                                </script>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-row mx-0">
                            <div class="col-md-12 mb-1">
                                <div class="form-row">
                                    <div class="col-md-2 mb-1">
                                        <label for="Descripcion" class="col-form-label">Descripci&oacute;n:</label>
                                    </div>
                                    <div class="col-md-10 mb-1">
                                        <input type="text" class="form-control" id="Descripcion"  name="Descripcion" autocomplete="off" value="<?=$o_CP_ObligacionesBN->getDescripcion()?>" onfocus="this.select();" onblur="this.value=this.value.toUpperCase();" required>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <h5 class="card-header" style="border-top: 1px solid rgba(0,0,0,.125)">Documento</h5>
                    <div class="card-body" style="padding: 10px;">
                        <div class="form-row mx-0">
                            <div class="col-md-6 mb-1">
                                <div class="form-row">
                                    <div class="col-md-4 mb-1">
                                        <label for="MonedaCod" class="col-form-label">Tipo:</label>
                                    </div>
                                    <div class="col-md-8 mb-1">
                                        <select class="form-control" name="IdTipoDocumento" id="IdTipoDocumento" onchange="" required>
                                            <option value=""> - Seleccione - </option>
                                            <?php foreach ( VTA_TipoDocumentoFN::buscarDocParaLogistica() as $o_VTA_TipoDocumentoBN ) { ?>
                                                <option value="<?=$o_VTA_TipoDocumentoBN->getIdTipoDocumento()?>" <?php if( $o_CP_ObligacionesBN->getIdTipoDocumento() == $o_VTA_TipoDocumentoBN->getIdTipoDocumento() ){ echo "SELECTED"; } ?> > <?=strtoupper( $o_VTA_TipoDocumentoBN->getDescripcionLocal() )?> </option>
                                            <?php } ?>
                                        </select>
                                        <script>
                                            $( "#IdTipoDocumento" ).change
                                            (
                                                function ( elm )
                                                {
                                                    if( $( elm.target ).val() != "" )
                                                    {
                                                        var valor = $( elm.target ).find(':selected').val();
                                                        if( valor == "NC" || valor == "ND" || valor == "LC" || valor == "LB" )
                                                        {
                                                            $( "#content_comprobante_ref" ).show();
                                                            $( "#ComprobanteSerieNumeroRef" ).attr( "required", 1 );
                                                        }
                                                        else
                                                        {
                                                            $( "#content_comprobante_ref" ).hide();

                                                            $( "#ComprobanteRefId" ).val( "" );
                                                            $( "#ComprobanteSerieNumeroRef" ).val( "" );

                                                            $( "#ComprobanteSerieNumeroRef" ).removeAttr( "required" );
                                                        }
                                                    }
                                                    else
                                                    {
                                                        $( "#content_comprobante_ref" ).hide();

                                                        $( "#ComprobanteRefId" ).val( "" );
                                                        $( "#ComprobanteSerieNumeroRef" ).val( "" );

                                                        $( "#ComprobanteSerieNumeroRef" ).removeAttr( "required" );
                                                    }
                                                }
                                            );
                                        </script>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6 mb-1">
                                <div class="form-row">
                                    <div class="col-md-4 mb-1">
                                        <label for="FechaEmision" class="col-form-label">Fecha Emision:</label>
                                    </div>
                                    <div class="col-md-8 mb-1">
                                        <input type="text" class="form-control text-center" name="FechaEmision" id="FechaEmision" value="<?=$o_CP_ObligacionesBN->getFechaEmision()?>" onfocus="this.select();" autocomplete="off" required>
                                        <script type="text/javascript">
                                            $( "#FechaEmision" ).datepicker( { dateFormat: "yy-mm-dd", changeYear:true, yearRange: "-1:+1", changeMonth: true, onClose: function (){ this.focus(); } } );
                                            $( "#FechaEmision" ).blur
                                            (
                                                function ( elm )
                                                {
                                                    if( $( elm.target ).val().trim() != "" )
                                                    {
                                                        blockContent( 'content_tipo_cambio' );
                                                        var strFormSerialize = "Fecha=" + $( "#FechaEmision" ).val();
                                                        executeAjaxJson
                                                        (
                                                            "<?php echo buildUrl( 'fact/requestFactAlm', 'TipoProc=BuscarTipoCambio' ) ?>",
                                                            strFormSerialize,
                                                            function( o_json )
                                                            {
                                                                unBlockContent( 'content_tipo_cambio' );
                                                                $('#TipoCambio')[0].options.length = 0;
                                                                $( "#TipoCambio").append( "<option value=" + o_json.TipoCambio + "> VENTA - " + o_json.TipoCambio + "</option>" );
                                                                //AHORA SE ACTUALIZA LA FEHCA DE VENCIMIENTO
                                                                $( "#TerminoId" ).trigger( "change" );
                                                            }
                                                        );
                                                    }
                                                }
                                            );
                                        </script>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-row mx-0">
                            <div class="col-md-6 mb-1">
                                <!--IF PHP-->
                                <div class="form-row" id="content_comprobante_ref" <?php if( !$o_CP_ObligacionesBN->getComprobanteRefId() ){ ?> style="display: none;" <?php } ?> >
                                    <div class="col-md-4 mb-1">
                                        <label class="col-form-label" for="ComprobanteSerieNumeroRef">Comprobante:</label>
                                    </div>
                                    <div class="col-md-8 mb-1">
                                        <div class="input-group mb-0">
                                            <input type="hidden" name="ComprobanteRefId" id="ComprobanteRefId" value="<?=$o_CP_ObligacionesBN->getComprobanteRefId()?>">
                                            <?php if( $s_TipoProc == "shw" || $s_TipoProc == "dlt" ){ ?>
                                                <input type="text" id="ComprobanteSerieNumeroRef" name="ComprobanteSerieNumeroRef" class="form-control text-center" value="<?=$o_CP_ObligacionesBN->getComprobanteTipoDocumentoCod()?> <?=$o_CP_ObligacionesBN->getComprobanteSerieNumeroRef()?>" >
                                            <?php }else{ ?>
                                                <input type="text" id="ComprobanteSerieNumeroRef" name="ComprobanteSerieNumeroRef" class="form-control text-center" value="<?=$o_CP_ObligacionesBN->getComprobanteSerieNumeroRef()?>" autocomplete="off" onfocus="this.select();">
                                            <?php } ?>
                                            <div class="input-group-append">
                                                <button class="btn btn-outline-secondary" id="btnBusCompRef" type="button">...</button>
                                                <script>
                                                    asignarComprobanteRef = function( ObligacionesId, DocumentoSerieNumero )
                                                    {
                                                        $( "#ComprobanteRefId" ).val( ObligacionesId );
                                                        $( "#ComprobanteSerieNumeroRef" ).val( DocumentoSerieNumero );

                                                        ocultarModal3();
                                                    }
                                                    $( "#btnBusCompRef" )
                                                        .click
                                                        (
                                                            function()
                                                            {
                                                                if( $( "#ProveedorId" ).val() == "" )
                                                                {
                                                                    showAlertBootStrap( 'content_alert', 'alert-danger', "Debe seleccionar el Proveedor." );
                                                                    return false;
                                                                }

                                                                $( "#exampleModalLongTitle3" ).html( "Buscar Comprobantes Proveedor" );
                                                                $( '#exampleModalCenter3' ).modal( { show:true } );

                                                                if ( $.fn.DataTable.isDataTable( '#example2') )
                                                                {
                                                                    $( '#example2' ).DataTable().destroy();
                                                                }

                                                                $('#example2 tbody').empty();

                                                                $('#example2').DataTable
                                                                (
                                                                    {
                                                                        ajax: '<?=buildUrl( 'fact/requestFactAlm', "TipoProc=BuscarComprobantesProv" )?>/IdMoneda/' + $( "#IdMoneda" ).val() + '/ProveedorId/' + $( "#ProveedorId" ).val(),
                                                                        language: {"url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json"},
                                                                        //responsive: { details: true },
                                                                        responsive: true,
                                                                        //destroy: true,
                                                                        //bRetrieve: true,
                                                                        //processing: true,
                                                                        //serverSide: true,
                                                                        aoColumns :
                                                                            [
                                                                                { "mData": "i_ObligacionesId", 'sClass': 'text-center', "title": "Nro" },
                                                                                { "mData": "TipoComprobanteDesc", 'sClass': 'text-center', "title": "Tipo Comp" },
                                                                                { "mData": "s_DocumentoSerieNumero", 'sClass': 'text-center', "title": "Numero Comp" },
                                                                                { "mData": "MonedaDesc", 'sClass': 'text-center', "title": "Moneda" },
                                                                                { "mData": "MontoTotalFormat", 'sClass': 'text-center', "title": "Total" },
                                                                                { "mData": "MontoSaldoFormat", 'sClass': 'text-center', "title": "Saldo" },
                                                                                {
                                                                                    'sClass': 'text-center',
                                                                                    "title": "",
                                                                                    'mData': function ( data, type, full )
                                                                                    {
                                                                                        return '<a href=\'javascript:void(0);\' ><i class=\'ace-icon fa fa-search-plus bigger-130\' onclick="asignarComprobanteRef( \'' + data.i_ObligacionesId + '\', \'' + data.s_DocumentoSerieNumero + '\' )" ></i></a>';
                                                                                    }
                                                                                }
                                                                            ]
                                                                    }
                                                                );

                                                                //$('#example').DataTable().destroy();
                                                            }
                                                        );
                                                    $( "#ComprobanteSerieNumeroRef" ).blur
                                                    (
                                                        function ( elm )
                                                        {
                                                            if( $( elm.target ).val().trim() == "" )
                                                            {
                                                                $( "#ComprobanteRefId" ).val( '' );
                                                            }
                                                        }
                                                    );
                                                </script>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--FIN IF-->
                            </div>
                            <div class="col-md-6 mb-1">
                                <div class="form-row">
                                    <div class="col-md-4 mb-1">
                                        <label for="FechaVencimiento" class="col-form-label">Fecha Venc:</label>
                                    </div>
                                    <div class="col-md-8 mb-1">
                                        <input type="text" class="form-control text-center" name="FechaVencimiento" id="FechaVencimiento" value="<?=$o_CP_ObligacionesBN->getFechaVencimiento()?>" onfocus="this.select();" autocomplete="off" >
                                        <script type="text/javascript">
                                            $( "#FechaVencimiento" ).datepicker( { dateFormat: "yy-mm-dd", changeYear:true, yearRange: "-1:+1", changeMonth: true, onClose: function (){ this.focus(); } } );
                                        </script>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-row mx-0">
                            <div class="col-md-6 mb-1">
                                <div class="form-row">
                                    <div class="col-md-4 mb-1">
                                        <label for="DocumentoSerie" class="col-form-label">Serie:</label>
                                    </div>
                                    <div class="col-md-8 mb-1">
                                        <input type="text" class="form-control text-center" name="DocumentoSerie" id="DocumentoSerie" value="<?=$o_CP_ObligacionesBN->getDocumentoSerie()?>" onfocus="this.select();" autocomplete="off" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 mb-1">
                                <div class="form-row">
                                    <div class="col-md-4 mb-1">
                                        <label for="DocumentoNumero" class="col-form-label">Numero:</label>
                                    </div>
                                    <div class="col-md-8 mb-1">
                                        <input type="text" class="form-control text-center" name="DocumentoNumero" id="DocumentoNumero" value="<?=$o_CP_ObligacionesBN->getDocumentoNumero()?>" onfocus="this.select();" autocomplete="off" required>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-row mx-0">
                            <div class="col-md-5 mb-1">
                                &nbsp;
                            </div>
                            <div class="col-md-7 mb-1">
                                <div class="form-row">
                                    <div class="col-md-5 mb-1">
                                        <label for="FechaProgramacion" class="col-form-label">Fecha Programaci&oacute;n:</label>
                                    </div>
                                    <div class="col-md-7 mb-1 text-right">
                                        <input type="text" class="form-control text-center" name="FechaProgramacion" id="FechaProgramacion" value="<?=$o_CP_ObligacionesBN->getFechaProgramacion()?>" onfocus="this.select();" autocomplete="off" required>
                                        <script type="text/javascript">
                                            $( "#FechaProgramacion" ).datepicker( { dateFormat: "yy-mm-dd", changeYear:true, yearRange: "-1:+1", changeMonth: true, onClose: function (){ this.focus(); } } );
                                        </script>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="card">
                    <h5 class="card-header">Resumen</h5>
                    <div class="card-body" style="padding: 10px;">
                        <div class="form-row mx-0">
                            <div class="col-md-6 mb-1">
                                <div class="form-row">
                                    <div class="col-md-4 mb-1">
                                        <label for="IdMoneda" class="col-form-label">Moneda:</label>
                                    </div>
                                    <div class="col-md-8 mb-1">
                                        <select class="form-control" name="IdMoneda" id="IdMoneda" onchange="" required>
                                            <?php foreach ( GSS_MonedaMastFN::selectActivos() as $i_Key => $o_GSS_MonedaMastBN ){ ?>
                                                <option value="<?=$o_GSS_MonedaMastBN->getIdMoneda()?>" <?php if( $o_CP_ObligacionesBN->getIdMoneda() == $o_GSS_MonedaMastBN->getIdMoneda() ){ echo "SELECTED"; } ?> > <?=$o_GSS_MonedaMastBN->getDescripcion()?> </option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 mb-1" id="content_tipo_cambio">
                                <div class="form-row">
                                    <div class="col-md-4 mb-1">
                                        <label for="TipoCambio" class="col-form-label">T. Cambio:</label>
                                    </div>
                                    <div class="col-md-8 mb-1">
                                        <div class="input-group mb-0 " >
                                            <select class="form-control" name="TipoCambio" id="TipoCambio" onchange="" required>
                                                <?php if( $s_TipoProc == "shw" || $s_TipoProc == "dlt" ){ ?>
                                                    <option value=""> VENTA - <?=$o_CP_ObligacionesBN->getTipoCambio()?> </option>
                                                <?php }else{ ?>
                                                    <?php if( GSS_TipoCambioFN::getStaticTipoCambioVenta() ){ ?>
                                                        <option value="<?=GSS_TipoCambioFN::getStaticTipoCambioVenta()?>"> VENTA - <?=GSS_TipoCambioFN::getStaticTipoCambioVenta()?> </option>
                                                    <?php } ?>
                                                <?php } ?>
                                            </select>
                                            <div class="input-group-append">
                                                <button class="btn btn-outline-secondary" id="btnBuscarTipoCambio" type="button">Buscar</button>
                                                <script type="text/javascript">
                                                    $( "#btnBuscarTipoCambio" )
                                                        .click
                                                        (
                                                            function()
                                                            {
                                                                blockContent( 'content_tipo_cambio' );
                                                                var strFormSerialize = "fecha=" + $( "#FechaEmision" ).val();
                                                                executeAjaxJson
                                                                (
                                                                    "<?php echo buildUrlComplet( 'vta/pro/request', 'TipoProc=registrar_tc' ) ?>",
                                                                    strFormSerialize,
                                                                    function( o_json )
                                                                    {
                                                                        unBlockContent( 'content_tipo_cambio' );
                                                                        //location.reload();
                                                                        $( "#TipoCambio" ).empty();
                                                                        $( "#TipoCambio" ).append( "<option value='" + o_json.f_SunatVenta + "'> VENTA - " + o_json.f_SunatVenta + " </option>" );
                                                                        //$( "#TipoCambio" ).val( o_json.f_SunatVenta );
                                                                        //aqui se tiene q agregar por el combo
                                                                    }
                                                                );
                                                            }
                                                        );
                                                </script>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-row mx-0">
                            <div class="col-md-6 mb-1">
                                <div class="form-row">
                                    <div class="col-md-4 mb-1">
                                        <label for="AfectoIGV" class="col-form-label">Tipo IGV:</label>
                                    </div>
                                    <div class="col-md-8 mb-1">
                                        <select class="form-control" name="AfectoIGV" id="AfectoIGV" onchange="" required>
                                            <option value="1" <?php if( $o_CP_ObligacionesBN->getAfectoIGV() ){ echo "SELECTED"; } ?> > IGV Afecto </option>
                                            <option value="0" <?php if( !$o_CP_ObligacionesBN->getAfectoIGV() ){ echo "SELECTED"; } ?> > IGV No Afecto </option>
                                        </select>
                                        <script>
                                            $( "#AfectoIGV" ).change
                                            (
                                                function ( elm )
                                                {
                                                    $( "#MontoNoAfecto" ).val( '' );
                                                    $( "#MontoAfecto" ).val( '' );
                                                    $( "#MontoIGV" ).val( '' );
                                                    $( "#MontoTotal" ).val( '' );
                                                }
                                            );
                                        </script>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 mb-1">
                                &nbsp;
                            </div>
                        </div>
                        <div class="form-row mx-0">
                            <div class="col-md-6 mb-1">
                                <div class="form-row">
                                    <div class="col-md-4 mb-1">
                                        <label for="MontoAfecto" class="col-form-label">Afecto:</label>
                                    </div>
                                    <div class="col-md-8 mb-1">
                                        <input type="text" class="form-control text-center" name="MontoAfecto" id="MontoAfecto" value="<?=$o_CP_ObligacionesBN->getMontoAfecto()?>" autocomplete="off" onfocus="this.select();" >
                                        <script>
                                            $( "#MontoAfecto" ).blur
                                            (
                                                function ( elm )
                                                {
                                                    let MontoSubTotal = parseFloat( $( elm.target ).val() );
                                                    if( !MontoSubTotal )
                                                    {
                                                        return false;
                                                    }

                                                    let AfectoaIGV = parseInt( $( "#AfectoIGV" ).val() );
                                                    if( AfectoaIGV )
                                                    {
                                                        let MontoIGV = redondear( ( MontoSubTotal * 0.18 ), 2 );
                                                        let MontoTotal = redondear( ( MontoSubTotal + MontoIGV ), 2 );

                                                        $( "#MontoNoAfecto" ).val( 0 );
                                                        $( "#MontoAfecto" ).val( MontoSubTotal );
                                                        $( "#MontoIGV" ).val( MontoIGV );
                                                        $( "#MontoTotal" ).val( MontoTotal );
                                                    }
                                                    else
                                                    {

                                                        $( "#MontoNoAfecto" ).val( MontoSubTotal );
                                                        $( "#MontoAfecto" ).val( 0 );
                                                        $( "#MontoIGV" ).val( 0 );
                                                        $( "#MontoTotal" ).val( MontoSubTotal );
                                                    }
                                                }
                                            );
                                        </script>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 mb-1">
                                <div class="form-row">
                                    <div class="col-md-4 mb-1">
                                        <label for="MontoNoAfecto" class="col-form-label">No Afecto:</label>
                                    </div>
                                    <div class="col-md-8 mb-1">
                                        <input type="text" class="form-control text-center" name="MontoNoAfecto" id="MontoNoAfecto" autocomplete="off" value="<?=$o_CP_ObligacionesBN->getMontoNoAfecto()?>" onfocus="this.select();" >
                                        <script>
                                            $( "#MontoNoAfecto" ).blur
                                            (
                                                function ( elm )
                                                {
                                                    let MontoSubTotal = parseFloat( $( elm.target ).val() );
                                                    if( !MontoSubTotal )
                                                    {
                                                        return false;
                                                    }

                                                    let AfectoaIGV = parseInt( $( "#AfectoIGV" ).val() );
                                                    if( AfectoaIGV )
                                                    {
                                                        let MontoIGV = redondear( ( MontoSubTotal * 0.18 ), 2 );
                                                        let MontoTotal = redondear( ( MontoSubTotal + MontoIGV ), 2 );

                                                        $( "#MontoNoAfecto" ).val( 0 );
                                                        $( "#MontoAfecto" ).val( MontoSubTotal );
                                                        $( "#MontoIGV" ).val( MontoIGV );
                                                        $( "#MontoTotal" ).val( MontoTotal );
                                                    }
                                                    else
                                                    {

                                                        $( "#MontoNoAfecto" ).val( MontoSubTotal );
                                                        $( "#MontoAfecto" ).val( 0 );
                                                        $( "#MontoIGV" ).val( 0 );
                                                        $( "#MontoTotal" ).val( MontoSubTotal );
                                                    }
                                                }
                                            );
                                        </script>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-row mx-0">
                            <div class="col-md-6 mb-1">
                                <div class="form-row">
                                    <div class="col-md-4 mb-1">
                                        <label for="MontoIGV" class="col-form-label">Impuesto:</label>
                                    </div>
                                    <div class="col-md-8 mb-1">
                                        <input type="text" class="form-control text-center" name="MontoIGV" id="MontoIGV" autocomplete="off" value="<?=$o_CP_ObligacionesBN->getMontoIGV()?>" onfocus="this.select();" required >
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 mb-1">
                                <div class="form-row">
                                    <div class="col-md-4 mb-1">
                                        <label for="MontoTotal" class="col-form-label">Monto Total:</label>
                                    </div>
                                    <div class="col-md-8 mb-1">
                                        <input type="text" class="form-control text-center" name="MontoTotal" id="MontoTotal" autocomplete="off" value="<?=$o_CP_ObligacionesBN->getMontoTotal()?>" onfocus="this.select();" required>
                                        <script>
                                            $( "#MontoTotal" ).blur
                                            (
                                                function ( elm )
                                                {
                                                    let MontoTotal = parseFloat( $( elm.target ).val() );
                                                    if( !MontoTotal )
                                                    {
                                                        return false;
                                                    }

                                                    let AfectoaIGV = parseInt( $( "#AfectoIGV" ).val() );
                                                    if( AfectoaIGV )
                                                    {
                                                        let MontoSubTotal = redondear( ( MontoTotal / 1.18 ), 2 );
                                                        let MontoIGV      = redondear( ( MontoTotal - MontoSubTotal ), 2 );

                                                        $( "#MontoNoAfecto" ).val( 0 );
                                                        $( "#MontoAfecto" ).val( MontoSubTotal );
                                                        $( "#MontoIGV" ).val( MontoIGV );
                                                    }
                                                    else
                                                    {
                                                        $( "#MontoNoAfecto" ).val( MontoTotal );
                                                        $( "#MontoAfecto" ).val( 0 );
                                                        $( "#MontoIGV" ).val( 0 );
                                                    }
                                                }
                                            );
                                        </script>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="dropdown-divider"></div>

                        <div class="form-row mx-0">
                            <div class="col-md-6 mb-1">
                                <div class="form-row">
                                    <div class="col-md-4 mb-1">
                                        <label for="TerminoId" class="col-form-label">T&eacute;rminos:</label>
                                    </div>
                                    <div class="col-md-8 mb-1">
                                        <select class="form-control" name="TerminoId" id="TerminoId" onchange="" required>
                                            <option value=""> - Seleccione - </option>
                                            <?php foreach( CP_TerminosFN::selectActivos() as $o_CP_TerminosBN ){ ?>
                                            <option value="<?=$o_CP_TerminosBN->getTerminoId()?>" cantidad="<?=$o_CP_TerminosBN->getCantidad()?>" <?php if( $o_CP_ObligacionesBN->getTerminoId() == $o_CP_TerminosBN->getTerminoId() ){ echo "SELECTED"; } ?> > <?=$o_CP_TerminosBN->getDescripcion()?> </option>
                                            <?php } ?>
                                        </select>
                                        <script>
                                            $( "#TerminoId" ).change
                                            (
                                                function ( elm )
                                                {
                                                    if( $("#FechaEmision").val().trim() != "" )
                                                    {
                                                        if( $( elm.target ).val() != "" )
                                                        {
                                                            var Cantidad = $( elm.target ).find(':selected').attr('cantidad');

                                                            $( "#FechaVencimiento" ).val( mostrarFecha( $("#FechaEmision").val(), Cantidad ) );
                                                        }
                                                        else
                                                        {
                                                            $( "#FechaVencimiento" ).val( mostrarFecha( $("#FechaEmision").val(), 0 ) );
                                                        }
                                                    }
                                                    else
                                                    {
                                                        $( elm.target ).val( "" );
                                                    }
                                                }
                                            );
                                        </script>
                                    </div>
                                </div>
                            </div>
                            <!--
                            <div class="col-md-6 mb-1">
                                <div class="form-row">
                                    <div class="col-md-4 mb-1">
                                        <label for="MetodoPagoId" class="col-form-label">M&eacute;todo Pago:</label>
                                    </div>
                                    <div class="col-md-8 mb-1">
                                        <select class="form-control" name="MetodoPagoId" id="MetodoPagoId" onchange="" required>
                                            <option value=""> - Seleccione - </option>
                                            <?php /*foreach( CP_MetodosPagoFN::selectActivos() as $o_CP_MetodosPagoBN ){ */?>
                                                <option value="<?/*=$o_CP_MetodosPagoBN->getMetodoPagoId()*/?>" <?php /*if( $o_CP_ObligacionesBN->getMetodoPagoId() == $o_CP_MetodosPagoBN->getMetodoPagoId() ){ echo "SELECTED"; } */?>  > <?/*=$o_CP_MetodosPagoBN->getNombre()*/?> </option>
                                            <?php /*} */?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            -->
                        </div>


                    </div>
                </div>
            </div>
        </div>
        <!--
        <div class="form-row p-1 mx-0">

            <div class="col-md-12 mb-1">
                <div class="card">
                    <h5 class="card-header">Detalles</h5>

                    <div class="card-body" style="padding: 10px;">

                        <div class="form-row mx-0">
                            <div class="col-md-6 mb-2">
                                <button type="button" id="btnAgregarSrv" class="btn btn-primary btn-sm">[-] Servicios</button>
                                <script>
                                    $( "#btnAgregarSrv" ).click
                                    (
                                        function()
                                        {
                                            var frameSrc = "<?=buildUrlComplet( 'vta.php/pro/listServices', '' )?>";
                                            $( "#exampleModalLongTitle" ).html( "Buscar Servicios" );
                                            $( '#iframe_id' ).attr( "src", frameSrc );
                                            $( '#exampleModalCenter' ).modal( { show:true } );
                                        }
                                    );
                                    asignarValores = function()
                                    {
                                        //aqui se agrega el detalle para las obligaciones
                                        pr( arguments );
                                        ocultarModal();
                                    }
                                </script>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table table-sm table-bordered table-hover">
                                <thead class="thead-light">
                                    <tr>
                                        <th width="2%"  style="text-align: center;" scope="col"><b>No</b></th>
                                        <th width="10%"  style="text-align: center;" scope="col"><b>C&oacute;digo</b></th>
                                        <th width="25%" align="" scope="col"><b>Descripci&oacute;n</b></th>
                                        <th width="10%"  style="text-align: center;" scope="col"><b>Precio</b></th>
                                        <th width="10%"  style="text-align: center;" scope="col" nowrap=""><b>Sub Total</b></th>
                                        <th width="10%"  style="text-align: center;" scope="col" nowrap=""><b>Total</b></th>
                                        <th width="5%"  align="center" scope="col">&nbsp;</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        -->
    </div>

    <?php if( $s_TipoProc == "nvo" ){ ?>
    <div class="card mt-2" id="content_buttons">
        <div class="card-body" style="padding: 5px;">
            <div class="form-row mx-0">
                <div class="col-md-6 mb-1">
                    <button type="button" class="btn btn-secondary btn-lg btn-block" id="btnCancelar" onclick="location.href='<?php echo buildUrl( 'fact/list' ) ?>'">CANCELAR</button>
                </div>
                <div class="col-md-6 mb-1">
                    <button type="submit" class="btn btn-primary btn-lg btn-block" id="btnGuardarFactPorOrden" style="margin-top: 0;" onclick="">GENERAR OBLIGACION</button>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>

</form>

<?php if( $s_TipoProc == "shw" || $s_TipoProc == "dlt" ){ ?>
<?php
//SE BUSCA APLICACIONES
$o_FCO_AplicacionFN = new CP_AplicacionFN();
$o_FCO_AplicacionFN->setIdDocNumRef( $o_CP_ObligacionesBN->getObligacionesId() );
$a_FCO_Aplicacion = $o_FCO_AplicacionFN->select();

//SE BUSCA NOTA DE CREDITO COMO REFERENCIA:
$o_CP_ObligacionesFN = new CP_ObligacionesFN();
$o_CP_ObligacionesFN->setComprobanteRefId( $o_CP_ObligacionesBN->getObligacionesId() );
$a_AplicacionNC = $o_CP_ObligacionesFN->select();

//AHORA SI ES NOTA DE CREDITO SE BUSCA LA RELACION DE FACTURA
if( $o_CP_ObligacionesBN->getIdTipoDocumento() == "NC" )
{
    $o_CP_ObligacionesFN = new CP_ObligacionesFN();
    $o_CP_ObligacionesFN->setObligacionesId( $o_CP_ObligacionesBN->getComprobanteRefId() );
    $a_AplicacionNC = $o_CP_ObligacionesFN->select();
}
?>
<br>
<div class="table-responsive">
    <table class="table table-sm table-bordered table-hover">
        <thead class="thead-light">
        <tr>
            <th width="8%"  style="text-align: center;"><b>Fecha Apli</b></th>
            <th width="10%" style="text-align: center;"><b>Tipo</b></th>
            <th width="10%" style="text-align: center;"><b>Nro Operacion</b></th>
            <th width="10%" style="text-align: center;"><b>Observaciones</b></th>
            <th width="10%" style="text-align: center;"><b>Moneda</b></th>
            <th width="10%" style="text-align: center;"><b>Monto Apli</b></th>
        </tr>
        </thead>
        <?php foreach ( $a_FCO_Aplicacion as $i_aplication => $o_FCO_AplicacionBN ){ ?>
        <tbody>
            <tr>
                <td style="text-align: center;"><?=substr( $o_FCO_AplicacionBN->getFechaAplicacion(), 0, 10 )?></td>
                <td style="text-align: center;"><?=$o_FCO_AplicacionBN->getTipoPagoNombre()?></td>
                <td style="text-align: center;"><?=$o_FCO_AplicacionBN->getReciboNumero()?></td>
                <td style="text-align: center;" nowrap="nowrap"><?=$o_FCO_AplicacionBN->getObjectDocRecibo()->getBancoDesc()?> <?=$o_FCO_AplicacionBN->getObjectDocRecibo()->getObjectCuentaBancaria()->getNumeroCuentaCorto()?></td>
                <td style="text-align: center;"><?=$o_FCO_AplicacionBN->getMonedaDes()?></td>
                <td style="text-align: right;"><?=number_format( $o_FCO_AplicacionBN->getMontoAplicado(), 2 )?></td>
            </tr>
        </tbody>
        <?php } ?>
        <?php foreach ( $a_AplicacionNC as $i_aplication => $o_AplicacionBN ){ ?>
            <?php if( $o_CP_ObligacionesBN->getIdTipoDocumento() == "NC" ){ $o_AplicacionBN->setFechaPago( $o_CP_ObligacionesBN->getFechaPago() ); $o_AplicacionBN->setMontoTotal( $o_CP_ObligacionesBN->getMontoTotal() ); } ?>
            <tbody>
            <tr>
                <td style="text-align: center;"><?=substr( $o_AplicacionBN->getFechaPago(), 0, 10 )?></td>
                <td style="text-align: center;"><?=$o_AplicacionBN->getTipoDocumentoCod()?></td>
                <td style="text-align: center;"><?=$o_AplicacionBN->getDocumentoSerieNumero()?></td>
                <td style="text-align: center;" nowrap="nowrap"><?=$o_AplicacionBN->getTipoDocumentoDesc()?> EN <?=$o_AplicacionBN->getMonedaDesc()?></td>
                <td style="text-align: center;"><?=$o_AplicacionBN->getMonedaDesc()?></td>
                <td style="text-align: right;"><?=number_format( abs( $o_AplicacionBN->getMontoTotal() ), 2 )?></td>
            </tr>
            </tbody>
        <?php } ?>
        <tr><td colspan="6">&nbsp;</td></tr>
        <tr><td colspan="6">&nbsp;</td></tr>
        <tr>
            <td align="right" colspan="5">SALDO: <?=GSS_MonedaMastFN::getSiglaxId( $o_CP_ObligacionesBN->getIdMoneda() )?></td>
            <td align="center"><?=number_format( ( $o_CP_ObligacionesBN->getMontoSaldo() ), 2 )?></td>
        </tr>
    </table>
</div>
<?php } ?>

<script>
    buscarInfoOrdenCompra = function()
    {
        if( $( "#IdOrdenCompra" ).val() != "" )
        {
            blockContent( 'form1' );
            var ParamURL = "TipoProc=getOrdenCompraInfo&IdOrdenCompra=" + $( "#IdOrdenCompra" ).val();
            executeAjaxJson
            (
                "<?php echo buildUrl( 'fact/requestFactAlm', "" ) ?>",
                ParamURL,
                function( o_json )
                {
                    unBlockContent( 'form1' );

                    if( o_json.error )
                    {
                        showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                        return false;
                    }

                    //validaciones por clase de documento y tipo de documento del cliente - 2020-08-07

                    $( "#FechaEmision" ).val( "<?=date( "Y-m-d" )?>" );
                    $( "#ProveedorId" ).val( o_json.i_IdProveedor );
                    //$( "#TipoCambio" ).val( o_json.f_TipoCambio );
                    $( "#TerminoId" ).val( o_json.i_TerminoId );
                    $( "#MetodoPagoId" ).val( o_json.s_IdMonedaPago );
                    $( "#Descripcion" ).val( o_json.s_Descripcion );
                    $( "#TerminoId" ).trigger( 'change' );
                    $( "#IdMoneda" ).val( o_json.s_IdMoneda );
                    $( "#AfectoIGV" ).val( o_json.i_AfectoIGV );

                    if( o_json.i_AfectoIGV )
                    {
                        $("#MontoNoAfecto").val( o_json.f_MontoNoAfecto );
                        $("#MontoAfecto").val( o_json.f_MontoAfecto );
                        $("#MontoIGV").val( o_json.f_MontoIGV );
                        $("#MontoTotal").val( o_json.f_MontoBruto );
                    }
                    else
                    {
                        $("#MontoNoAfecto").val( o_json.f_MontoPendientePago );
                        $("#MontoAfecto").val( 0 );
                        $("#MontoIGV").val( 0 );
                        $("#MontoTotal").val( o_json.f_MontoPendientePago );
                    }

                    buscarInfoProveedor();
                }
            );
        }
    }

    buscarInfoProveedor = function()
    {
        if( $( "#ProveedorId" ).val() != "" )
        {
            blockContent( 'content_buttons' );
            var ParamURL = "TipoProc=getProveedorInfo&IdPersona=" + $( "#ProveedorId" ).val();
            executeAjaxJson
            (
                "<?php echo buildUrl( 'fact/requestFactAlm', "" ) ?>",
                ParamURL,
                function( o_json )
                {
                    unBlockContent( 'content_buttons' );

                    if( o_json.error )
                    {
                        showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                        return false;
                    }

                    if( $( "#IdTipoDocumento" ).val() == "" )
                    {
                        //validaciones por clase de documento y tipo de documento del cliente - 2020-08-07
                        if (o_json.TipoDocumento == "RUC") //cliente juridico
                        {
                            $("#IdTipoDocumento").val( "FC" );
                        }
                    }

                    $( "#ProveedorNombre" ).val( o_json.Nombre );
                    $( "#ProveedorDocNum" ).val( o_json.Documento );

                }
            );
        }
        else
        {
            showAlertBootStrap( 'content_alert', 'alert-danger', "Debe de seleccionar un proveedor." );
        }
    }
</script>

<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->
<style type="text/css">
    .modal
    {
        padding: 0 !important;

    }
    .modal-dialog {
        max-width: 95% !important;
        height: 90%;
        /*  padding: 0;
          margin: 0;*/
    }

    .modal-content {
        /*border-radius: 0 !important;*/
        height: 90%;
    }
    .modal-body{
        overflow-y: auto;
    }
</style>
<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->

<!-- Modal -  -->
<div class="modal hide fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle"></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <iframe id="iframe_id" src="" style="" width="99.6%" height="99.6%" frameborder="0"></iframe>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <!--<button type="button" class="btn btn-primary">Save changes</button>-->
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    ocultarModal = function()
    {
        $( '#exampleModalCenter' ).modal( 'hide' );
    }
</script>
<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->

<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->
<!--OTRO POPUP-->
<style>
</style>
<div class="modal hide fade" id="exampleModalCenter2" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle2" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle2">Buscar Orden de Compra</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

                <!--<table id="example" class="table table-striped table-hover responsive" style="width:100%">-->
                <table id="example" class="table table-striped table-bordered" style="width:100%">

                </table>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <!--<button type="button" class="btn btn-primary">Save changes</button>-->
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    ocultarModal2 = function()
    {
        $( '#exampleModalCenter2' ).modal( 'hide' );
    }

    /*
    dataTableProv.on
    (
        'responsive-resize', function ( e, datatable, columns )
        {
            var count = columns.reduce
            (
                function ( a, b )
                {
                    return b === false ? ( a + 1 ) : a;
                },
                0
            );
            pr( count + ' column(s) are hidden' );
        }
    );
    */

    /*$( '#exampleModalCenter2' ).on
    (
        'shown.bs.modal', function ()
        {
            var table = $( '#example' ).DataTable();
            table.columns.adjust();
        }
    );*/

</script>

<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->
<!--OTRO POPUP-->
<style>
</style>
<div class="modal hide fade" id="exampleModalCenter3" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle3" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle3">Buscar Orden de Compra</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

                <!--<table id="example" class="table table-striped table-hover responsive" style="width:100%">-->
                <table id="example2" class="table table-striped table-bordered" style="width:100%">

                </table>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <!--<button type="button" class="btn btn-primary">Save changes</button>-->
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    ocultarModal3 = function()
    {
        $( '#exampleModalCenter3' ).modal( 'hide' );
    }
</script>
<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->

<style>
    #example tbody tr.even:hover, #example tbody tr.even td.highlighted
    {
        background-color: #ECFFB3;
    }

    #example tbody tr.odd:hover, #example tbody tr.odd td.highlighted
    {
        background-color: #E6FF99;
    }

    #example tr.even:hover
    {
        background-color: #ECFFB3;
    }

    #example tr.even:hover td.sorting_1
    {
        background-color: #DDFF75;
    }

    #example tr.even:hover td.sorting_2
    {
        background-color: #E7FF9E;
    }

    #example tr.even:hover td.sorting_3
    {
        background-color: #E2FF89;
    }

    #example tr.odd:hover
    {
        background-color: #E6FF99;
    }

    #example tr.odd:hover td.sorting_1
    {
        background-color: #D6FF5C;
    }

    #example tr.odd:hover td.sorting_2
    {
        background-color: #E0FF84;
    }

    #example tr.odd:hover td.sorting_3
    {
        background-color: #DBFF70;
    }
</style>
<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->

<?php if( $s_TipoProc == "shw" || $s_TipoProc == "dlt" ){ ?>
<script type="text/javascript">
    convertirDisabledTodosLosInputs();
</script>
<?php } ?>

<?php if( $s_TipoProc == "dlt" ){ ?>
<form name="form1" id="form1" method="POST" action="" onsubmit="">
    <input type="hidden" name="Control" id="Control" value="1">
    <input type="hidden" name="TipoProc" id="TipoProc" value="<?=$s_TipoProc?>">
    <input type="hidden" name="Id" id="Id" value="<?=$o_CP_ObligacionesBN->getObligacionesId()?>">

    <div class="card mt-2" id="">
        <div class="card-body" style="padding: 5px;">
            <div class="form-row mx-0">
                <div class="col-md-6 mb-1">
                    <button type="button" class="btn btn-secondary btn-lg btn-block" id="btnCancelar" onclick="location.href='<?php echo buildUrl( 'fact/list' ) ?>'">CERRAR</button>
                </div>
                <div class="col-md-6 mb-1">
                    <button type="submit" class="btn btn-primary btn-lg btn-block" id="btnGuardarFactPorOrden" style="margin-top: 0;" onclick="">ANULAR</button>
                </div>
            </div>
        </div>
    </div>
</form>
<?php } ?>

<?php if( $b_Control ){ ?>
<script>
    parent.findControl();
    parent.closeWindow();
</script>
<?php } ?>
