<?php
class AddeditfactAction extends wtActions
{
    public function execute()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_TipoProc = $this->getRequestParameter( "TipoProc" );
        $this->s_Id       = $this->getRequestParameter( "Id" );
        $this->b_Control  = $this->getRequestParameter( "Control" );

        $this->s_Titulo  = "Registro de Obligaciones";
        $this->b_Error   = false;
        $this->s_Mensaje = "";

        $this->o_CP_ObligacionesBN = new CP_ObligacionesBN();
        $this->o_CP_ObligacionesBN->setAfectoIGV( 1 );

        if( $this->s_TipoProc == "upd" || $this->s_TipoProc == "shw" || $this->s_TipoProc == "dlt"  )
        {
            $this->s_Titulo = "Edicion de Obligaciones";

            $o_CP_ObligacionesFN = new CP_ObligacionesFN();
            $this->o_CP_ObligacionesBN = $o_CP_ObligacionesFN->selectByPK( $this->s_Id );
        }

        if( $this->getRequestParameter( "Control" ) )
        {
            //se hace un submit
            $con = Conexion::getConexion();
            $con->begin();
            try
            {
                myUser::getUser()->validar_session();

                //VALIDAR -> PROVEEDOR, TIPO DOC, SERIE Y NUMERO

                if( $this->s_TipoProc == "dlt" )
                {
                    //VALIDAR DOCUMENTO, NO SE DEBE DE ANULAR CUANDO ESTA PAGADO


                    $o_CP_ObligacionesFN = new CP_ObligacionesFN();
                    $o_CP_ObligacionesBN = $o_CP_ObligacionesFN->selectByPK( $this->s_Id );

                    if( $o_CP_ObligacionesBN )
                    {
                        $o_CP_ObligacionesDP = new CP_ObligacionesDP();
                        $o_CP_ObligacionesDP->setObligacionesId( ( int ) $this->s_Id );
                        $o_CP_ObligacionesDP->setEstado( CP_ObligacionesBN::ESTADO_CANCELADO );
                        $o_CP_ObligacionesDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_CP_ObligacionesDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_CP_ObligacionesDP->update();

                        $con->commit();
                    }
                }
                else
                {
                    $IdTipoDocumento  = $this->getRequestParameter( "IdTipoDocumento" );
                    $FechaEmision     = $this->getRequestParameter( "FechaEmision" );
                    $FechaVencimiento = $this->getRequestParameter( "FechaVencimiento" );
                    $FechaProgramacion= $this->getRequestParameter( "FechaProgramacion" );
                    $DocumentoSerie   = $this->getRequestParameter( "DocumentoSerie" );
                    $DocumentoNumero  = $this->getRequestParameter( "DocumentoNumero" );
                    $IdOrdenCompra    = trim( $this->getRequestParameter( "IdOrdenCompra" ) ) != "" ? intval( $this->getRequestParameter( "IdOrdenCompra" ) ) : 'null';
                    $ProveedorId      = $this->getRequestParameter( "ProveedorId" );
                    $ProveedorDocNum  = $this->getRequestParameter( "ProveedorDocNum" );
                    $IdProyecto       = $this->getRequestParameter( "IdProyecto" );
                    $NombreProyecto   = $this->getRequestParameter( "NombreProyecto" );
                    $ProveedorNombre  = $this->getRequestParameter( "ProveedorNombre" );
                    $Descripcion      = strtoupper( $this->getRequestParameter( "Descripcion" ) );
                    $IdMoneda         = $this->getRequestParameter( "IdMoneda" );
                    $TipoCambio       = floatval( $this->getRequestParameter( "TipoCambio" ) );
                    $AfectoIGV        = intval( $this->getRequestParameter( "AfectoIGV" ) );
                    $MontoAfecto      = floatval( $this->getRequestParameter( "MontoAfecto" ) );
                    $MontoNoAfecto    = floatval( $this->getRequestParameter( "MontoNoAfecto" ) );
                    $MontoIGV         = floatval( $this->getRequestParameter( "MontoIGV" ) );
                    $MontoTotal       = floatval( $this->getRequestParameter( "MontoTotal" ) );
                    $TerminoId        = $this->getRequestParameter( "TerminoId" );
                    $MetodoPagoId     = $this->getRequestParameter( "MetodoPagoId" );

                    $ComprobanteRefId          = 'null';
                    $ComprobanteTipoRefId      = "";
                    $ComprobanteSerieNumeroRef = "";
                    $ComprobanteFechaEmisioRef = '';

                    if( is_numeric( substr( $DocumentoSerie, 0, 1 ) ) )
                    {
                        $s_Serie = str_pad( strtoupper( $DocumentoSerie ), 4, "0", STR_PAD_LEFT );
                    }
                    else
                    {
                        $s_Serie = strtoupper( $DocumentoSerie );
                    }

                    $s_Numero = str_pad( strtoupper( $DocumentoNumero ), 10, "0", STR_PAD_LEFT );

                    $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                    $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $ProveedorId );

                    $s_TipoDocumento  = $o_MST_PersonaMastBN->getTipoDocumento();
                    $s_Documento      = $o_MST_PersonaMastBN->getDocumento();
                    $o_NombreCompleto = $o_MST_PersonaMastBN->getNombreCompleto();

                    if( $IdProyecto )
                    {
                        $IdProyecto           = intval( $IdProyecto );
                        $o_VTA_PrsProyectosFN = new VTA_PrsProyectosFN();
                        $o_VTA_PrsProyectosBN = $o_VTA_PrsProyectosFN->selectByPK( $IdProyecto );
                        $NombreProyecto       = $o_VTA_PrsProyectosBN->getNombreProyecto();
                    }
                    else
                    {
                        $IdProyecto     = 'null';
                        $NombreProyecto = "";
                    }

                    $MontoAfectoMN   = $MontoAfecto;
                    $MontoNoAfectoMN = $MontoNoAfecto;
                    $MontoIGVMN      = $MontoIGV;
                    $MontoTotalMN    = $MontoTotal;

                    if( $IdMoneda == "EX" )
                    {
                        if( $AfectoIGV )
                        {
                            $MontoTotalMN  = round( $MontoTotal * $TipoCambio, 2 );
                            $MontoAfectoMN = round( $MontoAfecto * $TipoCambio, 2 );
                            $MontoIGVMN    = round( $MontoTotalMN - $MontoAfectoMN, 2 );

                        }
                        else
                        {
                            $MontoTotalMN  = round( $MontoTotal * $TipoCambio, 2 );
                            $MontoAfectoMN = $MontoTotalMN;
                            $MontoIGVMN    = 0;
                        }
                    }

                    if( $IdTipoDocumento == "NC" || $IdTipoDocumento == "ND" || $IdTipoDocumento == "LC" || $IdTipoDocumento == "LB" )
                    {
                        $ComprobanteRefId          = intval( $this->getRequestParameter( "ComprobanteRefId" ) );
                        $ComprobanteSerieNumeroRef = $this->getRequestParameter( "ComprobanteSerieNumeroRef" );

                        $o_CP_ObligacionesFN = new CP_ObligacionesFN();
                        $o_CP_ObligacionesBN = $o_CP_ObligacionesFN->selectByPK( $ComprobanteRefId );

                        $ComprobanteTipoRefId = $o_CP_ObligacionesBN->getIdTipoDocumento();

                        $ComprobanteFechaEmisioRef = $o_CP_ObligacionesBN->getFechaEmision();

                        //VALIDACIONES
                        if( $MontoTotal > $o_CP_ObligacionesBN->getMontoSaldo() )
                        {
                            throw new Exception( "El monto ingresado no puede ser mayor al Saldo del Documento de Referencia." );
                        }

                        //AHORA ACTUALIZAMOS SALDOS
                        $o_CP_ObligacionesDP = new CP_ObligacionesDP();
                        $o_CP_ObligacionesDP->setObligacionesId( $o_CP_ObligacionesBN->getObligacionesId() );
                        $o_CP_ObligacionesDP->setMontoPagado( $o_CP_ObligacionesBN->getMontoPagado() + $MontoTotal );
                        $o_CP_ObligacionesDP->setMontoPagadoMN( $o_CP_ObligacionesBN->getMontoPagadoMN() + $MontoTotalMN );
                        $o_CP_ObligacionesDP->setMontoSaldo( $o_CP_ObligacionesBN->getMontoSaldo() - $MontoTotal );
                        $o_CP_ObligacionesDP->setMontoSaldoMN( $o_CP_ObligacionesBN->getMontoSaldoMN() - $MontoTotal );
                        if( $MontoTotal == $o_CP_ObligacionesBN->getMontoSaldo() || $MontoTotalMN == $o_CP_ObligacionesBN->getMontoSaldoMN() )
                        {
                            $o_CP_ObligacionesDP->setEstadoPagado( CP_ObligacionesBN::ESTADO_PAG_COBRADO ); //PE pendiente | CO pagado
                        }
                        $o_CP_ObligacionesDP->setFechaPago( date( "Y-m-d" ) );
                        $o_CP_ObligacionesDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_CP_ObligacionesDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_CP_ObligacionesDP->update();
                    }

                    if( $IdTipoDocumento == "NC" )
                    {
                        if( $AfectoIGV )
                        {
                            $MontoAfecto   = $MontoAfecto * -1;
                            $MontoNoAfecto = 0;
                            $MontoIGV      = $MontoIGV * -1;
                            $MontoTotal    = $MontoTotal * -1;

                            $MontoAfectoMN   = $MontoAfectoMN * -1;
                            $MontoNoAfectoMN = 0;
                            $MontoIGVMN      = $MontoIGVMN * -1;
                            $MontoTotalMN    = $MontoTotalMN * -1;
                        }
                        else
                        {
                            $MontoAfecto   = 0;
                            $MontoNoAfecto = $MontoNoAfecto * -1;
                            $MontoIGV      = 0;
                            $MontoTotal    = $MontoTotal * -1;

                            $MontoAfectoMN   = 0;
                            $MontoNoAfectoMN = $MontoNoAfectoMN * -1;
                            $MontoIGVMN      = 0;
                            $MontoTotalMN    = $MontoTotalMN * -1;
                        }
                    }

                    $o_CP_ObligacionesBN = new CP_ObligacionesBN();
                    $o_CP_ObligacionesBN->setIdCompania( myUser::getUser()->getIdCompania() );
                    $o_CP_ObligacionesBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
                    $o_CP_ObligacionesBN->setIdTipoDocumento( $IdTipoDocumento );
                    $o_CP_ObligacionesBN->setPeriodo( UtilDate::getFormatDate( $FechaEmision, "Ym" ) );
                    $o_CP_ObligacionesBN->setFechaEmision( $FechaEmision );
                    $o_CP_ObligacionesBN->setFechaVencimiento( $FechaVencimiento );
                    $o_CP_ObligacionesBN->setFechaProgramacion( $FechaProgramacion );
                    $o_CP_ObligacionesBN->setDocumentoSerie( $s_Serie );
                    $o_CP_ObligacionesBN->setDocumentoNumero( $s_Numero );
                    $o_CP_ObligacionesBN->setDocumentoSerieNumero( $s_Serie."-".$s_Numero );
                    $o_CP_ObligacionesBN->setNumeroOC( $IdOrdenCompra );
                    $o_CP_ObligacionesBN->setProveedorId( ( int ) $ProveedorId );
                    $o_CP_ObligacionesBN->setProveedorDocTipo( $s_TipoDocumento );
                    $o_CP_ObligacionesBN->setProveedorDocNum( $s_Documento );
                    $o_CP_ObligacionesBN->setProveedorNombre( $o_NombreCompleto );
                    $o_CP_ObligacionesBN->setIdProyecto( $IdProyecto );
                    $o_CP_ObligacionesBN->setProyectoNombre( $NombreProyecto );
                    $o_CP_ObligacionesBN->setDescripcion( $Descripcion );
                    $o_CP_ObligacionesBN->setTerminoId( ( int ) $TerminoId );
                    $o_CP_ObligacionesBN->setMetodoPagoId( ( int ) $MetodoPagoId );
                    $o_CP_ObligacionesBN->setIdMoneda( $IdMoneda );
                    $o_CP_ObligacionesBN->setTipoCambio( $TipoCambio );
                    $o_CP_ObligacionesBN->setAfectoIGV( $AfectoIGV );

                    $o_CP_ObligacionesBN->setMontoAfecto( $MontoAfecto );
                    $o_CP_ObligacionesBN->setMontoAfectoMN( $MontoAfectoMN );
                    $o_CP_ObligacionesBN->setMontoNoAfecto( $MontoNoAfecto );
                    $o_CP_ObligacionesBN->setMontoNoAfectoMN( $MontoNoAfectoMN );
                    $o_CP_ObligacionesBN->setMontoIGV( $MontoIGV );
                    $o_CP_ObligacionesBN->setMontoIGVMN( $MontoIGVMN );
                    $o_CP_ObligacionesBN->setMontoTotal( $MontoTotal );
                    $o_CP_ObligacionesBN->setMontoTotalMN( $MontoTotalMN );

                    $o_CP_ObligacionesBN->setComprobanteRefId( $ComprobanteRefId );
                    $o_CP_ObligacionesBN->setComprobanteTipoRefId( $ComprobanteTipoRefId );
                    $o_CP_ObligacionesBN->setComprobanteSerieNumeroRef( $ComprobanteSerieNumeroRef );
                    if( $ComprobanteFechaEmisioRef )
                    {
                        $o_CP_ObligacionesBN->setComprobanteFechaEmisionRef( $ComprobanteFechaEmisioRef );
                    }

                    $o_CP_ObligacionesBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_CP_ObligacionesBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );

                    if( $this->s_TipoProc == "nvo" )
                    {
                        //cuando es nuevo
                        $i_Id = CP_ObligacionesDP::recuperarId();

                        $o_CP_ObligacionesBN->setObligacionesId( $i_Id );

                        $o_CP_ObligacionesBN->setMontoPagado( 0 );
                        $o_CP_ObligacionesBN->setMontoPagadoMN( 0 );
                        $o_CP_ObligacionesBN->setMontoSaldo( $MontoTotal );
                        $o_CP_ObligacionesBN->setMontoSaldoMN( $MontoTotalMN );
                        $o_CP_ObligacionesBN->setEstado( CP_ObligacionesBN::ESTADO_VALIDADO );       //VA validado | AN anulado | PE pendiente
                        $o_CP_ObligacionesBN->setEstadoPagado( CP_ObligacionesBN::ESTADO_PAG_PENDIENTE ); //PE pendiente | CO pagado

                        if( $IdTipoDocumento == "NC" )
                        {
                            $o_CP_ObligacionesBN->setMontoPagado( $MontoTotal );
                            $o_CP_ObligacionesBN->setMontoPagadoMN( $MontoTotalMN );
                            $o_CP_ObligacionesBN->setMontoSaldo( 0 );
                            $o_CP_ObligacionesBN->setMontoSaldoMN( 0 );
                            $o_CP_ObligacionesBN->setFechaPago( date( "Y-m-d H:i:s" ) );
                            $o_CP_ObligacionesBN->setEstadoPagado( CP_ObligacionesBN::ESTADO_PAG_COBRADO ); //PE pendiente | CO pagado
                        }

                        $o_CP_ObligacionesBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                        $o_CP_ObligacionesBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );

                        $o_CP_ObligacionesDP = new CP_ObligacionesDP( $o_CP_ObligacionesBN );
                        $o_CP_ObligacionesDP->save();

                        $this->s_Id = $i_Id;
                    }
                    else
                    {
                        $o_CP_ObligacionesBN->setObligacionesId( ( int ) $this->s_Id );
                        $o_CP_ObligacionesDP = new CP_ObligacionesDP( $o_CP_ObligacionesBN );
                        $o_CP_ObligacionesDP->update();
                    }

                    if( trim( $this->getRequestParameter( "IdOrdenCompra" ) ) )
                    {
                        $o_COM_OrdenCompraCabeceraBN = COM_OrdenCompraCabeceraFN::selectById( $IdOrdenCompra );
                        $f_NuevoSaldo = $o_COM_OrdenCompraCabeceraBN->getMontoPendientePago() - $o_CP_ObligacionesBN->getMontoTotal();

                        $o_COM_OrdenCompraCabeceraDP = new COM_OrdenCompraCabeceraDP();
                        $o_COM_OrdenCompraCabeceraDP->setIdCompania( myUser::getUser()->getIdCompania() );
                        $o_COM_OrdenCompraCabeceraDP->setIdOrdenCompra( $IdOrdenCompra );
                        $o_COM_OrdenCompraCabeceraDP->setMontoPendientePago( $f_NuevoSaldo );
                        $o_COM_OrdenCompraCabeceraDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_COM_OrdenCompraCabeceraDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_COM_OrdenCompraCabeceraDP->update();
                    }

                    //pr( $o_CP_ObligacionesBN ); exit;

                    $con->commit();

                    //redirect
                    $s_Dir = Constantes::ROOT_DIR_APP;
                    //header( "Location:$s_Dir/alm.php/fact/addeditfact/TipoProc/upd/Id/".$this->s_Id );
                    header( "Location:$s_Dir/alm.php/fact/list/" );
                }
            }
            catch ( Exception $o_Exception )
            {
                //pr( $o_Exception );
                $con->rollback();
                $this->b_Error   = true;
                $this->s_Mensaje = $o_Exception->getMessage();
            }


        }


    }
}
