<?php
class aprobacionActions extends wtActions
{
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        $this->block = $this->getRequestParameter( 'block' );
        
        $this->a_EstadosOC = array( COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_PREPARACION => "PREPARACION" );
        
        //SE RECUPERA LOS PROVEEDORES
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( 'SI' );
        //$o_MST_PersonaMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_MST_PersonaMastFN->setEstado( 'A' );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
        
        //ALMACEN
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_ALM_AlmacenMastFN->setEstado( "A" );
        $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
    }
    
    public function executeGrid()
    {
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new COM_OrdenCompraCabeceraFN() );
        
        $o_GridAction->addMethodDefault( COM_OrdenCompraCabeceraFN::Estado, COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_PREPARACION );
        $o_GridAction->addMethodDefault( "IdCompania", myUser::getUser()->getIdBusiness() );
        
        $o_GridAction->addAssignFilter( "IdCompania" );
        if( !myUser::getUser()->hasGlobalAccess() )
        {
            //$IdAlmacen = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
            ParameterWR::getInstance()->setVar( "IdAlmacenEntrega", "1" );
            $o_GridAction->addConditionFilter( "IdAlmacenEntrega", COM_OrdenCompraCabeceraFN::IdAlmacenEntrega, "IN", "(SELECT IdAlmacen FROM ALM_AlmacenMast WHERE IdSucursal='".myUser::getUser()->getIdSucursal()."')"  );
        }
        $o_GridAction->addAssignFilter( "TipoOrden" );
        $o_GridAction->addAssignFilter( "Estado" );
        
        $o_GridAction->addConditionFilter( "IdOrdenCompra", COM_OrdenCompraCabeceraFN::IdOrdenCompra, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "NombreProveedor", COM_OrdenCompraCabeceraFN::NombreProveedor, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "FechaDocumento1", COM_OrdenCompraCabeceraFN::FechaCreacion,    ">=" );
        $o_GridAction->addConditionFilter( "FechaDocumento2", COM_OrdenCompraCabeceraFN::FechaCreacion,    "<=" );
        
        //$o_GridAction->addOrder( "Codigo",           GSS_CompaniaFN::Codigo );
        //$o_GridAction->addOrder( "DescripcionCorta", GSS_CompaniaFN::DescripcionCorta );
        //$o_GridAction->addOrder( "Ruc",              GSS_CompaniaFN::Ruc );
        
        $o_GridAction->addOrderDefault( COM_OrdenCompraCabeceraFN::IdOrdenCompra, false );
        
        $o_GridAction->addRowsToShow
        (
                "IdOrdenCompraConcat", "IdOrdenCompra", "TipoOrden", "IdOrdenClasificacion", "FechaCreacion", "NumeroInterno", "MonedaDesc", "OrdenClasificacionDesc",
                "NombreProveedor", "Estado", "FormatMontoBruto", "FormatMontoDolares", "FechaEntrega", "AlmacenDesc", "EstadoDesc", "TipoOCDesc"
                );
        
        $o_GridAction->addInnerJoin( new COM_OrdenItemClasificacionFN(), "IdOrdenClasificacion", "Descripcion" );
        
        $o_GridAction->setNumberRecordsShow( 15 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }
    
    public function executeProcess()
    {
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->a_GSS_Compania= $o_GSS_CompaniaFN->select();
        
        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $this->a_GSS_MonedaMast = $o_GSS_MonedaMastFN->select();
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
        
        $a_Ids = explode( "_", $this->i_Id );
        $IdCompania    = $a_Ids[0];
        $IdOrdenCompra = $a_Ids[1];
        
        $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
        $this->o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );
        
        $o_COM_OrdenItemClasificacionFN = new COM_OrdenItemClasificacionFN();
        $o_COM_OrdenItemClasificacionFN->setIdCompania( $this->o_COM_OrdenCompraCabeceraBN->getIdCompania() );
        $this->a_COM_OrdenItemClasificacion = $o_COM_OrdenItemClasificacionFN->select();
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $this->o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega() );
    }
    
    public function executeSaveProcess()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_status   = $this->getRequestParameter( 'status' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        try 
        {
            $a_Ids = explode( "_", $i_Id );
            $IdCompania    = $a_Ids[0];
            $IdOrdenCompra = $a_Ids[1];
            
            $o_COM_OrdenCompraCabeceraBN = new COM_OrdenCompraCabeceraBN();
            $o_COM_OrdenCompraCabeceraBN->setIdCompania( ( int ) $IdCompania );
            $o_COM_OrdenCompraCabeceraBN->setIdOrdenCompra( ( int ) $IdOrdenCompra );
            $o_COM_OrdenCompraCabeceraBN->setTipoRequerimientoLog( COM_OrdenCompraCabeceraBN::TIPO_REQUERIMIENTO_LOG );
            
            $o_OrdenCompraBL = new OrdenCompraBL();
            $b_Result = $o_OrdenCompraBL->aprobarOrdenCompra( $o_COM_OrdenCompraCabeceraBN );
            
            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = "No se pudo eliminar el registro.";
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
}