<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>

<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/responsive/2.2.5/css/responsive.bootstrap4.min.css" />
<!--<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" />-->

<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/responsive.bootstrap4.min.js"></script>

<style type="text/css">
#example_wrapper .row
{
    margin-right: 0;
    margin-left: 0;
}
table.dataTable tbody tr:hover 
{
   background-color: #DAE6FE !important;;
}
.table td, .table th 
{
    /*padding: 8px;*/
    /*font-size: 13px;*/
    font-size: 0.9rem;
    vertical-align: middle;
    font-family: 'Poppins', sans-serif;
    padding: .35rem;
}
th { white-space: nowrap; }
</style>

<style>
.ui-datepicker {
    height: 180px;
    width: auto;
    top: 0 !important;
}
.ui-datepicker td span, .ui-datepicker td a {
    text-align: center;
    padding: 0;
}
.ui-datepicker table {
     font-size: 10px;
}
.ui-datepicker th {
    padding: 0;
}
</style>

<script type="text/javascript">
actualizarTipoDocumento = function( elm )
{
    param_url = 'ValorId=' + elm.value + '&TipoProc=actualizarTipoDocumento&OrdenId=<?=$o_VTA_OrdenBN->getOrdenId()?>';
    executeAjaxJson
    (
        "<?php echo buildUrl( 'cot/requestOrden' ) ?>",
        param_url,
        function( o_json )
        {
            respuestaActualizarFormaPago( o_json );
        }
    );
}
actualizarFormaPagoMaster = function( elm )
{
    param_url = 'FormaPagoId=' + elm.value + '&TipoProc=actualizarFormaPago&OrdenId=<?=$o_VTA_OrdenBN->getOrdenId()?>';
    executeAjaxJson
    (
        "<?php echo buildUrl( 'cot/requestOrden' ) ?>", 
        param_url,
        function( o_json )
        {
            respuestaActualizarFormaPago( o_json );
        }
    );
}
respuestaActualizarFormaPago = function( o_json )
{
    pr( o_json );
}

actualizarFechaAlquiler = function( fecha_alq )
{
    if( fecha_alq.trim() != "" )
    {
        blockContent( 'content_form' );
        param_url = 'OrdenId=<?=$o_VTA_OrdenBN->getOrdenId()?>&TipoProc=actualizarFechaAlquiler&FechaInicioAlquiler=' + fecha_alq;
        executeAjaxJson
        ( 
            "<?php echo buildUrl( 'cot/requestOrden' ) ?>", 
            param_url,
            function( o_json )
            {
                if( o_json.error )
                {
                	unBlockContent( 'content_form' );
                    showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                    return false;
                }
                location.reload();
            } 
        );
    }
}
</script>

<form name="form1" id="form1" method="POST" action="" onsubmit="">
    <input type="hidden" name="control" id="control" value="1" >
    <input type="hidden" name="tipoproc" id="tipoproc" value="list" >
    <input type="hidden" name="iddocrecibo" id="iddocrecibo" value="" >
    <input type="hidden" name="idaplicacion" id="idaplicacion" value="" >

    <div class="">
        <!--<h5 class="card-header">Datos Generales</h5>-->
        <div class="card-body" style="padding: 2px;">

            <?php if( $o_VTA_OrdenBN->getOrdenTipoId() == VTA_OrdenBN::ORDEN_MASTER ){ ?>
            <div class="form-row mx-0">
                <div class="col-md-3 mb-1">
                </div>
                <div class="col-md-3 mb-1">
                </div>
                <div class="col-md-3 mb-1">
                    <?php if( $a_GSS_SucursalDocumento ){ ?>
                    <select class="custom-select" name="ReferenciaTipoDocId" id="ReferenciaTipoDocId" onchange="actualizarTipoDocumento( this )" <?php if( $o_VTA_OrdenBN->getOrdenEstado() != VTA_OrdenBN::ESTADO_ABIERTO ){ echo "disabled"; } ?> >
                        <option value=""> - TIPO DOCUMENTO - </option>
                        <option value="BV"  <?php if( $o_VTA_OrdenBN->getReferenciaTipoDocId() == "BV" ){ echo "selected"; } ?> > BOLETA ELECTRONICA </option>
                        <option value="NV"  <?php if( $o_VTA_OrdenBN->getReferenciaTipoDocId() == "NV" ){ echo "selected"; } ?> > NOTA DE VENTA </option>
                    </select>
                    <?php } ?>
                </div>
                <div class="col-md-3 mb-1">
                    <!--
                    <?php if( !myUser::getUser()->getObjectCompania()->getUsarCreditoConCuotas() ){ ?>
                    <select class="custom-select" name="cboFormaPago" id="cboFormaPago" onchange="actualizarFormaPagoMaster( this )" <?php if( $o_VTA_OrdenBN->getOrdenEstado() != VTA_OrdenBN::ESTADO_ABIERTO ){ echo "disabled"; } ?> >
                        <option value=""> - CONDICION DE VENTA - </option>
                        <?php foreach ( VTA_FormaPagoFN::selectActivos() as $o_VTA_FormaPagoBN ) { ?>
                        <option value="<?=$o_VTA_FormaPagoBN->getIdFormaPago()?>"  <?php if( $o_VTA_OrdenBN->getCondicionVentaId() == $o_VTA_FormaPagoBN->getIdFormaPago() ){ echo "selected"; } ?> >
                            <?=$o_VTA_FormaPagoBN->getDescripcionLocal()?> 
                        </option>
                        <?php } ?>
                    </select>
                    <?php } ?>
                    -->
                </div>
            </div>
            <?php } ?>

            <div class="table-responsive" id="content_form">
                <table class="table table-borderless" style="margin-bottom: 0px; ">
                    <tbody>
                        <tr>
                            <th class="text-nowrap" scope="row">Nro Orden:</th>
                            <td class="text-nowrap" style="color: #fc6d00;"><?=$o_VTA_OrdenBN->getOrdenNum()?></td>
                            <th class="text-nowrap" scope="row">Tipo de Orden:</th>
                            <td class="text-nowrap" style="font-weight: bold; color: #fc6d00; font-size: 16px;"><?=$o_VTA_OrdenBN->getTipoOrdenComercialDesc()?> - <?=$o_VTA_OrdenBN->getTipoClasificacionDesc()?></td>
                            <th class="text-nowrap" scope="row">Fecha:</th>
                            <td class="text-nowrap" ><?=UtilDate::getFormatDate( $o_VTA_OrdenBN->getOrdenFecha(), "m/d H:i" ) ?></td>
                            <th class="text-nowrap" scope="row">Vencimiento</th>
                            <td class="text-nowrap" ><?=UtilDate::getFormatDate( $o_VTA_OrdenBN->getOrdenVenc(), "m/d H:i" )?></td>
                            <?php if( $o_VTA_OrdenBN->getOrdenTipoComercialId() == VTA_OrdenBN::TIPO_COMERCIAL_ALQUILER ){ ?>
                            <th class="text-nowrap" scope="row">Inicio Alquiler</th>
                            <td class="text-nowrap" >
                                <input class="form-control form-control-sm text-center" type="text" autocomplete="off" name="FechaInicioAlq" id="FechaInicioAlq" value="<?=$o_VTA_OrdenBN->getFechaInicioAlq()?>">
                                <script type="text/javascript">
                                $( "#FechaInicioAlq" ).datepicker( { dateFormat: "yy-mm-dd", changeYear:true, yearRange: "-0:+1", changeMonth: true, onClose: function ( fec_sel, obj_sel ){ actualizarFechaAlquiler( fec_sel ); } } );
                                </script>
                            </td>
                            <?php } ?>
                        </tr>
                        <tr>
                            <th class="text-nowrap" scope="row">Estado:</th>
                            <td class="text-nowrap" style="color: #fc6d00;">
                                <?=$o_VTA_OrdenBN->getOrdenEstadoDesc()?> 
                                <?php if( $o_VTA_OrdenBN->getOrdenEstado() == VTA_OrdenBN::ESTADO_ANULADO ){ echo "[".$o_VTA_OrdenBN->getAnulacionComentario()."]"; } ?>
                                <?php if( $o_VTA_OrdenBN->getOrdenEstado() == VTA_OrdenBN::ESTADO_FACTURA ){ echo "[".$o_VTA_OrdenBN->getObjectVTADocumento()->getDocumentoSerieNumero()."]"; } ?> 
                            </td>
                            <th class="text-nowrap" scope="row">Almacen Despacho:</th>
                            <td class="text-nowrap" style="color: #fc6d00;" ><?=$o_VTA_OrdenBN->getObjectAlmacenDespacho()->getDescripcionLocal()?></td>
                            <th class="text-nowrap" scope="row">Validez Oferta:</th>
                            <td class="text-nowrap" ><?=$o_VTA_OrdenBN->getValidezOrdenDesc()?></td>
                            <th class="text-nowrap" scope="row">Plazo Entrega:</th>
                            <td class="text-nowrap" ><?=$o_VTA_OrdenBN->getPlazoEntregaOrdenDesc()?></td>
                            <?php if( $o_VTA_OrdenBN->getOrdenTipoComercialId() == VTA_OrdenBN::TIPO_COMERCIAL_ALQUILER ){ ?>
                            <th class="text-nowrap" scope="row">Fin Alquiler</th>
                            <td class="text-nowrap" ><?=$o_VTA_OrdenBN->getFechaFinAlq()?></td>
                            <?php } ?>
                        </tr>
                        <tr>
                            <th class="text-nowrap" scope="row">Cliente:</th>
                            <td class="" ><?=$o_VTA_OrdenBN->getClienteNombre()?></td>
                            <th class="text-nowrap" scope="row">Cliente Documento:</th>
                            <td class="text-nowrap" ><?=$o_VTA_OrdenBN->getClienteDocCod()?>&nbsp;<?=$o_VTA_OrdenBN->getClienteDocNum()?></td>
                            <th class="text-nowrap" scope="row">A. Comercial:</th>
                            <td class="text-nowrap" ><?=$o_VTA_OrdenBN->getVendedorOrden()?></td>
                            <th class="text-nowrap" scope="row">Correo:</th>
                            <td class="text-nowrap" ><?=$o_VTA_OrdenBN->getObjectVendedor()->getEmail()?></td>
                            <?php if( $o_VTA_OrdenBN->getOrdenTipoComercialId() == VTA_OrdenBN::TIPO_COMERCIAL_ALQUILER ){ ?>
                            <th class="text-nowrap" scope="row">D&iacute;as Alquiler:</th>
                            <td class="text-nowrap" ><?=$o_VTA_OrdenBN->getDiasAlqOrdenDesc()?></td>
                            <?php } ?>
                        </tr>
                        <tr>
                            <th class="text-nowrap" scope="row">O/C:</th>
                            <td class="text-nowrap" colspan=""><?=$o_VTA_OrdenBN->getOrdenCompraRef()?></td>
                            <th class="text-nowrap" scope="row">Moneda:</th>
                            <td class="text-nowrap" style="color: #fc6d00;"> <?=$o_GSS_MonedaMastBN->getDescripcion()?></td>
                            <th class="text-nowrap" scope="row">Tipo Cambio:</th>
                            <td class="text-nowrap" ><?=$o_VTA_OrdenBN->getMonedaCambioValor()?></td>
                            <th class="text-nowrap" scope="row">Celular:</th>
                            <td class="text-nowrap" ><?=$o_VTA_OrdenBN->getObjectVendedor()->getCelular()?></td>
                            <?php if( $o_VTA_OrdenBN->getOrdenTipoComercialId() == VTA_OrdenBN::TIPO_COMERCIAL_ALQUILER ){ ?>
                            <!--<th class="text-nowrap" scope="row">Condici&oacute;n Venta:</th>
                            <td class="text-nowrap" ><?/*=$o_VTA_OrdenBN->getCondicionVentaDesc()*/?></td>-->
                            <?php } ?>
                        </tr>
                        <tr>
                            <th class="text-nowrap" scope="row">Direcci&oacuten:</th>
                            <td class="text-nowrap" colspan="4"><?=$o_VTA_OrdenBN->getFactDirec1()?> - <?=$o_VTA_OrdenBN->getFactDirec2()?></td>

                        </tr>
                    </tbody>
                </table>
            </div>

        </div>

    </div>

</form>

<div id="content_alert" style=""></div>

<?php if( $o_VTA_OrdenBN->getOrdenTipoId() == VTA_OrdenBN::ORDEN_ESTANDAR ){ ?>
<div class="card" class="mb-2" style="margin-top: 5px;">
    <?php if( $b_Edicion ){ ?>
    <div class="" style="text-align: right; margin-top: 5px; margin-right: 15px;">
        <button type="button" class="btn btn-primary btn-sm" aria-label="Right Align" onclick="agregarNuevoMetodoPago();">
            <!--<i class="fas fa-file"></i>-->
            Agregar Pago
        </button>
    </div>
    <?php } ?>

    <div class="dropdown-divider"></div>

    <table id="example" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th width="2%" style="text-align: center;"> # </th>
                <th style="text-align: center;">Medio Pago</th>
                <th style="text-align: center;">Nro Doc</th>
                <th style="text-align: center;">Fecha Doc</th>

                <?php if( $b_CtrlFactura ){ ?>
                <th style="text-align: center;"> Comprobante </th>
                <?php } ?>

                <th style="text-align: center;">T/C</th>
                <th style="text-align: center;">Aplicar</th>
                <th style="text-align: center;">Monto <?=$s_PrfMonedaOrd?></th>
                <th style="text-align: center;">Estado</th>
                <th style="text-align: center;">Opciones</th>
            </tr>
        </thead>
        <tbody>
            <?php $f_TotalAcumulado = 0 ?>
            <?php foreach ( $a_FCO_DocRecibo as $key => $o_FCO_DocReciboBN ) { ?>
                <?php
                $s_Prfx = GSS_MonedaMastFN::getSiglaxId( $o_FCO_DocReciboBN->getIdMoneda() );
                if( $o_VTA_OrdenBN->getMonedaCod() == "LO" )
                {
                    //moneda local
                    $f_MontoSelect = $o_FCO_DocReciboBN->getMontoMN();
                }
                else
                {
                    //moneda extrangera
                    $f_MontoSelect = $o_FCO_DocReciboBN->getMontoME();
                }
                $f_TotalAcumulado = $f_TotalAcumulado + $f_MontoSelect;
                ?>
                <tr>
                    <td align="center"><?=$key+1?></td>
                    <td align="center" nowrap=""><?=$o_FCO_DocReciboBN->getObjectTipoPago()->getNombre()?></td>
                    <td align="center"><?=$o_FCO_DocReciboBN->getReciboNumero()?></td>
                    <td align="center"><?=substr( $o_FCO_DocReciboBN->getReciboFecha(), 0, 10 )?></td>

                    <?php if( $b_CtrlFactura ){ ?>
                    <td align="center"><?=$o_FCO_DocReciboBN->getNumeroComprobante()?></td>
                    <?php } ?>

                    <td align="center"><?=$o_FCO_DocReciboBN->getTipoCambio()?></td>
                    <td align="center"><?=$s_Prfx." ".number_format( $o_FCO_DocReciboBN->getMonto(), 2 )?></td>
                    <td align="center"><?=number_format( $f_MontoSelect, 2 )?></td>
                    <td align="center"><?=$o_FCO_DocReciboBN->getFlujoEstadoDesc()?></td>
                    <td align="center" nowrap="">
                        <?php if( $b_Edicion ){ ?>
                        <button type="button" class="btn btn-primary btn-sm" aria-label="Right Align" onclick="editarMetodoPago( '<?=$o_FCO_DocReciboBN->getIdDocRecibo()?>', '<?=$o_FCO_DocReciboBN->getIdAplicacion()?>' );">
                            <i class="fas fa-edit"></i>
                        </button>
                        <!--<button type="button" class="btn btn-primary btn-sm" aria-label="Right Align">
                            <i class="fas fa-file-alt"></i>
                        </button>-->
                        <button type="button" class="btn btn-primary btn-sm" aria-label="Right Align" onclick="eliminarMetodoPago( '<?=$o_FCO_DocReciboBN->getIdDocRecibo()?>', '<?=$o_FCO_DocReciboBN->getIdAplicacion()?>' );">
                            <i class="fas fa-times-circle"></i>
                        </button>
                        <?php }else{ ?>
                            &nbsp;
                        <?php } ?>
                    </td>
                </tr>    
            <?php } ?>
        </tbody>
        <tbody>
            <tr>
                <?php if( $b_CtrlFactura ){ ?>
                <th colspan="2" style="text-align:right"><b>TOTAL PAGADO:&nbsp;&nbsp;&nbsp;&nbsp;<?=$s_PrfMonedaOrd?>&nbsp;<?=round( $f_TotalAcumulado, 2 )?></b></th>
                <?php }else{ ?>
                <th colspan="2" style="text-align:right"><b>TOTAL A PAGAR:&nbsp;&nbsp;&nbsp;&nbsp;<?=$s_PrfMonedaOrd?>&nbsp;<?=round( $f_TotalAcumulado, 2 )?></b></th>
                <?php } ?>
                <th colspan="8">&nbsp;</th>
            </tr>
        </tbody>
    </table>
</div>
<?php } ?>



<style type="text/css">
.modal
{
    padding: 5px !important;
}
.modal-dialog 
{
    
    max-width: 90% !important;
    /*height: 99%;*/
    
    /*padding: 0;
    margin: 0;*/
    margin: 0.8rem auto !important;
}

.modal-content 
{
    /*border-radius: 0 !important;*/
    /*height: 98%;*/
    height: 350px !important;
}

/*
.modal-open .modal.modal-center 
{
    display: flex!important;
    align-items: center!important;
    .modal-dialog 
    {
        flex-grow: 1;
    }
}
*/
</style>

<!-- Modal -->
<div class="modal hide fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document" style="">
        <div class="modal-content">
            <!--
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Documento de Pago</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            -->
            <div class="modal-body">
                <iframe id="iframe_id" src="" style="" width="99.6%" height="99.9%" frameborder="0"></iframe>
            </div>
            <!--<div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary">Save changes</button>
            </div>-->
        </div>
    </div>
</div>


<script type="text/javascript">
$('#example').DataTable
(
    {
        language: { "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json" },
        responsive: { details: true },
        searching: false,
        info:     false,
        lengthChange: false,
        //paging:   false,
        dom: 'lrtip'
    }
);
</script>


<script type="text/javascript">
agregarNuevoMetodoPago = function()
{
    var frameSrc = "<?=buildUrl( 'pro/addeditfco', 'fuente=ORD&tipoproc=nvo&idnumdoc='.$o_VTA_OrdenBN->getOrdenId().'&ord_num='.$o_VTA_OrdenBN->getOrdenNum() )?>";
    $( '#iframe_id' ).attr( "src", frameSrc );
    $( '#exampleModalCenter' ).modal( { show:true } );
}
editarMetodoPago = function( iddocrecibo, idaplicacion )
{
    var frameSrc = "<?=buildUrl( 'pro/addeditfco', 'fuente=ORD&tipoproc=edit&idnumdoc='.$o_VTA_OrdenBN->getOrdenId().'&ord_num='.$o_VTA_OrdenBN->getOrdenNum() )?>" + '/iddocrecibo/' + iddocrecibo + '/idaplicacion/' + idaplicacion;
    $( '#iframe_id' ).attr( "src", frameSrc );
    $( '#exampleModalCenter' ).modal( { show:true } );
}
verMetodoPago = function( iddocrecibo, idaplicacion )
{
    var frameSrc = "<?=buildUrl( 'pro/addeditfco', 'fuente=ORD&tipoproc=view&idnumdoc='.$o_VTA_OrdenBN->getOrdenId().'&ord_num='.$o_VTA_OrdenBN->getOrdenNum() )?>" + '/iddocrecibo/' + iddocrecibo + '/idaplicacion/' + idaplicacion;
    $( '#iframe_id' ).attr( "src", frameSrc );
    $( '#exampleModalCenter' ).modal( { show:true } );
}
eliminarMetodoPago = function( iddocrecibo, idaplicacion )
{
    x = confirm( "Esta seguro de eliminar el Metodo de Pago?" );
    if( x )
    {
        $( "#tipoproc" ).val( "del" );
        $( "#iddocrecibo" ).val( iddocrecibo );
        $( "#idaplicacion" ).val( idaplicacion );
        $( "#form1" ).submit();
    }
}
ocultarModal = function( control )
{
    $( '#exampleModalCenter' ).modal( 'hide' );
    if ( control !== undefined ) 
    {
        //$( "#form1" ).submit();
        location.href = "<?=buildUrl( 'cot/listOrdFco', 'ord_id='.$i_OrdId.'&ord_num='.$s_OrdNum )?>";
    }
}
</script>

<script type="text/javascript">
<?php if( $s_MensajeError ){ ?>
showAlertBootStrap( 'content_alert', 'alert-danger', '<?=$s_MensajeError?>' );
<?php } ?>
</script>