<?php
class SaveOrdenProdFinalAction extends wtActions
{
    public function execute()
    {
        $i_Id = ( int ) $this->getRequestParameter( 'i_Id' );
        
        $con = Conexion::getConexion();
        $con->begin();
        
        try
        {
            $TipoProc       = $this->getRequestParameter( 's_TipoProc' );
            $Secuencia      = $this->getRequestParameter( 'Secuencia' );
            $IdAdicional    = $this->getRequestParameter( 'id_adicional' );
            $IdItem         = $this->getRequestParameter( 'IdItem' );
            $IdAlmacen      = $this->getRequestParameter( 'IdAlmacen' );
            $IdLote         = $this->getRequestParameter( 'IdLote' );
            $CantidadPedida = $this->getRequestParameter( 'CantidadPedida' );
            $CantidadxCaja  = $this->getRequestParameter( 'CantidadxCaja' );
            //$PrecioUnitario = floatval( $this->getRequestParameter( 'PrecioUnitario' ) ); //se tiene que modificar si se hace el proceso de bajar precio
            //$NoAfecImpuesto = $this->getRequestParameter( 'NoAfectoImpuestoVentasFlag' );
            
            $o_ALM_ItemMastFN = new ALM_ItemMastFN();
            $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $IdItem );
            
            switch ( $TipoProc )
            {
                case "delparent":
                    
                    $s_ProFinalId = $this->getRequestParameter( 'id_parent' );

                    $o_VTA_ProductoFinalFN = new VTA_ProductoFinalFN();
                    $o_VTA_ProductoFinalBN = $o_VTA_ProductoFinalFN->selectByPK( $s_ProFinalId );

                    $o_VTA_ProductoFinalDetFN = new VTA_ProductoFinalDetFN();
                    $o_VTA_ProductoFinalDetFN->setProFinalId( $s_ProFinalId );
                    $o_VTA_ProductoFinalDetFN->setOrdenId( $i_Id );
                    $o_VTA_ProductoFinalDetFN->addOrderBy( VTA_ProductoFinalDetFN::Secuencia );
                    $a_VTA_ProductoFinalDet = $o_VTA_ProductoFinalDetFN->select();

                    $o_VTA_ProductoFinalDetDP = new VTA_ProductoFinalDetDP();
                    $o_VTA_ProductoFinalDetDP->setProFinalId( ( int ) $s_ProFinalId );
                    $o_VTA_ProductoFinalDetDP->deleteAll();
                    
                    $o_VTA_ProductoFinalDP = new VTA_ProductoFinalDP();
                    $o_VTA_ProductoFinalDP->setProFinalId( ( int ) $s_ProFinalId );
                    $o_VTA_ProductoFinalDP->delete();
                    
                    VTA_OrdenDP::actualizarCabaceraMontos2( ( int ) $i_Id );

                    //se agrega procedimiento para poder agregar detalles despues de la facturacion
                    $o_VTA_OrdenBN = VTA_OrdenFN::findOrdenById( $i_Id );
                    if( $o_VTA_OrdenBN->getDocReferenciaId() )
                    {
                        $o_VTA_DocumentoBN = $o_VTA_OrdenBN->getObjectVTADocumento();

                        //si existe factura
                        $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
                        $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $o_VTA_DocumentoBN->getNumeroDocumento() );
                        $o_VTA_DocumentoDetalleFN->setItemCodigo( $o_VTA_ProductoFinalBN->getIdItem() );
                        $a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();
                        if( $a_VTA_DocumentoDetalle )
                        {
                            throw new Exception( "No se puede eliminar por ser un detalle principal." );
                        }
                        else
                        {
                            //se puede borrar pero revisar a cada detalle que no tenga despacho
                            if( !$a_VTA_ProductoFinalDet )
                            {
                                throw new Exception( "No se encontro el Detalle como referencia." );
                            }
                            foreach( $a_VTA_ProductoFinalDet as $o_VTA_ProductoFinalDetBN )
                            {
                                if( $o_VTA_ProductoFinalDetBN->getCantidadRecibida() > 0 )
                                {
                                    throw new Exception( "No se puede eliminar por que tiene Despacho asociado." );
                                }
                            }
                        }
                    }

                    //AHORA SE REGISTRA HISTORIAL
                    RegistroHistorialDP::registrarHistorial
                    (
                        array
                        (
                            "Tabla"             => "VTA_Orden",                             //referencia de la tabla donde se hace el update o insert
                            "IdDocumento"       => $o_VTA_OrdenBN->getOrdenId(),            //id del registro cabecera
                            "IdCampo"           => $o_VTA_OrdenBN->getOrdenNum(),            //puede ser el id de los detalles
                            "CampoValor"        => $o_VTA_ProductoFinalBN->getIdItem()." - ".$o_VTA_ProductoFinalBN->getDetalleDescripcion(),          //valor que se muestra al usuario
                            "Modulo"            => "COTIZACION",                            //modulo donde se realizo la accion
                            "CampoDescripcion"  => "ELIMINAR PROD FINAL",                                //descripcion de la accion a realizar
                            "ValorAnterior"     => $o_VTA_ProductoFinalBN->getIdItem(),
                            "ValorNuevo"        => "",
                        )
                    );
                    
                break;
                case "nvodet":
                    
                    $o_VTA_OrdenFN = new VTA_OrdenFN();
                    $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $i_Id );
                    
                    $CantidadPedida = 1;
                    if( $CantidadxCaja )
                    {
                        $CantidadPedida = floatval( $CantidadxCaja );
                    }
                    //nuevo
                    $i_ProFinalDetId = VTA_ProductoFinalDetDP::recuperarId();
                    $s_Secuencia     = VTA_ProductoFinalDetDP::recuperarSecuencia( $IdAdicional );
                    
                    //////////////////////////////////////////////////////////////////////////////////////////
                    //SE RECUPERA VALOR DE IGV ACTUAL
                    $f_ValorIGV       = GSS_ParametroMastFN::getValorPorTipo( "AL", "IGV" ); //0.18
                    $f_ValorIGVMasUno = $f_ValorIGV + 1;  //1.18
                    //////////////////////////////////////////////////////////////////////////////////////////
                    
                    $o_VTA_ProductoFinalDetDP = new VTA_ProductoFinalDetDP();
                    $o_VTA_ProductoFinalDetDP->setProFinalDetId( $i_ProFinalDetId );
                    $o_VTA_ProductoFinalDetDP->setProFinalId( ( int ) $IdAdicional );
                    $o_VTA_ProductoFinalDetDP->setOrdenId( ( int ) $i_Id );
                    $o_VTA_ProductoFinalDetDP->setSecuencia( $s_Secuencia );
                    $o_VTA_ProductoFinalDetDP->setIdItem( $IdItem );
                    $o_VTA_ProductoFinalDetDP->setIdAlmacen( $IdAlmacen );
                    $o_VTA_ProductoFinalDetDP->setIdUnidad( 58 );
                    $o_VTA_ProductoFinalDetDP->setDetalleDescripcion( $o_ALM_ItemMastBN->getDescripcionCompleta() );
                    $o_VTA_ProductoFinalDetDP->setCantidad( $CantidadPedida );
                    $o_VTA_ProductoFinalDetDP->setPesoUnitario( $o_ALM_ItemMastBN->getPesoGramos() );
                    $o_VTA_ProductoFinalDetDP->setPesoTotal( $CantidadPedida * $o_ALM_ItemMastBN->getPesoGramos() );
                    
                    //////////////////////////////////////////////////////////////////////////////////////////
                    $o_VTA_OrdenDetalleBN = new VTA_OrdenDetalleBN();
                    $o_VTA_OrdenDetalleBN->setItemCod( $IdItem );
                    $o_VTA_OrdenDetalleBN->setOrdenId( ( int ) $i_Id );
                    $o_VTA_OrdenDetalleBN->setItemTipo( VTA_OrdenDetalleBN::TIPO_PRODUCTO );
                    $o_VTA_OrdenDetalleBN->setForzarIdTipoLista( 1 ); //primero se busca precio para venta
                    //$o_VTA_OrdenDetalleBN->setForzarIdRango( 2 );
                    
                    $o_CotizacionesDetalleBL = new CotizacionesDetalleBL();
                    $o_CotizacionesDetalleBL->validarDetalleExisteItem( $o_VTA_OrdenDetalleBN );
                    //pr( $o_VTA_OrdenDetalleBN ); exit;
                    
                    $f_PrecioUnidadConIGV   = $o_VTA_OrdenDetalleBN->getPrecioUnidadIncImpuesto();
                    $f_ImpuestoUnidad       = $o_VTA_OrdenDetalleBN->getOrdenDetalleImpuestoUnidad();
                    $f_PrecioUnidad         = $o_VTA_OrdenDetalleBN->getOrdenDetallePrecioUnidad();
                    
                    if( $o_VTA_OrdenBN->esGravadaConImpuesto() )
                    {
                        $f_MontoTotalNeto           = round( $f_PrecioUnidadConIGV * $CantidadPedida, 2 );
                        $f_MontoSubTotal            = round( $f_MontoTotalNeto / $f_ValorIGVMasUno, 2 );
                        $f_MontoSubTotalImpuesto    = round( $f_MontoTotalNeto - $f_MontoSubTotal, 2 );
                    }
                    else
                    {
                        $f_MontoTotalNeto           = round( $f_PrecioUnidadConIGV * $CantidadPedida, 2 );
                        $f_MontoSubTotal            = $f_MontoTotalNeto;
                        $f_MontoSubTotalImpuesto    = 0;
                    }
                    
                    //////////////////////////////////////////////////////////////////////////////////////////
                    
                    $o_VTA_ProductoFinalDetDP->setPrecioUnitarioVal( $f_PrecioUnidad );
                    $o_VTA_ProductoFinalDetDP->setImpuestoUnitarioVal( $f_ImpuestoUnidad );
                    $o_VTA_ProductoFinalDetDP->setPrecioUnitarioConIGVVal( $f_PrecioUnidadConIGV );
                    $o_VTA_ProductoFinalDetDP->setMontoSubTotalVal( $f_MontoSubTotal );
                    $o_VTA_ProductoFinalDetDP->setImpuestoTotalVal( $f_MontoSubTotalImpuesto );
                    $o_VTA_ProductoFinalDetDP->setTotalConIGVVal( $f_MontoTotalNeto );
                    
                    //////////////////////////////////////////////////////////////////////////////////////////
                    $o_VTA_OrdenDetalleBN = new VTA_OrdenDetalleBN();
                    $o_VTA_OrdenDetalleBN->setItemCod( $IdItem );
                    $o_VTA_OrdenDetalleBN->setOrdenId( ( int ) $i_Id );
                    $o_VTA_OrdenDetalleBN->setItemTipo( VTA_OrdenDetalleBN::TIPO_PRODUCTO );
                    $o_VTA_OrdenDetalleBN->setForzarIdTipoLista( 2 );//ahora se busca precio para alquiler
                    //$o_VTA_OrdenDetalleBN->setForzarIdRango( 2 );
                    
                    $o_CotizacionesDetalleBL = new CotizacionesDetalleBL();
                    $o_CotizacionesDetalleBL->validarDetalleExisteItem( $o_VTA_OrdenDetalleBN );
                    
                    $f_PrecioUnidadConIGV   = $o_VTA_OrdenDetalleBN->getPrecioUnidadIncImpuesto();
                    $f_ImpuestoUnidad       = $o_VTA_OrdenDetalleBN->getOrdenDetalleImpuestoUnidad();
                    $f_PrecioUnidad         = $o_VTA_OrdenDetalleBN->getOrdenDetallePrecioUnidad();
                    
                    if( $o_VTA_OrdenBN->esGravadaConImpuesto() )
                    {
                        $f_MontoTotalNeto           = $f_PrecioUnidadConIGV * $CantidadPedida;
                        $f_MontoSubTotal            = round( $f_MontoTotalNeto / $f_ValorIGVMasUno, 2 );
                        $f_MontoSubTotalImpuesto    = round( $f_MontoTotalNeto - $f_MontoSubTotal, 2 );
                    }
                    else
                    {
                        $f_MontoTotalNeto           = round( $f_PrecioUnidadConIGV * $CantidadPedida, 2 );
                        $f_MontoSubTotal            = $f_MontoTotalNeto;
                        $f_MontoSubTotalImpuesto    = 0;
                    }
                    
                    //////////////////////////////////////////////////////////////////////////////////////////
                    
                    $o_VTA_ProductoFinalDetDP->setPrecioUnitarioAlq( $f_PrecioUnidad );
                    $o_VTA_ProductoFinalDetDP->setImpuestoUnitarioAlq( $f_ImpuestoUnidad );
                    $o_VTA_ProductoFinalDetDP->setPrecioUnitarioConIGVAlq( $f_PrecioUnidadConIGV );
                    $o_VTA_ProductoFinalDetDP->setMontoSubTotalAlq( $f_MontoSubTotal );
                    $o_VTA_ProductoFinalDetDP->setImpuestoTotalAlq( $f_MontoSubTotalImpuesto );
                    $o_VTA_ProductoFinalDetDP->setTotalConIGVAlq( $f_MontoTotalNeto );
                    
                    $o_VTA_ProductoFinalDetDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_VTA_ProductoFinalDetDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_VTA_ProductoFinalDetDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_VTA_ProductoFinalDetDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_VTA_ProductoFinalDetDP->save();

                    $this->o_SR_MovimientoBN = SR_MovimientoFN::selectOneRefNum( $o_VTA_OrdenBN->getOrdenNum() );
                    if( $this->o_SR_MovimientoBN )
                    {
                        if( $this->o_SR_MovimientoBN->getImpresionEstado() == SR_MovimientoBN::ESTADO_IMP_C )
                        {
                            throw new Exception( "No se puede ejecutar ningun procedimiento por que el despacho se encuentra completado." );
                        }
                    }

                    //AHORA SE REGISTRA HISTORIAL
                    RegistroHistorialDP::registrarHistorial
                    (
                        array
                        (
                            "Tabla"             => "VTA_Orden",                             //referencia de la tabla donde se hace el update o insert
                            "IdDocumento"       => $o_VTA_OrdenBN->getOrdenId(),            //id del registro cabecera
                            "IdCampo"           => $o_VTA_OrdenBN->getOrdenNum(),            //puede ser el id de los detalles
                            "CampoValor"        => $o_ALM_ItemMastBN->getIdItem()." - ".$o_ALM_ItemMastBN->getDescripcionCompleta(),          //valor que se muestra al usuario, mayor contenido
                            "Modulo"            => "COTIZACION",                            //modulo donde se realizo la accion
                            "CampoDescripcion"  => "NUEVO DETALLE DEL PROD FINAL",                                //descripcion de la accion a realizar
                            "ValorAnterior"     => "",
                            "ValorNuevo"        => $o_ALM_ItemMastBN->getIdItem(),
                        )
                    );

                break;
                case "upddet":
                    
                    $o_VTA_OrdenFN = new VTA_OrdenFN();
                    $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $i_Id );
                    
                    $i_ProFinalDetId = intval( $Secuencia );
                    $CantidadPedida  = floatval( $CantidadPedida );

                    $o_VTA_ProductoFinalDetFN = new VTA_ProductoFinalDetFN();
                    $o_VTA_ProductoFinalDetBN = $o_VTA_ProductoFinalDetFN->selectByPK( $i_ProFinalDetId );

                    //////////////////////////////////////////////////////////////////////////////////////////
                    //SE RECUPERA VALOR DE IGV ACTUAL
                    $f_ValorIGV       = GSS_ParametroMastFN::getValorPorTipo( "AL", "IGV" ); //0.18
                    $f_ValorIGVMasUno = $f_ValorIGV + 1;  //1.18
                    //////////////////////////////////////////////////////////////////////////////////////////
                    
                    $o_VTA_ProductoFinalDetDP = new VTA_ProductoFinalDetDP();
                    $o_VTA_ProductoFinalDetDP->setProFinalDetId( $i_ProFinalDetId );
                    $o_VTA_ProductoFinalDetDP->setCantidad( $CantidadPedida );
                    $o_VTA_ProductoFinalDetDP->setPesoTotal( $CantidadPedida * $o_ALM_ItemMastBN->getPesoGramos() );

                    //////////////////////////////////////////////////////////////////////////////////////////
                    $o_VTA_OrdenDetalleBN = new VTA_OrdenDetalleBN();
                    $o_VTA_OrdenDetalleBN->setItemCod( $IdItem );
                    $o_VTA_OrdenDetalleBN->setOrdenId( ( int ) $i_Id );
                    $o_VTA_OrdenDetalleBN->setItemTipo( VTA_OrdenDetalleBN::TIPO_PRODUCTO );
                    $o_VTA_OrdenDetalleBN->setForzarIdTipoLista( 1 );
                    //$o_VTA_OrdenDetalleBN->setForzarIdRango( 2 );
                    
                    $o_CotizacionesDetalleBL = new CotizacionesDetalleBL();
                    $o_CotizacionesDetalleBL->validarDetalleExisteItem( $o_VTA_OrdenDetalleBN );
                    
                    $f_PrecioUnidadConIGV   = $o_VTA_OrdenDetalleBN->getPrecioUnidadIncImpuesto();
                    $f_ImpuestoUnidad       = $o_VTA_OrdenDetalleBN->getOrdenDetalleImpuestoUnidad();
                    $f_PrecioUnidad         = $o_VTA_OrdenDetalleBN->getOrdenDetallePrecioUnidad();
                    
                    if( $o_VTA_OrdenBN->esGravadaConImpuesto() )
                    {
                        $f_MontoTotalNeto           = $f_PrecioUnidadConIGV * $CantidadPedida;
                        $f_MontoSubTotal            = round( $f_MontoTotalNeto / $f_ValorIGVMasUno, 2 );
                        $f_MontoSubTotalImpuesto    = round( $f_MontoTotalNeto - $f_MontoSubTotal, 2 );
                    }
                    else
                    {
                        $f_MontoTotalNeto           = round( $f_PrecioUnidadConIGV * $CantidadPedida, 2 );
                        $f_MontoSubTotal            = $f_MontoTotalNeto;
                        $f_MontoSubTotalImpuesto    = 0;
                    }
                    
                    //////////////////////////////////////////////////////////////////////////////////////////
                    
                    $o_VTA_ProductoFinalDetDP->setPrecioUnitarioVal( $f_PrecioUnidad );
                    $o_VTA_ProductoFinalDetDP->setImpuestoUnitarioVal( $f_ImpuestoUnidad );
                    $o_VTA_ProductoFinalDetDP->setPrecioUnitarioConIGVVal( $f_PrecioUnidadConIGV );
                    $o_VTA_ProductoFinalDetDP->setMontoSubTotalVal( $f_MontoSubTotal );
                    $o_VTA_ProductoFinalDetDP->setImpuestoTotalVal( $f_MontoSubTotalImpuesto );
                    $o_VTA_ProductoFinalDetDP->setTotalConIGVVal( $f_MontoTotalNeto );
                    
                    //////////////////////////////////////////////////////////////////////////////////////////
                    $o_VTA_OrdenDetalleBN = new VTA_OrdenDetalleBN();
                    $o_VTA_OrdenDetalleBN->setItemCod( $IdItem );
                    $o_VTA_OrdenDetalleBN->setOrdenId( ( int ) $i_Id );
                    $o_VTA_OrdenDetalleBN->setItemTipo( VTA_OrdenDetalleBN::TIPO_PRODUCTO );
                    $o_VTA_OrdenDetalleBN->setForzarIdTipoLista( 2 );
                    //$o_VTA_OrdenDetalleBN->setForzarIdRango( 2 );
                    
                    $o_CotizacionesDetalleBL = new CotizacionesDetalleBL();
                    $o_CotizacionesDetalleBL->validarDetalleExisteItem( $o_VTA_OrdenDetalleBN );
                    
                    $f_PrecioUnidadConIGV   = $o_VTA_OrdenDetalleBN->getPrecioUnidadIncImpuesto();
                    $f_ImpuestoUnidad       = $o_VTA_OrdenDetalleBN->getOrdenDetalleImpuestoUnidad();
                    $f_PrecioUnidad         = $o_VTA_OrdenDetalleBN->getOrdenDetallePrecioUnidad();
                    
                    if( $o_VTA_OrdenBN->esGravadaConImpuesto() )
                    {
                        $f_MontoTotalNeto           = $f_PrecioUnidadConIGV * $CantidadPedida;
                        $f_MontoSubTotal            = round( $f_MontoTotalNeto / $f_ValorIGVMasUno, 2 );
                        $f_MontoSubTotalImpuesto    = round( $f_MontoTotalNeto - $f_MontoSubTotal, 2 );
                    }
                    else
                    {
                        $f_MontoTotalNeto           = round( $f_PrecioUnidadConIGV * $CantidadPedida, 2 );
                        $f_MontoSubTotal            = $f_MontoTotalNeto;
                        $f_MontoSubTotalImpuesto    = 0;
                    }
                    
                    //////////////////////////////////////////////////////////////////////////////////////////
                    
                    $o_VTA_ProductoFinalDetDP->setPrecioUnitarioAlq( $f_PrecioUnidad );
                    $o_VTA_ProductoFinalDetDP->setImpuestoUnitarioAlq( $f_ImpuestoUnidad );
                    $o_VTA_ProductoFinalDetDP->setPrecioUnitarioConIGVAlq( $f_PrecioUnidadConIGV );
                    $o_VTA_ProductoFinalDetDP->setMontoSubTotalAlq( $f_MontoSubTotal );
                    $o_VTA_ProductoFinalDetDP->setImpuestoTotalAlq( $f_MontoSubTotalImpuesto );
                    $o_VTA_ProductoFinalDetDP->setTotalConIGVAlq( $f_MontoTotalNeto );
                    
                    $o_VTA_ProductoFinalDetDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_VTA_ProductoFinalDetDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_VTA_ProductoFinalDetDP->update();

                    //se agrega procedimiento para poder agregar detalles despues de la facturacion
                    $o_VTA_OrdenBN = VTA_OrdenFN::findOrdenById( $i_Id );
                    if( $o_VTA_OrdenBN->getDocReferenciaId() )
                    {
                        if( $CantidadPedida < $o_VTA_ProductoFinalDetBN->getCantidadRecibida() )
                        {
                            throw new Exception( "la cantidad a actualizar no puede ser menor a la cantidad entregada." );
                        }
                    }

                    $this->o_SR_MovimientoBN = SR_MovimientoFN::selectOneRefNum( $o_VTA_OrdenBN->getOrdenNum() );
                    if( $this->o_SR_MovimientoBN )
                    {
                        if( $this->o_SR_MovimientoBN->getImpresionEstado() == SR_MovimientoBN::ESTADO_IMP_C )
                        {
                            throw new Exception( "No se puede ejecutar ningun procedimiento por que el despacho se encuentra completado." );
                        }
                    }

                    //AHORA SE REGISTRA HISTORIAL
                    RegistroHistorialDP::registrarHistorial
                    (
                        array
                        (
                            "Tabla"             => "VTA_Orden",                             //referencia de la tabla donde se hace el update o insert
                            "IdDocumento"       => $o_VTA_OrdenBN->getOrdenId(),            //id del registro cabecera
                            "IdCampo"           => $o_VTA_OrdenBN->getOrdenNum(),            //puede ser el id de los detalles
                            "CampoValor"        => $o_VTA_ProductoFinalDetBN->getIdItem()." - ".$o_VTA_ProductoFinalDetBN->getDetalleDescripcion(),          //valor que se muestra al usuario, mayor contenido
                            "Modulo"            => "COTIZACION",                            //modulo donde se realizo la accion
                            "CampoDescripcion"  => "ACTUALIZAR DETALLE DEL PROD FINAL",                                //descripcion de la accion a realizar
                            "ValorAnterior"     => ( string ) $o_VTA_ProductoFinalDetBN->getCantidad(),
                            "ValorNuevo"        => ( string ) $CantidadPedida,
                        )
                    );
                    
                break;
                case "deldet":
                    
                    $s_ProFinalDetId = $this->getRequestParameter( 'id_det' );

                    $o_VTA_ProductoFinalDetFN = new VTA_ProductoFinalDetFN();
                    $o_VTA_ProductoFinalDetBN = $o_VTA_ProductoFinalDetFN->selectByPK( $s_ProFinalDetId );

                    $o_VTA_ProductoFinalDetDP = new VTA_ProductoFinalDetDP();
                    $o_VTA_ProductoFinalDetDP->setProFinalDetId( ( int ) $s_ProFinalDetId );
                    $o_VTA_ProductoFinalDetDP->delete();

                    //se agrega procedimiento para poder agregar detalles despues de la facturacion
                    $o_VTA_OrdenBN = VTA_OrdenFN::findOrdenById( $i_Id );
                    if( $o_VTA_OrdenBN->getDocReferenciaId() )
                    {
                        if( $o_VTA_ProductoFinalDetBN->getCantidadRecibida() > 0 )
                        {
                            throw new Exception( "No se puede eliminar por que tiene Despacho asociado." );
                        }
                    }

                    //AHORA SE REGISTRA HISTORIAL
                    RegistroHistorialDP::registrarHistorial
                    (
                        array
                        (
                            "Tabla"             => "VTA_Orden",                             //referencia de la tabla donde se hace el update o insert
                            "IdDocumento"       => $o_VTA_OrdenBN->getOrdenId(),            //id del registro cabecera
                            "IdCampo"           => $o_VTA_OrdenBN->getOrdenNum(),            //puede ser el id de los detalles
                            "CampoValor"        => $o_VTA_ProductoFinalDetBN->getIdItem()." - ".$o_VTA_ProductoFinalDetBN->getDetalleDescripcion(),          //valor que se muestra al usuario, mayor contenido
                            "Modulo"            => "COTIZACION",                            //modulo donde se realizo la accion
                            "CampoDescripcion"  => "ELIMINAR DETALLE DEL PROD FINAL",                                //descripcion de la accion a realizar
                            "ValorAnterior"     => $o_VTA_ProductoFinalDetBN->getIdItem(),
                            "ValorNuevo"        => "",
                        )
                    );
                    
                break;
            }
            
            $con->commit();
            
            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
}