<?php
class ListDescuentoAction extends wtActions
{
    public function execute()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $s_Id            = $this->getRequestParameter( 'id' );
        
        $s_ContraseniaAdm     = $this->getRequestParameter( 'ContraseniaAdm' );
        $s_TipoProceso        = $this->getRequestParameter( 'TipoProceso' );
        $this->s_DsctoTipoCod = $this->getRequestParameter( 'DsctoTipoCod' );
        $this->s_DsctoCod     = floatval( $this->getRequestParameter( 'DsctoCod' ) );
        
        $this->b_Control = $this->getRequestParameter( 'Control' );
        $this->b_CerrarPopup = false;
        
        $this->mensaje = "";
        
        $o_VTA_OrdenFN = new VTA_OrdenFN();
        $this->o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $s_Id );
        
        $f_TotalExonerado         = $this->o_VTA_OrdenBN->getMontoExonerado();
        $f_TotalInafecto          = $this->o_VTA_OrdenBN->getOrdenInafecto();
        $f_TotalGravado           = $this->o_VTA_OrdenBN->getMontoAfecto();
        $this->f_TotalAnticipo    = $this->o_VTA_OrdenBN->getMontoAnticipo();
        $this->f_TotalGravada     = $f_TotalGravado;
        $this->f_TotalDescuento   = $this->o_VTA_OrdenBN->getOrdenDscto();
        $this->f_TotalImponible   = $this->o_VTA_OrdenBN->getOrdenBaseImponible();
        $this->f_TotalImpConDscto = $this->o_VTA_OrdenBN->getOrdenImpuestoConDscto();
        $this->f_TotalaPagar      = $this->o_VTA_OrdenBN->getOrdenTotalaPagar();
        
        if( !$this->getRequestParameter( 'Control' ) )
        {
            if( $this->o_VTA_OrdenBN->getOrdenDscto() > 0 )
            {
                $this->s_DsctoCod = $this->o_VTA_OrdenBN->getDsctoCod();
            }
        }
        
        //////////////////////////////////////////////////////////////////////////////////////////
        //SE RECUPERA VALOR DE IGV ACTUAL
        $f_ValorIGV       = GSS_ParametroMastFN::getValorPorTipo( "AL", "IGV" ); //0.18
        $f_ValorIGVMasUno = $f_ValorIGV + 1;  //1.18
        //////////////////////////////////////////////////////////////////////////////////////////
        //se pregunta el control de impuesto por cabecera de la cotizacion
        $b_ControlImpuesto = $this->o_VTA_OrdenBN->esGravadaConImpuesto();

        //AHORA PREGUNTAMOS SI ESTA EXONERADO POR LA ZONA
        $b_ControlExonerado = $this->o_VTA_OrdenBN->esExoneradodeIGV();
        if( $b_ControlExonerado )
        {
            $b_ControlImpuesto = false;
        }
        //////////////////////////////////////////////////////////////////////////////////////////

        $this->f_TotalParaAfectoDscto = 0;
        $this->f_TotalParaAfectoDsctoIGV = 0;
        $this->f_TotalParaAfectoDsctoTotal = 0;

        $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
        $o_VTA_OrdenDetalleFN->setOrdenId( $s_Id );
        $o_VTA_OrdenDetalleFN->addCondition( VTA_OrdenDetalleFN::ItemTipo, "IN", "('P','S')", false );
        $a_VTA_OrdenDetalle = $o_VTA_OrdenDetalleFN->select();
        foreach( $a_VTA_OrdenDetalle as $o_VTA_OrdenDetalleBN )
        {
            $s_AfectoImpuesto = $o_VTA_OrdenDetalleBN->getOrdenDetalleAfectoImpuesto();
            if( $s_AfectoImpuesto == "Y" )
            {
                $this->f_TotalParaAfectoDscto      = ( $o_VTA_OrdenDetalleBN->getSubtotalFinal() ) + $this->f_TotalParaAfectoDscto; //PARECE Q SE LE RESTA EL ANTICIPO
                $this->f_TotalParaAfectoDsctoIGV   = ( $o_VTA_OrdenDetalleBN->getSubtotalIGVFinal() ) + $this->f_TotalParaAfectoDsctoIGV;
                $this->f_TotalParaAfectoDsctoTotal = ( $o_VTA_OrdenDetalleBN->getTotalFinal() ) + $this->f_TotalParaAfectoDsctoTotal;
            }
        }

        //////////////////////////////////////////////////////////////////////////////////////////
        switch ( $s_TipoProceso )
        {
            case "GUARDAR_DESCUENTO":
            case "CALCULAR_DESCUENTO":
                
                if( $this->s_DsctoCod > 0 )
                {
                    if( $b_ControlImpuesto )
                    {
                        $f_DsctoMulti             = ( $this->s_DsctoCod / 100 );
                        //$this->f_TotalDescuento   = round( ( $f_TotalGravado + $f_TotalExonerado + $f_TotalInafecto ) * $f_DsctoMulti, 2 );
                        $this->f_TotalDescuento   = round( $this->f_TotalParaAfectoDscto * $f_DsctoMulti, 2 );
                        //$f_TotalDescuentoGrabado  = ( $f_TotalGravado - $this->f_TotalAnticipo ) * $f_DsctoMulti ;
                        //$f_TotalDescuentoGrabado  = ( $f_TotalGravado ) * $f_DsctoMulti ;
                        //$this->f_TotalGravada     = $f_TotalGravado - $f_TotalDescuentoGrabado - $this->f_TotalAnticipo;
                        //$this->f_TotalGravada     = $f_TotalGravado - $f_TotalDescuentoGrabado;
                        //$this->f_TotalGravada     = $this->f_TotalImponible - $this->f_TotalDescuento;
                        $this->f_TotalGravada       = round( $f_TotalGravado * $f_DsctoMulti, 2 );
                        $this->f_TotalGravada       = round( $f_TotalGravado - $this->f_TotalGravada, 2 );
                        $this->f_TotalImponible   = $this->f_TotalGravada;
                        $this->f_TotalImpConDscto = round( $this->f_TotalImponible * $f_ValorIGV, 2 );
                        $this->f_TotalaPagar      = round( $this->f_TotalImponible + $this->f_TotalImpConDscto + $f_TotalInafecto, 2 );
                    }
                    else
                    {
                        $f_DsctoMulti             = ( $this->s_DsctoCod / 100 );
                        $this->f_TotalDescuento   = round( $this->o_VTA_OrdenBN->getOrdenBaseImponible() * $f_DsctoMulti, 2 );
                        $f_SumaDescuentos         = $this->f_TotalAnticipo + $this->f_TotalDescuento;
                        $this->f_TotalImponible   = $this->o_VTA_OrdenBN->getOrdenBaseImponible() - $f_SumaDescuentos;
                        $this->f_TotalImpConDscto = 0;
                        $this->f_TotalaPagar      = $this->f_TotalImponible + $this->f_TotalImpConDscto;
                    }
                }
                else
                {
                    $this->f_TotalDescuento   = 0;
                    $this->f_TotalImponible   = $this->o_VTA_OrdenBN->getOrdenBaseImponible();
                    $this->f_TotalImpConDscto = $this->o_VTA_OrdenBN->getOrdenImpuestoConDscto();
                    $this->f_TotalaPagar      = $this->o_VTA_OrdenBN->getOrdenTotalaPagar();
                }
                
            break;
        }
        
        
        if( $this->getRequestParameter( 'Control' ) )
        {
            if( $s_TipoProceso == "GUARDAR_DESCUENTO" )
            {
                $con = Conexion::getConexion();
                $con->begin();
                
                try
                {
                    //el tipo de cambio de la cabecera
                    $f_TipoCob = $this->o_VTA_OrdenBN->getMonedaCambioValor();
                    
                    //ahora recupero la moneda de la Orden de Venta
                    $s_OrdenMonedaCod = $this->o_VTA_OrdenBN->getMonedaCod();
                    
                    //se pregunta el control de impuesto por cabecera de la cotizacion
                    $b_ControlImpuesto = $this->o_VTA_OrdenBN->esGravadaConImpuesto();
                    
                    //para recuperar la moneda del sistema
                    $o_MST_ListaPrecioCabeceraFN = new MST_ListaPrecioCabeceraFN();
                    $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->selectByPK( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal() );
                    if( !$o_MST_ListaPrecioCabeceraBN )
                    {
                        $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->buscaListaPrecioAlternativo();
                    }
                    
                    if( $this->f_TotalDescuento <= 0 )
                    {
                        $this->s_DsctoCod     = "";
                        $this->s_DsctoTipoCod = "";
                    }
                    
                    //se agrega una validacion, solo se permite hasta el 3% de descuento para vendedores:
                    /*if( myUser::getUser()->getObjectRol()->getAccesoGlobal() == "N" )
                    {
                        if( $this->s_DsctoCod > 3 )
                        {
                            throw new Exception( "El usuario solo tiene permitido colocar hasta un 3%" );
                        }
                    }*/

                    //SE INICIA LAS VALIDACIONES
                    if( trim( $s_ContraseniaAdm ) == "" )
                    {
                        //PRIMERA VALIDACION ES QUE PARA UN VENDEDOR SOLO TIENE PERMITIDO HASTA UN PORCENTAJE QUE LE DESIGNE EL JEFE DE VENTAS
                        //ahora el porcentaje es dinamico, desde el maestro de personas
                        $o_VTA_VendedorFN = new VTA_VendedorFN();
                        $o_VTA_VendedorFN->setIdUsuario( myUser::getUser()->getUserId() );
                        $a_VTA_Vendedor = $o_VTA_VendedorFN->select();
                        if( $a_VTA_Vendedor )
                        {
                            //es vendedor
                            $o_VTA_VendedorBN  = $a_VTA_Vendedor[0];
                            $f_PorcentajeDscto = $o_VTA_VendedorBN->getPorcentajeDscto();
                            if( $this->s_DsctoCod > $f_PorcentajeDscto )
                            {
                                throw new Exception( "Solo tiene permitido hasta un $f_PorcentajeDscto% de Descuento" );
                            }
                        }
                        else
                        {
                            throw new Exception( "No tiene permiso para realizar descuentos." );
                        }
                    }
                    else
                    {
                        //AQUI ES PARA LA VALIDACION DE QUE SI SE INGRESA CONTRASEÑA Y ES VALIDA PUEDE USAR MAS PORCENTAJE DE DESCUENTO SEGUN COMO EL ADMIN LE HAYA ASIGNADO
                        $o_SEG_UsuarioFN = new SEG_UsuarioFN();
                        $o_SEG_UsuarioFN->setPermisoAdPwd( 1 );
                        $o_SEG_UsuarioFN->setUsuarioContrasenia( trim( $s_ContraseniaAdm ) );
                        $a_SEG_Usuario = $o_SEG_UsuarioFN->select();
                        if( $a_SEG_Usuario )
                        {
                            $o_SEG_UsuarioBN = $a_SEG_Usuario[0];
                            $s_TMP_IdUsuario = $o_SEG_UsuarioBN->getIdUsuario();

                            $o_VTA_VendedorFN = new VTA_VendedorFN();
                            $o_VTA_VendedorFN->setIdUsuario( $s_TMP_IdUsuario );
                            $a_VTA_Vendedor = $o_VTA_VendedorFN->select();
                            if( $a_VTA_Vendedor )
                            {
                                //es vendedor pero como jefe
                                $o_VTA_VendedorBN  = $a_VTA_Vendedor[0];
                                $f_PorcentajeDscto = $o_VTA_VendedorBN->getPorcentajeDscto();
                                if( $this->s_DsctoCod > $f_PorcentajeDscto )
                                {
                                    throw new Exception( "El Administrador solo tiene permitido colocar hasta un $f_PorcentajeDscto%" );
                                }
                            }
                            else
                            {
                                throw new Exception( "No tiene permiso para realizar descuentos." );
                            }
                        }
                        else
                        {
                            throw new Exception( "El Password ingresado no obtuvo coincidencia." );
                        }
                    }
                    
                    if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "LO" ) //MONEDA DE LA LISTA DE PRECIOS ES SOLES
                    {
                        if( $s_OrdenMonedaCod == "LO" )
                        {
                            $f_TotalDescuentoMN =  $this->f_TotalDescuento;
                        }
                        if( $s_OrdenMonedaCod == "EX" )
                        {
                            $f_TotalDescuentoMN =  round( $this->f_TotalDescuento * $f_TipoCob, 2 );
                        }
                    }
                    
                    $o_VTA_OrdenDP = new VTA_OrdenDP();
                    $o_VTA_OrdenDP->setOrdenId( ( int ) $s_Id );
                    $o_VTA_OrdenDP->setDsctoCod( ( string ) $this->s_DsctoCod );
                    $o_VTA_OrdenDP->setDsctoTipoCod( ( string ) $this->s_DsctoTipoCod );
                    $o_VTA_OrdenDP->setOrdenDscto( $this->f_TotalDescuento );
                    $o_VTA_OrdenDP->setOrdenDsctoMN( $f_TotalDescuentoMN );
                    $o_VTA_OrdenDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                    $o_VTA_OrdenDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                    $o_VTA_OrdenDP->update();

                    if( $this->o_VTA_OrdenBN->getOrdenTipoClasificacionId() == VTA_OrdenBN::TIPO_PRODUCTOS_TERMINADOS )
                    {
                        VTA_OrdenDP::actualizarCabaceraMontos2( ( int ) $s_Id );
                    }
                    else
                    {
                        VTA_OrdenDP::actualizarCabaceraMontos( ( int ) $s_Id );
                    }

                    $this->b_CerrarPopup = true;

                    $con->commit();
                }
                catch ( Exception $o_Exception )
                {
                    $con->rollback();
                    $this->mensaje = $o_Exception->getMessage();
                }
            }
        }
        
    }
}