<?php
class GuadarArchivoOrdAction extends wtActions
{
    public function execute()
    {
        $i_Id               = intval( $this->getRequestParameter( 'Id' ) );
        $i_SecuenciaArchivo = intval( $this->getRequestParameter( 'SecuenciaArchivo' ) );
        $s_TipoOpeArchivo   = $this->getRequestParameter( 'TipoOpeArchivo' );
        $s_TipoArchivoId    = $this->getRequestParameter( 'TipoArchivoId' );

        try
        {
            myUser::getUser()->validar_session();
            
            if( $s_TipoOpeArchivo == "NUEVO" )
            {
                $s_NombreCompleto = $_FILES['customFile']['name'];
                $s_TipoCompleto   = $_FILES['customFile']['type'];
                $i_TamanioFile    = intval( $_FILES['customFile']['size'] );
                $fileTmpPath      = $_FILES['customFile']['tmp_name'];
                
                $phpFileUploadErrors = array
                (
                        0 => 'There is no error, the file uploaded with success',
                        1 => 'El fichero subido excede la directiva upload_max_filesize de php.ini.',
                        2 => 'El fichero subido excede la directiva MAX_FILE_SIZE especificada en el formulario HTML.',
                        3 => 'El fichero fue sólo parcialmente subido.',
                        4 => 'No se subió ningún fichero.',
                        6 => 'Falta la carpeta temporal.',
                        7 => 'No se pudo escribir el fichero en el disco.',
                        8 => 'Una extensión de PHP detuvo la subida de ficheros. PHP no proporciona una forma de determinar la extensión que causó la parada de la subida de ficheros; el examen de la lista de extensiones cargadas con phpinfo() puede ayudar.',
                );
                
                if ( $_FILES['customFile']['error'] )
                {
                    throw new Exception( $phpFileUploadErrors[$_FILES['customFile']['error']] );
                }
                
                $a_Archivo = explode( ".", $s_NombreCompleto );
                
                $s_TipoArchivo = $a_Archivo[1];
                
                $s_CarpetaFisica   = SF_ROOT_DIR.DIRECTORY_SEPARATOR."web".DIRECTORY_SEPARATOR."files".DIRECTORY_SEPARATOR."orden".DIRECTORY_SEPARATOR.$i_Id;
                $s_UbicacionFisica = $s_CarpetaFisica.DIRECTORY_SEPARATOR.$s_NombreCompleto;
                
                if ( !file_exists( $s_CarpetaFisica ) )
                {
                    mkdir( $s_CarpetaFisica, 0777, true );
                }
                
                $s_UbicacionURL = Constantes::ROOT_DIR_FILES."orden/$i_Id/$s_NombreCompleto";
                
                /* 
                 * Función personalizada para comprimir y 
                 * subir una imagen mediante PHP
                 */ 
                function compressImage($source, $destination, $quality) { 
                    // Obtenemos la información de la imagen
                    $imgInfo = getimagesize($source); 
                    $mime = $imgInfo['mime']; 
                     
                    // Creamos una imagen
                    switch($mime){ 
                        case 'image/jpeg': 
                            $image = imagecreatefromjpeg($source); 
                            break; 
                        case 'image/png': 
                            $image = imagecreatefrompng($source); 
                            break; 
                        case 'image/gif': 
                            $image = imagecreatefromgif($source); 
                            break; 
                        default: 
                            $image = imagecreatefromjpeg($source); 
                    } 
                     
                    // Guardamos la imagen
                    imagejpeg($image, $destination, $quality); 
                     
                    // Devolvemos la imagen comprimida
                    return $destination; 
                }
                
                //ahora se guarda el archivo seleccionado
                if ( copy( $fileTmpPath, $s_UbicacionFisica ) )
                //if(compressImage($fileTmpPath, $s_UbicacionFisica, 70))
                {
                    $i_Secuencia = VTA_OrdenArchivosDP::recuperarId( $i_Id );
                    $o_ALM_CajaChicaArhivosDP = new VTA_OrdenArchivosDP();
                    $o_ALM_CajaChicaArhivosDP->setOrdenId( $i_Id );
                    $o_ALM_CajaChicaArhivosDP->setTipoArchivoId( ( int ) $s_TipoArchivoId );
                    $o_ALM_CajaChicaArhivosDP->setIdSecuencia( $i_Secuencia );
                    $o_ALM_CajaChicaArhivosDP->setNombre( $s_NombreCompleto );
                    $o_ALM_CajaChicaArhivosDP->setTipo( strtoupper( $s_TipoArchivo ) );
                    $o_ALM_CajaChicaArhivosDP->setTipoCompleto( $s_TipoCompleto );
                    $o_ALM_CajaChicaArhivosDP->setTamanio( $i_TamanioFile );
                    $o_ALM_CajaChicaArhivosDP->setUbicacionURL( $s_UbicacionURL );
                    $o_ALM_CajaChicaArhivosDP->setUbicacionFisica( addslashes( $s_UbicacionFisica ) );
                    $o_ALM_CajaChicaArhivosDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_ALM_CajaChicaArhivosDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_ALM_CajaChicaArhivosDP->save();
                    
                    //Guardar el archivo
                    
                    if($s_TipoArchivoId == 4)
                    {
                        
                        $a_archivoYapePlin = VTA_OrdenArchivosFN::getArrayObjArchhivos( $i_Id, $s_TipoArchivoId );
                        
                        //pr($a_archivoYapePlin);
                        
                        if(is_array($a_archivoYapePlin))
                        {
                            $o_VTA_OrdenArchivosFN = $a_archivoYapePlin[0];
                            $UbicacionURL = $o_VTA_OrdenArchivosFN->getUbicacionURL();
                            
                            $o_VTA_OrdenDP = new VTA_OrdenDP();
                            $o_VTA_OrdenDP->setOrdenId( ( int ) $i_Id );
                            $o_VTA_OrdenDP->setBilletraDigitalArchivo($UbicacionURL);
                            $o_VTA_OrdenDP->update();
                            
                            
                        }
                    }
                    
                    //
                }
                else
                {
                    throw new Exception( "No se puedo copiar el archivo temporal." );
                }
            }
            
            if( $s_TipoOpeArchivo == "ELIMINAR" )
            {
                $o_VTA_OrdenArchivosFN = new VTA_OrdenArchivosFN();
                $o_VTA_OrdenArchivosBN = $o_VTA_OrdenArchivosFN->selectByPK( $i_Id, $i_SecuenciaArchivo );
                if( !$o_VTA_OrdenArchivosBN )
                {
                    throw new Exception( "No se encontro el registro del archivo." );
                }
                
                //ahora se borra el archivo
                unlink( $o_VTA_OrdenArchivosBN->getUbicacionFisica() );
                
                $o_VTA_OrdenArchivosDP = new VTA_OrdenArchivosDP();
                $o_VTA_OrdenArchivosDP->setOrdenId( $i_Id );
                $o_VTA_OrdenArchivosDP->setIdSecuencia( $i_SecuenciaArchivo );
                $o_VTA_OrdenArchivosDP->delete();
            }
            
            $a_Rs['error']    = false;
            //$a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
}